/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.request.zze;
import com.google.android.gms.ads.internal.request.zzg;
import com.google.android.gms.ads.internal.request.zzk;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.internal.zzcn;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzih;
import com.google.android.gms.internal.zzii;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzkc;
import com.google.android.gms.internal.zzkt;

@zzig
public abstract class zzd
implements zzc.zza,
zzkc<Void> {
    private final zzkt<AdRequestInfoParcel> zzLa;
    private final zzc.zza zzLb;
    private final Object zzpp = new Object();

    public zzd(zzkt<AdRequestInfoParcel> zzkt2, zzc.zza zza2) {
        this.zzLa = zzkt2;
        this.zzLb = zza2;
    }

    public abstract void zzhQ();

    public abstract zzk zzhR();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(AdResponseParcel adResponseParcel) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzLb.zzb(adResponseParcel);
            this.zzhQ();
        }
    }

    public Void zzhp() {
        final zzk zzk2 = this.zzhR();
        if (zzk2 == null) {
            this.zzLb.zzb(new AdResponseParcel(0));
            this.zzhQ();
            return null;
        }
        this.zzLa.zza(new zzkt.zzc<AdRequestInfoParcel>(){

            @Override
            public void zzc(AdRequestInfoParcel adRequestInfoParcel) {
                if (!zzd.this.zza(zzk2, adRequestInfoParcel)) {
                    zzd.this.zzhQ();
                }
            }
        }, new zzkt.zza(){

            @Override
            public void run() {
                zzd.this.zzhQ();
            }
        });
        return null;
    }

    @Override
    public void cancel() {
        this.zzhQ();
    }

    boolean zza(zzk zzk2, AdRequestInfoParcel adRequestInfoParcel) {
        try {
            zzk2.zza(adRequestInfoParcel, new zzg(this));
            return true;
        }
        catch (RemoteException remoteException) {
            zzjw.zzd((String)"Could not fetch ad response from ad request service.", (Throwable)remoteException);
            zzu.zzcn().zzb(remoteException, true);
        }
        catch (NullPointerException nullPointerException) {
            zzjw.zzd((String)"Could not fetch ad response from ad request service due to an Exception.", (Throwable)nullPointerException);
            zzu.zzcn().zzb(nullPointerException, true);
        }
        catch (SecurityException securityException) {
            zzjw.zzd((String)"Could not fetch ad response from ad request service due to an Exception.", (Throwable)securityException);
            zzu.zzcn().zzb(securityException, true);
        }
        catch (Throwable throwable) {
            zzjw.zzd((String)"Could not fetch ad response from ad request service due to an Exception.", (Throwable)throwable);
            zzu.zzcn().zzb(throwable, true);
        }
        this.zzLb.zzb(new AdResponseParcel(0));
        return false;
    }

    @Override
    public /* synthetic */ Object zzhs() {
        return this.zzhp();
    }

    @zzig
    public static class zzb
    extends zzd
    implements zzd.zzb,
    zzd.zzc {
        private Context mContext;
        private VersionInfoParcel zzqP;
        private zzkt<AdRequestInfoParcel> zzLa;
        private final zzc.zza zzLb;
        private final Object zzpp = new Object();
        protected zze zzLe;
        private boolean zzLf;

        public zzb(Context context, VersionInfoParcel versionInfoParcel, zzkt<AdRequestInfoParcel> zzkt2, zzc.zza zza2) {
            super(zzkt2, zza2);
            Looper looper;
            this.mContext = context;
            this.zzqP = versionInfoParcel;
            this.zzLa = zzkt2;
            this.zzLb = zza2;
            if (zzcu.zzxz.get().booleanValue()) {
                this.zzLf = true;
                looper = zzu.zzcw().zzjl();
            } else {
                looper = context.getMainLooper();
            }
            this.zzLe = new zze(context, looper, this, this, this.zzqP.zzRD);
            this.connect();
        }

        protected void connect() {
            this.zzLe.zztj();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public zzk zzhR() {
            Object object = this.zzpp;
            synchronized (object) {
                try {
                    return this.zzLe.zzhV();
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzhQ() {
            Object object = this.zzpp;
            synchronized (object) {
                if (this.zzLe.isConnected() || this.zzLe.isConnecting()) {
                    this.zzLe.disconnect();
                }
                Binder.flushPendingCommands();
                if (this.zzLf) {
                    zzu.zzcw().zzjm();
                    this.zzLf = false;
                }
            }
        }

        zzkc zzhS() {
            return new zza(this.mContext, this.zzLa, this.zzLb);
        }

        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzjw.zzaU((String)"Cannot connect to remote service, fallback to local instance.");
            zzkc zzkc2 = this.zzhS();
            zzkc2.zzhs();
            Bundle bundle = new Bundle();
            bundle.putString("action", "gms_connection_failed_fallback_to_local");
            zzu.zzck().zzb(this.mContext, this.zzqP.afmaVersion, "gmob-apps", bundle, true);
        }

        public void onConnected(Bundle bundle) {
            Void cfr_ignored_0 = (Void)((zzd)this).zzhs();
        }

        public void onConnectionSuspended(int n) {
            zzjw.zzaU((String)"Disconnected from remote ad request service.");
        }

        @Override
        public /* synthetic */ Object zzhs() {
            return super.zzhp();
        }
    }

    @zzig
    public static final class zza
    extends zzd {
        private final Context mContext;

        public zza(Context context, zzkt<AdRequestInfoParcel> zzkt2, zzc.zza zza2) {
            super(zzkt2, zza2);
            this.mContext = context;
        }

        @Override
        public zzk zzhR() {
            zzcn zzcn2 = new zzcn(zzcu.zzwZ.get());
            return zzii.zza(this.mContext, zzcn2, zzih.zzhZ());
        }

        @Override
        public void zzhQ() {
        }

        @Override
        public /* synthetic */ Object zzhs() {
            return super.zzhp();
        }
    }
}

