/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzey;
import com.google.android.gms.internal.zzfc;
import com.google.android.gms.internal.zzfd;
import com.google.android.gms.internal.zzff;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzio;
import com.google.android.gms.internal.zzjw;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;

@zzig
public class zzfb {
    private final Map<zzfc, zzfd> zzDh = new HashMap<zzfc, zzfd>();
    private final LinkedList<zzfc> zzDi = new LinkedList();
    private zzey zzDj;

    void zza(zzey zzey2) {
        if (this.zzDj == null) {
            this.zzDj = zzey2.zzfh();
            this.restore();
        }
    }

    zzfd.zza zza(AdRequestParcel adRequestParcel, String string2) {
        Object object;
        if (this.zzae(string2)) {
            return null;
        }
        Context context = this.zzDj.getApplicationContext();
        zzio zzio2 = new zzio.zza(context).zzii();
        int n = zzio2.zzOh;
        AdRequestParcel adRequestParcel2 = zzfb.zzl(adRequestParcel);
        zzfc zzfc2 = new zzfc(adRequestParcel2, string2, n);
        zzfd zzfd2 = this.zzDh.get(zzfc2);
        if (zzfd2 == null) {
            zzfb.zza("Interstitial pool created at %s.", zzfc2);
            zzfd2 = new zzfd(adRequestParcel2, string2, n);
            this.zzDh.put(zzfc2, zzfd2);
        }
        this.zzDi.remove(zzfc2);
        this.zzDi.add(zzfc2);
        zzfd2.zzfn();
        while (this.zzDi.size() > zzcu.zzyj.get()) {
            object = this.zzDi.remove();
            zzfd zzfd3 = this.zzDh.get(object);
            zzfb.zza("Evicting interstitial queue for %s.", (zzfc)object);
            while (zzfd3.size() > 0) {
                zzfd.zza zza2 = zzfd3.zzm(null);
                zza2.zzDo.zzbO();
            }
            this.zzDh.remove(object);
        }
        while (zzfd2.size() > 0) {
            long l;
            object = zzfd2.zzm(adRequestParcel2);
            if (((zzfd.zza)object).zzDs && (l = zzu.zzco().currentTimeMillis() - ((zzfd.zza)object).zzDr) > 1000L * (long)zzcu.zzyl.get().intValue()) {
                zzfb.zza("Expired interstitial at %s.", zzfc2);
                continue;
            }
            String string3 = ((zzfd.zza)object).zzDp != null ? " (inline) " : " ";
            zzfb.zza(new StringBuilder(34 + String.valueOf(string3).length()).append("Pooled interstitial").append(string3).append("returned at %s.").toString(), zzfc2);
            return object;
        }
        return null;
    }

    void zzb(AdRequestParcel adRequestParcel, String string2) {
        if (this.zzDj == null) {
            return;
        }
        Context context = this.zzDj.getApplicationContext();
        zzio zzio2 = new zzio.zza(context).zzii();
        int n = zzio2.zzOh;
        AdRequestParcel adRequestParcel2 = zzfb.zzl(adRequestParcel);
        zzfc zzfc2 = new zzfc(adRequestParcel2, string2, n);
        zzfd zzfd2 = this.zzDh.get(zzfc2);
        if (zzfd2 == null) {
            zzfb.zza("Interstitial pool created at %s.", zzfc2);
            zzfd2 = new zzfd(adRequestParcel2, string2, n);
            this.zzDh.put(zzfc2, zzfd2);
        }
        zzfd2.zza(this.zzDj, adRequestParcel);
        zzfd2.zzfn();
        zzfb.zza("Inline entry added to the queue at %s.", zzfc2);
    }

    void zzfi() {
        if (this.zzDj == null) {
            return;
        }
        for (Map.Entry<zzfc, zzfd> entry : this.zzDh.entrySet()) {
            zzfc zzfc2 = entry.getKey();
            zzfd zzfd2 = entry.getValue();
            if (zzjw.zzX((int)2)) {
                int n = zzfd2.size();
                int n2 = zzfd2.zzfl();
                if (n2 < n) {
                    zzjw.v(String.format("Loading %s/%s pooled interstitials for %s.", n - n2, n, zzfc2));
                }
            }
            zzfd2.zzfm();
            while (zzfd2.size() < zzcu.zzyk.get()) {
                zzfb.zza("Pooling and loading one new interstitial for %s.", zzfc2);
                zzfd2.zzb(this.zzDj);
            }
        }
        this.save();
    }

    void save() {
        if (this.zzDj == null) {
            return;
        }
        Context context = this.zzDj.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        for (Map.Entry<zzfc, zzfd> entry : this.zzDh.entrySet()) {
            zzfc zzfc2 = entry.getKey();
            zzfd zzfd2 = entry.getValue();
            if (!zzfd2.zzfo()) continue;
            zzff zzff2 = new zzff(zzfd2);
            String string2 = zzff2.zzfr();
            String string3 = zzfc2.toString();
            editor.putString(string3, string2);
            zzfb.zza("Saved interstitial queue for %s.", zzfc2);
        }
        editor.putString("PoolKeys", this.zzfj());
        editor.apply();
    }

    void restore() {
        zzfc zzfc2;
        if (this.zzDj == null) {
            return;
        }
        Context context = this.zzDj.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
        this.flush();
        HashMap<String, zzfc> hashMap = new HashMap<String, zzfc>();
        String[] stringArray = sharedPreferences.getAll().entrySet().iterator();
        while (stringArray.hasNext()) {
            String[] stringArray2 = stringArray.next();
            try {
                String string2 = (String)stringArray2.getKey();
                if (string2.equals("PoolKeys")) continue;
                String string3 = (String)stringArray2.getValue();
                zzff object = new zzff(string3);
                zzfc2 = new zzfc(object.zzrD, object.zzqO, object.zzDm);
                if (this.zzDh.containsKey(zzfc2)) continue;
                zzfd zzfd2 = new zzfd(object.zzrD, object.zzqO, object.zzDm);
                this.zzDh.put(zzfc2, zzfd2);
                hashMap.put(zzfc2.toString(), zzfc2);
                zzfb.zza("Restored interstitial queue for %s.", zzfc2);
            }
            catch (IOException | ClassCastException exception) {
                zzjw.zzd((String)"Malformed preferences value for InterstitialAdPool.", (Throwable)exception);
            }
        }
        for (String string2 : stringArray = this.zzad(sharedPreferences.getString("PoolKeys", ""))) {
            zzfc2 = (zzfc)hashMap.get(string2);
            if (!this.zzDh.containsKey(zzfc2)) continue;
            this.zzDi.add(zzfc2);
        }
    }

    void flush() {
        while (this.zzDi.size() > 0) {
            zzfc zzfc2 = this.zzDi.remove();
            zzfd zzfd2 = this.zzDh.get(zzfc2);
            zzfb.zza("Flushing interstitial queue for %s.", zzfc2);
            while (zzfd2.size() > 0) {
                zzfd.zza zza2 = zzfd2.zzm(null);
                zza2.zzDo.zzbO();
            }
            this.zzDh.remove(zzfc2);
        }
    }

    private String zzfj() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.zzDi.iterator();
            while (iterator.hasNext()) {
                String string2 = ((zzfc)iterator.next()).toString();
                stringBuilder.append(Base64.encodeToString((byte[])string2.getBytes("UTF-8"), (int)0));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\u0000");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private String[] zzad(String string2) {
        try {
            String[] stringArray = string2.split("\u0000");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(Base64.decode((String)stringArray[i], (int)0), "UTF-8");
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String[0];
        }
    }

    private boolean zzae(String string2) {
        try {
            return Pattern.matches(zzcu.zzym.get(), string2);
        }
        catch (RuntimeException runtimeException) {
            zzu.zzcn().zzb(runtimeException, true);
            return false;
        }
    }

    @Nullable
    static Bundle zzi(AdRequestParcel adRequestParcel) {
        Bundle bundle = adRequestParcel.zzuX;
        if (bundle == null) {
            return null;
        }
        return bundle.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
    }

    static AdRequestParcel zzj(AdRequestParcel adRequestParcel) {
        Parcel parcel = Parcel.obtain();
        adRequestParcel.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        AdRequestParcel adRequestParcel2 = (AdRequestParcel)AdRequestParcel.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        Bundle bundle = zzfb.zzi(adRequestParcel2);
        if (bundle == null) {
            bundle = new Bundle();
            adRequestParcel2.zzuX.putBundle("com.google.ads.mediation.admob.AdMobAdapter", bundle);
        }
        bundle.putBoolean("_skipMediation", true);
        return adRequestParcel2;
    }

    static boolean zzk(AdRequestParcel adRequestParcel) {
        Bundle bundle = adRequestParcel.zzuX;
        if (bundle == null) {
            return false;
        }
        Bundle bundle2 = bundle.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        return bundle2 != null && bundle2.containsKey("_skipMediation");
    }

    private static AdRequestParcel zzl(AdRequestParcel adRequestParcel) {
        String[] stringArray;
        Parcel parcel = Parcel.obtain();
        adRequestParcel.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        AdRequestParcel adRequestParcel2 = (AdRequestParcel)AdRequestParcel.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        String string2 = zzcu.zzyi.get();
        for (String string3 : stringArray = string2.split(",")) {
            zzfb.zzc(adRequestParcel2.zzuX, string3);
        }
        return adRequestParcel2;
    }

    private static void zzc(Bundle bundle, String string2) {
        String[] stringArray = string2.split("/", 2);
        if (stringArray.length == 0) {
            return;
        }
        String string3 = stringArray[0];
        if (stringArray.length == 1) {
            bundle.remove(string3);
            return;
        }
        Bundle bundle2 = bundle.getBundle(string3);
        if (bundle2 == null) {
            return;
        }
        zzfb.zzc(bundle2, stringArray[1]);
    }

    private static void zza(String string2, zzfc zzfc2) {
        if (zzjw.zzX((int)2)) {
            zzjw.v(String.format(string2, zzfc2));
        }
    }
}

