/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzf;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzfq;
import com.google.android.gms.internal.zzfr;
import com.google.android.gms.internal.zzft;
import com.google.android.gms.internal.zzfv;
import com.google.android.gms.internal.zzga;
import com.google.android.gms.internal.zzgb;
import com.google.android.gms.internal.zzgc;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzgh;
import com.google.android.gms.internal.zzgp;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzka;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzig
public class zzfu
implements zzfv.zza {
    private final String zzEV;
    private final zzga zzqc;
    private final long zzEW;
    private final zzfr zzEX;
    private final zzfq zzEY;
    private AdRequestParcel zzrD;
    private final AdSizeParcel zzrJ;
    private final Context mContext;
    private final Object zzpp = new Object();
    private final VersionInfoParcel zzqP;
    private final boolean zztM;
    private final NativeAdOptionsParcel zzqL;
    private final List<String> zzqM;
    private final boolean zzwo;
    private zzgb zzEZ;
    private int zzFa = -2;
    private zzgd zzFb;

    public zzfu(Context context, String string, zzga zzga2, zzfr zzfr2, zzfq zzfq2, AdRequestParcel adRequestParcel, AdSizeParcel adSizeParcel, VersionInfoParcel versionInfoParcel, boolean bl, boolean bl2, NativeAdOptionsParcel nativeAdOptionsParcel, List<String> list) {
        this.mContext = context;
        this.zzqc = zzga2;
        this.zzEY = zzfq2;
        this.zzEV = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string) ? this.zzfB() : string;
        this.zzEX = zzfr2;
        this.zzEW = zzfr2.zzEE != -1L ? zzfr2.zzEE : 10000L;
        this.zzrD = adRequestParcel;
        this.zzrJ = adSizeParcel;
        this.zzqP = versionInfoParcel;
        this.zztM = bl;
        this.zzwo = bl2;
        this.zzqL = nativeAdOptionsParcel;
        this.zzqM = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.zzpp;
        synchronized (object) {
            try {
                if (this.zzEZ != null) {
                    this.zzEZ.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzjw.zzd((String)"Could not destroy mediation adapter.", (Throwable)remoteException);
            }
            this.zzFa = -1;
            this.zzpp.notify();
        }
    }

    private String zzfB() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzEY.zzEr)) {
                return this.zzqc.zzam(this.zzEY.zzEr) ? "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter" : "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzjw.zzaW((String)"Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzw(int n) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzFa = n;
            this.zzpp.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(int n, zzgd zzgd2) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzFa = n;
            this.zzFb = zzgd2;
            this.zzpp.notify();
        }
    }

    protected zzgb zza(MediationAdapter mediationAdapter) {
        return new zzgh(mediationAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzfv zza(long l, long l2) {
        Object object = this.zzpp;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            final zzft zzft2 = new zzft();
            zzka.zzQu.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = zzfu.this.zzpp;
                    synchronized (object) {
                        if (zzfu.this.zzFa != -2) {
                            return;
                        }
                        zzfu.this.zzEZ = zzfu.this.zzfD();
                        if (zzfu.this.zzEZ == null) {
                            zzfu.this.zzw(4);
                            return;
                        }
                        if (zzfu.this.zzfE() && !zzfu.this.zzx(1)) {
                            String string = zzfu.this.zzEV;
                            zzjw.zzaW((String)new StringBuilder(56 + String.valueOf(string).length()).append("Ignoring adapter ").append(string).append(" as delayed impression is not supported").toString());
                            zzfu.this.zzw(2);
                            return;
                        }
                        zzft2.zza(zzfu.this);
                        zzfu.this.zza(zzft2);
                    }
                }
            });
            long l4 = this.zza(l3, this.zzEW, l, l2);
            return new zzfv(this.zzEY, this.zzEZ, this.zzEV, zzft2, this.zzFa, this.zzfC(), l4);
        }
    }

    private zzgd zzfC() {
        if (this.zzFa != 0 || !this.zzfE()) {
            return null;
        }
        try {
            if (this.zzx(4) && this.zzFb != null && this.zzFb.zzfG() != 0) {
                return this.zzFb;
            }
        }
        catch (RemoteException remoteException) {
            zzjw.zzaW((String)"Could not get cpm value from MediationResponseMetadata");
        }
        return zzfu.zzy(this.zzfF());
    }

    private zzgb zzfD() {
        String string = String.valueOf(this.zzEV);
        zzjw.zzaV((String)(string.length() != 0 ? "Instantiating mediation adapter: ".concat(string) : new String("Instantiating mediation adapter: ")));
        if (!this.zztM) {
            if (zzcu.zzyF.get().booleanValue() && "com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzEV)) {
                return this.zza((MediationAdapter)new AdMobAdapter());
            }
            if (zzcu.zzyG.get().booleanValue() && "com.google.ads.mediation.AdUrlAdapter".equals(this.zzEV)) {
                return this.zza((MediationAdapter)new AdUrlAdapter());
            }
            if ("com.google.ads.mediation.admob.AdMobCustomTabsAdapter".equals(this.zzEV)) {
                return new zzgh((MediationAdapter)new zzgp());
            }
        }
        try {
            return this.zzqc.zzal(this.zzEV);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(this.zzEV);
            zzjw.zza((String)(string2.length() != 0 ? "Could not instantiate mediation adapter: ".concat(string2) : new String("Could not instantiate mediation adapter: ")), (Throwable)remoteException);
            return null;
        }
    }

    private void zza(zzft zzft2) {
        String string;
        if ("com.google.ads.mediation.AdUrlAdapter".equals(this.zzEV)) {
            if (this.zzrD.zzuX == null) {
                this.zzrD = new zzf(this.zzrD).zzc(new Bundle()).zzdA();
            }
            if ((string = this.zzrD.zzuX.getBundle(this.zzEV)) == null) {
                string = new Bundle();
            }
            string.putString("sdk_less_network_id", this.zzEY.zzEo);
            this.zzrD.zzuX.putBundle(this.zzEV, (Bundle)string);
        }
        string = this.zzai(this.zzEY.zzEv);
        try {
            if (this.zzqP.zzRD < 4100000) {
                if (this.zzrJ.zzvt) {
                    this.zzEZ.zza(zze.zzD((Object)this.mContext), this.zzrD, string, (zzgc)zzft2);
                } else {
                    this.zzEZ.zza(zze.zzD((Object)this.mContext), this.zzrJ, this.zzrD, string, (zzgc)zzft2);
                }
            } else if (this.zztM) {
                this.zzEZ.zza(zze.zzD((Object)this.mContext), this.zzrD, string, this.zzEY.zzEn, (zzgc)zzft2, this.zzqL, this.zzqM);
            } else if (this.zzrJ.zzvt) {
                this.zzEZ.zza(zze.zzD((Object)this.mContext), this.zzrD, string, this.zzEY.zzEn, (zzgc)zzft2);
            } else if (this.zzwo) {
                if (this.zzEY.zzEy != null) {
                    this.zzEZ.zza(zze.zzD((Object)this.mContext), this.zzrD, string, this.zzEY.zzEn, (zzgc)zzft2, new NativeAdOptionsParcel(zzfu.zzaj(this.zzEY.zzEC)), this.zzEY.zzEB);
                } else {
                    this.zzEZ.zza(zze.zzD((Object)this.mContext), this.zzrJ, this.zzrD, string, this.zzEY.zzEn, (zzgc)zzft2);
                }
            } else {
                this.zzEZ.zza(zze.zzD((Object)this.mContext), this.zzrJ, this.zzrD, string, this.zzEY.zzEn, (zzgc)zzft2);
            }
        }
        catch (RemoteException remoteException) {
            zzjw.zzd((String)"Could not request ad from mediation adapter.", (Throwable)remoteException);
            this.zzw(5);
        }
    }

    private long zza(long l, long l2, long l3, long l4) {
        while (this.zzFa == -2) {
            this.zzb(l, l2, l3, l4);
        }
        return zzu.zzco().elapsedRealtime() - l;
    }

    private void zzb(long l, long l2, long l3, long l4) {
        long l5 = SystemClock.elapsedRealtime();
        long l6 = l2 - (l5 - l);
        long l7 = l4 - (l5 - l3);
        if (l6 <= 0L || l7 <= 0L) {
            zzjw.zzaV((String)"Timed out waiting for adapter.");
            this.zzFa = 3;
            return;
        }
        try {
            this.zzpp.wait(Math.min(l6, l7));
        }
        catch (InterruptedException interruptedException) {
            this.zzFa = -1;
        }
    }

    private boolean zzx(int n) {
        Bundle bundle = null;
        try {
            bundle = this.zztM ? this.zzEZ.zzfL() : (this.zzrJ.zzvt ? this.zzEZ.getInterstitialAdapterInfo() : this.zzEZ.zzfK());
        }
        catch (RemoteException remoteException) {
            zzjw.zzaW((String)"Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private boolean zzfE() {
        return this.zzEX.zzEO != -1;
    }

    private String zzai(String string) {
        if (string == null || !this.zzfE() || this.zzx(2)) {
            return string;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzjw.zzaW((String)"Could not remove field. Returning the original value");
            return string;
        }
    }

    private int zzfF() {
        JSONObject jSONObject;
        if (this.zzEY.zzEv == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzEY.zzEv);
        }
        catch (JSONException jSONException) {
            zzjw.zzaW((String)"Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzEV)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzx(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static zzgd zzy(final int n) {
        return new zzgd.zza(){

            public int zzfG() throws RemoteException {
                return n;
            }
        };
    }

    private static NativeAdOptions zzaj(String string) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (string == null) {
            return builder.build();
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            builder.setRequestMultipleImages(jSONObject.optBoolean("multiple_images", false));
            builder.setReturnUrlsForImageAssets(jSONObject.optBoolean("only_urls", false));
            String string2 = jSONObject.optString("native_image_orientation", "any");
            builder.setImageOrientation(zzfu.zzak(string2));
        }
        catch (JSONException jSONException) {
            zzjw.zzd((String)"Exception occurred when creating native ad options", (Throwable)jSONException);
        }
        return builder.build();
    }

    private static int zzak(String string) {
        if ("landscape".equals(string)) {
            return 2;
        }
        if ("portrait".equals(string)) {
            return 1;
        }
        return 0;
    }
}

