/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.formats.zzc;
import com.google.android.gms.ads.internal.formats.zzf;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.formats.zzi;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzaq;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzdv;
import com.google.android.gms.internal.zzdw;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzfk;
import com.google.android.gms.internal.zzia;
import com.google.android.gms.internal.zzic;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzie;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzkg;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzkp;
import com.google.android.gms.internal.zzkq;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzla;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzig
public class zzib
implements Callable<zzjn> {
    private static final long zzKl = TimeUnit.SECONDS.toMillis(60L);
    private final Context mContext;
    private final zzkg zzKu;
    private final zzq zzKv;
    private final zzaq zzAZ;
    private final zzia zzAX;
    private final Object zzpp = new Object();
    private final zzjn.zza zzJJ;
    private boolean zzKw;
    private int zzKa;
    private List<String> zzKx;
    private JSONObject zzKy;

    public zzib(Context context, zzq zzq2, zzkg zzkg2, zzaq zzaq2, zzjn.zza zza2) {
        this.mContext = context;
        this.zzKv = zzq2;
        this.zzKu = zzkg2;
        this.zzJJ = zza2;
        this.zzAZ = zzaq2;
        this.zzAX = this.zza(context, zza2, zzq2, zzaq2);
        this.zzAX.zzhA();
        this.zzKw = false;
        this.zzKa = -2;
        this.zzKx = null;
    }

    public zzjn zzhL() {
        try {
            this.zzAX.zzhB();
            String string2 = UUID.randomUUID().toString();
            JSONObject jSONObject = this.zzaA(string2);
            zza zza2 = this.zze(jSONObject);
            zzh.zza zza3 = this.zza(zza2, jSONObject, string2);
            this.zza(zza3);
            zzjn zzjn2 = this.zzb(zza3);
            return zzjn2;
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (JSONException jSONException) {
            zzjw.zzd((String)"Malformed native JSON response.", (Throwable)jSONException);
        }
        catch (TimeoutException timeoutException) {
            zzjw.zzd((String)"Timeout when loading native ad.", (Throwable)timeoutException);
        }
        if (!this.zzKw) {
            this.zzL(0);
        }
        return this.zzb(null);
    }

    private JSONObject zzaA(final String string2) throws TimeoutException, JSONException {
        if (this.zzhM()) {
            return null;
        }
        final zzko zzko2 = new zzko();
        final zzb zzb2 = new zzb();
        zzia.zza zza2 = new zzia.zza(){

            @Override
            public void zze(final zzfk zzfk2) {
                zzeh zzeh2;
                zzb2.zzKQ = zzeh2 = new zzeh(){

                    @Override
                    public void zza(zzla zzla2, Map<String, String> map) {
                        zzfk2.zzb("/nativeAdPreProcess", zzb2.zzKQ);
                        try {
                            String string2 = map.get("success");
                            if (!TextUtils.isEmpty((CharSequence)string2)) {
                                zzko2.zzh(new JSONObject(string2).getJSONArray("ads").getJSONObject(0));
                                return;
                            }
                        }
                        catch (JSONException jSONException) {
                            zzjw.zzb((String)"Malformed native JSON response.", (Throwable)jSONException);
                        }
                        zzib.this.zzL(0);
                        zzaa.zza((boolean)zzib.this.zzhM(), (Object)"Unable to set the ad state error!");
                        zzko2.zzh(null);
                    }
                };
                zzfk2.zza("/nativeAdPreProcess", zzeh2);
                try {
                    JSONObject jSONObject = new JSONObject(((zzib)zzib.this).zzJJ.zzPi.body);
                    jSONObject.put("ads_id", (Object)string2);
                    zzfk2.zza("google.afma.nativeAds.preProcessJsonGmsg", jSONObject);
                }
                catch (JSONException jSONException) {
                    zzjw.zzd((String)"Exception occurred while invoking javascript", (Throwable)jSONException);
                    zzko2.zzh(null);
                }
            }

            @Override
            public void zzhK() {
                zzko2.zzh(null);
            }
        };
        this.zzAX.zza(zza2);
        return (JSONObject)zzko2.get(zzKl, TimeUnit.MILLISECONDS);
    }

    protected zza zze(JSONObject jSONObject) throws JSONException, TimeoutException {
        boolean bl;
        if (this.zzhM()) {
            return null;
        }
        String string2 = jSONObject.getString("template_id");
        boolean bl2 = this.zzJJ.zzPh.zzsP != null ? this.zzJJ.zzPh.zzsP.zzBl : false;
        boolean bl3 = bl = this.zzJJ.zzPh.zzsP != null ? this.zzJJ.zzPh.zzsP.zzBn : false;
        if ("2".equals(string2)) {
            return new zzic(bl2, bl);
        }
        if ("1".equals(string2)) {
            return new zzid(bl2, bl);
        }
        if ("3".equals(string2)) {
            final String string3 = jSONObject.getString("custom_template_id");
            final zzko zzko2 = new zzko();
            zzka.zzQu.post(new Runnable(){

                @Override
                public void run() {
                    zzko2.zzh((zzdw)zzib.this.zzKv.zzbV().get((Object)string3));
                }
            });
            if (zzko2.get(zzKl, TimeUnit.MILLISECONDS) != null) {
                return new zzie(bl2);
            }
            String string4 = String.valueOf(jSONObject.getString("custom_template_id"));
            zzjw.e((String)(string4.length() != 0 ? "No handler for custom template: ".concat(string4) : new String("No handler for custom template: ")));
        } else {
            this.zzL(0);
        }
        return null;
    }

    private void zza(zzh.zza zza2) {
        zzeh zzeh2;
        if (!(zza2 instanceof zzf)) {
            return;
        }
        final zzf zzf2 = (zzf)zza2;
        zzb zzb2 = new zzb();
        zzb2.zzKQ = zzeh2 = new zzeh(){

            @Override
            public void zza(zzla zzla2, Map<String, String> map) {
                String string2 = map.get("asset");
                zzib.this.zzb((zzdr)zzf2, string2);
            }
        };
        this.zzAX.zza(new zzia.zza(){

            @Override
            public void zze(zzfk zzfk2) {
                zzfk2.zza("/nativeAdCustomClick", zzeh2);
            }
        });
    }

    private void zzb(zzdr zzdr2, String string2) {
        try {
            zzdv zzdv2 = this.zzKv.zzv(zzdr2.getCustomTemplateId());
            if (zzdv2 != null) {
                zzdv2.zza(zzdr2, string2);
            }
        }
        catch (RemoteException remoteException) {
            zzjw.zzd((String)new StringBuilder(40 + String.valueOf(string2).length()).append("Failed to call onCustomClick for asset ").append(string2).append(".").toString(), (Throwable)remoteException);
        }
    }

    private zzh.zza zza(zza zza2, JSONObject jSONObject, String string2) throws ExecutionException, InterruptedException, JSONException {
        if (this.zzhM()) {
            return null;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("tracking_urls_and_actions");
        String[] stringArray = this.zzc(jSONObject2, "impression_tracking_urls");
        this.zzKx = stringArray == null ? null : Arrays.asList(stringArray);
        this.zzKy = jSONObject2.optJSONObject("active_view");
        Object t = zza2.zza(this, jSONObject);
        if (t == null) {
            zzjw.e((String)"Failed to retrieve ad assets.");
            return null;
        }
        t.zzb((zzh)new zzi(this.mContext, this.zzKv, this.zzAX, this.zzAZ, jSONObject, (zzh.zza)t, this.zzJJ.zzPh.zzsx, string2));
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzjn zzb(zzh.zza zza2) {
        int n;
        Object object = this.zzpp;
        synchronized (object) {
            n = this.zzKa;
            if (zza2 == null && this.zzKa == -2) {
                n = 0;
            }
        }
        if (n != -2) {
            zza2 = null;
        }
        return new zzjn(this.zzJJ.zzPh.zzLi, null, this.zzJJ.zzPi.zzEF, n, this.zzJJ.zzPi.zzEG, this.zzKx, this.zzJJ.zzPi.orientation, this.zzJJ.zzPi.zzEL, this.zzJJ.zzPh.zzLl, false, null, null, null, null, null, 0L, this.zzJJ.zzsB, this.zzJJ.zzPi.zzLO, this.zzJJ.zzPc, this.zzJJ.zzPd, this.zzJJ.zzPi.zzLU, this.zzKy, zza2, null, null, null, this.zzJJ.zzPi.zzMi, this.zzJJ.zzPi.zzMj, null, this.zzJJ.zzPi.zzEI);
    }

    public zzkr<com.google.android.gms.ads.internal.formats.zza> zzf(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject.optJSONObject("attribution");
        if (jSONObject2 == null) {
            return new zzkp<Object>(null);
        }
        final String string2 = jSONObject2.optString("text");
        final int n = jSONObject2.optInt("text_size", -1);
        final Integer n2 = this.zzb(jSONObject2, "text_color");
        final Integer n3 = this.zzb(jSONObject2, "bg_color");
        final int n4 = jSONObject2.optInt("animation_ms", 1000);
        final int n5 = jSONObject2.optInt("presentation_ms", 4000);
        ArrayList arrayList = new ArrayList<zzkr<zzc>>();
        if (jSONObject2.optJSONArray("images") != null) {
            arrayList = this.zza(jSONObject2, "images", false, false, true);
        } else {
            arrayList.add(this.zza(jSONObject2, "image", false, false));
        }
        zzkr zzkr2 = zzkq.zzn(arrayList);
        return zzkq.zza(zzkr2, new zzkq.zza<List<zzc>, com.google.android.gms.ads.internal.formats.zza>(){

            public com.google.android.gms.ads.internal.formats.zza zzj(List<zzc> list) {
                try {
                    return list == null || list.isEmpty() ? null : new com.google.android.gms.ads.internal.formats.zza(string2, zzib.zzh(list), n3, n2, n > 0 ? Integer.valueOf(n) : null, n5 + n4);
                }
                catch (RemoteException remoteException) {
                    zzjw.zzb((String)"Could not get attribution icon", (Throwable)remoteException);
                    return null;
                }
            }

            @Override
            public /* synthetic */ Object zzg(Object object) {
                return this.zzj((List)object);
            }
        });
    }

    private Integer zzb(JSONObject jSONObject, String string2) {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
            int n = jSONObject2.getInt("r");
            int n2 = jSONObject2.getInt("g");
            int n3 = jSONObject2.getInt("b");
            return Color.rgb((int)n, (int)n2, (int)n3);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public Future<zzc> zza(JSONObject jSONObject, String string2, boolean bl) throws JSONException {
        JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
        boolean bl2 = jSONObject2.optBoolean("require", true);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl2, bl);
    }

    public zzkr<zzc> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2) throws JSONException {
        JSONObject jSONObject2 = bl ? jSONObject.getJSONObject(string2) : jSONObject.optJSONObject(string2);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl, bl2);
    }

    public List<zzkr<zzc>> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2, boolean bl3) throws JSONException {
        JSONArray jSONArray = bl ? jSONObject.getJSONArray(string2) : jSONObject.optJSONArray(string2);
        ArrayList<zzkr<zzc>> arrayList = new ArrayList<zzkr<zzc>>();
        if (jSONArray == null || jSONArray.length() == 0) {
            this.zza(0, bl);
            return arrayList;
        }
        int n = bl3 ? jSONArray.length() : 1;
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
            arrayList.add(this.zza(jSONObject2, bl, bl2));
        }
        return arrayList;
    }

    private zzkr<zzc> zza(JSONObject jSONObject, final boolean bl, boolean bl2) throws JSONException {
        final String string2 = bl ? jSONObject.getString("url") : jSONObject.optString("url");
        final double d = jSONObject.optDouble("scale", 1.0);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zza(0, bl);
            return new zzkp<Object>(null);
        }
        if (bl2) {
            return new zzkp<zzc>(new zzc(null, Uri.parse((String)string2), d));
        }
        return this.zzKu.zza(string2, new zzkg.zza<zzc>(){

            public zzc zzhN() {
                zzib.this.zza(2, bl);
                return null;
            }

            public zzc zzg(InputStream inputStream) {
                byte[] byArray = null;
                try {
                    byArray = zzo.zzk((InputStream)inputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (byArray == null) {
                    zzib.this.zza(2, bl);
                    return null;
                }
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                if (bitmap == null) {
                    zzib.this.zza(2, bl);
                    return null;
                }
                bitmap.setDensity((int)(160.0 * d));
                return new zzc((Drawable)new BitmapDrawable(Resources.getSystem(), bitmap), Uri.parse((String)string2), d);
            }

            @Override
            public /* synthetic */ Object zzhO() {
                return this.zzhN();
            }

            @Override
            public /* synthetic */ Object zzh(InputStream inputStream) {
                return this.zzg(inputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzhM() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzKw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzL(int n) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzKw = true;
            this.zzKa = n;
        }
    }

    public void zza(int n, boolean bl) {
        if (bl) {
            this.zzL(n);
        }
    }

    private String[] zzc(JSONObject jSONObject, String string2) throws JSONException {
        JSONArray jSONArray = jSONObject.optJSONArray(string2);
        if (jSONArray == null) {
            return null;
        }
        String[] stringArray = new String[jSONArray.length()];
        for (int i = 0; i < jSONArray.length(); ++i) {
            stringArray[i] = jSONArray.getString(i);
        }
        return stringArray;
    }

    private static List<Drawable> zzh(List<zzc> list) throws RemoteException {
        ArrayList<Drawable> arrayList = new ArrayList<Drawable>();
        for (zzc zzc2 : list) {
            arrayList.add((Drawable)zze.zzx((zzd)zzc2.zzeM()));
        }
        return arrayList;
    }

    zzia zza(Context context, zzjn.zza zza2, zzq zzq2, zzaq zzaq2) {
        return new zzia(context, zza2, zzq2, zzaq2);
    }

    @Override
    public /* synthetic */ Object call() throws Exception {
        return this.zzhL();
    }

    class zzb {
        public zzeh zzKQ;

        zzb() {
        }
    }

    public static interface zza<T extends zzh.zza> {
        public T zza(zzib var1, JSONObject var2) throws JSONException, InterruptedException, ExecutionException;
    }
}

