/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjw;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;

@zzig
public class zzif
implements Thread.UncaughtExceptionHandler {
    private Thread.UncaughtExceptionHandler zzKT;
    private Thread.UncaughtExceptionHandler zzKU;
    private Context mContext;
    private VersionInfoParcel zzrx;

    public static zzif zza(Context context, Thread thread, VersionInfoParcel versionInfoParcel) {
        if (context == null || thread == null || versionInfoParcel == null) {
            return null;
        }
        if (!zzif.zzt(context)) {
            return null;
        }
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = thread.getUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler2 = thread.getDefaultUncaughtExceptionHandler();
        zzif zzif2 = new zzif(context, versionInfoParcel, uncaughtExceptionHandler, uncaughtExceptionHandler2);
        if (uncaughtExceptionHandler == null || !(uncaughtExceptionHandler instanceof zzif)) {
            try {
                thread.setUncaughtExceptionHandler(zzif2);
                return zzif2;
            }
            catch (SecurityException securityException) {
                zzjw.zzc((String)"Fail to set UncaughtExceptionHandler.", (Throwable)securityException);
            }
        } else {
            return (zzif)uncaughtExceptionHandler;
        }
        return null;
    }

    private static boolean zzt(Context context) {
        return zzcu.zzxe.get();
    }

    public zzif(Context context, VersionInfoParcel versionInfoParcel, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Thread.UncaughtExceptionHandler uncaughtExceptionHandler2) {
        this.zzKT = uncaughtExceptionHandler;
        this.zzKU = uncaughtExceptionHandler2;
        this.mContext = context;
        this.zzrx = versionInfoParcel;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (this.zzb(throwable)) {
            if (Looper.getMainLooper().getThread() != thread) {
                this.zza(throwable, true);
                return;
            }
            this.zza(throwable, false);
        }
        if (this.zzKT != null) {
            this.zzKT.uncaughtException(thread, throwable);
        } else if (this.zzKU != null) {
            this.zzKU.uncaughtException(thread, throwable);
        }
    }

    protected boolean zzb(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        while (throwable != null) {
            StackTraceElement[] stackTraceElementArray;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = throwable.getStackTrace()) {
                if (this.zzaB(stackTraceElement.getClassName())) {
                    bl = true;
                }
                if (!this.getClass().getName().equals(stackTraceElement.getClassName())) continue;
                bl2 = true;
            }
            throwable = throwable.getCause();
        }
        return bl && !bl2;
    }

    protected boolean zzaB(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (string.startsWith(zzcu.zzxg.get())) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.isAnnotationPresent(zzig.class);
        }
        catch (Exception exception) {
            String string2 = String.valueOf(string);
            zzjw.zza((String)(string2.length() != 0 ? "Fail to check class type for class ".concat(string2) : new String("Fail to check class type for class ")), (Throwable)exception);
            return false;
        }
    }

    protected boolean zzaC(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return string.startsWith("android.") || string.startsWith("java.");
    }

    public void zza(Throwable throwable, boolean bl) {
        if (!zzif.zzt(this.mContext)) {
            return;
        }
        Throwable throwable2 = this.zzc(throwable);
        if (throwable2 == null) {
            return;
        }
        Class<?> clazz = throwable.getClass();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.zza(clazz, throwable2, bl));
        zzu.zzck().zza(arrayList, zzu.zzcn().zziJ());
    }

    String zza(Class clazz, Throwable throwable, boolean bl) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        Uri.Builder builder = new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("id", "gmob-apps-report-exception").appendQueryParameter("os", Build.VERSION.RELEASE).appendQueryParameter("api", String.valueOf(Build.VERSION.SDK_INT)).appendQueryParameter("device", zzu.zzck().zzjb()).appendQueryParameter("js", this.zzrx.afmaVersion).appendQueryParameter("appid", this.mContext.getApplicationContext().getPackageName()).appendQueryParameter("exceptiontype", clazz.getName()).appendQueryParameter("stacktrace", stringWriter.toString()).appendQueryParameter("eids", TextUtils.join((CharSequence)",", zzcu.zzer())).appendQueryParameter("trapped", String.valueOf(bl));
        return builder.toString();
    }

    private Throwable zzc(Throwable throwable) {
        Throwable throwable2;
        if (zzcu.zzxf.get().booleanValue()) {
            return throwable;
        }
        LinkedList<Throwable> linkedList = new LinkedList<Throwable>();
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            linkedList.push(throwable2);
        }
        Throwable throwable3 = null;
        while (!linkedList.isEmpty()) {
            throwable2 = (Throwable)linkedList.pop();
            StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
            arrayList.add(new StackTraceElement(throwable2.getClass().getName(), "<filtered>", "<filtered>", 1));
            boolean bl = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (this.zzaB(stackTraceElement.getClassName())) {
                    bl = true;
                    arrayList.add(stackTraceElement);
                    continue;
                }
                if (this.zzaC(stackTraceElement.getClassName())) {
                    arrayList.add(stackTraceElement);
                    continue;
                }
                StackTraceElement stackTraceElement2 = new StackTraceElement("<filtered>", "<filtered>", "<filtered>", 1);
                arrayList.add(stackTraceElement2);
            }
            if (!bl) continue;
            throwable3 = throwable3 == null ? new Throwable(throwable2.getMessage()) : new Throwable(throwable2.getMessage(), throwable3);
            throwable3.setStackTrace(arrayList.toArray(new StackTraceElement[0]));
        }
        return throwable3;
    }
}

