/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzig;
import java.util.Locale;

@zzig
public final class zzio {
    public final int zzNV;
    public final boolean zzNW;
    public final boolean zzNX;
    public final String zzNY;
    public final String zzNZ;
    public final boolean zzOa;
    public final boolean zzOb;
    public final boolean zzOc;
    public final boolean zzOd;
    public final String zzOe;
    public final String zzOf;
    public final int zzOg;
    public final int zzOh;
    public final int zzOi;
    public final int zzOj;
    public final int zzOk;
    public final int zzOl;
    public final float zzLu;
    public final int zzLs;
    public final int zzLt;
    public final double zzOm;
    public final boolean zzOn;
    public final boolean zzOo;
    public final int zzOp;
    public final String zzOq;
    public final boolean zzOr;

    zzio(int n, boolean bl, boolean bl2, String string2, String string3, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string4, String string5, int n2, int n3, int n4, int n5, int n6, int n7, float f, int n8, int n9, double d, boolean bl7, boolean bl8, int n10, String string6, boolean bl9) {
        this.zzNV = n;
        this.zzNW = bl;
        this.zzNX = bl2;
        this.zzNY = string2;
        this.zzNZ = string3;
        this.zzOa = bl3;
        this.zzOb = bl4;
        this.zzOc = bl5;
        this.zzOd = bl6;
        this.zzOe = string4;
        this.zzOf = string5;
        this.zzOg = n2;
        this.zzOh = n3;
        this.zzOi = n4;
        this.zzOj = n5;
        this.zzOk = n6;
        this.zzOl = n7;
        this.zzLu = f;
        this.zzLs = n8;
        this.zzLt = n9;
        this.zzOm = d;
        this.zzOn = bl7;
        this.zzOo = bl8;
        this.zzOp = n10;
        this.zzOq = string6;
        this.zzOr = bl9;
    }

    public static final class zza {
        private int zzNV;
        private boolean zzOc;
        private boolean zzOd;
        private int zzOg;
        private int zzOk;
        private int zzOl;
        private String zzNY;
        private int zzOh;
        private int zzOi;
        private int zzOj;
        private boolean zzOo;
        private int zzOp;
        private double zzOm;
        private boolean zzOn;
        private String zzOq;
        private boolean zzNW;
        private boolean zzNX;
        private String zzNZ;
        private boolean zzOa;
        private boolean zzOb;
        private String zzOe;
        private String zzOf;
        private float zzLu;
        private int zzLs;
        private int zzLt;
        private boolean zzOr;

        public zza(Context context) {
            PackageManager packageManager = context.getPackageManager();
            this.zzu(context);
            this.zza(context, packageManager);
            this.zzv(context);
            Locale locale = Locale.getDefault();
            this.zzNW = zza.zza(packageManager, "geo:0,0?q=donuts") != null;
            this.zzNX = zza.zza(packageManager, "http://www.google.com") != null;
            this.zzNZ = locale.getCountry();
            this.zzOa = zzm.zzdQ().zzjr();
            this.zzOb = zzi.zzaC((Context)context);
            this.zzOe = locale.getLanguage();
            this.zzOf = zza.zza(packageManager);
            Resources resources = context.getResources();
            if (resources == null) {
                return;
            }
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            if (displayMetrics == null) {
                return;
            }
            this.zzLu = displayMetrics.density;
            this.zzLs = displayMetrics.widthPixels;
            this.zzLt = displayMetrics.heightPixels;
        }

        public zza(Context context, zzio zzio2) {
            PackageManager packageManager = context.getPackageManager();
            this.zzu(context);
            this.zza(context, packageManager);
            this.zzv(context);
            this.zzw(context);
            this.zzNW = zzio2.zzNW;
            this.zzNX = zzio2.zzNX;
            this.zzNZ = zzio2.zzNZ;
            this.zzOa = zzio2.zzOa;
            this.zzOb = zzio2.zzOb;
            this.zzOe = zzio2.zzOe;
            this.zzOf = zzio2.zzOf;
            this.zzLu = zzio2.zzLu;
            this.zzLs = zzio2.zzLs;
            this.zzLt = zzio2.zzLt;
        }

        private void zzu(Context context) {
            AudioManager audioManager = zzu.zzck().zzJ(context);
            if (audioManager != null) {
                try {
                    this.zzNV = audioManager.getMode();
                    this.zzOc = audioManager.isMusicActive();
                    this.zzOd = audioManager.isSpeakerphoneOn();
                    this.zzOg = audioManager.getStreamVolume(3);
                    this.zzOk = audioManager.getRingerMode();
                    this.zzOl = audioManager.getStreamVolume(2);
                    return;
                }
                catch (Throwable throwable) {
                    zzu.zzcn().zzb(throwable, true);
                }
            }
            this.zzNV = -2;
            this.zzOc = false;
            this.zzOd = false;
            this.zzOg = 0;
            this.zzOk = 0;
            this.zzOl = 0;
        }

        @TargetApi(value=16)
        private void zza(Context context, PackageManager packageManager) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            this.zzNY = telephonyManager.getNetworkOperator();
            this.zzOi = telephonyManager.getNetworkType();
            this.zzOj = telephonyManager.getPhoneType();
            this.zzOh = -2;
            this.zzOo = false;
            this.zzOp = -1;
            if (zzu.zzck().zza(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null) {
                    this.zzOh = networkInfo.getType();
                    this.zzOp = networkInfo.getDetailedState().ordinal();
                } else {
                    this.zzOh = -1;
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    this.zzOo = connectivityManager.isActiveNetworkMetered();
                }
            }
        }

        private void zzv(Context context) {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent intent = context.registerReceiver(null, intentFilter);
            if (intent != null) {
                int n = intent.getIntExtra("status", -1);
                int n2 = intent.getIntExtra("level", -1);
                int n3 = intent.getIntExtra("scale", -1);
                this.zzOm = (float)n2 / (float)n3;
                this.zzOn = n == 2 || n == 5;
            } else {
                this.zzOm = -1.0;
                this.zzOn = false;
            }
        }

        private void zzw(Context context) {
            this.zzOq = Build.FINGERPRINT;
            this.zzOr = zzdi.zzo(context);
        }

        private static String zza(PackageManager packageManager) {
            ResolveInfo resolveInfo = zza.zza(packageManager, "market://details?id=com.google.android.gms.ads");
            if (resolveInfo == null) {
                return null;
            }
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null) {
                return null;
            }
            try {
                String string2;
                PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
                if (packageInfo != null) {
                    int n = packageInfo.versionCode;
                    String string3 = String.valueOf(activityInfo.packageName);
                    string2 = new StringBuilder(12 + String.valueOf(string3).length()).append(n).append(".").append(string3).toString();
                } else {
                    string2 = null;
                }
                return string2;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
        }

        private static ResolveInfo zza(PackageManager packageManager, String string2) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }

        public zzio zzii() {
            return new zzio(this.zzNV, this.zzNW, this.zzNX, this.zzNY, this.zzNZ, this.zzOa, this.zzOb, this.zzOc, this.zzOd, this.zzOe, this.zzOf, this.zzOg, this.zzOh, this.zzOi, this.zzOj, this.zzOk, this.zzOl, this.zzLu, this.zzLs, this.zzLt, this.zzOm, this.zzOn, this.zzOo, this.zzOp, this.zzOq, this.zzOr);
        }
    }
}

