/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzaq;
import com.google.android.gms.internal.zzbv;
import com.google.android.gms.internal.zzcy;
import com.google.android.gms.internal.zzda;
import com.google.android.gms.internal.zzdb;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzeu;
import com.google.android.gms.internal.zzgw;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkz;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzlf;
import com.google.android.gms.internal.zzlg;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzig
class zzle
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzla {
    private final zza zzSt;
    private final Object zzpp = new Object();
    private final zzaq zzAZ;
    private final VersionInfoParcel zzqP;
    private final com.google.android.gms.ads.internal.zzs zzSu;
    private final zzd zzpY;
    private zzlb zzSv;
    private com.google.android.gms.ads.internal.overlay.zzd zzSw;
    private AdSizeParcel zzrJ;
    private boolean zzSx;
    private boolean zzSy;
    private boolean zzSz;
    private boolean zzSA;
    private Boolean zzPO;
    private int zzSB;
    private boolean zzSC = true;
    boolean zzSD = false;
    private String zzII = "";
    private zzlf zzSE;
    private boolean zzSF;
    private zzda zzSG;
    private zzda zzSH;
    private zzda zzSI;
    private zzdb zzSJ;
    private WeakReference<View.OnClickListener> zzSK;
    private com.google.android.gms.ads.internal.overlay.zzd zzSL;
    private zzkn zzth;
    private int zzGz = -1;
    private int zzGy = -1;
    private int zzGB = -1;
    private int zzGC = -1;
    private Map<String, zzeu> zzSM;
    private final WindowManager zztn;

    static zzle zzb(Context context, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, zzaq zzaq2, VersionInfoParcel versionInfoParcel, zzdc zzdc2, com.google.android.gms.ads.internal.zzs zzs2, zzd zzd2) {
        zza zza2 = new zza(context);
        return new zzle(zza2, adSizeParcel, bl, bl2, zzaq2, versionInfoParcel, zzdc2, zzs2, zzd2);
    }

    protected zzle(zza zza2, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, zzaq zzaq2, VersionInfoParcel versionInfoParcel, zzdc zzdc2, com.google.android.gms.ads.internal.zzs zzs2, zzd zzd2) {
        super((Context)zza2);
        this.zzSt = zza2;
        this.zzrJ = adSizeParcel;
        this.zzSz = bl;
        this.zzSB = -1;
        this.zzAZ = zzaq2;
        this.zzqP = versionInfoParcel;
        this.zzSu = zzs2;
        this.zzpY = zzd2;
        this.zztn = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(0);
        }
        zzu.zzck().zza((Context)zza2, versionInfoParcel.afmaVersion, webSettings);
        zzu.zzcm().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzkc();
        if (zzs.zzvc()) {
            this.addJavascriptInterface(new zzlg(this), "googleAdsJsInterface");
        }
        if (zzs.zzuX()) {
            this.removeJavascriptInterface("accessibility");
            this.removeJavascriptInterface("accessibilityTraversal");
        }
        this.zzth = new zzkn(this.zzSt.zzjy(), (View)this, this, null);
        this.zzd(zzdc2);
    }

    @Override
    public void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzlb) {
            this.zzSv = (zzlb)webViewClient;
        }
    }

    @Override
    public WebView getWebView() {
        return this;
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public zzd zzjA() {
        return this.zzpY;
    }

    public boolean zzjZ() {
        int n;
        int n2;
        if (!this.zzjD().zzdi()) {
            return false;
        }
        DisplayMetrics displayMetrics = zzu.zzck().zza(this.zztn);
        int n3 = zzm.zzdQ().zzb(displayMetrics, displayMetrics.widthPixels);
        int n4 = zzm.zzdQ().zzb(displayMetrics, displayMetrics.heightPixels);
        Activity activity = this.zzjy();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            int[] nArray = zzu.zzck().zzh(activity);
            n2 = zzm.zzdQ().zzb(displayMetrics, nArray[0]);
            n = zzm.zzdQ().zzb(displayMetrics, nArray[1]);
        }
        if (this.zzGy == n3 && this.zzGz == n4 && this.zzGB == n2 && this.zzGC == n) {
            return false;
        }
        boolean bl = this.zzGy != n3 || this.zzGz != n4;
        this.zzGy = n3;
        this.zzGz = n4;
        this.zzGB = n2;
        this.zzGC = n;
        new zzgw(this).zza(n3, n4, n2, n, displayMetrics.density, this.zztn.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzu.zzck().zzM(map);
        }
        catch (JSONException jSONException) {
            zzjw.zzaW((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zzb(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    public void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzjw.zzaW((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(string2, valueCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzba(String string2) {
        Object object = this.zzpp;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzjw.zzaW((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadUrl(String string2) {
        Object object = this.zzpp;
        synchronized (object) {
            if (!this.isDestroyed()) {
                try {
                    super.loadUrl(string2);
                }
                catch (Throwable throwable) {
                    String string3 = String.valueOf(throwable);
                    zzjw.zzaW((String)new StringBuilder(24 + String.valueOf(string3).length()).append("Could not call loadUrl. ").append(string3).toString());
                }
            } else {
                zzjw.zzaW((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzaX(String string2) {
        Object object = this.zzpp;
        synchronized (object) {
            try {
                super.loadUrl(string2);
            }
            catch (Throwable throwable) {
                String string3 = String.valueOf(throwable);
                zzjw.zzaW((String)new StringBuilder(24 + String.valueOf(string3).length()).append("Could not call loadUrl. ").append(string3).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(String string2, String string3, String string4) {
        Object object = this.zzpp;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(string2, string3, string4);
            } else {
                zzjw.zzaW((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        Object object = this.zzpp;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            } else {
                zzjw.zzaW((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    protected void zza(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzpp;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.evaluateJavascript(string2, valueCallback);
            } else {
                zzjw.zzaW((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
            }
        }
    }

    protected void zzbb(String string2) {
        if (zzs.zzve()) {
            if (this.zziL() == null) {
                this.zzka();
            }
            if (this.zziL().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
            } else {
                String string3 = String.valueOf(string2);
                this.zzba(string3.length() != 0 ? "javascript:".concat(string3) : new String("javascript:"));
            }
        } else {
            String string4 = String.valueOf(string2);
            this.zzba(string4.length() != 0 ? "javascript:".concat(string4) : new String("javascript:"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzka() {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzPO = zzu.zzcn().zziL();
            if (this.zzPO == null) {
                try {
                    String string2 = "(function(){})()";
                    this.evaluateJavascript(string2, null);
                    this.zzb(true);
                }
                catch (IllegalStateException illegalStateException) {
                    this.zzb(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzb(Boolean bl) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzPO = bl;
        }
        zzu.zzcn().zzb(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean zziL() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzPO;
        }
    }

    @Override
    public void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        this.zzh(string2, string3);
    }

    @Override
    public void zzh(String string2, String string3) {
        String string4 = new StringBuilder(3 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("(").append(string3).append(");").toString();
        this.zzbb(string4);
    }

    @Override
    public void zzb(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AFMA_ReceiveMessage('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzjw.v(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: "));
        this.zzbb(stringBuilder.toString());
    }

    @Override
    public void zzjw() {
        this.zzkb();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzqP.afmaVersion);
        this.zza("onhide", hashMap);
    }

    @Override
    public void zzD(int n) {
        this.zzkb();
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzqP.afmaVersion);
        this.zza("onhide", hashMap);
    }

    private void zzkb() {
        zzcy.zza(this.zzSJ.zzez(), this.zzSG, "aeh");
    }

    @Override
    public void zzgu() {
        if (this.zzSG == null) {
            zzcy.zza(this.zzSJ.zzez(), this.zzSI, "aes");
            this.zzSG = zzcy.zzb(this.zzSJ.zzez());
            this.zzSJ.zza("native:view_show", this.zzSG);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzqP.afmaVersion);
        this.zza("onshow", hashMap);
    }

    @Override
    public void zzjx() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzu.zzck().zzbU()));
        hashMap.put("app_volume", String.valueOf(zzu.zzck().zzbS()));
        hashMap.put("device_volume", String.valueOf(zzu.zzck().zzK(this.getContext())));
        this.zza("volume", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zzd zzjB() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzSw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zzd zzjC() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzSL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdSizeParcel zzbi() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzrJ;
        }
    }

    @Override
    public zzlb zzjD() {
        return this.zzSv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzjE() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzSx;
        }
    }

    @Override
    public zzaq zzjF() {
        return this.zzAZ;
    }

    @Override
    public VersionInfoParcel zzjG() {
        return this.zzqP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzjH() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzSz;
        }
    }

    public void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzu.zzck().zzb(this.getContext(), intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzjw.zzaU((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzAZ != null) {
            this.zzAZ.zza(motionEvent);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int n, int n2) {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.zzSz || this.zzrJ.zzvv || this.zzrJ.zzvw) {
                super.onMeasure(n, n2);
                return;
            }
            if (this.zzrJ.zzvt) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zztn.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n3 = View.MeasureSpec.getMode((int)n);
            int n4 = View.MeasureSpec.getSize((int)n);
            int n5 = View.MeasureSpec.getMode((int)n2);
            int n6 = View.MeasureSpec.getSize((int)n2);
            int n7 = Integer.MAX_VALUE;
            if (n3 == Integer.MIN_VALUE || n3 == 0x40000000) {
                n7 = n4;
            }
            int n8 = Integer.MAX_VALUE;
            if (n5 == Integer.MIN_VALUE || n5 == 0x40000000) {
                n8 = n6;
            }
            if (this.zzrJ.widthPixels > n7 || this.zzrJ.heightPixels > n8) {
                float f = this.zzSt.getResources().getDisplayMetrics().density;
                int n9 = (int)((float)this.zzrJ.widthPixels / f);
                int n10 = (int)((float)this.zzrJ.heightPixels / f);
                int n11 = (int)((float)n4 / f);
                int n12 = (int)((float)n6 / f);
                zzjw.zzaW((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n9).append("x").append(n10).append(" dp, but only has ").append(n11).append("x").append(n12).append(" dp.").toString());
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzrJ.widthPixels, this.zzrJ.heightPixels);
            }
        }
    }

    public void onGlobalLayout() {
        boolean bl = this.zzjZ();
        com.google.android.gms.ads.internal.overlay.zzd zzd2 = this.zzjB();
        if (zzd2 != null && bl) {
            zzd2.zzgt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(Context context, AdSizeParcel adSizeParcel, zzdc zzdc2) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzth.zzjo();
            this.setContext(context);
            this.zzSw = null;
            this.zzrJ = adSizeParcel;
            this.zzSz = false;
            this.zzSx = false;
            this.zzII = "";
            this.zzSB = -1;
            zzu.zzcm().zzj(this);
            this.loadUrl("about:blank");
            this.zzSv.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
            this.zzSC = true;
            this.zzSD = false;
            this.zzSE = null;
            this.zzd(zzdc2);
            this.zzSF = false;
            zzu.zzcD().zzd(this);
            this.zzkf();
        }
    }

    private void zzd(zzdc zzdc2) {
        this.zzkg();
        this.zzSJ = new zzdb(new zzdc(true, "make_wv", this.zzrJ.zzvs));
        this.zzSJ.zzez().zzc(zzdc2);
        this.zzSH = zzcy.zzb(this.zzSJ.zzez());
        this.zzSJ.zza("native:view_create", this.zzSH);
        this.zzSI = null;
        this.zzSG = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(com.google.android.gms.ads.internal.overlay.zzd zzd2) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzSw = zzd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzc(com.google.android.gms.ads.internal.overlay.zzd zzd2) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzSL = zzd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(AdSizeParcel adSizeParcel) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzrJ = adSizeParcel;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzG(boolean bl) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzSz = bl;
            this.zzkc();
        }
    }

    @Override
    public void zzjO() {
        this.zzth.zzjn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttachedToWindow() {
        Object object = this.zzpp;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzth.onAttachedToWindow();
            }
            this.zzK(this.zzSF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        Object object = this.zzpp;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzth.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
        }
        this.zzK(false);
    }

    @Override
    public void setContext(Context context) {
        this.zzSt.setBaseContext(context);
        this.zzth.zzl(this.zzSt.zzjy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzH(boolean bl) {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzSw != null) {
                this.zzSw.zza(this.zzSv.zzdi(), bl);
            } else {
                this.zzSx = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestedOrientation() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzSB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestedOrientation(int n) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzSB = n;
            if (this.zzSw != null) {
                this.zzSw.setRequestedOrientation(this.zzSB);
            }
        }
    }

    @Override
    public Activity zzjy() {
        return this.zzSt.zzjy();
    }

    @Override
    public Context zzjz() {
        return this.zzSt.zzjz();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzkc() {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzSz || this.zzrJ.zzvt) {
                if (Build.VERSION.SDK_INT < 14) {
                    zzjw.zzaU((String)"Disabling hardware acceleration on an overlay.");
                    this.zzkd();
                } else {
                    zzjw.zzaU((String)"Enabling hardware acceleration on an overlay.");
                    this.zzke();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                zzjw.zzaU((String)"Disabling hardware acceleration on an AdView.");
                this.zzkd();
            } else {
                zzjw.zzaU((String)"Enabling hardware acceleration on an AdView.");
                this.zzke();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzkd() {
        Object object = this.zzpp;
        synchronized (object) {
            if (!this.zzSA) {
                zzu.zzcm().zzq((View)this);
            }
            this.zzSA = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzke() {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzSA) {
                zzu.zzcm().zzp((View)this);
            }
            this.zzSA = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzkg();
            this.zzth.zzjo();
            if (this.zzSw != null) {
                this.zzSw.close();
                this.zzSw.onDestroy();
                this.zzSw = null;
            }
            this.zzSv.reset();
            if (this.zzSy) {
                return;
            }
            zzu.zzcD().zzd(this);
            this.zzkf();
            this.zzSy = true;
            zzjw.v("Initiating WebView self destruct sequence in 3...");
            this.zzSv.zzjT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Object object = this.zzpp;
        synchronized (object) {
            if (!this.zzSy) {
                this.zzSv.reset();
                zzu.zzcD().zzd(this);
                this.zzkf();
            }
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzjI() {
        Object object = this.zzpp;
        synchronized (object) {
            zzjw.v("Destroying WebView!");
            zzka.zzQu.post(new Runnable(){

                @Override
                public void run() {
                    zzle.super.destroy();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzSy;
        }
    }

    @TargetApi(value=21)
    protected void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
    }

    @Override
    public void zzjP() {
        if (this.zzSI == null) {
            this.zzSI = zzcy.zzb(this.zzSJ.zzez());
            this.zzSJ.zza("native:view_load", this.zzSI);
        }
    }

    @Override
    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (zzs.zzuX()) {
                super.onPause();
            }
        }
        catch (Exception exception) {
            zzjw.zzb((String)"Could not pause webview.", (Throwable)exception);
        }
    }

    @Override
    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (zzs.zzuX()) {
                super.onResume();
            }
        }
        catch (Exception exception) {
            zzjw.zzb((String)"Could not resume webview.", (Throwable)exception);
        }
    }

    @Override
    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
        }
        catch (Exception exception) {
            zzjw.zzb((String)"Could not stop loading webview.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzI(boolean bl) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzSC = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzgO() {
        Object object = this.zzpp;
        synchronized (object) {
            zzcy.zza(this.zzSJ.zzez(), this.zzSG, "aebb");
            return this.zzSC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzjJ() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzSD;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzbA() {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzSD = true;
            if (this.zzSu != null) {
                this.zzSu.zzbA();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzbB() {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzSD = false;
            if (this.zzSu != null) {
                this.zzSu.zzbB();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzkf() {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzSM = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzaY(String string2) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzII = string2 == null ? "" : string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRequestId() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzII;
        }
    }

    @Override
    public zzkz zzjK() {
        return null;
    }

    @Override
    public zzda zzjL() {
        return this.zzSI;
    }

    @Override
    public zzdb zzjM() {
        return this.zzSJ;
    }

    @Override
    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzSK = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public View.OnClickListener zzjQ() {
        return (View.OnClickListener)this.zzSK.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzlf zzjN() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzSE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzlf zzlf2) {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzSE != null) {
                zzjw.e((String)"Attempt to create multiple AdWebViewVideoControllers.");
                return;
            }
            this.zzSE = zzlf2;
        }
    }

    private void zzkg() {
        if (this.zzSJ == null) {
            return;
        }
        zzdc zzdc2 = this.zzSJ.zzez();
        if (zzdc2 != null && zzu.zzcn().zziG() != null) {
            zzu.zzcn().zziG().zza(zzdc2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzbv zzbv2, boolean bl) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzSF = bl;
        }
        this.zzK(bl);
    }

    private void zzK(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public void zza(String string2, zzeh zzeh2) {
        if (this.zzSv != null) {
            this.zzSv.zza(string2, zzeh2);
        }
    }

    @Override
    public void zzb(String string2, zzeh zzeh2) {
        if (this.zzSv != null) {
            this.zzSv.zzb(string2, zzeh2);
        }
    }

    @zzig
    public static class zza
    extends MutableContextWrapper {
        private Activity zzRn;
        private Context zztm;
        private Context zzSO;

        public zza(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context context) {
            this.zztm = context.getApplicationContext();
            this.zzRn = context instanceof Activity ? (Activity)context : null;
            this.zzSO = context;
            super.setBaseContext(this.zztm);
        }

        public void startActivity(Intent intent) {
            if (this.zzRn != null) {
                this.zzRn.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.zztm.startActivity(intent);
            }
        }

        public Activity zzjy() {
            return this.zzRn;
        }

        public Object getSystemService(String string2) {
            return this.zzSO.getSystemService(string2);
        }

        public Context zzjz() {
            return this.zzSO;
        }
    }
}

