/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.formats;

import android.content.Context;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.zza;
import com.google.android.gms.ads.internal.formats.zzb;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzas;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzet;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzil;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzll;
import com.google.android.gms.internal.zzlm;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzir
public class zzi
implements zzh {
    private final Object zzail = new Object();
    private final zzq zzbgb;
    private final Context mContext;
    private final JSONObject zzbge;
    private final zzil zzbgf;
    private final zzh.zza zzbgg;
    private final zzas zzbgh;
    private final VersionInfoParcel zzalm;
    private boolean zzbgi;
    private zzll zzbgj;
    private String zzbgk;
    private String zzbgl;
    private WeakReference<View> zzbgm = null;

    public zzi(Context context, zzq zzq2, zzil zzil2, zzas zzas2, JSONObject jSONObject, zzh.zza zza2, VersionInfoParcel versionInfoParcel, String string) {
        this.mContext = context;
        this.zzbgb = zzq2;
        this.zzbgf = zzil2;
        this.zzbgh = zzas2;
        this.zzbge = jSONObject;
        this.zzbgg = zza2;
        this.zzalm = versionInfoParcel;
        this.zzbgl = string;
    }

    public zzb zza(View.OnClickListener onClickListener) {
        zza zza2 = this.zzbgg.zzkz();
        if (zza2 == null) {
            return null;
        }
        zzb zzb2 = new zzb(this.mContext, zza2);
        zzb2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzb2.zzku().setOnClickListener(onClickListener);
        zzb2.zzku().setContentDescription((CharSequence)"Ad attribution icon");
        return zzb2;
    }

    public void zza(String string, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3) {
        zzab.zzhj((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject4 = new JSONObject();
            jSONObject4.put("asset", (Object)string);
            jSONObject4.put("template", (Object)this.zzbgg.zzky());
            final JSONObject jSONObject5 = new JSONObject();
            jSONObject5.put("ad", (Object)this.zzbge);
            jSONObject5.put("click", (Object)jSONObject4);
            jSONObject5.put("has_custom_click_handler", this.zzbgb.zzv(this.zzbgg.getCustomTemplateId()) != null);
            if (jSONObject != null) {
                jSONObject5.put("view_rectangles", (Object)jSONObject);
            }
            if (jSONObject2 != null) {
                jSONObject5.put("click_point", (Object)jSONObject2);
            }
            if (jSONObject3 != null) {
                jSONObject5.put("native_view_rectangle", (Object)jSONObject3);
            }
            jSONObject5.put("ads_id", (Object)this.zzbgl);
            this.zzbgf.zza(new zzil.zza(){

                @Override
                public void zze(zzfx zzfx2) {
                    zzfx2.zza("google.afma.nativeAds.handleClickGmsg", jSONObject5);
                }
            });
        }
        catch (JSONException jSONException) {
            zzkh.zzb((String)"Unable to create click JSON.", (Throwable)jSONException);
        }
    }

    public void zza(View view, Map<String, WeakReference<View>> map, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3) {
        zzab.zzhj((String)"performClick must be called on the main UI thread.");
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (!view.equals(view2)) continue;
            this.zza(entry.getKey(), jSONObject, jSONObject2, jSONObject3);
            return;
        }
        if ("2".equals(this.zzbgg.zzky())) {
            this.zza("2099", jSONObject, jSONObject2, jSONObject3);
        } else if ("1".equals(this.zzbgg.zzky())) {
            this.zza("1099", jSONObject, jSONObject2, jSONObject3);
        }
    }

    public void zzb(MotionEvent motionEvent) {
        this.zzbgh.zza(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzg(View view) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzbgi) {
                return;
            }
            if (!view.isShown()) {
                return;
            }
            if (!view.getGlobalVisibleRect(new Rect(), null)) {
                return;
            }
            this.recordImpression();
        }
    }

    public void recordImpression() {
        zzab.zzhj((String)"recordImpression must be called on the main UI thread.");
        this.zzq(true);
        try {
            final JSONObject jSONObject = new JSONObject();
            jSONObject.put("ad", (Object)this.zzbge);
            jSONObject.put("ads_id", (Object)this.zzbgl);
            this.zzbgf.zza(new zzil.zza(){

                @Override
                public void zze(zzfx zzfx2) {
                    zzfx2.zza("google.afma.nativeAds.handleImpressionPing", jSONObject);
                }
            });
        }
        catch (JSONException jSONException) {
            zzkh.zzb((String)"Unable to create impression JSON.", (Throwable)jSONException);
        }
        this.zzbgb.zza(this);
    }

    public View zzle() {
        return this.zzbgm != null ? (View)this.zzbgm.get() : null;
    }

    public void zzh(View view) {
        this.zzbgm = new WeakReference<View>(view);
    }

    public void zza(View view, Map<String, WeakReference<View>> map, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        if (!zzdc.zzbcg.get().booleanValue()) {
            return;
        }
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(onTouchListener);
            view2.setClickable(true);
            view2.setOnClickListener(onClickListener);
        }
    }

    public void zzb(View view, Map<String, WeakReference<View>> map) {
        view.setOnTouchListener(null);
        view.setClickable(false);
        view.setOnClickListener(null);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(null);
            view2.setClickable(false);
            view2.setOnClickListener(null);
        }
    }

    public zzll zzld() {
        this.zzbgj = this.zzlf();
        this.zzbgj.getView().setVisibility(8);
        zzil.zza zza2 = new zzil.zza(){

            @Override
            public void zze(final zzfx zzfx2) {
                zzfx2.zza("/loadHtml", new zzet(){

                    @Override
                    public void zza(zzll zzll2, final Map<String, String> map) {
                        zzi.this.zzbgj.zzuk().zza(new zzlm.zza(){

                            @Override
                            public void zza(zzll zzll2, boolean bl) {
                                zzi.this.zzbgk = (String)map.get("id");
                                JSONObject jSONObject = new JSONObject();
                                try {
                                    jSONObject.put("messageType", (Object)"htmlLoaded");
                                    jSONObject.put("id", (Object)zzi.this.zzbgk);
                                    zzfx2.zzb("sendMessageToNativeJs", jSONObject);
                                }
                                catch (JSONException jSONException) {
                                    zzkh.zzb((String)"Unable to dispatch sendMessageToNativeJs event", (Throwable)jSONException);
                                }
                            }
                        });
                        String string = map.get("overlayHtml");
                        String string2 = map.get("baseUrl");
                        if (TextUtils.isEmpty((CharSequence)string2)) {
                            zzi.this.zzbgj.loadData(string, "text/html", "UTF-8");
                        } else {
                            zzi.this.zzbgj.loadDataWithBaseURL(string2, string, "text/html", "UTF-8", null);
                        }
                    }
                });
                zzfx2.zza("/showOverlay", new zzet(){

                    @Override
                    public void zza(zzll zzll2, Map<String, String> map) {
                        zzi.this.zzbgj.getView().setVisibility(0);
                    }
                });
                zzfx2.zza("/hideOverlay", new zzet(){

                    @Override
                    public void zza(zzll zzll2, Map<String, String> map) {
                        zzi.this.zzbgj.getView().setVisibility(8);
                    }
                });
                zzi.this.zzbgj.zzuk().zza("/hideOverlay", new zzet(){

                    @Override
                    public void zza(zzll zzll2, Map<String, String> map) {
                        zzi.this.zzbgj.getView().setVisibility(8);
                    }
                });
                zzi.this.zzbgj.zzuk().zza("/sendMessageToSdk", new zzet(){

                    @Override
                    public void zza(zzll zzll2, Map<String, String> map) {
                        JSONObject jSONObject = new JSONObject();
                        try {
                            for (String string : map.keySet()) {
                                jSONObject.put(string, (Object)map.get(string));
                            }
                            jSONObject.put("id", (Object)zzi.this.zzbgk);
                            zzfx2.zzb("sendMessageToNativeJs", jSONObject);
                        }
                        catch (JSONException jSONException) {
                            zzkh.zzb((String)"Unable to dispatch sendMessageToNativeJs event", (Throwable)jSONException);
                        }
                    }
                });
            }
        };
        this.zzbgf.zza(zza2);
        return this.zzbgj;
    }

    protected void zzq(boolean bl) {
        this.zzbgi = bl;
    }

    zzll zzlf() {
        return zzu.zzfr().zza(this.mContext, AdSizeParcel.zzk((Context)this.mContext), false, false, this.zzbgh, this.zzalm);
    }

    public Context getContext() {
        return this.mContext;
    }
}

