/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzw;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzir
@TargetApi(value=14)
public class zzc
extends zzi
implements AudioManager.OnAudioFocusChangeListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzbrv = new HashMap<Integer, String>();
    private final zzx zzbrw;
    private final boolean zzbrx;
    private int zzbry = 0;
    private int zzbrz = 0;
    private MediaPlayer zzbsa;
    private Uri zzbsb;
    private int zzbsc;
    private int zzbsd;
    private int zzbse;
    private int zzbsf;
    private int zzbsg;
    private float zzbsh = 1.0f;
    private boolean zzbsi;
    private boolean zzbsj;
    private zzw zzbsk;
    private boolean zzbsl;
    private int zzbsm;
    private zzh zzbsn;

    public zzc(Context context, boolean bl, boolean bl2, zzx zzx2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzbrw = zzx2;
        this.zzbsl = bl;
        this.zzbrx = bl2;
        this.zzbrw.zza(this);
    }

    @Override
    public String zznk() {
        String string = String.valueOf(this.zzbsl ? " spherical" : "");
        return string.length() != 0 ? "MediaPlayer".concat(string) : new String("MediaPlayer");
    }

    @Override
    public void zza(zzh zzh2) {
        this.zzbsn = zzh2;
    }

    @Override
    public void setMimeType(String string) {
    }

    @Override
    public void setVideoPath(String string) {
        this.setVideoURI(Uri.parse((String)string));
    }

    public void setVideoURI(Uri uri) {
        this.zzbsb = uri;
        this.zzbsm = 0;
        this.zznl();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void stop() {
        zzkh.v("AdMediaPlayerView stop");
        if (this.zzbsa != null) {
            this.zzbsa.stop();
            this.zzbsa.release();
            this.zzbsa = null;
            this.zzad(0);
            this.zzae(0);
            this.zzno();
        }
        this.zzbrw.onStop();
    }

    public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzkh.v(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzbsc = mediaPlayer.getVideoWidth();
        this.zzbsd = mediaPlayer.getVideoHeight();
        if (this.zzbsc != 0 && this.zzbsd != 0) {
            this.requestLayout();
        }
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        zzkh.v("AdMediaPlayerView prepared");
        this.zzad(2);
        this.zzbrw.zzol();
        zzkl.zzclg.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzbsn != null) {
                    zzc.this.zzbsn.zzol();
                }
            }
        });
        this.zzbsc = mediaPlayer.getVideoWidth();
        this.zzbsd = mediaPlayer.getVideoHeight();
        if (this.zzbsm != 0) {
            this.seekTo(this.zzbsm);
        }
        this.zznm();
        int n = this.zzbsc;
        int n2 = this.zzbsd;
        zzkh.zzcx((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzbrz == 3) {
            this.play();
        }
        this.zznn();
        this.zznu();
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        zzkh.v("AdMediaPlayerView completion");
        this.zzad(5);
        this.zzae(5);
        zzkl.zzclg.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzbsn != null) {
                    zzc.this.zzbsn.zzon();
                }
            }
        });
    }

    public boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string = zzbrv.get(n);
        String string2 = zzbrv.get(n2);
        zzkh.v(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string).append(":").append(string2).toString());
        return true;
    }

    public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        final String string = zzbrv.get(n);
        final String string2 = zzbrv.get(n2);
        zzkh.zzcy((String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string).append(":").append(string2).toString());
        this.zzad(-1);
        this.zzae(-1);
        zzkl.zzclg.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzbsn != null) {
                    zzc.this.zzbsn.zzl(string, string2);
                }
            }
        });
        return true;
    }

    public void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzbse = n;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzkh.v("AdMediaPlayerView surface created");
        this.zznl();
        zzkl.zzclg.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzbsn != null) {
                    zzc.this.zzbsn.zzok();
                }
            }
        });
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        boolean bl;
        zzkh.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzbrz == 3;
        boolean bl3 = bl = this.zzbsc == n && this.zzbsd == n2;
        if (this.zzbsa != null && bl2 && bl) {
            if (this.zzbsm != 0) {
                this.seekTo(this.zzbsm);
            }
            this.play();
        }
        if (this.zzbsk != null) {
            this.zzbsk.zzg(n, n2);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzkh.v("AdMediaPlayerView surface destroyed");
        if (this.zzbsa != null && this.zzbsm == 0) {
            this.zzbsm = this.zzbsa.getCurrentPosition();
        }
        if (this.zzbsk != null) {
            this.zzbsk.zzoy();
        }
        zzkl.zzclg.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzbsn != null) {
                    zzc.this.zzbsn.onPaused();
                    zzc.this.zzbsn.zzoo();
                }
            }
        });
        this.zzy(true);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzbrw.zzb(this);
    }

    protected void onMeasure(int n, int n2) {
        int n3 = zzc.getDefaultSize((int)this.zzbsc, (int)n);
        int n4 = zzc.getDefaultSize((int)this.zzbsd, (int)n2);
        if (this.zzbsc > 0 && this.zzbsd > 0 && this.zzbsk == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzbsc * n4 < n3 * this.zzbsd) {
                    n3 = n4 * this.zzbsc / this.zzbsd;
                } else if (this.zzbsc * n4 > n3 * this.zzbsd) {
                    n4 = n3 * this.zzbsd / this.zzbsc;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzbsd / this.zzbsc;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzbsc / this.zzbsd;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzbsc;
                n4 = this.zzbsd;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzbsc / this.zzbsd;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzbsd / this.zzbsc;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzbsk != null) {
            this.zzbsk.zzg(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzbsf > 0 && this.zzbsf != n3 || this.zzbsg > 0 && this.zzbsg != n4) {
                this.zznm();
            }
            this.zzbsf = n3;
            this.zzbsg = n4;
        }
    }

    public String toString() {
        String string = String.valueOf(((Object)((Object)this)).getClass().getName());
        String string2 = String.valueOf(Integer.toHexString(((Object)((Object)this)).hashCode()));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("@").append(string2).toString();
    }

    private void zznl() {
        zzkh.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzbsb == null || surfaceTexture == null) {
            return;
        }
        this.zzy(false);
        try {
            Surface surface;
            this.zzbsa = zzu.zzgd().zzox();
            this.zzbsa.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzbsa.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzbsa.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzbsa.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzbsa.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzbsa.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzbse = 0;
            if (this.zzbsl) {
                this.zzbsk = new zzw(this.getContext());
                this.zzbsk.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzbsk.start();
                surface = this.zzbsk.zzoz();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzbsk.zzoy();
                    this.zzbsk = null;
                }
            }
            this.zzbsa.setDataSource(this.getContext(), this.zzbsb);
            surface = zzu.zzge().zza(surfaceTexture);
            this.zzbsa.setSurface(surface);
            this.zzbsa.setAudioStreamType(3);
            this.zzbsa.setScreenOnWhilePlaying(true);
            this.zzbsa.prepareAsync();
            this.zzad(1);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string = String.valueOf(this.zzbsb);
            zzkh.zzd((String)new StringBuilder(36 + String.valueOf(string).length()).append("Failed to initialize MediaPlayer at ").append(string).toString(), (Throwable)exception);
            this.onError(this.zzbsa, 1, 0);
        }
    }

    private void zznm() {
        if (!this.zzbrx) {
            return;
        }
        if (this.zznp() && this.zzbsa.getCurrentPosition() > 0 && this.zzbrz != 3) {
            long l;
            zzkh.v("AdMediaPlayerView nudging MediaPlayer");
            this.zzb(0.0f);
            this.zzbsa.start();
            int n = this.zzbsa.getCurrentPosition();
            long l2 = zzu.zzfu().currentTimeMillis();
            while (this.zznp() && this.zzbsa.getCurrentPosition() == n && (l = zzu.zzfu().currentTimeMillis()) - l2 <= 250L) {
            }
            this.zzbsa.pause();
            this.zznu();
        }
    }

    private void zznn() {
        AudioManager audioManager = this.zznv();
        if (audioManager != null && !this.zzbsj) {
            int n = audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 2);
            if (n == 1) {
                this.zzns();
            } else {
                zzkh.zzcy((String)"AdMediaPlayerView audio focus request failed");
            }
        }
    }

    private void zzno() {
        zzkh.v("AdMediaPlayerView abandon audio focus");
        AudioManager audioManager = this.zznv();
        if (audioManager != null && this.zzbsj) {
            int n = audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
            if (n == 1) {
                this.zzbsj = false;
            } else {
                zzkh.zzcy((String)"AdMediaPlayerView abandon audio focus failed");
            }
        }
    }

    private void zzy(boolean bl) {
        zzkh.v("AdMediaPlayerView release");
        if (this.zzbsk != null) {
            this.zzbsk.zzoy();
            this.zzbsk = null;
        }
        if (this.zzbsa != null) {
            this.zzbsa.reset();
            this.zzbsa.release();
            this.zzbsa = null;
            this.zzad(0);
            if (bl) {
                this.zzbrz = 0;
                this.zzae(0);
            }
            this.zzno();
        }
    }

    @Override
    public void play() {
        zzkh.v("AdMediaPlayerView play");
        if (this.zznp()) {
            this.zzbsa.start();
            this.zzad(3);
            zzkl.zzclg.post(new Runnable(){

                @Override
                public void run() {
                    if (zzc.this.zzbsn != null) {
                        zzc.this.zzbsn.zzom();
                    }
                }
            });
        }
        this.zzae(3);
    }

    @Override
    public void pause() {
        zzkh.v("AdMediaPlayerView pause");
        if (this.zznp() && this.zzbsa.isPlaying()) {
            this.zzbsa.pause();
            this.zzad(4);
            zzkl.zzclg.post(new Runnable(){

                @Override
                public void run() {
                    if (zzc.this.zzbsn != null) {
                        zzc.this.zzbsn.onPaused();
                    }
                }
            });
        }
        this.zzae(4);
    }

    @Override
    public int getDuration() {
        if (this.zznp()) {
            return this.zzbsa.getDuration();
        }
        return -1;
    }

    @Override
    public int getCurrentPosition() {
        if (this.zznp()) {
            return this.zzbsa.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public void seekTo(int n) {
        zzkh.v(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zznp()) {
            this.zzbsa.seekTo(n);
            this.zzbsm = 0;
        } else {
            this.zzbsm = n;
        }
    }

    private boolean zznp() {
        return this.zzbsa != null && this.zzbry != -1 && this.zzbry != 0 && this.zzbry != 1;
    }

    public void onAudioFocusChange(int n) {
        if (n > 0) {
            this.zzns();
        } else if (n < 0) {
            this.zznt();
        }
    }

    @Override
    public void zznq() {
        this.zzbsi = true;
        this.zznu();
    }

    @Override
    public void zznr() {
        this.zzbsi = false;
        this.zznu();
    }

    @Override
    public void zza(float f) {
        this.zzbsh = f;
        this.zznu();
    }

    @Override
    public void zza(float f, float f2) {
        if (this.zzbsk != null) {
            this.zzbsk.zzb(f, f2);
        }
    }

    @Override
    public int getVideoWidth() {
        if (this.zzbsa != null) {
            return this.zzbsa.getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (this.zzbsa != null) {
            return this.zzbsa.getVideoHeight();
        }
        return 0;
    }

    private void zzns() {
        zzkh.v("AdMediaPlayerView audio focus gained");
        this.zzbsj = true;
        this.zznu();
    }

    private void zznt() {
        zzkh.v("AdMediaPlayerView audio focus lost");
        this.zzbsj = false;
        this.zznu();
    }

    private void zznu() {
        if (!this.zzbsi && this.zzbsj) {
            this.zzb(this.zzbsh);
        } else {
            this.zzb(0.0f);
        }
    }

    private void zzb(float f) {
        if (this.zzbsa != null) {
            try {
                this.zzbsa.setVolume(f, f);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            zzkh.zzcy((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
        }
    }

    private AudioManager zznv() {
        Context context = this.getContext();
        return (AudioManager)context.getSystemService("audio");
    }

    private void zzad(int n) {
        if (n == 3) {
            this.zzbrw.zzpk();
        } else if (this.zzbry == 3) {
            this.zzbrw.zzpl();
        }
        this.zzbry = n;
    }

    private void zzae(int n) {
        this.zzbrz = n;
    }

    static {
        zzbrv.put(-1004, "MEDIA_ERROR_IO");
        zzbrv.put(-1007, "MEDIA_ERROR_MALFORMED");
        zzbrv.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
        zzbrv.put(-110, "MEDIA_ERROR_TIMED_OUT");
        zzbrv.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzbrv.put(1, "MEDIA_ERROR_UNKNOWN");
        zzbrv.put(1, "MEDIA_INFO_UNKNOWN");
        zzbrv.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzbrv.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        zzbrv.put(701, "MEDIA_INFO_BUFFERING_START");
        zzbrv.put(702, "MEDIA_INFO_BUFFERING_END");
        zzbrv.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzbrv.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzbrv.put(802, "MEDIA_INFO_METADATA_UPDATE");
        zzbrv.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
        zzbrv.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
    }
}

