/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkl;
import com.google.android.gms.internal.zzll;
import java.util.HashMap;

@zzir
public class zzk
extends FrameLayout
implements zzh {
    private final zzll zzbgj;
    private final FrameLayout zzbua;
    private final zzy zzbub;
    @Nullable
    private zzi zzbuc;
    private boolean zzbud;
    private boolean zzbue;
    private TextView zzbuf;
    private long zzbug;
    private long zzbuh;
    private String zzbui;
    private String zzbjg;

    public static void zzi(zzll zzll2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzll2.zza("onVideoEvent", hashMap);
    }

    public zzk(Context context, zzll zzll2, int n, boolean bl, zzdk zzdk2, zzdi zzdi2) {
        super(context);
        this.zzbgj = zzll2;
        this.zzbua = new FrameLayout(context);
        this.addView((View)this.zzbua, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzb.zzw((Object)zzll2.zzuh());
        this.zzbuc = zzll2.zzuh().zzakk.zza(context, zzll2, n, bl, zzdk2, zzdi2);
        if (this.zzbuc != null) {
            this.zzbua.addView((View)this.zzbuc, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        }
        this.zzbuf = new TextView(context);
        this.zzbuf.setBackgroundColor(-16777216);
        this.zzor();
        this.zzbub = new zzy(this);
        this.zzbub.zzpm();
        if (this.zzbuc != null) {
            this.zzbuc.zza(this);
        }
        if (this.zzbuc == null) {
            this.zzl("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3 + 2, n4 + 2);
        layoutParams.setMargins(n - 1, n2 - 1, 0, 0);
        this.zzbua.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public void setMimeType(String string) {
        this.zzbui = string;
    }

    public void zzbx(String string) {
        this.zzbjg = string;
    }

    public void zza(float f, float f2) {
        if (this.zzbuc != null) {
            this.zzbuc.zza(f, f2);
        }
    }

    public void zzlx() {
        if (this.zzbuc == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzbjg)) {
            this.zzbuc.setMimeType(this.zzbui);
            this.zzbuc.setVideoPath(this.zzbjg);
        } else {
            this.zza("no_src", new String[0]);
        }
    }

    public void pause() {
        if (this.zzbuc == null) {
            return;
        }
        this.zzbuc.pause();
    }

    public void play() {
        if (this.zzbuc == null) {
            return;
        }
        this.zzbuc.play();
    }

    public void seekTo(int n) {
        if (this.zzbuc == null) {
            return;
        }
        this.zzbuc.seekTo(n);
    }

    public void zznq() {
        if (this.zzbuc == null) {
            return;
        }
        this.zzbuc.zznq();
    }

    public void zznr() {
        if (this.zzbuc == null) {
            return;
        }
        this.zzbuc.zznr();
    }

    public void zza(float f) {
        if (this.zzbuc == null) {
            return;
        }
        this.zzbuc.zza(f);
    }

    public void zzd(MotionEvent motionEvent) {
        if (this.zzbuc == null) {
            return;
        }
        this.zzbuc.dispatchTouchEvent(motionEvent);
    }

    public void zzop() {
        if (this.zzbuc == null) {
            return;
        }
        Context context = this.zzbuc.getContext();
        TextView textView = new TextView(context);
        String string = String.valueOf(this.zzbuc.zznk());
        textView.setText((CharSequence)(string.length() != 0 ? "AdMob - ".concat(string) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzbua.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzbua.bringChildToFront((View)textView);
    }

    @Override
    public void zzok() {
        zzkl.zzclg.post(new Runnable(){

            @Override
            public void run() {
                zzk.this.zza("surfaceCreated", new String[0]);
            }
        });
    }

    @Override
    public void zzol() {
        if (this.zzbuc == null) {
            return;
        }
        if (this.zzbuh == 0L) {
            float f = (float)this.zzbuc.getDuration() / 1000.0f;
            int n = this.zzbuc.getVideoWidth();
            int n2 = this.zzbuc.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public void zzom() {
        this.zzou();
    }

    @Override
    public void onPaused() {
        this.zza("pause", new String[0]);
        this.zzov();
    }

    @Override
    public void zzon() {
        this.zza("ended", new String[0]);
        this.zzov();
    }

    @Override
    public void zzl(String string, String string2) {
        this.zza("error", "what", string, "extra", string2);
    }

    @Override
    public void zzoo() {
        this.zzor();
        this.zzbuh = this.zzbug;
        zzkl.zzclg.post(new Runnable(){

            @Override
            public void run() {
                zzk.this.zza("surfaceDestroyed", new String[0]);
            }
        });
    }

    public void destroy() {
        this.zzbub.cancel();
        if (this.zzbuc != null) {
            this.zzbuc.stop();
        }
        this.zzov();
    }

    void zzoq() {
        if (this.zzbuc == null) {
            return;
        }
        long l = this.zzbuc.getCurrentPosition();
        if (this.zzbug != l && l > 0L) {
            this.zzos();
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzbug = l;
        }
    }

    private void zzor() {
        if (!this.zzot()) {
            this.zzbua.addView((View)this.zzbuf, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.zzbua.bringChildToFront((View)this.zzbuf);
        }
    }

    private void zzos() {
        if (this.zzot()) {
            this.zzbua.removeView((View)this.zzbuf);
        }
    }

    private boolean zzot() {
        return this.zzbuf.getParent() != null;
    }

    private void zza(String string, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string);
        String string2 = null;
        for (String string3 : stringArray) {
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            hashMap.put(string2, string3);
            string2 = null;
        }
        this.zzbgj.zza("onVideoEvent", hashMap);
    }

    private void zzou() {
        if (this.zzbgj.zzuf() == null) {
            return;
        }
        if (this.zzbud) {
            return;
        }
        WindowManager.LayoutParams layoutParams = this.zzbgj.zzuf().getWindow().getAttributes();
        boolean bl = this.zzbue = (layoutParams.flags & 0x80) != 0;
        if (!this.zzbue) {
            this.zzbgj.zzuf().getWindow().addFlags(128);
            this.zzbud = true;
        }
    }

    private void zzov() {
        if (this.zzbgj.zzuf() == null) {
            return;
        }
        if (this.zzbud && !this.zzbue) {
            this.zzbgj.zzuf().getWindow().clearFlags(128);
            this.zzbud = false;
        }
    }
}

