/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.TextureView;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkq;
import java.util.concurrent.TimeUnit;

@zzir
public class zzx {
    private final Context mContext;
    private final String zzbvu;
    private final VersionInfoParcel zzamu;
    @Nullable
    private final zzdi zzbvv;
    @Nullable
    private final zzdk zzbvw;
    private final zzkq zzbvx = new zzkq.zzb().zza("min_1", Double.MIN_VALUE, 1.0).zza("1_5", 1.0, 5.0).zza("5_10", 5.0, 10.0).zza("10_20", 10.0, 20.0).zza("20_30", 20.0, 30.0).zza("30_max", 30.0, Double.MAX_VALUE).zztp();
    private final long[] zzbvy;
    private final String[] zzbvz;
    @Nullable
    private zzdi zzbwa;
    @Nullable
    private zzdi zzbwb;
    @Nullable
    private zzdi zzbwc;
    @Nullable
    private zzdi zzbwd;
    private boolean zzbwe;
    private zzi zzbwf;
    private boolean zzbwg;
    private boolean zzbwh;
    private long zzbwi = -1L;

    public zzx(Context context, VersionInfoParcel versionInfoParcel, String string, @Nullable zzdk zzdk2, @Nullable zzdi zzdi2) {
        this.mContext = context;
        this.zzamu = versionInfoParcel;
        this.zzbvu = string;
        this.zzbvw = zzdk2;
        this.zzbvv = zzdi2;
        String string2 = zzdc.zzayr.get();
        if (string2 == null) {
            this.zzbvz = new String[0];
            this.zzbvy = new long[0];
            return;
        }
        String[] stringArray = TextUtils.split((String)string2, (String)",");
        this.zzbvz = new String[stringArray.length];
        this.zzbvy = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.zzbvy[i] = Long.parseLong(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                zzkh.zzd((String)"Unable to parse frame hash target time number.", (Throwable)numberFormatException);
                this.zzbvy[i] = -1L;
            }
        }
    }

    public void zza(zzi zzi2) {
        zzdg.zza(this.zzbvw, this.zzbvv, "vpc");
        this.zzbwa = zzdg.zzb(this.zzbvw);
        if (this.zzbvw != null) {
            this.zzbvw.zzh("vpn", zzi2.zznk());
        }
        this.zzbwf = zzi2;
    }

    public void zzol() {
        if (this.zzbwa == null || this.zzbwb != null) {
            return;
        }
        zzdg.zza(this.zzbvw, this.zzbwa, "vfr");
        this.zzbwb = zzdg.zzb(this.zzbvw);
    }

    public void onStop() {
        if (zzdc.zzayq.get().booleanValue() && !this.zzbwg) {
            Bundle bundle = new Bundle();
            bundle.putString("type", "native-player-metrics");
            bundle.putString("request", this.zzbvu);
            bundle.putString("player", this.zzbwf.zznk());
            for (zzkq.zza object : this.zzbvx.getBuckets()) {
                String string = String.valueOf("fps_c_");
                String string2 = String.valueOf(object.name);
                bundle.putString(string2.length() != 0 ? string.concat(string2) : new String(string), Integer.toString(object.count));
                String string3 = String.valueOf("fps_p_");
                String string4 = String.valueOf(object.name);
                bundle.putString(string4.length() != 0 ? string3.concat(string4) : new String(string3), Double.toString(object.zzcmc));
            }
            for (int i = 0; i < this.zzbvy.length; ++i) {
                String string = this.zzbvz[i];
                if (string == null) continue;
                String string5 = String.valueOf("fh_");
                String string6 = String.valueOf((Object)this.zzbvy[i]);
                bundle.putString(new StringBuilder(0 + String.valueOf(string5).length() + String.valueOf(string6).length()).append(string5).append(string6).toString(), string);
            }
            zzu.zzfq().zza(this.mContext, this.zzamu.zzcs, "gmob-apps", bundle, true);
            this.zzbwg = true;
        }
    }

    public void zzb(zzi zzi2) {
        this.zzpj();
        this.zzc(zzi2);
    }

    private void zzpj() {
        if (this.zzbwc != null && this.zzbwd == null) {
            zzdg.zza(this.zzbvw, this.zzbwc, "vff");
            zzdg.zza(this.zzbvw, this.zzbvv, "vtt");
            this.zzbwd = zzdg.zzb(this.zzbvw);
        }
        long l = zzu.zzfu().nanoTime();
        if (this.zzbwe && this.zzbwh && this.zzbwi != -1L) {
            double d = (double)TimeUnit.SECONDS.toNanos(1L) / (double)(l - this.zzbwi);
            this.zzbvx.zza(d);
        }
        this.zzbwh = this.zzbwe;
        this.zzbwi = l;
    }

    private void zzc(zzi zzi2) {
        long l = zzdc.zzays.get();
        long l2 = zzi2.getCurrentPosition();
        for (int i = 0; i < this.zzbvz.length; ++i) {
            long l3;
            if (this.zzbvz[i] != null || l <= Math.abs(l2 - (l3 = this.zzbvy[i]))) continue;
            this.zzbvz[i] = this.zza((TextureView)zzi2);
            break;
        }
    }

    String zza(TextureView textureView) {
        Bitmap bitmap = textureView.getBitmap(8, 8);
        long l = 0L;
        long l2 = 63L;
        for (int i = 0; i < 8; ++i) {
            int n = 0;
            while (n < 8) {
                int n2 = bitmap.getPixel(n, i);
                int n3 = Color.blue((int)n2) + Color.red((int)n2) + Color.green((int)n2);
                long l3 = n3 > 128 ? 1L : 0L;
                l |= l3 << (int)l2;
                ++n;
                --l2;
            }
        }
        return String.format("%016X", l);
    }

    public void zzpk() {
        this.zzbwe = true;
        if (this.zzbwb != null && this.zzbwc == null) {
            zzdg.zza(this.zzbvw, this.zzbwb, "vfp");
            this.zzbwc = zzdg.zzb(this.zzbvw);
        }
    }

    public void zzpl() {
        this.zzbwe = false;
    }
}

