/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.webkit.CookieManager;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzas;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzge;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzjy;
import com.google.android.gms.internal.zzkg;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkk;
import com.google.android.gms.internal.zzkl;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzle;
import com.google.android.gms.internal.zzlf;
import org.json.JSONException;
import org.json.JSONObject;

@zzir
public class zzb
extends zzkg
implements zzc.zza {
    private final zza.zza zzcai;
    private final AdRequestInfoParcel.zza zzcaj;
    private final Object zzbxy = new Object();
    private final Context mContext;
    private final zzas zzbgh;
    private AdRequestInfoParcel zzbox;
    private Runnable zzbxx;
    zzkn zzcak;
    AdResponseParcel zzbxw;
    zzge zzboi;

    public zzb(Context context, AdRequestInfoParcel.zza zza2, zzas zzas2, zza.zza zza3) {
        this.zzcai = zza3;
        this.mContext = context;
        this.zzcaj = zza2;
        this.zzbgh = zzas2;
    }

    zzkn zza(VersionInfoParcel versionInfoParcel, zzle<AdRequestInfoParcel> zzle2) {
        return zzc.zza(this.mContext, versionInfoParcel, zzle2, this);
    }

    @Override
    public void zzew() {
        zzkh.zzcw((String)"AdLoaderBackgroundTask started.");
        this.zzbxx = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzb.this.zzbxy;
                synchronized (object) {
                    if (zzb.this.zzcak == null) {
                        return;
                    }
                    zzb.this.onStop();
                    zzb.this.zzd(2, "Timed out waiting for ad response.");
                }
            }
        };
        zzkl.zzclg.postDelayed(this.zzbxx, zzdc.zzbbe.get().longValue());
        final zzlf<AdRequestInfoParcel> zzlf2 = new zzlf<AdRequestInfoParcel>();
        long l = zzu.zzfu().elapsedRealtime();
        zzkk.zza(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzb.this.zzbxy;
                synchronized (object) {
                    zzb.this.zzcak = zzb.this.zza(((zzb)zzb.this).zzcaj.zzaou, zzlf2);
                    if (zzb.this.zzcak == null) {
                        zzb.this.zzd(0, "Could not start the ad request service.");
                        zzkl.zzclg.removeCallbacks(zzb.this.zzbxx);
                    }
                }
            }
        });
        zzan zzan2 = this.zzbgh.zzax();
        String string = zzan2.zzb(this.mContext);
        this.zzbox = new AdRequestInfoParcel(this.zzcaj, string, l);
        zzlf2.zzg(this.zzbox);
    }

    private void zzd(int n, String string) {
        if (n == 3 || n == -1) {
            zzkh.zzcx((String)string);
        } else {
            zzkh.zzcy((String)string);
        }
        this.zzbxw = this.zzbxw == null ? new AdResponseParcel(n) : new AdResponseParcel(n, this.zzbxw.zzbnw);
        AdRequestInfoParcel adRequestInfoParcel = this.zzbox != null ? this.zzbox : new AdRequestInfoParcel(this.zzcaj, null, -1L);
        zzjy.zza zza2 = new zzjy.zza(adRequestInfoParcel, this.zzbxw, this.zzboi, null, n, -1L, this.zzbxw.zzccg, null);
        this.zzcai.zza(zza2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(@NonNull AdResponseParcel adResponseParcel) {
        zzkh.zzcw((String)"Received ad response.");
        this.zzbxw = adResponseParcel;
        long l = zzu.zzfu().elapsedRealtime();
        Object object = this.zzbxy;
        synchronized (object) {
            this.zzcak = null;
        }
        zzu.zzft().zzd(this.mContext, this.zzbxw.zzcbu);
        object = null;
        try {
            if (this.zzbxw.errorCode != -2 && this.zzbxw.errorCode != -3) {
                int n = this.zzbxw.errorCode;
                throw new zza(new StringBuilder(66).append("There was a problem getting an ad response. ErrorCode: ").append(n).toString(), this.zzbxw.errorCode);
            }
            this.zzqw();
            if (this.zzbox.zzaoy.zzaur != null) {
                object = this.zzb(this.zzbox);
            }
        }
        catch (zza zza2) {
            this.zzd(zza2.getErrorCode(), zza2.getMessage());
            zzkl.zzclg.removeCallbacks(this.zzbxx);
            return;
        }
        zzu.zzft().zzae(this.zzbxw.zzccm);
        JSONObject jSONObject = null;
        if (!TextUtils.isEmpty((CharSequence)this.zzbxw.zzcck)) {
            try {
                jSONObject = new JSONObject(this.zzbxw.zzcck);
            }
            catch (Exception exception) {
                zzkh.zzb((String)"Error parsing the JSON for Active View.", (Throwable)exception);
            }
        }
        zzjy.zza zza3 = new zzjy.zza(this.zzbox, this.zzbxw, this.zzboi, (AdSizeParcel)object, -2, l, this.zzbxw.zzccg, jSONObject);
        this.zzcai.zza(zza3);
        zzkl.zzclg.removeCallbacks(this.zzbxx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzbxy;
        synchronized (object) {
            if (this.zzcak != null) {
                this.zzcak.cancel();
            }
        }
    }

    protected void zzqw() throws zza {
        if (this.zzbxw.errorCode == -3) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzbxw.body)) {
            throw new zza("No fill from ad server.", 3);
        }
        zzu.zzft().zzc(this.mContext, this.zzbxw.zzcbd);
        if (this.zzbxw.zzccc) {
            try {
                this.zzboi = new zzge(this.zzbxw.body);
                zzu.zzft().zzaf(this.zzboi.zzbnu);
            }
            catch (JSONException jSONException) {
                zzkh.zzb((String)"Could not parse mediation config.", (Throwable)jSONException);
                String string = String.valueOf(this.zzbxw.body);
                throw new zza(string.length() != 0 ? "Could not parse mediation config: ".concat(string) : new String("Could not parse mediation config: "), 0);
            }
        } else {
            zzu.zzft().zzaf(this.zzbxw.zzbnu);
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzbxw.zzcbv) && zzdc.zzbdl.get().booleanValue()) {
            zzkh.zzcw((String)"Received cookie from server. Setting webview cookie in CookieManager.");
            CookieManager cookieManager = zzu.zzfs().zzao(this.mContext);
            if (cookieManager != null) {
                cookieManager.setCookie("googleads.g.doubleclick.net", this.zzbxw.zzcbv);
            }
        }
    }

    protected AdSizeParcel zzb(AdRequestInfoParcel adRequestInfoParcel) throws zza {
        int n;
        int n2;
        if (this.zzbxw.zzccf == null) {
            throw new zza("The ad response must specify one of the supported ad sizes.", 0);
        }
        String[] stringArray = this.zzbxw.zzccf.split("x");
        if (stringArray.length != 2) {
            String string = String.valueOf(this.zzbxw.zzccf);
            throw new zza(string.length() != 0 ? "Invalid ad size format from the ad response: ".concat(string) : new String("Invalid ad size format from the ad response: "), 0);
        }
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            String string = String.valueOf(this.zzbxw.zzccf);
            throw new zza(string.length() != 0 ? "Invalid ad size number from the ad response: ".concat(string) : new String("Invalid ad size number from the ad response: "), 0);
        }
        for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzaoy.zzaur) {
            int n3;
            float f = this.mContext.getResources().getDisplayMetrics().density;
            int n4 = adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / f) : adSizeParcel.width;
            int n5 = n3 = adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / f) : adSizeParcel.height;
            if (n2 != n4 || n != n3) continue;
            return new AdSizeParcel(adSizeParcel, adRequestInfoParcel.zzaoy.zzaur);
        }
        String string = String.valueOf(this.zzbxw.zzccf);
        throw new zza(string.length() != 0 ? "The ad size from the ad response was not one of the requested sizes: ".concat(string) : new String("The ad size from the ad response was not one of the requested sizes: "), 0);
    }

    @zzir
    static final class zza
    extends Exception {
        private final int zzbym;

        public zza(String string, int n) {
            super(string);
            this.zzbym = n;
        }

        public int getErrorCode() {
            return this.zzbym;
        }
    }
}

