/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Debug;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.ThinAdSizeParcel;
import com.google.android.gms.ads.internal.client.VideoOptionsParcel;
import com.google.android.gms.ads.internal.client.zzab;
import com.google.android.gms.ads.internal.client.zzf;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.client.zzq;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.internal.client.zzw;
import com.google.android.gms.ads.internal.client.zzy;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzcg;
import com.google.android.gms.internal.zzcl;
import com.google.android.gms.internal.zzco;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzdo;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzhs;
import com.google.android.gms.internal.zzhw;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zzjy;
import com.google.android.gms.internal.zzjz;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzkh;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;

@zzir
public abstract class zza
extends zzu.zza
implements com.google.android.gms.ads.internal.client.zza,
zzp,
zza.zza,
zzeo,
zzig.zza,
zzkd {
    protected zzdk zzajn;
    protected zzdi zzajo;
    protected zzdi zzajp;
    protected boolean zzajq = false;
    protected final zzr zzajr;
    protected final zzv zzajs;
    @Nullable
    protected transient AdRequestParcel zzajt;
    protected final zzcg zzaju;
    protected final zzd zzajv;

    zza(zzv zzv2, @Nullable zzr zzr2, zzd zzd2) {
        this.zzajs = zzv2;
        this.zzajr = zzr2 != null ? zzr2 : new zzr(this);
        this.zzajv = zzd2;
        zzu.zzfq().zzad(this.zzajs.zzagf);
        zzu.zzft().zzb(this.zzajs.zzagf, this.zzajs.zzaou);
        this.zzaju = zzu.zzft().zzsv();
        this.zzdl();
    }

    private void zzdl() {
        if (zzdc.zzbch.get().booleanValue()) {
            Timer timer = new Timer();
            CountDownLatch countDownLatch = new CountDownLatch(zzdc.zzbcj.get());
            TimerTask timerTask = this.zza(timer, countDownLatch);
            timer.schedule(timerTask, 0L, (long)zzdc.zzbci.get());
        }
    }

    private TimerTask zza(final Timer timer, final CountDownLatch countDownLatch) {
        return new TimerTask(){

            @Override
            public void run() {
                if ((long)zzdc.zzbcj.get().intValue() != countDownLatch.getCount()) {
                    zzkh.zzcw((String)"Stopping method tracing");
                    Debug.stopMethodTracing();
                    if (countDownLatch.getCount() == 0L) {
                        timer.cancel();
                        return;
                    }
                }
                String string = String.valueOf(zza.this.zzajs.zzagf.getPackageName()).concat("_adsTrace_");
                try {
                    zzkh.zzcw((String)"Starting method tracing");
                    countDownLatch.countDown();
                    long l = zzu.zzfu().currentTimeMillis();
                    Debug.startMethodTracing((String)new StringBuilder(20 + String.valueOf(string).length()).append(string).append(l).toString(), (int)zzdc.zzbck.get());
                }
                catch (Exception exception) {
                    zzkh.zzd((String)"Exception occurred while starting method tracing.", (Throwable)exception);
                    return;
                }
            }
        };
    }

    public void zzdm() {
        this.zzajn = new zzdk(zzdc.zzazc.get(), "load_ad", this.zzajs.zzaoy.zzaup);
        this.zzajo = new zzdi(-1L, null, null);
        this.zzajp = new zzdi(-1L, null, null);
    }

    public void destroy() {
        com.google.android.gms.common.internal.zzab.zzhj((String)"destroy must be called on the main UI thread.");
        this.zzajr.cancel();
        this.zzaju.zzj(this.zzajs.zzaoz);
        this.zzajs.destroy();
    }

    public com.google.android.gms.dynamic.zzd zzdn() {
        com.google.android.gms.common.internal.zzab.zzhj((String)"getAdFrame must be called on the main UI thread.");
        return zze.zzae((Object)((Object)this.zzajs.zzaov));
    }

    @Nullable
    public AdSizeParcel zzdo() {
        com.google.android.gms.common.internal.zzab.zzhj((String)"getAdSize must be called on the main UI thread.");
        return this.zzajs.zzaoy == null ? null : new ThinAdSizeParcel(this.zzajs.zzaoy);
    }

    public boolean isReady() {
        com.google.android.gms.common.internal.zzab.zzhj((String)"isLoaded must be called on the main UI thread.");
        return this.zzajs.zzaow == null && this.zzajs.zzaox == null && this.zzajs.zzaoz != null;
    }

    public void setManualImpressionsEnabled(boolean bl) {
        throw new UnsupportedOperationException("Attempt to call setManualImpressionsEnabled for an unsupported ad type.");
    }

    private AdRequestParcel zza(AdRequestParcel adRequestParcel) {
        if (zzi.zzcl((Context)this.zzajs.zzagf) && adRequestParcel.zzats != null) {
            return new zzf(adRequestParcel).zza(null).zzig();
        }
        return adRequestParcel;
    }

    public boolean zzb(AdRequestParcel adRequestParcel) {
        com.google.android.gms.common.internal.zzab.zzhj((String)"loadAd must be called on the main UI thread.");
        adRequestParcel = this.zza(adRequestParcel);
        if (this.zzajs.zzaow != null || this.zzajs.zzaox != null) {
            if (this.zzajt != null) {
                zzkh.zzcy((String)"Aborting last ad request since another ad request is already in progress. The current request object will still be cached for future refreshes.");
            } else {
                zzkh.zzcy((String)"Loading already in progress, saving this object for future refreshes.");
            }
            this.zzajt = adRequestParcel;
            return false;
        }
        zzkh.zzcx((String)"Starting ad request.");
        this.zzdm();
        this.zzajo = this.zzajn.zzkg();
        if (!adRequestParcel.zzatn) {
            String string = String.valueOf(zzm.zziw().zzaq(this.zzajs.zzagf));
            zzkh.zzcx((String)new StringBuilder(71 + String.valueOf(string).length()).append("Use AdRequest.Builder.addTestDevice(\"").append(string).append("\") to get test ads on this device.").toString());
        }
        this.zzajq = this.zza(adRequestParcel, this.zzajn);
        return this.zzajq;
    }

    protected abstract boolean zza(AdRequestParcel var1, zzdk var2);

    @Override
    public void zza(zzjy.zza zza2) {
        long l;
        if (zza2.zzciu.zzccg != -1L && !TextUtils.isEmpty((CharSequence)zza2.zzciu.zzccp) && (l = this.zzs(zza2.zzciu.zzccp)) != -1L) {
            zzdi zzdi2 = this.zzajn.zzc(zza2.zzciu.zzccg + l);
            this.zzajn.zza(zzdi2, "stc");
        }
        this.zzajn.zzas(zza2.zzciu.zzccp);
        this.zzajn.zza(this.zzajo, "arf");
        this.zzajp = this.zzajn.zzkg();
        this.zzajn.zzh("gqi", zza2.zzciu.zzccq);
        this.zzajs.zzaow = null;
        this.zzajs.zzapa = zza2;
        this.zza(zza2, this.zzajn);
    }

    protected abstract void zza(zzjy.zza var1, zzdk var2);

    boolean zza(zzjy zzjy2) {
        return false;
    }

    @Override
    public void zzb(zzjy zzjy2) {
        this.zzajn.zza(this.zzajp, "awr");
        this.zzajs.zzaox = null;
        if (zzjy2.errorCode != -2 && zzjy2.errorCode != 3) {
            zzu.zzft().zzb(this.zzajs.zzgl());
        }
        if (zzjy2.errorCode == -1) {
            this.zzajq = false;
            return;
        }
        if (this.zza(zzjy2)) {
            zzkh.zzcw((String)"Ad refresh scheduled.");
        }
        if (zzjy2.errorCode != -2) {
            this.zzh(zzjy2.errorCode);
            return;
        }
        if (this.zzajs.zzaps == null) {
            this.zzajs.zzaps = new zzke(this.zzajs.zzaos);
        }
        this.zzaju.zzi(this.zzajs.zzaoz);
        if (this.zza(this.zzajs.zzaoz, zzjy2)) {
            this.zzajs.zzaoz = zzjy2;
            this.zzajs.zzgu();
            this.zzajn.zzh("is_mraid", this.zzajs.zzaoz.zzho() ? "1" : "0");
            this.zzajn.zzh("is_mediation", this.zzajs.zzaoz.zzccc ? "1" : "0");
            if (this.zzajs.zzaoz.zzbtq != null && this.zzajs.zzaoz.zzbtq.zzuk() != null) {
                this.zzajn.zzh("is_delay_pl", this.zzajs.zzaoz.zzbtq.zzuk().zzuz() ? "1" : "0");
            }
            this.zzajn.zza(this.zzajo, "ttc");
            if (zzu.zzft().zzsm() != null) {
                zzu.zzft().zzsm().zza(this.zzajn);
            }
            if (this.zzajs.zzgp()) {
                this.zzdv();
            }
        }
        if (zzjy2.zzbnt != null) {
            zzu.zzfq().zza(this.zzajs.zzagf, zzjy2.zzbnt);
        }
    }

    protected abstract boolean zza(@Nullable zzjy var1, zzjy var2);

    public void onAdClicked() {
        if (this.zzajs.zzaoz == null) {
            zzkh.zzcy((String)"Ad state was null when trying to ping click URLs.");
            return;
        }
        zzkh.zzcw((String)"Pinging click URLs.");
        this.zzajs.zzapb.zzsa();
        if (this.zzajs.zzaoz.zzbnq != null) {
            zzu.zzfq().zza(this.zzajs.zzagf, this.zzajs.zzaou.zzcs, this.zzajs.zzaoz.zzbnq);
        }
        if (this.zzajs.zzapc != null) {
            try {
                this.zzajs.zzapc.onAdClicked();
            }
            catch (RemoteException remoteException) {
                zzkh.zzd((String)"Could not notify onAdClicked event.", (Throwable)remoteException);
            }
        }
    }

    @Override
    public void zzdp() {
        this.zzdt();
    }

    @Override
    public void onAppEvent(String string, @Nullable String string2) {
        if (this.zzajs.zzape != null) {
            try {
                this.zzajs.zzape.onAppEvent(string, string2);
            }
            catch (RemoteException remoteException) {
                zzkh.zzd((String)"Could not call the AppEventListener.", (Throwable)remoteException);
            }
        }
    }

    public void zzdq() {
        com.google.android.gms.common.internal.zzab.zzhj((String)"recordManualImpression must be called on the main UI thread.");
        if (this.zzajs.zzaoz == null) {
            zzkh.zzcy((String)"Ad state was null when trying to ping manual tracking URLs.");
            return;
        }
        zzkh.zzcw((String)"Pinging manual tracking URLs.");
        if (this.zzajs.zzaoz.zzcce != null && !this.zzajs.zzaoz.zzcis) {
            zzu.zzfq().zza(this.zzajs.zzagf, this.zzajs.zzaou.zzcs, this.zzajs.zzaoz.zzcce);
            this.zzajs.zzaoz.zzcis = true;
        }
    }

    public void pause() {
        com.google.android.gms.common.internal.zzab.zzhj((String)"pause must be called on the main UI thread.");
    }

    public void resume() {
        com.google.android.gms.common.internal.zzab.zzhj((String)"resume must be called on the main UI thread.");
    }

    protected boolean zzc(AdRequestParcel adRequestParcel) {
        if (this.zzajs.zzaov == null) {
            return false;
        }
        ViewParent viewParent = this.zzajs.zzaov.getParent();
        if (!(viewParent instanceof View)) {
            return false;
        }
        View view = (View)viewParent;
        return zzu.zzfq().zza(view, view.getContext());
    }

    public void zzd(AdRequestParcel adRequestParcel) {
        if (this.zzc(adRequestParcel)) {
            this.zzb(adRequestParcel);
        } else {
            zzkh.zzcx((String)"Ad is not visible. Not refreshing ad.");
            this.zzajr.zzg(adRequestParcel);
        }
    }

    public void zza(zzq zzq2) {
        com.google.android.gms.common.internal.zzab.zzhj((String)"setAdListener must be called on the main UI thread.");
        this.zzajs.zzapd = zzq2;
    }

    public void zza(com.google.android.gms.ads.internal.reward.client.zzd zzd2) {
        com.google.android.gms.common.internal.zzab.zzhj((String)"setRewardedVideoAdListener can only be called from the UI thread.");
        this.zzajs.zzapp = zzd2;
    }

    public void setUserId(String string) {
        zzkh.zzcy((String)"RewardedVideoAd.setUserId() is deprecated. Please do not call this method.");
    }

    public void zza(com.google.android.gms.ads.internal.client.zzp zzp2) {
        com.google.android.gms.common.internal.zzab.zzhj((String)"setAdListener must be called on the main UI thread.");
        this.zzajs.zzapc = zzp2;
    }

    public void zza(AdSizeParcel adSizeParcel) {
        com.google.android.gms.common.internal.zzab.zzhj((String)"setAdSize must be called on the main UI thread.");
        this.zzajs.zzaoy = adSizeParcel;
        if (this.zzajs.zzaoz != null && this.zzajs.zzaoz.zzbtq != null && this.zzajs.zzapu == 0) {
            this.zzajs.zzaoz.zzbtq.zza(adSizeParcel);
        }
        if (this.zzajs.zzaov == null) {
            return;
        }
        if (this.zzajs.zzaov.getChildCount() > 1) {
            this.zzajs.zzaov.removeView(this.zzajs.zzaov.getNextView());
        }
        this.zzajs.zzaov.setMinimumWidth(adSizeParcel.widthPixels);
        this.zzajs.zzaov.setMinimumHeight(adSizeParcel.heightPixels);
        this.zzajs.zzaov.requestLayout();
    }

    public void zza(zzw zzw2) {
        com.google.android.gms.common.internal.zzab.zzhj((String)"setAppEventListener must be called on the main UI thread.");
        this.zzajs.zzape = zzw2;
    }

    public void zza(zzhs zzhs2) {
        throw new IllegalStateException("setInAppPurchaseListener is not supported for current ad type");
    }

    public void zza(zzdo zzdo2) {
        throw new IllegalStateException("setOnCustomRenderedAdLoadedListener is not supported for current ad type");
    }

    public void zza(zzhw zzhw2, String string) {
        throw new IllegalStateException("setPlayStorePurchaseParams is not supported for current ad type");
    }

    public void zza(zzy zzy2) {
        com.google.android.gms.common.internal.zzab.zzhj((String)"setCorrelationIdProvider must be called on the main UI thread");
        this.zzajs.zzapf = zzy2;
    }

    public void stopLoading() {
        com.google.android.gms.common.internal.zzab.zzhj((String)"stopLoading must be called on the main UI thread.");
        this.zzajq = false;
        this.zzajs.zzi(true);
    }

    public boolean isLoading() {
        return this.zzajq;
    }

    public zzab zzdr() {
        return null;
    }

    public void zza(@Nullable VideoOptionsParcel videoOptionsParcel) {
        com.google.android.gms.common.internal.zzab.zzhj((String)"setVideoOptions must be called on the main UI thread.");
        this.zzajs.zzapn = videoOptionsParcel;
    }

    Bundle zza(@Nullable zzco zzco2) {
        if (zzco2 == null) {
            return null;
        }
        if (zzco2.zzid()) {
            zzco2.wakeup();
        }
        zzcl zzcl2 = zzco2.zzib();
        String string = null;
        String string2 = null;
        if (zzcl2 != null) {
            string = zzcl2.zzhr();
            string2 = zzcl2.zzhs();
            String string3 = String.valueOf(zzcl2.toString());
            zzkh.zzcw((String)(string3.length() != 0 ? "In AdManager: loadAd, ".concat(string3) : new String("In AdManager: loadAd, ")));
            if (string != null) {
                zzu.zzft().zzcn(string);
            }
        } else {
            string = zzu.zzft().zzsq();
        }
        if (string != null) {
            Bundle bundle = new Bundle(1);
            bundle.putString("fingerprint", string);
            if (!string.equals(string2)) {
                bundle.putString("v_fp", string2);
            }
            return bundle;
        }
        return null;
    }

    long zzs(String string) {
        int n = string.indexOf("ufe");
        int n2 = string.indexOf(44, n);
        if (n2 == -1) {
            n2 = string.length();
        }
        try {
            return Long.parseLong(string.substring(n + 4, n2));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzkh.zzcy((String)"Invalid index for Url fetch time in CSI latency info.");
        }
        catch (NumberFormatException numberFormatException) {
            zzkh.zzcy((String)"Cannot find valid format of Url fetch time in CSI latency info.");
        }
        return -1L;
    }

    protected void zzb(View view) {
        this.zzajs.zzaov.addView(view, zzu.zzfs().zztn());
    }

    protected void zzds() {
        zzkh.zzcx((String)"Ad closing.");
        if (this.zzajs.zzapd != null) {
            try {
                this.zzajs.zzapd.onAdClosed();
            }
            catch (RemoteException remoteException) {
                zzkh.zzd((String)"Could not call AdListener.onAdClosed().", (Throwable)remoteException);
            }
        }
        if (this.zzajs.zzapp != null) {
            try {
                this.zzajs.zzapp.onRewardedVideoAdClosed();
            }
            catch (RemoteException remoteException) {
                zzkh.zzd((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdClosed().", (Throwable)remoteException);
            }
        }
    }

    protected void zzdt() {
        zzkh.zzcx((String)"Ad leaving application.");
        if (this.zzajs.zzapd != null) {
            try {
                this.zzajs.zzapd.onAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzkh.zzd((String)"Could not call AdListener.onAdLeftApplication().", (Throwable)remoteException);
            }
        }
        if (this.zzajs.zzapp != null) {
            try {
                this.zzajs.zzapp.onRewardedVideoAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzkh.zzd((String)"Could not call  RewardedVideoAdListener.onRewardedVideoAdLeftApplication().", (Throwable)remoteException);
            }
        }
    }

    protected void zzdu() {
        zzkh.zzcx((String)"Ad opening.");
        if (this.zzajs.zzapd != null) {
            try {
                this.zzajs.zzapd.onAdOpened();
            }
            catch (RemoteException remoteException) {
                zzkh.zzd((String)"Could not call AdListener.onAdOpened().", (Throwable)remoteException);
            }
        }
        if (this.zzajs.zzapp != null) {
            try {
                this.zzajs.zzapp.onRewardedVideoAdOpened();
            }
            catch (RemoteException remoteException) {
                zzkh.zzd((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdOpened().", (Throwable)remoteException);
            }
        }
    }

    protected void zzdv() {
        zzkh.zzcx((String)"Ad finished loading.");
        this.zzajq = false;
        if (this.zzajs.zzapd != null) {
            try {
                this.zzajs.zzapd.onAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzkh.zzd((String)"Could not call AdListener.onAdLoaded().", (Throwable)remoteException);
            }
        }
        if (this.zzajs.zzapp != null) {
            try {
                this.zzajs.zzapp.onRewardedVideoAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzkh.zzd((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdLoaded().", (Throwable)remoteException);
            }
        }
    }

    protected void zzh(int n) {
        zzkh.zzcy((String)new StringBuilder(30).append("Failed to load ad: ").append(n).toString());
        this.zzajq = false;
        if (this.zzajs.zzapd != null) {
            try {
                this.zzajs.zzapd.onAdFailedToLoad(n);
            }
            catch (RemoteException remoteException) {
                zzkh.zzd((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
            }
        }
        if (this.zzajs.zzapp != null) {
            try {
                this.zzajs.zzapp.onRewardedVideoAdFailedToLoad(n);
            }
            catch (RemoteException remoteException) {
                zzkh.zzd((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdFailedToLoad().", (Throwable)remoteException);
            }
        }
    }

    protected void zzdw() {
        if (this.zzajs.zzapp == null) {
            return;
        }
        try {
            this.zzajs.zzapp.onRewardedVideoStarted();
        }
        catch (RemoteException remoteException) {
            zzkh.zzd((String)"Could not call RewardedVideoAdListener.onVideoStarted().", (Throwable)remoteException);
        }
    }

    protected void zza(@Nullable RewardItemParcel rewardItemParcel) {
        if (this.zzajs.zzapp == null) {
            return;
        }
        try {
            String string = "";
            int n = 0;
            if (rewardItemParcel != null) {
                string = rewardItemParcel.type;
                n = rewardItemParcel.zzcih;
            }
            this.zzajs.zzapp.zza((com.google.android.gms.ads.internal.reward.client.zza)new zzjh(string, n));
        }
        catch (RemoteException remoteException) {
            zzkh.zzd((String)"Could not call RewardedVideoAdListener.onRewarded().", (Throwable)remoteException);
        }
    }

    protected void zzc(@Nullable zzjy zzjy2) {
        if (zzjy2 == null) {
            zzkh.zzcy((String)"Ad state was null when trying to ping impression URLs.");
            return;
        }
        zzkh.zzcw((String)"Pinging Impression URLs.");
        this.zzajs.zzapb.zzrz();
        if (zzjy2.zzbnr != null && !zzjy2.zzcir) {
            zzu.zzfq().zza(this.zzajs.zzagf, this.zzajs.zzaou.zzcs, zzjy2.zzbnr);
            zzjy2.zzcir = true;
        }
    }

    @Override
    public void zza(HashSet<zzjz> hashSet) {
        this.zzajs.zza(hashSet);
    }
}

