/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.view.View;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.purchase.GInAppPurchaseManagerInfoParcel;
import com.google.android.gms.ads.internal.purchase.zzc;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzj;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.CapabilityParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzgf;
import com.google.android.gms.internal.zzgn;
import com.google.android.gms.internal.zzhp;
import com.google.android.gms.internal.zzhr;
import com.google.android.gms.internal.zzhs;
import com.google.android.gms.internal.zzhv;
import com.google.android.gms.internal.zzhw;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzjy;
import com.google.android.gms.internal.zzjz;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkl;
import com.google.android.gms.internal.zzll;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Future;

@zzir
public abstract class zzb
extends zza
implements zzg,
zzj,
zzs,
zzev,
zzgf {
    protected final zzgn zzajz;
    private final Messenger mMessenger;
    protected transient boolean zzaka;

    public zzb(Context context, AdSizeParcel adSizeParcel, String string, zzgn zzgn2, VersionInfoParcel versionInfoParcel, zzd zzd2) {
        this(new zzv(context, adSizeParcel, string, versionInfoParcel), zzgn2, null, zzd2);
    }

    protected zzb(zzv zzv2, zzgn zzgn2, @Nullable zzr zzr2, zzd zzd2) {
        super(zzv2, zzr2, zzd2);
        this.zzajz = zzgn2;
        this.mMessenger = new Messenger((Handler)new zzhp(this.zzajs.zzagf));
        this.zzaka = false;
    }

    @Override
    public boolean zza(AdRequestParcel adRequestParcel, zzdk zzdk2) {
        if (!this.zzdx()) {
            return false;
        }
        Bundle bundle = null;
        bundle = this.zza(zzu.zzft().zzaa(this.zzajs.zzagf));
        this.zzajr.cancel();
        this.zzajs.zzapu = 0;
        zzka zzka2 = null;
        if (zzdc.zzbcr.get().booleanValue()) {
            zzka2 = zzu.zzft().zzsu();
            zzu.zzgi().zza(this.zzajs.zzagf, this.zzajs.zzaou, false, zzka2, zzka2 == null ? null : zzka2.zzsi(), this.zzajs.zzaos);
        }
        AdRequestInfoParcel.zza zza2 = this.zza(adRequestParcel, bundle, zzka2);
        zzdk2.zzh("seq_num", zza2.zzcay);
        zzdk2.zzh("request_id", zza2.zzcbk);
        zzdk2.zzh("session_id", zza2.zzcaz);
        if (zza2.zzcaw != null) {
            zzdk2.zzh("app_version", String.valueOf(zza2.zzcaw.versionCode));
        }
        this.zzajs.zzaow = zzu.zzfm().zza(this.zzajs.zzagf, zza2, this.zzajs.zzaot, this);
        return true;
    }

    @Override
    public void zzb(zzjy zzjy2) {
        super.zzb(zzjy2);
        if (zzjy2.zzbor != null) {
            zzkh.zzcw((String)"Pinging network fill URLs.");
            zzu.zzgf().zza(this.zzajs.zzagf, this.zzajs.zzaou.zzcs, zzjy2, this.zzajs.zzaos, false, zzjy2.zzbor.zzbnf);
            if (zzjy2.zzcik.zzbnt != null && zzjy2.zzcik.zzbnt.size() > 0) {
                zzkh.zzcw((String)"Pinging urls remotely");
                zzu.zzfq().zza(this.zzajs.zzagf, zzjy2.zzcik.zzbnt);
            }
        }
        if (zzjy2.errorCode == 3 && zzjy2.zzcik != null && zzjy2.zzcik.zzbns != null) {
            zzkh.zzcw((String)"Pinging no fill URLs.");
            zzu.zzgf().zza(this.zzajs.zzagf, this.zzajs.zzaou.zzcs, zzjy2, this.zzajs.zzaos, false, zzjy2.zzcik.zzbns);
        }
    }

    @Override
    protected boolean zza(@Nullable zzjy zzjy2, zzjy zzjy3) {
        if (zzjy2 != null && zzjy2.zzbou != null) {
            zzjy2.zzbou.zza((zzgf)null);
        }
        if (zzjy3.zzbou != null) {
            zzjy3.zzbou.zza(this);
        }
        int n = 0;
        int n2 = 0;
        if (zzjy3.zzcik != null) {
            n = zzjy3.zzcik.zzboc;
            n2 = zzjy3.zzcik.zzbod;
        }
        this.zzajs.zzaps.zzh(n, n2);
        return true;
    }

    @Override
    public void onAdClicked() {
        if (this.zzajs.zzaoz == null) {
            zzkh.zzcy((String)"Ad state was null when trying to ping click URLs.");
            return;
        }
        if (this.zzajs.zzaoz.zzcik != null && this.zzajs.zzaoz.zzcik.zzbnq != null) {
            zzu.zzgf().zza(this.zzajs.zzagf, this.zzajs.zzaou.zzcs, this.zzajs.zzaoz, this.zzajs.zzaos, false, this.zzajs.zzaoz.zzcik.zzbnq);
        }
        if (this.zzajs.zzaoz.zzbor != null && this.zzajs.zzaoz.zzbor.zzbnd != null) {
            zzu.zzgf().zza(this.zzajs.zzagf, this.zzajs.zzaou.zzcs, this.zzajs.zzaoz, this.zzajs.zzaos, false, this.zzajs.zzaoz.zzbor.zzbnd);
        }
        super.onAdClicked();
    }

    @Override
    boolean zza(zzjy zzjy2) {
        AdRequestParcel adRequestParcel;
        boolean bl = false;
        if (this.zzajt != null) {
            adRequestParcel = this.zzajt;
            this.zzajt = null;
        } else {
            adRequestParcel = zzjy2.zzcav;
            bl = adRequestParcel.extras != null ? adRequestParcel.extras.getBoolean("_noRefresh", false) : false;
        }
        return this.zza(adRequestParcel, zzjy2, bl);
    }

    protected boolean zza(AdRequestParcel adRequestParcel, zzjy zzjy2, boolean bl) {
        if (!bl && this.zzajs.zzgp()) {
            if (zzjy2.zzbnw > 0L) {
                this.zzajr.zza(adRequestParcel, zzjy2.zzbnw);
            } else if (zzjy2.zzcik != null && zzjy2.zzcik.zzbnw > 0L) {
                this.zzajr.zza(adRequestParcel, zzjy2.zzcik.zzbnw);
            } else if (!zzjy2.zzccc && zzjy2.errorCode == 2) {
                this.zzajr.zzg(adRequestParcel);
            }
        }
        return this.zzajr.zzfc();
    }

    @Override
    public void pause() {
        zzab.zzhj((String)"pause must be called on the main UI thread.");
        if (this.zzajs.zzaoz != null && this.zzajs.zzaoz.zzbtq != null && this.zzajs.zzgp()) {
            zzu.zzfs().zzj(this.zzajs.zzaoz.zzbtq);
        }
        if (this.zzajs.zzaoz != null && this.zzajs.zzaoz.zzbos != null) {
            try {
                this.zzajs.zzaoz.zzbos.pause();
            }
            catch (RemoteException remoteException) {
                zzkh.zzcy((String)"Could not pause mediation adapter.");
            }
        }
        this.zzaju.zzk(this.zzajs.zzaoz);
        this.zzajr.pause();
    }

    @Override
    public void resume() {
        zzab.zzhj((String)"resume must be called on the main UI thread.");
        zzll zzll2 = null;
        if (this.zzajs.zzaoz != null && this.zzajs.zzaoz.zzbtq != null) {
            zzll2 = this.zzajs.zzaoz.zzbtq;
        }
        if (zzll2 != null && this.zzajs.zzgp()) {
            zzu.zzfs().zzk(this.zzajs.zzaoz.zzbtq);
        }
        if (this.zzajs.zzaoz != null && this.zzajs.zzaoz.zzbos != null) {
            try {
                this.zzajs.zzaoz.zzbos.resume();
            }
            catch (RemoteException remoteException) {
                zzkh.zzcy((String)"Could not resume mediation adapter.");
            }
        }
        if (zzll2 == null || !zzll2.zzuq()) {
            this.zzajr.resume();
        }
        this.zzaju.zzl(this.zzajs.zzaoz);
    }

    @Override
    protected boolean zzc(AdRequestParcel adRequestParcel) {
        return super.zzc(adRequestParcel) && !this.zzaka;
    }

    protected boolean zzdx() {
        boolean bl = true;
        if (!zzu.zzfq().zza(this.zzajs.zzagf.getPackageManager(), this.zzajs.zzagf.getPackageName(), "android.permission.INTERNET") || !zzu.zzfq().zzac(this.zzajs.zzagf)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void zzdy() {
        this.zzaju.zzi(this.zzajs.zzaoz);
        this.zzaka = false;
        this.zzds();
        this.zzajs.zzapb.zzsb();
    }

    @Override
    public void zzdz() {
        this.zzaka = true;
        this.zzdu();
    }

    @Override
    public void onPause() {
        this.zzaju.zzk(this.zzajs.zzaoz);
    }

    @Override
    public void onResume() {
        this.zzaju.zzl(this.zzajs.zzaoz);
    }

    @Override
    public void zzea() {
        this.onAdClicked();
    }

    @Override
    public void zzeb() {
        this.zzdy();
    }

    @Override
    public void zzec() {
        this.zzdp();
    }

    @Override
    public void zzed() {
        this.zzdz();
    }

    @Override
    public void zzee() {
        if (this.zzajs.zzaoz != null) {
            String string = this.zzajs.zzaoz.zzbot;
            zzkh.zzcy((String)new StringBuilder(74 + String.valueOf(string).length()).append("Mediation adapter ").append(string).append(" refreshed, but mediation adapters should never refresh.").toString());
        }
        this.zza(this.zzajs.zzaoz, true);
        this.zzdv();
    }

    @Override
    public void zzef() {
        this.recordImpression();
    }

    private AdRequestInfoParcel.zza zza(AdRequestParcel adRequestParcel, Bundle bundle, zzka zzka2) {
        String string;
        int n;
        Object object;
        PackageInfo packageInfo;
        PackageManager packageManager;
        ApplicationInfo applicationInfo = this.zzajs.zzagf.getApplicationInfo();
        try {
            packageManager = this.zzajs.zzagf.getPackageManager();
            packageInfo = packageManager.getPackageInfo(applicationInfo.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
        }
        packageManager = this.zzajs.zzagf.getResources().getDisplayMetrics();
        Bundle bundle2 = null;
        if (this.zzajs.zzaov != null && this.zzajs.zzaov.getParent() != null) {
            object = new int[2];
            this.zzajs.zzaov.getLocationOnScreen((int[])object);
            Object object2 = object[0];
            Object object3 = object[1];
            int n2 = this.zzajs.zzaov.getWidth();
            int n3 = this.zzajs.zzaov.getHeight();
            int n4 = 0;
            if (this.zzajs.zzaov.isShown() && object2 + n2 > 0 && object3 + n3 > 0 && object2 <= packageManager.widthPixels && object3 <= packageManager.heightPixels) {
                n4 = 1;
            }
            bundle2 = new Bundle(5);
            bundle2.putInt("x", (int)object2);
            bundle2.putInt("y", (int)object3);
            bundle2.putInt("width", n2);
            bundle2.putInt("height", n3);
            bundle2.putInt("visible", n4);
        }
        object = zzu.zzft().zzsk();
        this.zzajs.zzapb = new zzjz((String)object, this.zzajs.zzaos);
        this.zzajs.zzapb.zzq(adRequestParcel);
        String string2 = zzu.zzfq().zza(this.zzajs.zzagf, (View)this.zzajs.zzaov, this.zzajs.zzaoy);
        long l = 0L;
        if (this.zzajs.zzapf != null) {
            try {
                l = this.zzajs.zzapf.getValue();
            }
            catch (RemoteException remoteException) {
                zzkh.zzcy((String)"Cannot get correlation id, default to 0.");
            }
        }
        String string3 = UUID.randomUUID().toString();
        Bundle bundle3 = zzu.zzft().zza(this.zzajs.zzagf, this, (String)object);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.zzajs.zzapl.size(); n += 1) {
            arrayList.add((String)this.zzajs.zzapl.keyAt(n));
        }
        n = this.zzajs.zzapg != null ? 1 : 0;
        boolean bl = this.zzajs.zzaph != null && zzu.zzft().zzsw();
        boolean bl2 = this.zzajv.zzakl.zzr(this.zzajs.zzagf);
        String string4 = "";
        if (zzdc.zzbdl.get().booleanValue()) {
            zzkh.zzcw((String)"Getting webview cookie from CookieManager.");
            string = zzu.zzfs().zzao(this.zzajs.zzagf);
            if (string != null) {
                string4 = string.getCookie("googleads.g.doubleclick.net");
            }
        }
        string = null;
        if (zzka2 != null) {
            string = zzka2.zzsh();
        }
        return new AdRequestInfoParcel.zza(bundle2, adRequestParcel, this.zzajs.zzaoy, this.zzajs.zzaos, applicationInfo, packageInfo, (String)object, zzu.zzft().getSessionId(), this.zzajs.zzaou, bundle3, this.zzajs.zzapq, arrayList, bundle, zzu.zzft().zzso(), this.mMessenger, packageManager.widthPixels, packageManager.heightPixels, packageManager.density, string2, l, string3, zzdc.zzjx(), this.zzajs.zzaor, this.zzajs.zzapm, new CapabilityParcel(n != 0, bl, bl2), this.zzajs.zzgt(), zzu.zzfq().zzey(), zzu.zzfq().zzfa(), zzu.zzfq().zzam(this.zzajs.zzagf), zzu.zzfq().zzn((View)this.zzajs.zzaov), this.zzajs.zzagf instanceof Activity, zzu.zzft().zzss(), string4, string, zzu.zzft().zzst(), zzu.zzgj().zzlm(), zzu.zzfq().zztj());
    }

    @Override
    public void zza(zzhs zzhs2) {
        zzab.zzhj((String)"setInAppPurchaseListener must be called on the main UI thread.");
        this.zzajs.zzapg = zzhs2;
    }

    @Override
    public void zza(zzhw zzhw2, @Nullable String string) {
        zzab.zzhj((String)"setPlayStorePurchaseParams must be called on the main UI thread.");
        this.zzajs.zzapr = new zzk(string);
        this.zzajs.zzaph = zzhw2;
        if (!zzu.zzft().zzsn() && zzhw2 != null) {
            Future cfr_ignored_0 = (Future)new zzc(this.zzajs.zzagf, this.zzajs.zzaph, this.zzajs.zzapr).zzpz();
        }
    }

    @Override
    public void zza(String string, ArrayList<String> arrayList) {
        com.google.android.gms.ads.internal.purchase.zzd zzd2 = new com.google.android.gms.ads.internal.purchase.zzd(string, arrayList, this.zzajs.zzagf, this.zzajs.zzaou.zzcs);
        if (this.zzajs.zzapg == null) {
            zzkh.zzcy((String)"InAppPurchaseListener is not set. Try to launch default purchase flow.");
            if (!zzm.zziw().zzar(this.zzajs.zzagf)) {
                zzkh.zzcy((String)"Google Play Service unavailable, cannot launch default purchase flow.");
                return;
            }
            if (this.zzajs.zzaph == null) {
                zzkh.zzcy((String)"PlayStorePurchaseListener is not set.");
                return;
            }
            if (this.zzajs.zzapr == null) {
                zzkh.zzcy((String)"PlayStorePurchaseVerifier is not initialized.");
                return;
            }
            if (this.zzajs.zzapv) {
                zzkh.zzcy((String)"An in-app purchase request is already in progress, abort");
                return;
            }
            this.zzajs.zzapv = true;
            try {
                if (!this.zzajs.zzaph.isValidPurchase(string)) {
                    this.zzajs.zzapv = false;
                    return;
                }
            }
            catch (RemoteException remoteException) {
                zzkh.zzcy((String)"Could not start In-App purchase.");
                this.zzajs.zzapv = false;
                return;
            }
            zzu.zzga().zza(this.zzajs.zzagf, this.zzajs.zzaou.zzcnq, new GInAppPurchaseManagerInfoParcel(this.zzajs.zzagf, this.zzajs.zzapr, (zzhr)zzd2, this));
        } else {
            try {
                this.zzajs.zzapg.zza((zzhr)zzd2);
            }
            catch (RemoteException remoteException) {
                zzkh.zzcy((String)"Could not start In-App purchase.");
            }
        }
    }

    @Override
    public void zza(String string, boolean bl, int n, final Intent intent, zzf zzf2) {
        try {
            if (this.zzajs.zzaph != null) {
                this.zzajs.zzaph.zza((zzhv)new com.google.android.gms.ads.internal.purchase.zzg(this.zzajs.zzagf, string, bl, n, intent, zzf2));
            }
        }
        catch (RemoteException remoteException) {
            zzkh.zzcy((String)"Fail to invoke PlayStorePurchaseListener.");
        }
        zzkl.zzclg.postDelayed(new Runnable(){

            @Override
            public void run() {
                int n = zzu.zzga().zzd(intent);
                zzu.zzga();
                if (n == 0 && zzb.this.zzajs.zzaoz != null && zzb.this.zzajs.zzaoz.zzbtq != null && zzb.this.zzajs.zzaoz.zzbtq.zzui() != null) {
                    zzb.this.zzajs.zzaoz.zzbtq.zzui().close();
                }
                zzb.this.zzajs.zzapv = false;
            }
        }, 500L);
    }

    public void recordImpression() {
        this.zza(this.zzajs.zzaoz, false);
    }

    protected void zza(@Nullable zzjy zzjy2, boolean bl) {
        if (zzjy2 == null) {
            zzkh.zzcy((String)"Ad state was null when trying to ping impression URLs.");
            return;
        }
        super.zzc(zzjy2);
        if (zzjy2.zzcik != null && zzjy2.zzcik.zzbnr != null) {
            zzu.zzgf().zza(this.zzajs.zzagf, this.zzajs.zzaou.zzcs, zzjy2, this.zzajs.zzaos, bl, zzjy2.zzcik.zzbnr);
        }
        if (zzjy2.zzbor != null && zzjy2.zzbor.zzbne != null) {
            zzu.zzgf().zza(this.zzajs.zzagf, this.zzajs.zzaou.zzcs, zzjy2, this.zzajs.zzaos, bl, zzjy2.zzbor.zzbne);
        }
    }

    public String getMediationAdapterClassName() {
        if (this.zzajs.zzaoz == null) {
            return null;
        }
        return this.zzajs.zzaoz.zzbot;
    }

    public void showInterstitial() {
        throw new IllegalStateException("showInterstitial is not supported for current ad type");
    }

    @Override
    public void zzeg() {
        zzu.zzfq().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                zzb.this.zzajr.pause();
            }
        });
    }

    @Override
    public void zzeh() {
        zzu.zzfq().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                zzb.this.zzajr.resume();
            }
        });
    }
}

