/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzce;
import com.google.android.gms.internal.zzcf;
import com.google.android.gms.internal.zzch;
import com.google.android.gms.internal.zzck;
import com.google.android.gms.internal.zzet;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzjy;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkv;
import com.google.android.gms.internal.zzll;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzir
public abstract class zzcd
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    protected final Object zzail = new Object();
    private final WeakReference<zzjy> zzaqf;
    private WeakReference<ViewTreeObserver> zzaqg;
    private final zzck zzaqh;
    protected final zzcf zzaqi;
    private final Context zzaqj;
    private final WindowManager zzaqk;
    private final PowerManager zzaql;
    private final KeyguardManager zzaqm;
    private zzch zzaqn;
    private boolean zzaqo;
    private boolean zzanc = false;
    private boolean zzaqp = false;
    private boolean zzaqq;
    private boolean zzaqr;
    private boolean zzaqs;
    BroadcastReceiver zzaqt;
    private final HashSet<zzce> zzaqu = new HashSet();
    private zzkv zzapz;
    private final zzet zzaqv = new zzet(){

        @Override
        public void zza(zzll zzll2, Map<String, String> map) {
            if (!zzcd.this.zzb(map)) {
                return;
            }
            zzcd.this.zza(zzll2.getView(), map);
        }
    };
    private final zzet zzaqw = new zzet(){

        @Override
        public void zza(zzll zzll2, Map<String, String> map) {
            if (!zzcd.this.zzb(map)) {
                return;
            }
            String string2 = String.valueOf(zzcd.this.zzaqi.zzhn());
            zzkh.zzcw((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
            zzcd.this.destroy();
        }
    };
    private final zzet zzaqx = new zzet(){

        @Override
        public void zza(zzll zzll2, Map<String, String> map) {
            if (!zzcd.this.zzb(map)) {
                return;
            }
            if (!map.containsKey("isVisible")) {
                return;
            }
            Boolean bl = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
            zzcd.this.zzj(bl);
        }
    };

    public zzcd(Context context, AdSizeParcel adSizeParcel, zzjy zzjy2, VersionInfoParcel versionInfoParcel, zzck zzck2) {
        this.zzaqf = new WeakReference<zzjy>(zzjy2);
        this.zzaqh = zzck2;
        this.zzaqg = new WeakReference<Object>(null);
        this.zzaqq = true;
        this.zzaqs = false;
        this.zzapz = new zzkv(200L);
        this.zzaqi = new zzcf(UUID.randomUUID().toString(), versionInfoParcel, adSizeParcel.zzaup, zzjy2.zzcii, zzjy2.zzho(), adSizeParcel.zzaus);
        this.zzaqk = (WindowManager)context.getSystemService("window");
        this.zzaql = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzaqm = (KeyguardManager)context.getSystemService("keyguard");
        this.zzaqj = context;
    }

    public void zza(zzce zzce2) {
        this.zzaqu.add(zzce2);
    }

    protected void zzj(boolean bl) {
        for (zzce zzce2 : this.zzaqu) {
            zzce2.zza(this, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzgw() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzaqt != null) {
                return;
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            this.zzaqt = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    zzcd.this.zzk(3);
                }
            };
            this.zzaqj.registerReceiver(this.zzaqt, intentFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzgx() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzaqt != null) {
                try {
                    this.zzaqj.unregisterReceiver(this.zzaqt);
                }
                catch (IllegalStateException illegalStateException) {
                    zzkh.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                }
                catch (Exception exception) {
                    zzu.zzft().zzb(exception, true);
                }
                this.zzaqt = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzhc();
            this.zzgx();
            this.zzaqq = false;
            this.zzgz();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzgy() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzaqq) {
                this.zzaqr = true;
                try {
                    JSONObject jSONObject = this.zzhg();
                    this.zza(jSONObject);
                }
                catch (JSONException jSONException) {
                    zzkh.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzkh.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zzaqi.zzhn());
                zzkh.zzcw((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
        }
    }

    protected void zza(View view, Map<String, String> map) {
        this.zzk(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzk(int n) {
        Object object = this.zzail;
        synchronized (object) {
            boolean bl;
            boolean bl2;
            if (!this.zzhe() || !this.zzaqq) {
                return;
            }
            View view = this.zzaqh.zzhh();
            this.zzaqs = bl2 = view != null && zzu.zzfq().zza(view, this.zzaql, this.zzaqm) && view.getGlobalVisibleRect(new Rect(), null);
            boolean bl3 = this.zzaqh.zzhi();
            if (bl3) {
                this.zzgy();
                return;
            }
            boolean bl4 = bl = n == 1;
            if (bl && !this.zzapz.tryAcquire() && bl2 == this.zzaqs) {
                return;
            }
            if (!bl2 && !this.zzaqs && n == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zzd(view);
                this.zza(jSONObject);
            }
            catch (RuntimeException | JSONException throwable) {
                zzkh.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            this.zzhb();
            this.zzgz();
        }
    }

    protected void zzgz() {
        if (this.zzaqn != null) {
            this.zzaqn.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzha() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzaqq;
        }
    }

    protected int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    protected void zzhb() {
        zzck zzck2 = this.zzaqh.zzhj();
        View view = zzck2.zzhh();
        if (view == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzaqg.get();
        ViewTreeObserver viewTreeObserver2 = view.getViewTreeObserver();
        if (viewTreeObserver2 == viewTreeObserver) {
            return;
        }
        this.zzhc();
        if (!this.zzaqo || viewTreeObserver != null && viewTreeObserver.isAlive()) {
            this.zzaqo = true;
            viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.zzaqg = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
    }

    protected boolean zzb(Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzaqi.zzhn());
    }

    protected void zzc(zzfx zzfx2) {
        zzfx2.zza("/updateActiveView", this.zzaqv);
        zzfx2.zza("/untrackActiveViewUnit", this.zzaqw);
        zzfx2.zza("/visibilityChanged", this.zzaqx);
    }

    protected void zzd(zzfx zzfx2) {
        zzfx2.zzb("/visibilityChanged", this.zzaqx);
        zzfx2.zzb("/untrackActiveViewUnit", this.zzaqw);
        zzfx2.zzb("/updateActiveView", this.zzaqv);
    }

    protected void zzhc() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzaqg.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected JSONObject zzhd() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.zzaqi.zzhl()).put("activeViewJSON", (Object)this.zzaqi.zzhm()).put("timestamp", zzu.zzfu().elapsedRealtime()).put("adFormat", (Object)this.zzaqi.zzhk()).put("hashCode", (Object)this.zzaqi.zzhn()).put("isMraid", this.zzaqi.zzho()).put("isStopped", this.zzaqp).put("isPaused", this.zzanc).put("isScreenOn", this.isScreenOn()).put("isNative", this.zzaqi.zzhp());
        return jSONObject;
    }

    protected void zza(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject2 = new JSONObject();
            jSONArray.put((Object)jSONObject);
            jSONObject2.put("units", (Object)jSONArray);
            this.zzb(jSONObject2);
        }
        catch (Throwable throwable) {
            zzkh.zzb((String)"Skipping active view message.", (Throwable)throwable);
        }
    }

    protected abstract void zzb(JSONObject var1);

    protected abstract boolean zzhe();

    protected JSONObject zzhf() throws JSONException {
        return this.zzhd().put("isAttachedToWindow", false).put("isScreenOn", this.isScreenOn()).put("isVisible", false);
    }

    protected JSONObject zzd(View view) throws JSONException {
        if (view == null) {
            return this.zzhf();
        }
        boolean bl = zzu.zzfs().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzkh.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        Rect rect = new Rect();
        rect.left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        rect2.right = this.zzaqk.getDefaultDisplay().getWidth();
        rect2.bottom = this.zzaqk.getDefaultDisplay().getHeight();
        Rect rect3 = new Rect();
        boolean bl2 = view.getGlobalVisibleRect(rect3, null);
        Rect rect4 = new Rect();
        boolean bl3 = view.getLocalVisibleRect(rect4);
        Rect rect5 = new Rect();
        view.getHitRect(rect5);
        JSONObject jSONObject = this.zzhd();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl).put("viewBox", (Object)new JSONObject().put("top", this.zza(rect2.top, displayMetrics)).put("bottom", this.zza(rect2.bottom, displayMetrics)).put("left", this.zza(rect2.left, displayMetrics)).put("right", this.zza(rect2.right, displayMetrics))).put("adBox", (Object)new JSONObject().put("top", this.zza(rect.top, displayMetrics)).put("bottom", this.zza(rect.bottom, displayMetrics)).put("left", this.zza(rect.left, displayMetrics)).put("right", this.zza(rect.right, displayMetrics))).put("globalVisibleBox", (Object)new JSONObject().put("top", this.zza(rect3.top, displayMetrics)).put("bottom", this.zza(rect3.bottom, displayMetrics)).put("left", this.zza(rect3.left, displayMetrics)).put("right", this.zza(rect3.right, displayMetrics))).put("globalVisibleBoxVisible", bl2).put("localVisibleBox", (Object)new JSONObject().put("top", this.zza(rect4.top, displayMetrics)).put("bottom", this.zza(rect4.bottom, displayMetrics)).put("left", this.zza(rect4.left, displayMetrics)).put("right", this.zza(rect4.right, displayMetrics))).put("localVisibleBoxVisible", bl3).put("hitBox", (Object)new JSONObject().put("top", this.zza(rect5.top, displayMetrics)).put("bottom", this.zza(rect5.bottom, displayMetrics)).put("left", this.zza(rect5.left, displayMetrics)).put("right", this.zza(rect5.right, displayMetrics))).put("screenDensity", (double)displayMetrics.density).put("isVisible", zzu.zzfq().zza(view, this.zzaql, this.zzaqm));
        return jSONObject;
    }

    boolean isScreenOn() {
        return this.zzaql.isScreenOn();
    }

    protected JSONObject zzhg() throws JSONException {
        JSONObject jSONObject = this.zzhd();
        jSONObject.put("doneReasonCode", (Object)"u");
        return jSONObject;
    }

    public void onScrollChanged() {
        this.zzk(1);
    }

    public void onGlobalLayout() {
        this.zzk(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzch zzch2) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzaqn = zzch2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzaqp = true;
            this.zzk(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzanc = true;
            this.zzk(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzanc = false;
            this.zzk(3);
        }
    }

    public static class zzb
    implements zzck {
        private zzh zzara;

        public zzb(zzh zzh2) {
            this.zzara = zzh2;
        }

        @Override
        public View zzhh() {
            return this.zzara.zzle();
        }

        @Override
        public boolean zzhi() {
            return this.zzara == null;
        }

        @Override
        public zzck zzhj() {
            return this;
        }
    }

    public static class zza
    implements zzck {
        private WeakReference<zzh> zzaqz;

        public zza(zzh zzh2) {
            this.zzaqz = new WeakReference<zzh>(zzh2);
        }

        @Override
        public View zzhh() {
            zzh zzh2 = (zzh)this.zzaqz.get();
            return zzh2 != null ? zzh2.zzle() : null;
        }

        @Override
        public boolean zzhi() {
            return this.zzaqz.get() == null;
        }

        @Override
        public zzck zzhj() {
            return new zzb((zzh)this.zzaqz.get());
        }
    }

    public static class zzc
    implements zzck {
        private final View mView;
        private final zzjy zzarb;

        public zzc(View view, zzjy zzjy2) {
            this.mView = view;
            this.zzarb = zzjy2;
        }

        @Override
        public View zzhh() {
            return this.mView;
        }

        @Override
        public boolean zzhi() {
            return this.zzarb == null || this.mView == null;
        }

        @Override
        public zzck zzhj() {
            return this;
        }
    }

    public static class zzd
    implements zzck {
        private final WeakReference<View> zzarc;
        private final WeakReference<zzjy> zzard;

        public zzd(View view, zzjy zzjy2) {
            this.zzarc = new WeakReference<View>(view);
            this.zzard = new WeakReference<zzjy>(zzjy2);
        }

        @Override
        public View zzhh() {
            return (View)this.zzarc.get();
        }

        @Override
        public boolean zzhi() {
            return this.zzarc.get() == null || this.zzard.get() == null;
        }

        @Override
        public zzck zzhj() {
            return new zzc((View)this.zzarc.get(), (zzjy)this.zzard.get());
        }
    }
}

