/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.DownloadManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzds;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkh;
import java.io.File;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@zzir
public class zzdt {
    private static final Object zzamp = new Object();
    private static AtomicInteger zzbeu = new AtomicInteger();
    private static zzdt zzbev;

    protected zzdt() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzdt zzkq() {
        Object object = zzamp;
        synchronized (object) {
            if (zzbev == null) {
                zzbev = new zzdt();
            }
            return zzbev;
        }
    }

    public void zza(Context context, Map<String, String> map) {
        String string2 = map.get("url");
        String string3 = map.get("package_name");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzkh.e((String)"Download URL provided by creative is null or empty.");
            return;
        }
        DownloadManager.Request request = null;
        try {
            request = this.zza(context, new DownloadManager.Request(Uri.parse((String)string2)), string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            zzkh.zzb((String)"Download URL is not a valid HTTP/HTTPS URI. Abort downloading task.", (Throwable)illegalArgumentException);
            return;
        }
        String string4 = map.get("tracking_url");
        zzkh.zzcw((String)new StringBuilder(32 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Start downloading package ").append(string3).append(" from ").append(string2).toString());
        DownloadManager downloadManager = (DownloadManager)context.getSystemService("download");
        zzds.zza(context, zzh.zzavi()).zza(downloadManager.enqueue(request), string3, string4);
    }

    public void zzd(Context context, @NonNull String string2) {
        String string3 = String.valueOf(string2);
        zzkh.zzcw((String)(string3.length() != 0 ? "Deleting downloaded file: ".concat(string3) : new String("Deleting downloaded file: ")));
        File file = new File(string2);
        boolean bl = file.exists();
        if (bl) {
            file.delete();
            boolean bl2 = file.exists();
            if (!bl2) {
                String string4 = String.valueOf(string2);
                zzkh.zzcw((String)(string4.length() != 0 ? "File deleted successfully from path: ".concat(string4) : new String("File deleted successfully from path: ")));
            } else {
                String string5 = String.valueOf(string2);
                zzkh.zzcw((String)(string5.length() != 0 ? "Error deleting file: ".concat(string5) : new String("Error deleting file: ")));
            }
        } else {
            zzkh.zzcw((String)new StringBuilder(21 + String.valueOf(string2).length()).append("File: ").append(string2).append(" doesn't exist!").toString());
        }
        zzds.zza(context, zzh.zzavi()).zzat(string2);
    }

    protected DownloadManager.Request zza(Context context, DownloadManager.Request request, String string2) {
        String string3 = String.valueOf(Environment.getExternalStorageDirectory().toString());
        String string4 = String.valueOf("/directappinstall/");
        request.setDestinationInExternalFilesDir(context, string4.length() != 0 ? string3.concat(string4) : new String(string3), string2).setVisibleInDownloadsUi(true).setAllowedNetworkTypes(3);
        if (zzs.zzavj()) {
            return request.setNotificationVisibility(1);
        }
        return request.setShowRunningNotification(true);
    }

    public String zzb(Context context, Map<String, String> map) {
        String string2 = map.get("package_name");
        PackageManager packageManager = context.getPackageManager();
        try {
            int n;
            PackageInfo packageInfo = packageManager.getPackageInfo(string2, 1);
            String string3 = map.get("app_version");
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzkh.e((String)"No app version provided by creative.");
                return "installed_unknown_version";
            }
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                zzkh.e((String)"Malformated app version is provided by creative.");
                return "installed_unknown_version";
            }
            int n2 = packageInfo.versionCode;
            if (n > n2) {
                zzkh.zzcw((String)new StringBuilder(34 + String.valueOf(string2).length()).append("App ").append(string2).append(" installed but need an update.").toString());
                return "installed_older_version";
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zzkh.zzcw((String)new StringBuilder(19 + String.valueOf(string2).length()).append("App ").append(string2).append(" not installed.").toString());
            return "not_installed";
        }
        zzkh.zzcw((String)new StringBuilder(52 + String.valueOf(string2).length()).append("App ").append(string2).append(" already installed with current / newer version.").toString());
        return "installed_given_version";
    }
}

