/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.ActivityManager;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.AdLauncherIntentInfoParcel;
import com.google.android.gms.ads.internal.zze;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzet;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzhe;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzll;
import com.google.android.gms.internal.zzlm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@zzir
public final class zzfa
implements zzet {
    private final zzev zzbja;
    private final zze zzbix;
    private final zzhe zzbiy;

    public zzfa(zzev zzev2, zze zze2, zzhe zzhe2) {
        this.zzbja = zzev2;
        this.zzbix = zze2;
        this.zzbiy = zzhe2;
    }

    @Override
    public void zza(zzll zzll2, Map<String, String> map) {
        String string2 = map.get("a");
        if (string2 == null) {
            zzkh.zzcy((String)"Action missing from an open GMSG.");
            return;
        }
        if (this.zzbix != null && !this.zzbix.zzem()) {
            this.zzbix.zzt(map.get("u"));
            return;
        }
        zzlm zzlm2 = zzll2.zzuk();
        if ("expand".equalsIgnoreCase(string2)) {
            if (zzll2.zzuo()) {
                zzkh.zzcy((String)"Cannot expand WebView that is already expanded.");
                return;
            }
            this.zzr(false);
            zzlm2.zza(zzfa.zzc(map), zzfa.zzd(map));
        } else if ("webapp".equalsIgnoreCase(string2)) {
            String string3 = map.get("u");
            this.zzr(false);
            if (string3 != null) {
                zzlm2.zza(zzfa.zzc(map), zzfa.zzd(map), string3);
            } else {
                zzlm2.zza(zzfa.zzc(map), zzfa.zzd(map), map.get("html"), map.get("baseurl"));
            }
        } else if ("in_app_purchase".equalsIgnoreCase(string2)) {
            String string4 = map.get("product_id");
            String string5 = map.get("report_urls");
            if (this.zzbja == null) {
                return;
            }
            if (string5 != null && !string5.isEmpty()) {
                String[] stringArray = string5.split(" ");
                this.zzbja.zza(string4, new ArrayList<String>(Arrays.asList(stringArray)));
            } else {
                this.zzbja.zza(string4, new ArrayList<String>());
            }
        } else if ("app".equalsIgnoreCase(string2) && "true".equalsIgnoreCase(map.get("system_browser"))) {
            this.zzr(true);
            zzfa.zze(zzll2, map);
        } else {
            this.zzr(true);
            String string6 = map.get("u");
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                string6 = zzu.zzfq().zza(zzll2, string6);
            }
            zzlm2.zza(new AdLauncherIntentInfoParcel(map.get("i"), string6, map.get("m"), map.get("p"), map.get("c"), map.get("f"), map.get("e")));
        }
    }

    private static void zze(zzll zzll2, Map<String, String> map) {
        Context context = zzll2.getContext();
        String string2 = map.get("u");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzkh.zzcy((String)"Destination url cannot be empty.");
            return;
        }
        zzlm zzlm2 = zzll2.zzuk();
        zza zza2 = new zza(zzll2);
        Intent intent = zza2.zzc(context, map);
        try {
            zzlm2.zza(new AdLauncherIntentInfoParcel(intent));
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzkh.zzcy((String)activityNotFoundException.getMessage());
        }
    }

    private static boolean zzc(Map<String, String> map) {
        return "1".equals(map.get("custom_close"));
    }

    private static int zzd(Map<String, String> map) {
        String string2 = map.get("o");
        if (string2 != null) {
            if ("p".equalsIgnoreCase(string2)) {
                return zzu.zzfs().zztl();
            }
            if ("l".equalsIgnoreCase(string2)) {
                return zzu.zzfs().zztk();
            }
            if ("c".equalsIgnoreCase(string2)) {
                return zzu.zzfs().zztm();
            }
        }
        return -1;
    }

    private void zzr(boolean bl) {
        if (this.zzbiy != null) {
            this.zzbiy.zzs(bl);
        }
    }

    public static class zza {
        private final zzll zzbgj;

        public zza(zzll zzll2) {
            this.zzbgj = zzll2;
        }

        public Intent zze(Uri uri) {
            if (uri == null) {
                return null;
            }
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addFlags(0x10000000);
            intent.setData(uri);
            intent.setAction("android.intent.action.VIEW");
            return intent;
        }

        public ResolveInfo zza(Context context, Intent intent) {
            return this.zza(context, intent, new ArrayList<ResolveInfo>());
        }

        public ResolveInfo zza(Context context, Intent intent, ArrayList<ResolveInfo> arrayList) {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return null;
            }
            List list = packageManager.queryIntentActivities(intent, 65536);
            ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
            ResolveInfo resolveInfo2 = null;
            if (list != null && resolveInfo != null) {
                for (int i = 0; i < list.size(); ++i) {
                    ResolveInfo resolveInfo3 = (ResolveInfo)list.get(i);
                    if (resolveInfo == null || !resolveInfo.activityInfo.name.equals(resolveInfo3.activityInfo.name)) continue;
                    resolveInfo2 = resolveInfo;
                    break;
                }
            }
            arrayList.addAll(list);
            return resolveInfo2;
        }

        public Intent zza(Intent intent, ResolveInfo resolveInfo) {
            Intent intent2 = new Intent(intent);
            intent2.setClassName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name);
            return intent2;
        }

        public Intent zzc(Context context, Map<String, String> map) {
            Object object;
            ResolveInfo resolveInfo3;
            Object object2;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            String string2 = map.get("u");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            if (this.zzbgj != null) {
                string2 = zzu.zzfq().zza(this.zzbgj, string2);
            }
            Uri uri = Uri.parse((String)string2);
            boolean bl = Boolean.parseBoolean(map.get("use_first_package"));
            boolean bl2 = Boolean.parseBoolean(map.get("use_running_process"));
            Uri uri2 = null;
            if ("http".equalsIgnoreCase(uri.getScheme())) {
                uri2 = uri.buildUpon().scheme("https").build();
            } else if ("https".equalsIgnoreCase(uri.getScheme())) {
                uri2 = uri.buildUpon().scheme("http").build();
            }
            ArrayList<ResolveInfo> arrayList = new ArrayList<ResolveInfo>();
            Intent intent = this.zze(uri);
            Intent intent2 = this.zze(uri2);
            ResolveInfo resolveInfo2 = this.zza(context, intent, arrayList);
            if (resolveInfo2 != null) {
                return this.zza(intent, resolveInfo2);
            }
            if (intent2 != null && (object2 = this.zza(context, intent2)) != null && (resolveInfo3 = this.zza(context, (Intent)(object = this.zza(intent, (ResolveInfo)object2)))) != null) {
                return object;
            }
            if (arrayList.size() == 0) {
                return intent;
            }
            if (bl2 && activityManager != null && (object2 = activityManager.getRunningAppProcesses()) != null) {
                for (ResolveInfo resolveInfo3 : arrayList) {
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)iterator.next();
                        if (!runningAppProcessInfo.processName.equals(resolveInfo3.activityInfo.packageName)) continue;
                        return this.zza(intent, resolveInfo3);
                    }
                }
            }
            if (bl) {
                return this.zza(intent, arrayList.get(0));
            }
            return intent;
        }
    }
}

