/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzhj;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzll;
import java.util.Map;

@zzir
public class zzhd
extends zzhj {
    private final Map<String, String> zzbee;
    private final Context mContext;
    private String zzbqc;
    private long zzbqd;
    private long zzbqe;
    private String zzbqf;
    private String zzbqg;

    public zzhd(zzll zzll2, Map<String, String> map) {
        super(zzll2, "createCalendarEvent");
        this.zzbee = map;
        this.mContext = zzll2.zzuf();
        this.zzmv();
    }

    private void zzmv() {
        this.zzbqc = this.zzbr("description");
        this.zzbqf = this.zzbr("summary");
        this.zzbqd = this.zzbs("start_ticks");
        this.zzbqe = this.zzbs("end_ticks");
        this.zzbqg = this.zzbr("location");
    }

    private String zzbr(String string2) {
        return TextUtils.isEmpty((CharSequence)this.zzbee.get(string2)) ? "" : this.zzbee.get(string2);
    }

    private long zzbs(String string2) {
        String string3 = this.zzbee.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzbu("Activity context is not available.");
            return;
        }
        zzcu zzcu2 = zzu.zzfq().zzag(this.mContext);
        if (!zzcu2.zzju()) {
            this.zzbu("This feature is not available on the device.");
            return;
        }
        AlertDialog.Builder builder = zzu.zzfq().zzaf(this.mContext);
        Resources resources = zzu.zzft().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.create_calendar_title) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.create_calendar_message) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.accept) : "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                Intent intent = zzhd.this.createIntent();
                zzu.zzfq().zzb(zzhd.this.mContext, intent);
            }
        });
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.decline) : "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                zzhd.this.zzbu("Operation denied by user.");
            }
        });
        builder.create().show();
    }

    @TargetApi(value=14)
    Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzbqc);
        intent.putExtra("eventLocation", this.zzbqg);
        intent.putExtra("description", this.zzbqf);
        if (this.zzbqd > -1L) {
            intent.putExtra("beginTime", this.zzbqd);
        }
        if (this.zzbqe > -1L) {
            intent.putExtra("endTime", this.zzbqe);
        }
        intent.setFlags(0x10000000);
        return intent;
    }
}

