/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.app.DownloadManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzhj;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzll;
import java.util.Map;

@zzir
public class zzhg
extends zzhj {
    private final Map<String, String> zzbee;
    private final Context mContext;

    public zzhg(zzll zzll2, Map<String, String> map) {
        super(zzll2, "storePicture");
        this.zzbee = map;
        this.mContext = zzll2.zzuf();
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzbu("Activity context is not available");
            return;
        }
        zzcu zzcu2 = zzu.zzfq().zzag(this.mContext);
        if (!zzcu2.zzjr()) {
            this.zzbu("Feature is not supported by the device.");
            return;
        }
        final String string2 = this.zzbee.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzbu("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            String string3 = String.valueOf(string2);
            this.zzbu(string3.length() != 0 ? "Invalid image url: ".concat(string3) : new String("Invalid image url: "));
            return;
        }
        final String string4 = this.zzbt(string2);
        if (!zzu.zzfq().zzcr(string4)) {
            String string5 = String.valueOf(string4);
            this.zzbu(string5.length() != 0 ? "Image type not recognized: ".concat(string5) : new String("Image type not recognized: "));
            return;
        }
        Resources resources = zzu.zzft().getResources();
        AlertDialog.Builder builder = zzu.zzfq().zzaf(this.mContext);
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.store_picture_title) : "Save image"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.store_picture_message) : "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.accept) : "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                DownloadManager downloadManager = (DownloadManager)zzhg.this.mContext.getSystemService("download");
                try {
                    DownloadManager.Request request = zzhg.this.zzk(string2, string4);
                    downloadManager.enqueue(request);
                }
                catch (IllegalStateException illegalStateException) {
                    zzhg.this.zzbu("Could not store picture.");
                }
            }
        });
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.decline) : "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                zzhg.this.zzbu("User canceled the download.");
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    DownloadManager.Request zzk(String string2, String string3) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)string2));
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_PICTURES, string3);
        zzu.zzfs().zza(request);
        return request;
    }

    String zzbt(String string2) {
        Uri uri = Uri.parse((String)string2);
        return uri.getLastPathSegment();
    }
}

