/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.formats.zzc;
import com.google.android.gms.ads.internal.formats.zzf;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.formats.zzi;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzas;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzet;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzil;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzio;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzjy;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkl;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzkz;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzll;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzir
public class zzim
implements Callable<zzjy> {
    private static final long zzbyx = TimeUnit.SECONDS.toMillis(60L);
    private final Context mContext;
    private final zzkr zzbzg;
    private final zzq zzbzh;
    private final zzas zzbgh;
    private final zzil zzbgf;
    private final Object zzail = new Object();
    private final zzjy.zza zzbxv;
    private boolean zzbzi;
    private int zzbym;
    private List<String> zzbzj;
    private JSONObject zzbzk;

    public zzim(Context context, zzq zzq2, zzkr zzkr2, zzas zzas2, zzjy.zza zza2) {
        this.mContext = context;
        this.zzbzh = zzq2;
        this.zzbzg = zzkr2;
        this.zzbxv = zza2;
        this.zzbgh = zzas2;
        this.zzbgf = this.zza(context, zza2, zzq2, zzas2);
        this.zzbgf.zzqh();
        this.zzbzi = false;
        this.zzbym = -2;
        this.zzbzj = null;
    }

    public zzjy zzqs() {
        try {
            this.zzbgf.zzqi();
            String string2 = UUID.randomUUID().toString();
            JSONObject jSONObject = this.zzcc(string2);
            zza zza2 = this.zzf(jSONObject);
            zzh.zza zza3 = this.zza(zza2, jSONObject, string2);
            this.zza(zza3);
            zzjy zzjy2 = this.zzb(zza3);
            return zzjy2;
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (JSONException jSONException) {
            zzkh.zzd((String)"Malformed native JSON response.", (Throwable)jSONException);
        }
        catch (TimeoutException timeoutException) {
            zzkh.zzd((String)"Timeout when loading native ad.", (Throwable)timeoutException);
        }
        if (!this.zzbzi) {
            this.zzan(0);
        }
        return this.zzb(null);
    }

    private JSONObject zzcc(final String string2) throws ExecutionException, InterruptedException, TimeoutException, JSONException {
        if (this.zzqt()) {
            return null;
        }
        final zzkz zzkz2 = new zzkz();
        final zzb zzb2 = new zzb();
        zzil.zza zza2 = new zzil.zza(){

            @Override
            public void zze(final zzfx zzfx2) {
                zzet zzet2;
                zzb2.zzcad = zzet2 = new zzet(){

                    @Override
                    public void zza(zzll zzll2, Map<String, String> map) {
                        zzfx2.zzb("/nativeAdPreProcess", zzb2.zzcad);
                        try {
                            String string2 = map.get("success");
                            if (!TextUtils.isEmpty((CharSequence)string2)) {
                                zzkz2.zzi(new JSONObject(string2).getJSONArray("ads").getJSONObject(0));
                                return;
                            }
                        }
                        catch (JSONException jSONException) {
                            zzkh.zzb((String)"Malformed native JSON response.", (Throwable)jSONException);
                        }
                        zzim.this.zzan(0);
                        zzab.zza((boolean)zzim.this.zzqt(), (Object)"Unable to set the ad state error!");
                        zzkz2.zzi(null);
                    }
                };
                zzfx2.zza("/nativeAdPreProcess", zzet2);
                try {
                    JSONObject jSONObject = new JSONObject(((zzim)zzim.this).zzbxv.zzciu.body);
                    jSONObject.put("ads_id", (Object)string2);
                    zzfx2.zza("google.afma.nativeAds.preProcessJsonGmsg", jSONObject);
                }
                catch (JSONException jSONException) {
                    zzkh.zzd((String)"Exception occurred while invoking javascript", (Throwable)jSONException);
                    zzkz2.zzi(null);
                }
            }

            @Override
            public void zzqr() {
                zzkz2.zzi(null);
            }
        };
        this.zzbgf.zza(zza2);
        return (JSONObject)zzkz2.get(zzbyx, TimeUnit.MILLISECONDS);
    }

    protected zza zzf(JSONObject jSONObject) throws ExecutionException, InterruptedException, JSONException, TimeoutException {
        boolean bl;
        if (this.zzqt()) {
            return null;
        }
        String string2 = jSONObject.getString("template_id");
        boolean bl2 = this.zzbxv.zzcit.zzapm != null ? this.zzbxv.zzcit.zzapm.zzbgt : false;
        boolean bl3 = bl = this.zzbxv.zzcit.zzapm != null ? this.zzbxv.zzcit.zzapm.zzbgv : false;
        if ("2".equals(string2)) {
            return new zzin(bl2, bl);
        }
        if ("1".equals(string2)) {
            return new zzio(bl2, bl);
        }
        if ("3".equals(string2)) {
            final String string3 = jSONObject.getString("custom_template_id");
            final zzkz zzkz2 = new zzkz();
            zzkl.zzclg.post(new Runnable(){

                @Override
                public void run() {
                    zzkz2.zzi((zzeh)zzim.this.zzbzh.zzfb().get((Object)string3));
                }
            });
            if (zzkz2.get(zzbyx, TimeUnit.MILLISECONDS) != null) {
                return new zzip(bl2);
            }
            String string4 = String.valueOf(jSONObject.getString("custom_template_id"));
            zzkh.e((String)(string4.length() != 0 ? "No handler for custom template: ".concat(string4) : new String("No handler for custom template: ")));
        } else {
            this.zzan(0);
        }
        return null;
    }

    private void zza(zzh.zza zza2) {
        zzet zzet2;
        if (!(zza2 instanceof zzf)) {
            return;
        }
        final zzf zzf2 = (zzf)zza2;
        zzb zzb2 = new zzb();
        zzb2.zzcad = zzet2 = new zzet(){

            @Override
            public void zza(zzll zzll2, Map<String, String> map) {
                String string2 = map.get("asset");
                zzim.this.zzb((zzec)zzf2, string2);
            }
        };
        this.zzbgf.zza(new zzil.zza(){

            @Override
            public void zze(zzfx zzfx2) {
                zzfx2.zza("/nativeAdCustomClick", zzet2);
            }
        });
    }

    private void zzb(zzec zzec2, String string2) {
        try {
            zzeg zzeg2 = this.zzbzh.zzv(zzec2.getCustomTemplateId());
            if (zzeg2 != null) {
                zzeg2.zza(zzec2, string2);
            }
        }
        catch (RemoteException remoteException) {
            zzkh.zzd((String)new StringBuilder(40 + String.valueOf(string2).length()).append("Failed to call onCustomClick for asset ").append(string2).append(".").toString(), (Throwable)remoteException);
        }
    }

    private zzh.zza zza(zza zza2, JSONObject jSONObject, String string2) throws ExecutionException, InterruptedException, JSONException {
        if (this.zzqt()) {
            return null;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("tracking_urls_and_actions");
        String[] stringArray = this.zzc(jSONObject2, "impression_tracking_urls");
        this.zzbzj = stringArray == null ? null : Arrays.asList(stringArray);
        this.zzbzk = jSONObject2.optJSONObject("active_view");
        Object t = zza2.zza(this, jSONObject);
        if (t == null) {
            zzkh.e((String)"Failed to retrieve ad assets.");
            return null;
        }
        t.zzb((zzh)new zzi(this.mContext, this.zzbzh, this.zzbgf, this.zzbgh, jSONObject, (zzh.zza)t, this.zzbxv.zzcit.zzaou, string2));
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzjy zzb(zzh.zza zza2) {
        int n;
        Object object = this.zzail;
        synchronized (object) {
            n = this.zzbym;
            if (zza2 == null && this.zzbym == -2) {
                n = 0;
            }
        }
        if (n != -2) {
            zza2 = null;
        }
        return new zzjy(this.zzbxv.zzcit.zzcav, null, this.zzbxv.zzciu.zzbnq, n, this.zzbxv.zzciu.zzbnr, this.zzbzj, this.zzbxv.zzciu.orientation, this.zzbxv.zzciu.zzbnw, this.zzbxv.zzcit.zzcay, false, null, null, null, null, null, 0L, this.zzbxv.zzaoy, this.zzbxv.zzciu.zzccb, this.zzbxv.zzcio, this.zzbxv.zzcip, this.zzbxv.zzciu.zzcch, this.zzbzk, zza2, null, null, null, this.zzbxv.zzciu.zzccu, this.zzbxv.zzciu.zzccv, null, this.zzbxv.zzciu.zzbnt);
    }

    public zzlc<com.google.android.gms.ads.internal.formats.zza> zzg(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject.optJSONObject("attribution");
        if (jSONObject2 == null) {
            return new zzla<Object>(null);
        }
        final String string2 = jSONObject2.optString("text");
        final int n = jSONObject2.optInt("text_size", -1);
        final Integer n2 = this.zzb(jSONObject2, "text_color");
        final Integer n3 = this.zzb(jSONObject2, "bg_color");
        final int n4 = jSONObject2.optInt("animation_ms", 1000);
        final int n5 = jSONObject2.optInt("presentation_ms", 4000);
        final int n6 = this.zzbxv.zzcit.zzapm != null && this.zzbxv.zzcit.zzapm.versionCode >= 2 ? this.zzbxv.zzcit.zzapm.zzbgw : 1;
        ArrayList arrayList = new ArrayList<zzlc<zzc>>();
        if (jSONObject2.optJSONArray("images") != null) {
            arrayList = this.zza(jSONObject2, "images", false, false, true);
        } else {
            arrayList.add(this.zza(jSONObject2, "image", false, false));
        }
        zzlc zzlc2 = zzlb.zzn(arrayList);
        return zzlb.zza(zzlc2, new zzlb.zza<List<zzc>, com.google.android.gms.ads.internal.formats.zza>(){

            public com.google.android.gms.ads.internal.formats.zza zzj(List<zzc> list) {
                try {
                    return list == null || list.isEmpty() ? null : new com.google.android.gms.ads.internal.formats.zza(string2, zzim.zzh(list), n3, n2, n > 0 ? Integer.valueOf(n) : null, n5 + n4, n6);
                }
                catch (RemoteException remoteException) {
                    zzkh.zzb((String)"Could not get attribution icon", (Throwable)remoteException);
                    return null;
                }
            }

            @Override
            public /* synthetic */ Object zzh(Object object) {
                return this.zzj((List)object);
            }
        });
    }

    private Integer zzb(JSONObject jSONObject, String string2) {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
            int n = jSONObject2.getInt("r");
            int n2 = jSONObject2.getInt("g");
            int n3 = jSONObject2.getInt("b");
            return Color.rgb((int)n, (int)n2, (int)n3);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public Future<zzc> zza(JSONObject jSONObject, String string2, boolean bl) throws JSONException {
        JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
        boolean bl2 = jSONObject2.optBoolean("require", true);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl2, bl);
    }

    public zzlc<zzc> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2) throws JSONException {
        JSONObject jSONObject2 = bl ? jSONObject.getJSONObject(string2) : jSONObject.optJSONObject(string2);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl, bl2);
    }

    public List<zzlc<zzc>> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2, boolean bl3) throws JSONException {
        JSONArray jSONArray = bl ? jSONObject.getJSONArray(string2) : jSONObject.optJSONArray(string2);
        ArrayList<zzlc<zzc>> arrayList = new ArrayList<zzlc<zzc>>();
        if (jSONArray == null || jSONArray.length() == 0) {
            this.zza(0, bl);
            return arrayList;
        }
        int n = bl3 ? jSONArray.length() : 1;
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
            arrayList.add(this.zza(jSONObject2, bl, bl2));
        }
        return arrayList;
    }

    private zzlc<zzc> zza(JSONObject jSONObject, final boolean bl, boolean bl2) throws JSONException {
        final String string2 = bl ? jSONObject.getString("url") : jSONObject.optString("url");
        final double d = jSONObject.optDouble("scale", 1.0);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zza(0, bl);
            return new zzla<Object>(null);
        }
        if (bl2) {
            return new zzla<zzc>(new zzc(null, Uri.parse((String)string2), d));
        }
        return this.zzbzg.zza(string2, new zzkr.zza<zzc>(){

            public zzc zzqu() {
                zzim.this.zza(2, bl);
                return null;
            }

            public zzc zzg(InputStream inputStream) {
                byte[] byArray = null;
                try {
                    byArray = zzo.zzk((InputStream)inputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (byArray == null) {
                    zzim.this.zza(2, bl);
                    return null;
                }
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                if (bitmap == null) {
                    zzim.this.zza(2, bl);
                    return null;
                }
                bitmap.setDensity((int)(160.0 * d));
                return new zzc((Drawable)new BitmapDrawable(Resources.getSystem(), bitmap), Uri.parse((String)string2), d);
            }

            @Override
            public /* synthetic */ Object zzqv() {
                return this.zzqu();
            }

            @Override
            public /* synthetic */ Object zzh(InputStream inputStream) {
                return this.zzg(inputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzqt() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzbzi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzan(int n) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzbzi = true;
            this.zzbym = n;
        }
    }

    public void zza(int n, boolean bl) {
        if (bl) {
            this.zzan(n);
        }
    }

    private String[] zzc(JSONObject jSONObject, String string2) throws JSONException {
        JSONArray jSONArray = jSONObject.optJSONArray(string2);
        if (jSONArray == null) {
            return null;
        }
        String[] stringArray = new String[jSONArray.length()];
        for (int i = 0; i < jSONArray.length(); ++i) {
            stringArray[i] = jSONArray.getString(i);
        }
        return stringArray;
    }

    private static List<Drawable> zzh(List<zzc> list) throws RemoteException {
        ArrayList<Drawable> arrayList = new ArrayList<Drawable>();
        for (zzc zzc2 : list) {
            arrayList.add((Drawable)zze.zzad((zzd)zzc2.zzkv()));
        }
        return arrayList;
    }

    zzil zza(Context context, zzjy.zza zza2, zzq zzq2, zzas zzas2) {
        return new zzil(context, zza2, zzq2, zzas2);
    }

    @Override
    public /* synthetic */ Object call() throws Exception {
        return this.zzqs();
    }

    class zzb {
        public zzet zzcad;

        zzb() {
        }
    }

    public static interface zza<T extends zzh.zza> {
        public T zza(zzim var1, JSONObject var2) throws JSONException, InterruptedException, ExecutionException;
    }
}

