/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkh;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;

@zzir
public class zziq
implements Thread.UncaughtExceptionHandler {
    private Thread.UncaughtExceptionHandler zzcag;
    private Thread.UncaughtExceptionHandler zzcah;
    private Context mContext;
    private VersionInfoParcel zzamu;

    public static zziq zza(Context context, Thread thread, VersionInfoParcel versionInfoParcel) {
        if (context == null || thread == null || versionInfoParcel == null) {
            return null;
        }
        if (!zziq.zzu(context)) {
            return null;
        }
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = thread.getUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler2 = thread.getDefaultUncaughtExceptionHandler();
        zziq zziq2 = new zziq(context, versionInfoParcel, uncaughtExceptionHandler, uncaughtExceptionHandler2);
        if (uncaughtExceptionHandler == null || !(uncaughtExceptionHandler instanceof zziq)) {
            try {
                thread.setUncaughtExceptionHandler(zziq2);
                return zziq2;
            }
            catch (SecurityException securityException) {
                zzkh.zzc((String)"Fail to set UncaughtExceptionHandler.", (Throwable)securityException);
            }
        } else {
            return (zziq)uncaughtExceptionHandler;
        }
        return null;
    }

    private static boolean zzu(Context context) {
        return zzdc.zzayb.get();
    }

    public zziq(Context context, VersionInfoParcel versionInfoParcel, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Thread.UncaughtExceptionHandler uncaughtExceptionHandler2) {
        this.zzcag = uncaughtExceptionHandler;
        this.zzcah = uncaughtExceptionHandler2;
        this.mContext = context;
        this.zzamu = versionInfoParcel;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (this.zzb(throwable)) {
            if (Looper.getMainLooper().getThread() != thread) {
                this.zza(throwable, true);
                return;
            }
            this.zza(throwable, false);
        }
        if (this.zzcag != null) {
            this.zzcag.uncaughtException(thread, throwable);
        } else if (this.zzcah != null) {
            this.zzcah.uncaughtException(thread, throwable);
        }
    }

    protected boolean zzb(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        while (throwable != null) {
            StackTraceElement[] stackTraceElementArray;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = throwable.getStackTrace()) {
                if (this.zzcd(stackTraceElement.getClassName())) {
                    bl = true;
                }
                if (!this.getClass().getName().equals(stackTraceElement.getClassName())) continue;
                bl2 = true;
            }
            throwable = throwable.getCause();
        }
        return bl && !bl2;
    }

    protected boolean zzcd(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (string.startsWith(zzdc.zzayd.get())) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.isAnnotationPresent(zzir.class);
        }
        catch (Exception exception) {
            String string2 = String.valueOf(string);
            zzkh.zza((String)(string2.length() != 0 ? "Fail to check class type for class ".concat(string2) : new String("Fail to check class type for class ")), (Throwable)exception);
            return false;
        }
    }

    protected boolean zzce(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return string.startsWith("android.") || string.startsWith("java.");
    }

    public void zza(Throwable throwable, boolean bl) {
        if (!zziq.zzu(this.mContext)) {
            return;
        }
        Throwable throwable2 = this.zzc(throwable);
        if (throwable2 == null) {
            return;
        }
        Class<?> clazz = throwable.getClass();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.zza(clazz, throwable2, bl));
        zzu.zzfq().zza(arrayList, zzu.zzft().zzsp());
    }

    String zza(Class clazz, Throwable throwable, boolean bl) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        Uri.Builder builder = new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("id", "gmob-apps-report-exception").appendQueryParameter("os", Build.VERSION.RELEASE).appendQueryParameter("api", String.valueOf(Build.VERSION.SDK_INT)).appendQueryParameter("device", zzu.zzfq().zzth()).appendQueryParameter("js", this.zzamu.zzcs).appendQueryParameter("appid", this.mContext.getApplicationContext().getPackageName()).appendQueryParameter("exceptiontype", clazz.getName()).appendQueryParameter("stacktrace", stringWriter.toString()).appendQueryParameter("eids", TextUtils.join((CharSequence)",", zzdc.zzjx())).appendQueryParameter("trapped", String.valueOf(bl));
        return builder.toString();
    }

    private Throwable zzc(Throwable throwable) {
        Throwable throwable2;
        if (zzdc.zzayc.get().booleanValue()) {
            return throwable;
        }
        LinkedList<Throwable> linkedList = new LinkedList<Throwable>();
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            linkedList.push(throwable2);
        }
        Throwable throwable3 = null;
        while (!linkedList.isEmpty()) {
            throwable2 = (Throwable)linkedList.pop();
            StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
            arrayList.add(new StackTraceElement(throwable2.getClass().getName(), "<filtered>", "<filtered>", 1));
            boolean bl = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (this.zzcd(stackTraceElement.getClassName())) {
                    bl = true;
                    arrayList.add(stackTraceElement);
                    continue;
                }
                if (this.zzce(stackTraceElement.getClassName())) {
                    arrayList.add(stackTraceElement);
                    continue;
                }
                StackTraceElement stackTraceElement2 = new StackTraceElement("<filtered>", "<filtered>", "<filtered>", 1);
                arrayList.add(stackTraceElement2);
            }
            if (!bl) continue;
            throwable3 = throwable3 == null ? new Throwable(throwable2.getMessage()) : new Throwable(throwable2.getMessage(), throwable3);
            throwable3.setStackTrace(arrayList.toArray(new StackTraceElement[0]));
        }
        return throwable3;
    }
}

