/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.SearchAdRequestParcel;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.AutoClickProtectionConfigurationParcel;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzit;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzjd;
import com.google.android.gms.internal.zzkf;
import com.google.android.gms.internal.zzkh;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzir
public final class zziu {
    private static final SimpleDateFormat zzcep = new SimpleDateFormat("yyyyMMdd", Locale.US);

    @Nullable
    public static JSONObject zza(Context context, AdRequestInfoParcel adRequestInfoParcel, zziz zziz2, zzjd.zza zza2, Location location, zzcv zzcv2, String string2, List<String> list, Bundle bundle, String string3) {
        try {
            CharSequence charSequence;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (list.size() > 0) {
                hashMap.put("eid", TextUtils.join((CharSequence)",", list));
            }
            if (adRequestInfoParcel.zzcau != null) {
                hashMap.put("ad_pos", adRequestInfoParcel.zzcau);
            }
            zziu.zza(hashMap, adRequestInfoParcel.zzcav);
            hashMap.put("format", adRequestInfoParcel.zzaoy.zzaup);
            if (adRequestInfoParcel.zzaoy.width == -1) {
                hashMap.put("smart_w", "full");
            }
            if (adRequestInfoParcel.zzaoy.height == -2) {
                hashMap.put("smart_h", "auto");
            }
            if (adRequestInfoParcel.zzaoy.zzaut) {
                hashMap.put("fluid", "height");
            }
            if (adRequestInfoParcel.zzaoy.zzaur != null) {
                charSequence = new StringBuilder();
                for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzaoy.zzaur) {
                    if (charSequence.length() != 0) {
                        charSequence.append("|");
                    }
                    charSequence.append(adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / zziz2.zzcbh) : adSizeParcel.width);
                    charSequence.append("x");
                    charSequence.append(adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / zziz2.zzcbh) : adSizeParcel.height);
                }
                hashMap.put("sz", charSequence);
            }
            if (adRequestInfoParcel.zzcbb != 0) {
                hashMap.put("native_version", adRequestInfoParcel.zzcbb);
                if (!adRequestInfoParcel.zzaoy.zzauu) {
                    hashMap.put("native_templates", adRequestInfoParcel.zzapq);
                    hashMap.put("native_image_orientation", zziu.zzc(adRequestInfoParcel.zzapm));
                    if (!adRequestInfoParcel.zzcbm.isEmpty()) {
                        hashMap.put("native_custom_templates", adRequestInfoParcel.zzcbm);
                    }
                }
            }
            hashMap.put("slotname", adRequestInfoParcel.zzaos);
            hashMap.put("pn", adRequestInfoParcel.applicationInfo.packageName);
            if (adRequestInfoParcel.zzcaw != null) {
                hashMap.put("vc", adRequestInfoParcel.zzcaw.versionCode);
            }
            hashMap.put("ms", string2);
            hashMap.put("seq_num", adRequestInfoParcel.zzcay);
            hashMap.put("session_id", adRequestInfoParcel.zzcaz);
            hashMap.put("js", adRequestInfoParcel.zzaou.zzcs);
            zziu.zza(hashMap, zziz2, zza2, adRequestInfoParcel.zzcbz);
            zziu.zza(hashMap, string3);
            hashMap.put("platform", Build.MANUFACTURER);
            hashMap.put("submodel", Build.MODEL);
            if (location != null) {
                zziu.zza(hashMap, location);
            } else if (adRequestInfoParcel.zzcav.versionCode >= 2 && adRequestInfoParcel.zzcav.zzats != null) {
                zziu.zza(hashMap, adRequestInfoParcel.zzcav.zzats);
            }
            if (adRequestInfoParcel.versionCode >= 2) {
                hashMap.put("quality_signals", adRequestInfoParcel.zzcba);
            }
            if (adRequestInfoParcel.versionCode >= 4 && adRequestInfoParcel.zzcbd) {
                hashMap.put("forceHttps", adRequestInfoParcel.zzcbd);
            }
            if (bundle != null) {
                hashMap.put("content_info", bundle);
            }
            if (adRequestInfoParcel.versionCode >= 5) {
                hashMap.put("u_sd", Float.valueOf(adRequestInfoParcel.zzcbh));
                hashMap.put("sh", adRequestInfoParcel.zzcbg);
                hashMap.put("sw", adRequestInfoParcel.zzcbf);
            } else {
                hashMap.put("u_sd", Float.valueOf(zziz2.zzcbh));
                hashMap.put("sh", zziz2.zzcbg);
                hashMap.put("sw", zziz2.zzcbf);
            }
            if (adRequestInfoParcel.versionCode >= 6) {
                if (!TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzcbi)) {
                    try {
                        hashMap.put("view_hierarchy", new JSONObject(adRequestInfoParcel.zzcbi));
                    }
                    catch (JSONException jSONException) {
                        zzkh.zzd((String)"Problem serializing view hierarchy to JSON", (Throwable)jSONException);
                    }
                }
                hashMap.put("correlation_id", adRequestInfoParcel.zzcbj);
            }
            if (adRequestInfoParcel.versionCode >= 7) {
                hashMap.put("request_id", adRequestInfoParcel.zzcbk);
            }
            if (adRequestInfoParcel.versionCode >= 11 && adRequestInfoParcel.zzcbo != null) {
                hashMap.put("capability", adRequestInfoParcel.zzcbo.toBundle());
            }
            if (adRequestInfoParcel.versionCode >= 12 && !TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzcbp)) {
                hashMap.put("anchor", adRequestInfoParcel.zzcbp);
            }
            if (adRequestInfoParcel.versionCode >= 13) {
                hashMap.put("android_app_volume", Float.valueOf(adRequestInfoParcel.zzcbq));
            }
            if (adRequestInfoParcel.versionCode >= 18) {
                hashMap.put("android_app_muted", adRequestInfoParcel.zzcbw);
            }
            if (adRequestInfoParcel.versionCode >= 14 && adRequestInfoParcel.zzcbr > 0) {
                hashMap.put("target_api", adRequestInfoParcel.zzcbr);
            }
            if (adRequestInfoParcel.versionCode >= 15) {
                hashMap.put("scroll_index", adRequestInfoParcel.zzcbs == -1 ? -1 : adRequestInfoParcel.zzcbs);
            }
            if (adRequestInfoParcel.versionCode >= 16) {
                hashMap.put("_activity_context", adRequestInfoParcel.zzcbt);
            }
            if (adRequestInfoParcel.versionCode >= 18) {
                if (!TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzcbx)) {
                    try {
                        hashMap.put("app_settings", new JSONObject(adRequestInfoParcel.zzcbx));
                    }
                    catch (JSONException jSONException) {
                        zzkh.zzd((String)"Problem creating json from app settings", (Throwable)jSONException);
                    }
                }
                hashMap.put("render_in_browser", adRequestInfoParcel.zzbnu);
            }
            if (adRequestInfoParcel.versionCode >= 18) {
                hashMap.put("android_num_video_cache_tasks", adRequestInfoParcel.zzcby);
            }
            if (zzkh.zzaz((int)2)) {
                charSequence = zzu.zzfq().zzam(hashMap).toString(2);
                String string4 = String.valueOf(charSequence);
                zzkh.v(string4.length() != 0 ? "Ad Request JSON: ".concat(string4) : new String("Ad Request JSON: "));
            }
            return zzu.zzfq().zzam(hashMap);
        }
        catch (JSONException jSONException) {
            String string5 = String.valueOf(jSONException.getMessage());
            zzkh.zzcy((String)(string5.length() != 0 ? "Problem serializing ad request to JSON: ".concat(string5) : new String("Problem serializing ad request to JSON: ")));
            return null;
        }
    }

    private static void zza(HashMap<String, Object> hashMap, String string2) {
        Bundle bundle = new Bundle();
        bundle.putString("doritos", string2);
        hashMap.put("pii", bundle);
    }

    private static void zza(HashMap<String, Object> hashMap, AdRequestParcel adRequestParcel) {
        String string2 = zzkf.zzsz();
        if (string2 != null) {
            hashMap.put("abf", string2);
        }
        if (adRequestParcel.zzatk != -1L) {
            hashMap.put("cust_age", zzcep.format(new Date(adRequestParcel.zzatk)));
        }
        if (adRequestParcel.extras != null) {
            hashMap.put("extras", adRequestParcel.extras);
        }
        if (adRequestParcel.zzatl != -1) {
            hashMap.put("cust_gender", adRequestParcel.zzatl);
        }
        if (adRequestParcel.zzatm != null) {
            hashMap.put("kw", adRequestParcel.zzatm);
        }
        if (adRequestParcel.zzato != -1) {
            hashMap.put("tag_for_child_directed_treatment", adRequestParcel.zzato);
        }
        if (adRequestParcel.zzatn) {
            hashMap.put("adtest", "on");
        }
        if (adRequestParcel.versionCode >= 2) {
            if (adRequestParcel.zzatp) {
                hashMap.put("d_imp_hdr", 1);
            }
            if (!TextUtils.isEmpty((CharSequence)adRequestParcel.zzatq)) {
                hashMap.put("ppid", adRequestParcel.zzatq);
            }
            if (adRequestParcel.zzatr != null) {
                zziu.zza(hashMap, adRequestParcel.zzatr);
            }
        }
        if (adRequestParcel.versionCode >= 3 && adRequestParcel.zzatt != null) {
            hashMap.put("url", adRequestParcel.zzatt);
        }
        if (adRequestParcel.versionCode >= 5) {
            if (adRequestParcel.zzatv != null) {
                hashMap.put("custom_targeting", adRequestParcel.zzatv);
            }
            if (adRequestParcel.zzatw != null) {
                hashMap.put("category_exclusions", adRequestParcel.zzatw);
            }
            if (adRequestParcel.zzatx != null) {
                hashMap.put("request_agent", adRequestParcel.zzatx);
            }
        }
        if (adRequestParcel.versionCode >= 6 && adRequestParcel.zzaty != null) {
            hashMap.put("request_pkg", adRequestParcel.zzaty);
        }
        if (adRequestParcel.versionCode >= 7) {
            hashMap.put("is_designed_for_families", adRequestParcel.zzatz);
        }
    }

    private static void zza(HashMap<String, Object> hashMap, zziz zziz2, zzjd.zza zza2, Bundle bundle) {
        Bundle bundle2;
        hashMap.put("am", zziz2.zzcgh);
        hashMap.put("cog", zziu.zzab(zziz2.zzcgi));
        hashMap.put("coh", zziu.zzab(zziz2.zzcgj));
        if (!TextUtils.isEmpty((CharSequence)zziz2.zzcgk)) {
            hashMap.put("carrier", zziz2.zzcgk);
        }
        hashMap.put("gl", zziz2.zzcgl);
        if (zziz2.zzcgm) {
            hashMap.put("simulator", 1);
        }
        if (zziz2.zzcgn) {
            hashMap.put("is_sidewinder", 1);
        }
        hashMap.put("ma", zziu.zzab(zziz2.zzcgo));
        hashMap.put("sp", zziu.zzab(zziz2.zzcgp));
        hashMap.put("hl", zziz2.zzcgq);
        if (!TextUtils.isEmpty((CharSequence)zziz2.zzcgr)) {
            hashMap.put("mv", zziz2.zzcgr);
        }
        hashMap.put("muv", zziz2.zzcgs);
        if (zziz2.zzcgt != -2) {
            hashMap.put("cnt", zziz2.zzcgt);
        }
        hashMap.put("gnt", zziz2.zzcgu);
        hashMap.put("pt", zziz2.zzcgv);
        hashMap.put("rm", zziz2.zzcgw);
        hashMap.put("riv", zziz2.zzcgx);
        Bundle bundle3 = new Bundle();
        bundle3.putString("build", zziz2.zzchc);
        Bundle bundle4 = new Bundle();
        bundle4.putBoolean("is_charging", zziz2.zzcgz);
        bundle4.putDouble("battery_level", zziz2.zzcgy);
        bundle3.putBundle("battery", bundle4);
        Bundle bundle5 = new Bundle();
        bundle5.putInt("active_network_state", zziz2.zzchb);
        bundle5.putBoolean("active_network_metered", zziz2.zzcha);
        if (zza2 != null) {
            bundle2 = new Bundle();
            bundle2.putInt("predicted_latency_micros", 0);
            bundle2.putLong("predicted_down_throughput_bps", 0L);
            bundle2.putLong("predicted_up_throughput_bps", 0L);
            bundle5.putBundle("predictions", bundle2);
        }
        bundle3.putBundle("network", bundle5);
        bundle2 = new Bundle();
        bundle2.putBoolean("is_browser_custom_tabs_capable", zziz2.zzchd);
        bundle3.putBundle("browser", bundle2);
        if (bundle != null) {
            bundle3.putBundle("android_mem_info", zziu.zzf(bundle));
        }
        hashMap.put("device", bundle3);
    }

    private static Bundle zzf(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        bundle2.putString("runtime_free", Long.toString(bundle.getLong("runtime_free_memory", -1L)));
        bundle2.putString("runtime_max", Long.toString(bundle.getLong("runtime_max_memory", -1L)));
        bundle2.putString("runtime_total", Long.toString(bundle.getLong("runtime_total_memory", -1L)));
        Debug.MemoryInfo memoryInfo = (Debug.MemoryInfo)bundle.getParcelable("debug_memory_info");
        if (memoryInfo != null) {
            bundle2.putString("debug_info_dalvik_private_dirty", Integer.toString(memoryInfo.dalvikPrivateDirty));
            bundle2.putString("debug_info_dalvik_pss", Integer.toString(memoryInfo.dalvikPss));
            bundle2.putString("debug_info_dalvik_shared_dirty", Integer.toString(memoryInfo.dalvikSharedDirty));
            bundle2.putString("debug_info_native_private_dirty", Integer.toString(memoryInfo.nativePrivateDirty));
            bundle2.putString("debug_info_native_pss", Integer.toString(memoryInfo.nativePss));
            bundle2.putString("debug_info_native_shared_dirty", Integer.toString(memoryInfo.nativeSharedDirty));
            bundle2.putString("debug_info_other_private_dirty", Integer.toString(memoryInfo.otherPrivateDirty));
            bundle2.putString("debug_info_other_pss", Integer.toString(memoryInfo.otherPss));
            bundle2.putString("debug_info_other_shared_dirty", Integer.toString(memoryInfo.otherSharedDirty));
        }
        return bundle2;
    }

    private static void zza(HashMap<String, Object> hashMap, Location location) {
        HashMap<String, Number> hashMap2 = new HashMap<String, Number>();
        Float f = Float.valueOf(location.getAccuracy() * 1000.0f);
        Long l = location.getTime() * 1000L;
        Long l2 = (long)(location.getLatitude() * 1.0E7);
        Long l3 = (long)(location.getLongitude() * 1.0E7);
        hashMap2.put("radius", f);
        hashMap2.put("lat", l2);
        hashMap2.put("long", l3);
        hashMap2.put("time", l);
        hashMap.put("uule", hashMap2);
    }

    private static void zza(HashMap<String, Object> hashMap, SearchAdRequestParcel searchAdRequestParcel) {
        String string2;
        String string3;
        if (Color.alpha((int)searchAdRequestParcel.zzawx) != 0) {
            hashMap.put("acolor", zziu.zzau(searchAdRequestParcel.zzawx));
        }
        if (Color.alpha((int)searchAdRequestParcel.backgroundColor) != 0) {
            hashMap.put("bgcolor", zziu.zzau(searchAdRequestParcel.backgroundColor));
        }
        if (Color.alpha((int)searchAdRequestParcel.zzawy) != 0 && Color.alpha((int)searchAdRequestParcel.zzawz) != 0) {
            hashMap.put("gradientto", zziu.zzau(searchAdRequestParcel.zzawy));
            hashMap.put("gradientfrom", zziu.zzau(searchAdRequestParcel.zzawz));
        }
        if (Color.alpha((int)searchAdRequestParcel.zzaxa) != 0) {
            hashMap.put("bcolor", zziu.zzau(searchAdRequestParcel.zzaxa));
        }
        hashMap.put("bthick", Integer.toString(searchAdRequestParcel.zzaxb));
        switch (searchAdRequestParcel.zzaxc) {
            case 0: {
                string3 = "none";
                break;
            }
            case 1: {
                string3 = "dashed";
                break;
            }
            case 2: {
                string3 = "dotted";
                break;
            }
            case 3: {
                string3 = "solid";
                break;
            }
            default: {
                string3 = null;
            }
        }
        if (string3 != null) {
            hashMap.put("btype", string3);
        }
        switch (searchAdRequestParcel.zzaxd) {
            case 2: {
                string2 = "dark";
                break;
            }
            case 0: {
                string2 = "light";
                break;
            }
            case 1: {
                string2 = "medium";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            hashMap.put("callbuttoncolor", string2);
        }
        if (searchAdRequestParcel.zzaxe != null) {
            hashMap.put("channel", searchAdRequestParcel.zzaxe);
        }
        if (Color.alpha((int)searchAdRequestParcel.zzaxf) != 0) {
            hashMap.put("dcolor", zziu.zzau(searchAdRequestParcel.zzaxf));
        }
        if (searchAdRequestParcel.zzaxg != null) {
            hashMap.put("font", searchAdRequestParcel.zzaxg);
        }
        if (Color.alpha((int)searchAdRequestParcel.zzaxh) != 0) {
            hashMap.put("hcolor", zziu.zzau(searchAdRequestParcel.zzaxh));
        }
        hashMap.put("headersize", Integer.toString(searchAdRequestParcel.zzaxi));
        if (searchAdRequestParcel.zzaxj != null) {
            hashMap.put("q", searchAdRequestParcel.zzaxj);
        }
    }

    private static Integer zzab(boolean bl) {
        return bl ? 1 : 0;
    }

    private static String zzau(int n) {
        return String.format(Locale.US, "#%06x", n & 0xFFFFFF);
    }

    private static String zzc(NativeAdOptionsParcel nativeAdOptionsParcel) {
        int n = nativeAdOptionsParcel != null ? nativeAdOptionsParcel.zzbgu : 0;
        switch (n) {
            case 1: {
                return "portrait";
            }
            case 2: {
                return "landscape";
            }
        }
        return "any";
    }

    public static AdResponseParcel zza(Context context, AdRequestInfoParcel adRequestInfoParcel, String string2) {
        try {
            List<String> list;
            List<String> list2;
            List<String> list3;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("ad_base_url", null);
            String string4 = jSONObject.optString("ad_url", null);
            String string5 = jSONObject.optString("ad_size", null);
            String string6 = jSONObject.optString("ad_slot_size", string5);
            boolean bl = adRequestInfoParcel != null && adRequestInfoParcel.zzcbb != 0;
            String string7 = jSONObject.optString("ad_json", null);
            if (string7 == null) {
                string7 = jSONObject.optString("ad_html", null);
            }
            if (string7 == null) {
                string7 = jSONObject.optString("body", null);
            }
            long l = -1L;
            String string8 = jSONObject.optString("debug_dialog", null);
            long l2 = jSONObject.has("interstitial_timeout") ? (long)(jSONObject.getDouble("interstitial_timeout") * 1000.0) : -1L;
            String string9 = jSONObject.optString("orientation", null);
            int n = -1;
            if ("portrait".equals(string9)) {
                n = zzu.zzfs().zztl();
            } else if ("landscape".equals(string9)) {
                n = zzu.zzfs().zztk();
            }
            AdResponseParcel adResponseParcel = null;
            if (TextUtils.isEmpty((CharSequence)string7) && !TextUtils.isEmpty((CharSequence)string4)) {
                adResponseParcel = zzit.zza(adRequestInfoParcel, context, adRequestInfoParcel.zzaou.zzcs, string4, null, null, null, null);
                string3 = adResponseParcel.zzbts;
                string7 = adResponseParcel.body;
                l = adResponseParcel.zzccg;
            }
            if (string7 == null) {
                return new AdResponseParcel(0);
            }
            JSONArray jSONArray = jSONObject.optJSONArray("click_urls");
            List<String> list4 = list3 = adResponseParcel == null ? null : adResponseParcel.zzbnq;
            if (jSONArray != null) {
                list3 = zziu.zza(jSONArray, list3);
            }
            JSONArray jSONArray2 = jSONObject.optJSONArray("impression_urls");
            List<String> list5 = list2 = adResponseParcel == null ? null : adResponseParcel.zzbnr;
            if (jSONArray2 != null) {
                list2 = zziu.zza(jSONArray2, list2);
            }
            JSONArray jSONArray3 = jSONObject.optJSONArray("manual_impression_urls");
            List<String> list6 = list = adResponseParcel == null ? null : adResponseParcel.zzcce;
            if (jSONArray3 != null) {
                list = zziu.zza(jSONArray3, list);
            }
            if (adResponseParcel != null) {
                if (adResponseParcel.orientation != -1) {
                    n = adResponseParcel.orientation;
                }
                if (adResponseParcel.zzccb > 0L) {
                    l2 = adResponseParcel.zzccb;
                }
            }
            String string10 = jSONObject.optString("active_view");
            String string11 = null;
            boolean bl2 = jSONObject.optBoolean("ad_is_javascript", false);
            if (bl2) {
                string11 = jSONObject.optString("ad_passback_url", null);
            }
            boolean bl3 = jSONObject.optBoolean("mediation", false);
            boolean bl4 = jSONObject.optBoolean("custom_render_allowed", false);
            boolean bl5 = jSONObject.optBoolean("content_url_opted_out", true);
            boolean bl6 = jSONObject.optBoolean("prefetch", false);
            long l3 = jSONObject.optLong("refresh_interval_milliseconds", -1L);
            long l4 = jSONObject.optLong("mediation_config_cache_time_milliseconds", -1L);
            String string12 = jSONObject.optString("gws_query_id", "");
            boolean bl7 = "height".equals(jSONObject.optString("fluid", ""));
            boolean bl8 = jSONObject.optBoolean("native_express", false);
            List<String> list7 = zziu.zza(jSONObject.optJSONArray("video_start_urls"), null);
            List<String> list8 = zziu.zza(jSONObject.optJSONArray("video_complete_urls"), null);
            RewardItemParcel rewardItemParcel = RewardItemParcel.zza((JSONArray)jSONObject.optJSONArray("rewards"));
            boolean bl9 = jSONObject.optBoolean("use_displayed_impression", false);
            AutoClickProtectionConfigurationParcel autoClickProtectionConfigurationParcel = AutoClickProtectionConfigurationParcel.zzh(jSONObject.optJSONObject("auto_protection_configuration"));
            String string13 = jSONObject.optString("set_cookie", "");
            List<String> list9 = zziu.zza(jSONObject.optJSONArray("remote_ping_urls"), null);
            String string14 = jSONObject.optString("safe_browsing");
            boolean bl10 = jSONObject.optBoolean("render_in_browser", adRequestInfoParcel.zzbnu);
            return new AdResponseParcel(adRequestInfoParcel, string3, string7, list3, list2, l2, bl3, l4, list, l3, n, string5, l, string8, bl2, string11, string10, bl4, bl, adRequestInfoParcel.zzcbd, bl5, bl6, string12, bl7, bl8, rewardItemParcel, list7, list8, bl9, autoClickProtectionConfigurationParcel, adRequestInfoParcel.zzcbu, string13, list9, string14, bl10, string6);
        }
        catch (JSONException jSONException) {
            String string15 = String.valueOf(jSONException.getMessage());
            zzkh.zzcy((String)(string15.length() != 0 ? "Could not parse the inline ad response: ".concat(string15) : new String("Could not parse the inline ad response: ")));
            return new AdResponseParcel(0);
        }
    }

    @Nullable
    private static List<String> zza(@Nullable JSONArray jSONArray, @Nullable List<String> list) throws JSONException {
        if (jSONArray == null) {
            return null;
        }
        if (list == null) {
            list = new LinkedList<String>();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            list.add(jSONArray.getString(i));
        }
        return list;
    }

    public static JSONObject zzc(AdResponseParcel adResponseParcel) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (adResponseParcel.zzbts != null) {
            jSONObject.put("ad_base_url", (Object)adResponseParcel.zzbts);
        }
        if (adResponseParcel.zzccf != null) {
            jSONObject.put("ad_size", (Object)adResponseParcel.zzccf);
        }
        jSONObject.put("native", adResponseParcel.zzaus);
        if (adResponseParcel.zzaus) {
            jSONObject.put("ad_json", (Object)adResponseParcel.body);
        } else {
            jSONObject.put("ad_html", (Object)adResponseParcel.body);
        }
        if (adResponseParcel.zzcch != null) {
            jSONObject.put("debug_dialog", (Object)adResponseParcel.zzcch);
        }
        if (adResponseParcel.zzccb != -1L) {
            jSONObject.put("interstitial_timeout", (double)adResponseParcel.zzccb / 1000.0);
        }
        if (adResponseParcel.orientation == zzu.zzfs().zztl()) {
            jSONObject.put("orientation", (Object)"portrait");
        } else if (adResponseParcel.orientation == zzu.zzfs().zztk()) {
            jSONObject.put("orientation", (Object)"landscape");
        }
        if (adResponseParcel.zzbnq != null) {
            jSONObject.put("click_urls", (Object)zziu.zzk(adResponseParcel.zzbnq));
        }
        if (adResponseParcel.zzbnr != null) {
            jSONObject.put("impression_urls", (Object)zziu.zzk(adResponseParcel.zzbnr));
        }
        if (adResponseParcel.zzcce != null) {
            jSONObject.put("manual_impression_urls", (Object)zziu.zzk(adResponseParcel.zzcce));
        }
        if (adResponseParcel.zzcck != null) {
            jSONObject.put("active_view", (Object)adResponseParcel.zzcck);
        }
        jSONObject.put("ad_is_javascript", adResponseParcel.zzcci);
        if (adResponseParcel.zzccj != null) {
            jSONObject.put("ad_passback_url", (Object)adResponseParcel.zzccj);
        }
        jSONObject.put("mediation", adResponseParcel.zzccc);
        jSONObject.put("custom_render_allowed", adResponseParcel.zzccl);
        jSONObject.put("content_url_opted_out", adResponseParcel.zzccm);
        jSONObject.put("prefetch", adResponseParcel.zzccn);
        if (adResponseParcel.zzbnw != -1L) {
            jSONObject.put("refresh_interval_milliseconds", adResponseParcel.zzbnw);
        }
        if (adResponseParcel.zzccd != -1L) {
            jSONObject.put("mediation_config_cache_time_milliseconds", adResponseParcel.zzccd);
        }
        if (!TextUtils.isEmpty((CharSequence)adResponseParcel.zzccq)) {
            jSONObject.put("gws_query_id", (Object)adResponseParcel.zzccq);
        }
        jSONObject.put("fluid", (Object)(adResponseParcel.zzaut ? "height" : ""));
        jSONObject.put("native_express", adResponseParcel.zzauu);
        if (adResponseParcel.zzccs != null) {
            jSONObject.put("video_start_urls", (Object)zziu.zzk(adResponseParcel.zzccs));
        }
        if (adResponseParcel.zzcct != null) {
            jSONObject.put("video_complete_urls", (Object)zziu.zzk(adResponseParcel.zzcct));
        }
        if (adResponseParcel.zzccr != null) {
            jSONObject.put("rewards", (Object)adResponseParcel.zzccr.zzrx());
        }
        jSONObject.put("use_displayed_impression", adResponseParcel.zzccu);
        jSONObject.put("auto_protection_configuration", (Object)adResponseParcel.zzccv);
        jSONObject.put("render_in_browser", adResponseParcel.zzbnu);
        return jSONObject;
    }

    @Nullable
    static JSONArray zzk(List<String> list) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (String string2 : list) {
            jSONArray.put((Object)string2);
        }
        return jSONArray;
    }
}

