/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.internal.zzdq;
import com.google.android.gms.internal.zzir;
import java.util.Locale;

@zzir
public final class zziz {
    public final int zzcgh;
    public final boolean zzcgi;
    public final boolean zzcgj;
    public final String zzcgk;
    public final String zzcgl;
    public final boolean zzcgm;
    public final boolean zzcgn;
    public final boolean zzcgo;
    public final boolean zzcgp;
    public final String zzcgq;
    public final String zzcgr;
    public final int zzcgs;
    public final int zzcgt;
    public final int zzcgu;
    public final int zzcgv;
    public final int zzcgw;
    public final int zzcgx;
    public final float zzcbh;
    public final int zzcbf;
    public final int zzcbg;
    public final double zzcgy;
    public final boolean zzcgz;
    public final boolean zzcha;
    public final int zzchb;
    public final String zzchc;
    public final boolean zzchd;

    zziz(int n, boolean bl, boolean bl2, String string2, String string3, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string4, String string5, int n2, int n3, int n4, int n5, int n6, int n7, float f, int n8, int n9, double d, boolean bl7, boolean bl8, int n10, String string6, boolean bl9) {
        this.zzcgh = n;
        this.zzcgi = bl;
        this.zzcgj = bl2;
        this.zzcgk = string2;
        this.zzcgl = string3;
        this.zzcgm = bl3;
        this.zzcgn = bl4;
        this.zzcgo = bl5;
        this.zzcgp = bl6;
        this.zzcgq = string4;
        this.zzcgr = string5;
        this.zzcgs = n2;
        this.zzcgt = n3;
        this.zzcgu = n4;
        this.zzcgv = n5;
        this.zzcgw = n6;
        this.zzcgx = n7;
        this.zzcbh = f;
        this.zzcbf = n8;
        this.zzcbg = n9;
        this.zzcgy = d;
        this.zzcgz = bl7;
        this.zzcha = bl8;
        this.zzchb = n10;
        this.zzchc = string6;
        this.zzchd = bl9;
    }

    public static final class zza {
        private int zzcgh;
        private boolean zzcgo;
        private boolean zzcgp;
        private int zzcgs;
        private int zzcgw;
        private int zzcgx;
        private String zzcgk;
        private int zzcgt;
        private int zzcgu;
        private int zzcgv;
        private boolean zzcha;
        private int zzchb;
        private double zzcgy;
        private boolean zzcgz;
        private String zzchc;
        private boolean zzcgi;
        private boolean zzcgj;
        private String zzcgl;
        private boolean zzcgm;
        private boolean zzcgn;
        private String zzcgq;
        private String zzcgr;
        private float zzcbh;
        private int zzcbf;
        private int zzcbg;
        private boolean zzchd;

        public zza(Context context) {
            PackageManager packageManager = context.getPackageManager();
            this.zzv(context);
            this.zza(context, packageManager);
            this.zzw(context);
            Locale locale = Locale.getDefault();
            this.zzcgi = zza.zza(packageManager, "geo:0,0?q=donuts") != null;
            this.zzcgj = zza.zza(packageManager, "http://www.google.com") != null;
            this.zzcgl = locale.getCountry();
            this.zzcgm = zzm.zziw().zztx();
            this.zzcgn = zzi.zzcl((Context)context);
            this.zzcgq = locale.getLanguage();
            this.zzcgr = zza.zza(packageManager);
            Resources resources = context.getResources();
            if (resources == null) {
                return;
            }
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            if (displayMetrics == null) {
                return;
            }
            this.zzcbh = displayMetrics.density;
            this.zzcbf = displayMetrics.widthPixels;
            this.zzcbg = displayMetrics.heightPixels;
        }

        public zza(Context context, zziz zziz2) {
            PackageManager packageManager = context.getPackageManager();
            this.zzv(context);
            this.zza(context, packageManager);
            this.zzw(context);
            this.zzx(context);
            this.zzcgi = zziz2.zzcgi;
            this.zzcgj = zziz2.zzcgj;
            this.zzcgl = zziz2.zzcgl;
            this.zzcgm = zziz2.zzcgm;
            this.zzcgn = zziz2.zzcgn;
            this.zzcgq = zziz2.zzcgq;
            this.zzcgr = zziz2.zzcgr;
            this.zzcbh = zziz2.zzcbh;
            this.zzcbf = zziz2.zzcbf;
            this.zzcbg = zziz2.zzcbg;
        }

        private void zzv(Context context) {
            AudioManager audioManager = zzu.zzfq().zzak(context);
            if (audioManager != null) {
                try {
                    this.zzcgh = audioManager.getMode();
                    this.zzcgo = audioManager.isMusicActive();
                    this.zzcgp = audioManager.isSpeakerphoneOn();
                    this.zzcgs = audioManager.getStreamVolume(3);
                    this.zzcgw = audioManager.getRingerMode();
                    this.zzcgx = audioManager.getStreamVolume(2);
                    return;
                }
                catch (Throwable throwable) {
                    zzu.zzft().zzb(throwable, true);
                }
            }
            this.zzcgh = -2;
            this.zzcgo = false;
            this.zzcgp = false;
            this.zzcgs = 0;
            this.zzcgw = 0;
            this.zzcgx = 0;
        }

        @TargetApi(value=16)
        private void zza(Context context, PackageManager packageManager) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            this.zzcgk = telephonyManager.getNetworkOperator();
            this.zzcgu = telephonyManager.getNetworkType();
            this.zzcgv = telephonyManager.getPhoneType();
            this.zzcgt = -2;
            this.zzcha = false;
            this.zzchb = -1;
            if (zzu.zzfq().zza(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null) {
                    this.zzcgt = networkInfo.getType();
                    this.zzchb = networkInfo.getDetailedState().ordinal();
                } else {
                    this.zzcgt = -1;
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    this.zzcha = connectivityManager.isActiveNetworkMetered();
                }
            }
        }

        private void zzw(Context context) {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent intent = context.registerReceiver(null, intentFilter);
            if (intent != null) {
                int n = intent.getIntExtra("status", -1);
                int n2 = intent.getIntExtra("level", -1);
                int n3 = intent.getIntExtra("scale", -1);
                this.zzcgy = (float)n2 / (float)n3;
                this.zzcgz = n == 2 || n == 5;
            } else {
                this.zzcgy = -1.0;
                this.zzcgz = false;
            }
        }

        private void zzx(Context context) {
            this.zzchc = Build.FINGERPRINT;
            this.zzchd = zzdq.zzo(context);
        }

        private static String zza(PackageManager packageManager) {
            ResolveInfo resolveInfo = zza.zza(packageManager, "market://details?id=com.google.android.gms.ads");
            if (resolveInfo == null) {
                return null;
            }
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null) {
                return null;
            }
            try {
                String string2;
                PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
                if (packageInfo != null) {
                    int n = packageInfo.versionCode;
                    String string3 = String.valueOf(activityInfo.packageName);
                    string2 = new StringBuilder(12 + String.valueOf(string3).length()).append(n).append(".").append(string3).toString();
                } else {
                    string2 = null;
                }
                return string2;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
        }

        private static ResolveInfo zza(PackageManager packageManager, String string2) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }

        public zziz zzro() {
            return new zziz(this.zzcgh, this.zzcgi, this.zzcgj, this.zzcgk, this.zzcgl, this.zzcgm, this.zzcgn, this.zzcgo, this.zzcgp, this.zzcgq, this.zzcgr, this.zzcgs, this.zzcgt, this.zzcgu, this.zzcgv, this.zzcgw, this.zzcgx, this.zzcbh, this.zzcbf, this.zzcbg, this.zzcgy, this.zzcgz, this.zzcha, this.zzchb, this.zzchc, this.zzchd);
        }
    }
}

