/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.PopupWindow;
import com.google.android.gms.ads.internal.ClientApi;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zza;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzaph;
import com.google.android.gms.internal.zzas;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzdq;
import com.google.android.gms.internal.zzfw;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzki;
import com.google.android.gms.internal.zzku;
import com.google.android.gms.internal.zzll;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzir
public class zzkl {
    public static final Handler zzclg = new zzki(Looper.getMainLooper());
    private final Object zzail = new Object();
    private boolean zzclh = true;
    private String zzbjj;
    private boolean zzcli = false;
    private zzfw zzcee;

    public void zza(Context context, String string, boolean bl, HttpURLConnection httpURLConnection) {
        this.zza(context, string, bl, httpURLConnection, false);
    }

    public void zza(Context context, String string, boolean bl, HttpURLConnection httpURLConnection, boolean bl2) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(bl);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.setRequestProperty("User-Agent", this.zzh(context, string));
        httpURLConnection.setUseCaches(bl2);
    }

    public boolean zzac(Context context) {
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.AdActivity");
        PackageManager packageManager = context.getPackageManager();
        ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
        boolean bl = true;
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            zzkh.zzcy((String)"Could not find com.google.android.gms.ads.AdActivity, please make sure it is declared in AndroidManifest.xml.");
            bl = false;
        } else {
            String string = "com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".";
            if ((resolveInfo.activityInfo.configChanges & 0x10) == 0) {
                zzkh.zzcy((String)String.format(string, "keyboard"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x20) == 0) {
                zzkh.zzcy((String)String.format(string, "keyboardHidden"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x80) == 0) {
                zzkh.zzcy((String)String.format(string, "orientation"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x100) == 0) {
                zzkh.zzcy((String)String.format(string, "screenLayout"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x200) == 0) {
                zzkh.zzcy((String)String.format(string, "uiMode"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x400) == 0) {
                zzkh.zzcy((String)String.format(string, "screenSize"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x800) == 0) {
                zzkh.zzcy((String)String.format(string, "smallestScreenSize"));
                bl = false;
            }
        }
        return bl;
    }

    public boolean zza(PackageManager packageManager, String string, String string2) {
        return packageManager.checkPermission(string2, string) == 0;
    }

    public boolean zztd() {
        return this.zzclh;
    }

    public void zza(Context context, String string, List<String> list) {
        for (String string2 : list) {
            Future cfr_ignored_0 = (Future)new zzku(context, string, string2).zzpz();
        }
    }

    public void zzc(Context context, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        this.zza(context, string, arrayList);
    }

    public void zza(List<String> list, String string) {
        for (String string2 : list) {
            Future cfr_ignored_0 = (Future)new zzku(string2, string).zzpz();
        }
    }

    public void zza(final Context context, final List<String> list) {
        if (!(context instanceof Activity)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzaph.zzeu((Context)((Activity)context)))) {
            return;
        }
        if (list == null) {
            zzkh.v("Cannot ping urls: empty list.");
            return;
        }
        if (!zzdq.zzo(context)) {
            zzkh.v("Cannot ping url because custom tabs is not supported");
            return;
        }
        final zzdq zzdq2 = new zzdq();
        zzdq.zza zza2 = new zzdq.zza(){

            @Override
            public void zzkn() {
                for (String string : list) {
                    String string2 = String.valueOf(string);
                    zzkh.zzcx((String)(string2.length() != 0 ? "Pinging url: ".concat(string2) : new String("Pinging url: ")));
                    Uri uri = Uri.parse((String)string);
                    zzdq2.mayLaunchUrl(uri, null, null);
                }
                zzdq2.zzd((Activity)context);
            }

            @Override
            public void zzko() {
            }
        };
        zzdq2.zza(zza2);
        zzdq2.zze((Activity)context);
    }

    public String zza(InputStreamReader inputStreamReader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(8192);
        char[] cArray = new char[2048];
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public boolean zzad(Context context) {
        if (this.zzcli) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zza(), intentFilter);
        this.zzcli = true;
        return true;
    }

    public void zza(Context context, String string, WebSettings webSettings) {
        webSettings.setUserAgentString(this.zzh(context, string));
    }

    String zzte() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuffer.append(" ").append(Build.VERSION.RELEASE);
        }
        stringBuffer.append("; ").append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuffer.append("; ").append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuffer.append(" Build/").append(Build.DISPLAY);
            }
        }
        stringBuffer.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzh(final Context context, String string) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzbjj != null) {
                return this.zzbjj;
            }
            try {
                this.zzbjj = zzu.zzfs().getDefaultUserAgent(context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (TextUtils.isEmpty((CharSequence)this.zzbjj)) {
                if (!zzm.zziw().zzty()) {
                    this.zzbjj = null;
                    zzclg.post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = zzkl.this.zzail;
                            synchronized (object) {
                                zzkl.this.zzbjj = zzkl.this.zzae(context);
                                zzkl.this.zzail.notifyAll();
                            }
                        }
                    });
                    while (this.zzbjj == null) {
                        try {
                            this.zzail.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.zzbjj = this.zzte();
                            String string2 = String.valueOf(this.zzbjj);
                            zzkh.zzcy((String)(string2.length() != 0 ? "Interrupted, use default user agent: ".concat(string2) : new String("Interrupted, use default user agent: ")));
                        }
                    }
                } else {
                    try {
                        this.zzbjj = this.zzae(context);
                    }
                    catch (Exception exception) {
                        this.zzbjj = this.zzte();
                    }
                }
            }
            String string3 = String.valueOf(this.zzbjj);
            this.zzbjj = new StringBuilder(11 + String.valueOf(string3).length() + String.valueOf(string).length()).append(string3).append(" (Mobile; ").append(string).append(")").toString();
            return this.zzbjj;
        }
    }

    protected String zzae(Context context) {
        return new WebView(context).getSettings().getUserAgentString();
    }

    public boolean zza(ClassLoader classLoader, Class<?> clazz, String string) {
        try {
            Class<?> clazz2 = Class.forName(string, false, classLoader);
            return clazz.isAssignableFrom(clazz2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public String zzcp(String string) {
        return Uri.parse((String)string).buildUpon().query(null).build().toString();
    }

    public JSONObject zzam(Map<String, ?> map) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string : map.keySet()) {
                this.zza(jSONObject, string, map.get(string));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            String string = String.valueOf(classCastException.getMessage());
            throw new JSONException(string.length() != 0 ? "Could not convert map to JSON: ".concat(string) : new String("Could not convert map to JSON: "));
        }
    }

    private JSONObject zzh(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string : bundle.keySet()) {
            this.zza(jSONObject, string, bundle.get(string));
        }
        return jSONObject;
    }

    private JSONArray zza(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : collection) {
            this.zza(jSONArray, obj);
        }
        return jSONArray;
    }

    JSONArray zza(Object[] objectArray) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object object : objectArray) {
            this.zza(jSONArray, object);
        }
        return jSONArray;
    }

    private void zza(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)this.zzh((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONArray.put((Object)this.zzam(map));
        } else if (object instanceof Collection) {
            jSONArray.put((Object)this.zza((Collection)object));
        } else if (object instanceof Object[]) {
            jSONArray.put((Object)this.zza((Object[])object));
        } else {
            jSONArray.put(object);
        }
    }

    private void zza(JSONObject jSONObject, String string, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string, (Object)this.zzh((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONObject.put(string, (Object)this.zzam(map));
        } else if (object instanceof Collection) {
            jSONObject.put(string != null ? string : "null", (Object)this.zza((Collection)object));
        } else if (object instanceof Object[]) {
            jSONObject.put(string, (Object)this.zza(Arrays.asList((Object[])object)));
        } else {
            jSONObject.put(string, object);
        }
    }

    public Map<String, String> zzf(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Set<String> set = zzu.zzfs().zzg(uri);
        for (String string : set) {
            hashMap.put(string, uri.getQueryParameter(string));
        }
        return hashMap;
    }

    public String zztf() {
        return UUID.randomUUID().toString();
    }

    public String zztg() {
        UUID uUID = UUID.randomUUID();
        byte[] byArray = BigInteger.valueOf(uUID.getLeastSignificantBits()).toByteArray();
        byte[] byArray2 = BigInteger.valueOf(uUID.getMostSignificantBits()).toByteArray();
        String string = new BigInteger(1, byArray).toString();
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(byArray);
                messageDigest.update(byArray2);
                byte[] byArray3 = new byte[8];
                System.arraycopy(messageDigest.digest(), 0, byArray3, 0, 8);
                string = new BigInteger(1, byArray3).toString();
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return string;
    }

    public int zzcq(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = String.valueOf(numberFormatException);
            zzkh.zzcy((String)new StringBuilder(22 + String.valueOf(string2).length()).append("Could not parse value:").append(string2).toString());
            return 0;
        }
    }

    public String zzth() {
        String string = Build.MODEL;
        String string2 = Build.MANUFACTURER;
        return string.startsWith(string2) ? string : new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(" ").append(string).toString();
    }

    protected int[] zzti() {
        return new int[]{0, 0};
    }

    public int[] zzh(Activity activity) {
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            return new int[]{view.getWidth(), view.getHeight()};
        }
        return this.zzti();
    }

    public int[] zzi(Activity activity) {
        int[] nArray = this.zzh(activity);
        return new int[]{zzm.zziw().zzb((Context)activity, nArray[0]), zzm.zziw().zzb((Context)activity, nArray[1])};
    }

    public int[] zzj(Activity activity) {
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            return new int[]{view.getTop(), view.getBottom()};
        }
        return this.zzti();
    }

    public int[] zzk(Activity activity) {
        int[] nArray = this.zzj(activity);
        return new int[]{zzm.zziw().zzb((Context)activity, nArray[0]), zzm.zziw().zzb((Context)activity, nArray[1])};
    }

    public boolean zzcr(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return string.matches("([^\\s]+(\\.(?i)(jpg|png|gif|bmp|webp))$)");
    }

    public void zza(Activity activity, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
        }
    }

    public void zza(Activity activity, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().addOnScrollChangedListener(onScrollChangedListener);
        }
    }

    public void zzb(Activity activity, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
        }
    }

    public DisplayMetrics zza(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Display display = windowManager.getDefaultDisplay();
        display.getMetrics(displayMetrics);
        return displayMetrics;
    }

    public AlertDialog.Builder zzaf(Context context) {
        return new AlertDialog.Builder(context);
    }

    public zzcu zzag(Context context) {
        return new zzcu(context);
    }

    public Bitmap zzk(View view) {
        view.setDrawingCacheEnabled(true);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        view.setDrawingCacheEnabled(false);
        return bitmap;
    }

    public PopupWindow zza(View view, int n, int n2, boolean bl) {
        return new PopupWindow(view, n, n2, bl);
    }

    public String zzah(Context context) {
        try {
            ActivityManager.RunningTaskInfo runningTaskInfo;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                return null;
            }
            List list = activityManager.getRunningTasks(1);
            if (list != null && !list.isEmpty() && (runningTaskInfo = (ActivityManager.RunningTaskInfo)list.get(0)) != null && runningTaskInfo.topActivity != null) {
                return runningTaskInfo.topActivity.getClassName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String zza(Context context, View view, AdSizeParcel adSizeParcel) {
        if (!zzdc.zzazv.get().booleanValue()) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("width", adSizeParcel.width);
            jSONObject2.put("height", adSizeParcel.height);
            jSONObject.put("size", (Object)jSONObject2);
            jSONObject.put("activity", (Object)this.zzah(context));
            if (!adSizeParcel.zzauq) {
                JSONArray jSONArray = new JSONArray();
                View view2 = view;
                while (view2 != null) {
                    ViewParent viewParent = view2.getParent();
                    if (viewParent != null) {
                        int n = -1;
                        if (viewParent instanceof ViewGroup) {
                            n = ((ViewGroup)viewParent).indexOfChild(view2);
                        }
                        JSONObject jSONObject3 = new JSONObject();
                        jSONObject3.put("type", (Object)viewParent.getClass().getName());
                        jSONObject3.put("index_of_child", n);
                        jSONArray.put((Object)jSONObject3);
                    }
                    if (viewParent != null && viewParent instanceof View) {
                        view2 = (View)viewParent;
                        continue;
                    }
                    view2 = null;
                }
                if (jSONArray.length() > 0) {
                    jSONObject.put("parents", (Object)jSONArray);
                }
            }
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzkh.zzd((String)"Fail to get view hierarchy json", (Throwable)jSONException);
            return null;
        }
    }

    public String zza(zzll zzll2, String string) {
        return this.zza(zzll2.getContext(), zzll2.zzum(), string);
    }

    public String zza(Context context, zzas zzas2, String string) {
        if (zzas2 == null) {
            return string;
        }
        try {
            Uri uri = Uri.parse((String)string);
            if (zzas2.zzd(uri)) {
                uri = zzas2.zzb(uri, context);
            }
            return uri.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public boolean zzai(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !this.zzj(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean zzj(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    public void zza(final Context context, final @Nullable String string, String string2, Bundle bundle, boolean bl) {
        if (bl) {
            bundle.putString("device", zzu.zzfq().zzth());
            bundle.putString("eids", TextUtils.join((CharSequence)",", zzdc.zzjx()));
        }
        zzm.zziw().zza(context, string, string2, bundle, bl, new zza.zza(){

            public void zzcs(String string2) {
                zzu.zzfq().zzc(context, string, string2);
            }
        });
    }

    public void zzb(Context context, String string, String string2, Bundle bundle, boolean bl) {
        if (zzdc.zzbas.get().booleanValue()) {
            this.zza(context, string, string2, bundle, bl);
        }
    }

    public void runOnUiThread(Runnable runnable) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            zzclg.post(runnable);
        }
    }

    private Bitmap zzl(@NonNull View view) {
        try {
            int n = view.getWidth();
            int n2 = view.getHeight();
            if (n == 0 || n2 == 0) {
                zzkh.zzcy((String)"Width or height of view is zero");
                return null;
            }
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            Canvas canvas = new Canvas(bitmap);
            view.layout(0, 0, n, n2);
            view.draw(canvas);
            return bitmap;
        }
        catch (RuntimeException runtimeException) {
            zzkh.zzb((String)"Fail to capture the webview", (Throwable)runtimeException);
            return null;
        }
    }

    private Bitmap zzm(@NonNull View view) {
        Bitmap bitmap = null;
        try {
            boolean bl = view.isDrawingCacheEnabled();
            view.setDrawingCacheEnabled(true);
            Bitmap bitmap2 = view.getDrawingCache();
            if (bitmap2 != null) {
                bitmap = Bitmap.createBitmap((Bitmap)bitmap2);
            }
            view.setDrawingCacheEnabled(bl);
        }
        catch (RuntimeException runtimeException) {
            zzkh.zzb((String)"Fail to capture the web view", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public Bitmap zzaj(Context context) {
        if (!(context instanceof Activity)) {
            return null;
        }
        Bitmap bitmap = null;
        try {
            if (zzdc.zzbbz.get().booleanValue()) {
                Window window = ((Activity)context).getWindow();
                if (window != null) {
                    View view = window.getDecorView().getRootView();
                    bitmap = this.zzm(view);
                }
            } else {
                bitmap = this.zzl(((Activity)context).getWindow().getDecorView());
            }
        }
        catch (RuntimeException runtimeException) {
            zzkh.zzb((String)"Fail to capture screen shot", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public void zzb(Context context, Intent intent) {
        try {
            context.startActivity(intent);
        }
        catch (Throwable throwable) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    public float zzey() {
        zzo zzo2 = zzu.zzgg().zzex();
        return zzo2 != null && zzo2.zzez() ? zzo2.zzey() : 1.0f;
    }

    public boolean zzfa() {
        zzo zzo2 = zzu.zzgg().zzex();
        return zzo2 != null ? zzo2.zzfa() : false;
    }

    public AudioManager zzak(Context context) {
        return (AudioManager)context.getSystemService("audio");
    }

    public float zzal(Context context) {
        AudioManager audioManager = this.zzak(context);
        if (audioManager == null) {
            return 0.0f;
        }
        int n = audioManager.getStreamMaxVolume(3);
        int n2 = audioManager.getStreamVolume(3);
        return n == 0 ? 0.0f : (float)n2 / (float)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzfw zzc(Context context, VersionInfoParcel versionInfoParcel) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzcee == null) {
                this.zzcee = new zzfw(context.getApplicationContext() != null ? context.getApplicationContext() : context, versionInfoParcel, zzdc.zzaxw.get());
            }
            return this.zzcee;
        }
    }

    public int zzam(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        return applicationInfo == null ? 0 : applicationInfo.targetSdkVersion;
    }

    public boolean zza(View view, Context context) {
        PowerManager powerManager = null;
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            powerManager = (PowerManager)context2.getSystemService("power");
        }
        KeyguardManager keyguardManager = null;
        Object object = context.getSystemService("keyguard");
        if (object != null && object instanceof KeyguardManager) {
            keyguardManager = (KeyguardManager)object;
        }
        return this.zza(view, powerManager, keyguardManager);
    }

    public boolean zza(View view, PowerManager powerManager, KeyguardManager keyguardManager) {
        boolean bl = zzu.zzfq().zztd() || !this.zza(keyguardManager);
        return view.getVisibility() == 0 && view.isShown() && this.zza(powerManager) && bl && (zzdc.zzbao.get() == false || view.getLocalVisibleRect(new Rect()) || view.getGlobalVisibleRect(new Rect()));
    }

    private boolean zza(PowerManager powerManager) {
        return powerManager == null || powerManager.isScreenOn();
    }

    private boolean zza(KeyguardManager keyguardManager) {
        if (keyguardManager == null) {
            return false;
        }
        return keyguardManager.inKeyguardRestrictedInputMode();
    }

    public int zzn(@Nullable View view) {
        ViewParent viewParent;
        if (view == null) {
            return -1;
        }
        for (viewParent = view.getParent(); viewParent != null && !(viewParent instanceof AdapterView); viewParent = viewParent.getParent()) {
        }
        if (viewParent == null) {
            return -1;
        }
        return ((AdapterView)viewParent).getPositionForView(view);
    }

    public boolean zzan(Context context) {
        try {
            context.getClassLoader().loadClass(ClientApi.class.getName());
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
    }

    public Bundle zztj() {
        Bundle bundle = new Bundle();
        try {
            Debug.MemoryInfo memoryInfo = new Debug.MemoryInfo();
            Debug.getMemoryInfo((Debug.MemoryInfo)memoryInfo);
            bundle.putParcelable("debug_memory_info", (Parcelable)memoryInfo);
            Runtime runtime = Runtime.getRuntime();
            bundle.putLong("runtime_free_memory", runtime.freeMemory());
            bundle.putLong("runtime_max_memory", runtime.maxMemory());
            bundle.putLong("runtime_total_memory", runtime.totalMemory());
        }
        catch (Exception exception) {
            zzkh.zzd((String)"Unable to gather memory stats", (Throwable)exception);
        }
        return bundle;
    }

    private final class zza
    extends BroadcastReceiver {
        private zza() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                zzkl.this.zzclh = true;
            } else if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                zzkl.this.zzclh = false;
            }
        }
    }
}

