/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.formats;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.zza;
import com.google.android.gms.ads.internal.formats.zzb;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzas;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzft;
import com.google.android.gms.internal.zzih;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzlh;
import com.google.android.gms.internal.zzli;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzin
public class zzi
implements zzh {
    private final Object zzail = new Object();
    private final zzq zzbfx;
    private final Context mContext;
    @Nullable
    private final JSONObject zzbga;
    @Nullable
    private final zzih zzbgb;
    @Nullable
    private final zzh.zza zzbgc;
    private final zzas zzbgd;
    @Nullable
    private final VersionInfoParcel zzalo;
    private boolean zzbge;
    private zzlh zzbgf;
    private String zzbgg;
    @Nullable
    private String zzbgh;
    private WeakReference<View> zzbgi = null;

    public zzi(Context context, zzq zzq2, @Nullable zzih zzih2, zzas zzas2, @Nullable JSONObject jSONObject, @Nullable zzh.zza zza2, @Nullable VersionInfoParcel versionInfoParcel, @Nullable String string) {
        this.mContext = context;
        this.zzbfx = zzq2;
        this.zzbgb = zzih2;
        this.zzbgd = zzas2;
        this.zzbga = jSONObject;
        this.zzbgc = zza2;
        this.zzalo = versionInfoParcel;
        this.zzbgh = string;
    }

    public zzb zza(View.OnClickListener onClickListener) {
        zza zza2 = this.zzbgc.zzkx();
        if (zza2 == null) {
            return null;
        }
        zzb zzb2 = new zzb(this.mContext, zza2);
        zzb2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzb2.zzks().setOnClickListener(onClickListener);
        zzb2.zzks().setContentDescription((CharSequence)"Ad attribution icon");
        return zzb2;
    }

    public void zza(String string, @Nullable JSONObject jSONObject, @Nullable JSONObject jSONObject2, @Nullable JSONObject jSONObject3) {
        zzab.zzhi((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject4 = new JSONObject();
            jSONObject4.put("asset", (Object)string);
            jSONObject4.put("template", (Object)this.zzbgc.zzkw());
            final JSONObject jSONObject5 = new JSONObject();
            jSONObject5.put("ad", (Object)this.zzbga);
            jSONObject5.put("click", (Object)jSONObject4);
            jSONObject5.put("has_custom_click_handler", this.zzbfx.zzv(this.zzbgc.getCustomTemplateId()) != null);
            if (jSONObject != null) {
                jSONObject5.put("view_rectangles", (Object)jSONObject);
            }
            if (jSONObject2 != null) {
                jSONObject5.put("click_point", (Object)jSONObject2);
            }
            if (jSONObject3 != null) {
                jSONObject5.put("native_view_rectangle", (Object)jSONObject3);
            }
            try {
                JSONObject jSONObject6 = this.zzbga.optJSONObject("tracking_urls_and_actions");
                if (jSONObject6 == null) {
                    jSONObject6 = new JSONObject();
                }
                String string2 = jSONObject6.optString("click_string");
                jSONObject4.put("click_signals", (Object)this.zzbgd.zzaw().zzb(this.mContext, string2));
            }
            catch (Exception exception) {
                zzkd.zzb((String)"Exception obtaining click signals", (Throwable)exception);
            }
            jSONObject5.put("ads_id", (Object)this.zzbgh);
            this.zzbgb.zza(new zzih.zza(){

                @Override
                public void zze(zzft zzft2) {
                    zzft2.zza("google.afma.nativeAds.handleClickGmsg", jSONObject5);
                }
            });
        }
        catch (JSONException jSONException) {
            zzkd.zzb((String)"Unable to create click JSON.", (Throwable)jSONException);
        }
    }

    public void zza(View view, Map<String, WeakReference<View>> map, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3) {
        zzab.zzhi((String)"performClick must be called on the main UI thread.");
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (!view.equals(view2)) continue;
            this.zza(entry.getKey(), jSONObject, jSONObject2, jSONObject3);
            return;
        }
        if ("2".equals(this.zzbgc.zzkw())) {
            this.zza("2099", jSONObject, jSONObject2, jSONObject3);
        } else if ("1".equals(this.zzbgc.zzkw())) {
            this.zza("1099", jSONObject, jSONObject2, jSONObject3);
        }
    }

    public void zzb(MotionEvent motionEvent) {
        this.zzbgd.zza(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzg(View view) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzbge) {
                return;
            }
            if (!view.isShown()) {
                return;
            }
            if (!view.getGlobalVisibleRect(new Rect(), null)) {
                return;
            }
            this.recordImpression();
        }
    }

    public void recordImpression() {
        zzab.zzhi((String)"recordImpression must be called on the main UI thread.");
        this.zzq(true);
        try {
            final JSONObject jSONObject = new JSONObject();
            jSONObject.put("ad", (Object)this.zzbga);
            jSONObject.put("ads_id", (Object)this.zzbgh);
            this.zzbgb.zza(new zzih.zza(){

                @Override
                public void zze(zzft zzft2) {
                    zzft2.zza("google.afma.nativeAds.handleImpressionPing", jSONObject);
                }
            });
        }
        catch (JSONException jSONException) {
            zzkd.zzb((String)"Unable to create impression JSON.", (Throwable)jSONException);
        }
        this.zzbfx.zza(this);
    }

    public View zzlc() {
        return this.zzbgi != null ? (View)this.zzbgi.get() : null;
    }

    public void zzh(View view) {
        this.zzbgi = new WeakReference<View>(view);
    }

    public void zza(View view, Map<String, WeakReference<View>> map, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        if (!zzdc.zzbci.get().booleanValue()) {
            return;
        }
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(onTouchListener);
            view2.setClickable(true);
            view2.setOnClickListener(onClickListener);
        }
    }

    public void zzb(View view, Map<String, WeakReference<View>> map) {
        view.setOnTouchListener(null);
        view.setClickable(false);
        view.setOnClickListener(null);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(null);
            view2.setClickable(false);
            view2.setOnClickListener(null);
        }
    }

    public zzlh zzlb() {
        this.zzbgf = this.zzld();
        this.zzbgf.getView().setVisibility(8);
        zzih.zza zza2 = new zzih.zza(){

            @Override
            public void zze(final zzft zzft2) {
                zzft2.zza("/loadHtml", new zzep(){

                    @Override
                    public void zza(zzlh zzlh2, final Map<String, String> map) {
                        zzi.this.zzbgf.zzuj().zza(new zzli.zza(){

                            @Override
                            public void zza(zzlh zzlh2, boolean bl) {
                                zzi.this.zzbgg = (String)map.get("id");
                                JSONObject jSONObject = new JSONObject();
                                try {
                                    jSONObject.put("messageType", (Object)"htmlLoaded");
                                    jSONObject.put("id", (Object)zzi.this.zzbgg);
                                    zzft2.zzb("sendMessageToNativeJs", jSONObject);
                                }
                                catch (JSONException jSONException) {
                                    zzkd.zzb((String)"Unable to dispatch sendMessageToNativeJs event", (Throwable)jSONException);
                                }
                            }
                        });
                        String string = map.get("overlayHtml");
                        String string2 = map.get("baseUrl");
                        if (TextUtils.isEmpty((CharSequence)string2)) {
                            zzi.this.zzbgf.loadData(string, "text/html", "UTF-8");
                        } else {
                            zzi.this.zzbgf.loadDataWithBaseURL(string2, string, "text/html", "UTF-8", null);
                        }
                    }
                });
                zzft2.zza("/showOverlay", new zzep(){

                    @Override
                    public void zza(zzlh zzlh2, Map<String, String> map) {
                        zzi.this.zzbgf.getView().setVisibility(0);
                    }
                });
                zzft2.zza("/hideOverlay", new zzep(){

                    @Override
                    public void zza(zzlh zzlh2, Map<String, String> map) {
                        zzi.this.zzbgf.getView().setVisibility(8);
                    }
                });
                zzi.this.zzbgf.zzuj().zza("/hideOverlay", new zzep(){

                    @Override
                    public void zza(zzlh zzlh2, Map<String, String> map) {
                        zzi.this.zzbgf.getView().setVisibility(8);
                    }
                });
                zzi.this.zzbgf.zzuj().zza("/sendMessageToSdk", new zzep(){

                    @Override
                    public void zza(zzlh zzlh2, Map<String, String> map) {
                        JSONObject jSONObject = new JSONObject();
                        try {
                            for (String string : map.keySet()) {
                                jSONObject.put(string, (Object)map.get(string));
                            }
                            jSONObject.put("id", (Object)zzi.this.zzbgg);
                            zzft2.zzb("sendMessageToNativeJs", jSONObject);
                        }
                        catch (JSONException jSONException) {
                            zzkd.zzb((String)"Unable to dispatch sendMessageToNativeJs event", (Throwable)jSONException);
                        }
                    }
                });
            }
        };
        this.zzbgb.zza(zza2);
        return this.zzbgf;
    }

    protected void zzq(boolean bl) {
        this.zzbge = bl;
    }

    zzlh zzld() {
        return zzu.zzfr().zza(this.mContext, AdSizeParcel.zzk((Context)this.mContext), false, false, this.zzbgd, this.zzalo);
    }

    public Context getContext() {
        return this.mContext;
    }
}

