/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzlh;
import java.util.HashMap;

@zzin
public class zzk
extends FrameLayout
implements zzh {
    private final zzlh zzbgf;
    private final FrameLayout zzbtw;
    private final zzy zzbtx;
    @Nullable
    private zzi zzbty;
    private boolean zzbtz;
    private boolean zzbua;
    private TextView zzbub;
    private long zzbuc;
    private long zzbud;
    private String zzbue;
    private String zzbjc;

    public static void zzh(zzlh zzlh2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzlh2.zza("onVideoEvent", hashMap);
    }

    public zzk(Context context, zzlh zzlh2, int n, boolean bl, zzdk zzdk2, zzdi zzdi2) {
        super(context);
        this.zzbgf = zzlh2;
        this.zzbtw = new FrameLayout(context);
        this.addView((View)this.zzbtw, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzb.zzu((Object)zzlh2.zzug());
        this.zzbty = zzlh2.zzug().zzakk.zza(context, zzlh2, n, bl, zzdk2, zzdi2);
        if (this.zzbty != null) {
            this.zzbtw.addView((View)this.zzbty, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        }
        this.zzbub = new TextView(context);
        this.zzbub.setBackgroundColor(-16777216);
        this.zzop();
        this.zzbtx = new zzy(this);
        this.zzbtx.zzpk();
        if (this.zzbty != null) {
            this.zzbty.zza(this);
        }
        if (this.zzbty == null) {
            this.zzl("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3 + 2, n4 + 2);
        layoutParams.setMargins(n - 1, n2 - 1, 0, 0);
        this.zzbtw.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public void setMimeType(String string) {
        this.zzbue = string;
    }

    public void zzbw(String string) {
        this.zzbjc = string;
    }

    public void zza(float f, float f2) {
        if (this.zzbty != null) {
            this.zzbty.zza(f, f2);
        }
    }

    public void zzlv() {
        if (this.zzbty == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzbjc)) {
            this.zzbty.setMimeType(this.zzbue);
            this.zzbty.setVideoPath(this.zzbjc);
        } else {
            this.zza("no_src", new String[0]);
        }
    }

    public void pause() {
        if (this.zzbty == null) {
            return;
        }
        this.zzbty.pause();
    }

    public void play() {
        if (this.zzbty == null) {
            return;
        }
        this.zzbty.play();
    }

    public void seekTo(int n) {
        if (this.zzbty == null) {
            return;
        }
        this.zzbty.seekTo(n);
    }

    public void zzno() {
        if (this.zzbty == null) {
            return;
        }
        this.zzbty.zzno();
    }

    public void zznp() {
        if (this.zzbty == null) {
            return;
        }
        this.zzbty.zznp();
    }

    public void zza(float f) {
        if (this.zzbty == null) {
            return;
        }
        this.zzbty.zza(f);
    }

    public void zzd(MotionEvent motionEvent) {
        if (this.zzbty == null) {
            return;
        }
        this.zzbty.dispatchTouchEvent(motionEvent);
    }

    public void zzon() {
        if (this.zzbty == null) {
            return;
        }
        Context context = this.zzbty.getContext();
        TextView textView = new TextView(context);
        String string = String.valueOf(this.zzbty.zzni());
        textView.setText((CharSequence)(string.length() != 0 ? "AdMob - ".concat(string) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzbtw.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzbtw.bringChildToFront((View)textView);
    }

    @Override
    public void zzoi() {
        zzkh.zzclc.post(new Runnable(){

            @Override
            public void run() {
                zzk.this.zza("surfaceCreated", new String[0]);
            }
        });
    }

    @Override
    public void zzoj() {
        if (this.zzbty == null) {
            return;
        }
        if (this.zzbud == 0L) {
            float f = (float)this.zzbty.getDuration() / 1000.0f;
            int n = this.zzbty.getVideoWidth();
            int n2 = this.zzbty.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public void zzok() {
        this.zzos();
    }

    @Override
    public void onPaused() {
        this.zza("pause", new String[0]);
        this.zzot();
    }

    @Override
    public void zzol() {
        this.zza("ended", new String[0]);
        this.zzot();
    }

    @Override
    public void zzl(String string, String string2) {
        this.zza("error", "what", string, "extra", string2);
    }

    @Override
    public void zzom() {
        this.zzop();
        this.zzbud = this.zzbuc;
        zzkh.zzclc.post(new Runnable(){

            @Override
            public void run() {
                zzk.this.zza("surfaceDestroyed", new String[0]);
            }
        });
    }

    public void destroy() {
        this.zzbtx.cancel();
        if (this.zzbty != null) {
            this.zzbty.stop();
        }
        this.zzot();
    }

    void zzoo() {
        if (this.zzbty == null) {
            return;
        }
        long l = this.zzbty.getCurrentPosition();
        if (this.zzbuc != l && l > 0L) {
            this.zzoq();
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzbuc = l;
        }
    }

    private void zzop() {
        if (!this.zzor()) {
            this.zzbtw.addView((View)this.zzbub, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.zzbtw.bringChildToFront((View)this.zzbub);
        }
    }

    private void zzoq() {
        if (this.zzor()) {
            this.zzbtw.removeView((View)this.zzbub);
        }
    }

    private boolean zzor() {
        return this.zzbub.getParent() != null;
    }

    private void zza(String string, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string);
        String string2 = null;
        for (String string3 : stringArray) {
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            hashMap.put(string2, string3);
            string2 = null;
        }
        this.zzbgf.zza("onVideoEvent", hashMap);
    }

    private void zzos() {
        if (this.zzbgf.zzue() == null) {
            return;
        }
        if (this.zzbtz) {
            return;
        }
        WindowManager.LayoutParams layoutParams = this.zzbgf.zzue().getWindow().getAttributes();
        boolean bl = this.zzbua = (layoutParams.flags & 0x80) != 0;
        if (!this.zzbua) {
            this.zzbgf.zzue().getWindow().addFlags(128);
            this.zzbtz = true;
        }
    }

    private void zzot() {
        if (this.zzbgf.zzue() == null) {
            return;
        }
        if (this.zzbtz && !this.zzbua) {
            this.zzbgf.zzue().getWindow().clearFlags(128);
            this.zzbtz = false;
        }
    }
}

