/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkd;

@zzin
class zzv
implements SensorEventListener {
    private final SensorManager zzbui;
    private final Object zzbuj;
    private final Display zzbuk;
    private final float[] zzbul;
    private final float[] zzbum;
    private float[] zzbun;
    private Handler zzbuo;
    private zza zzbup;

    zzv(Context context) {
        this.zzbui = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzbuk = windowManager.getDefaultDisplay();
        this.zzbul = new float[9];
        this.zzbum = new float[9];
        this.zzbuj = new Object();
    }

    int getRotation() {
        return this.zzbuk.getRotation();
    }

    void start() {
        if (this.zzbuo != null) {
            return;
        }
        Sensor sensor = this.zzbui.getDefaultSensor(11);
        if (sensor == null) {
            zzkd.e((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzbuo = new Handler(handlerThread.getLooper());
        boolean bl = this.zzbui.registerListener((SensorEventListener)this, sensor, 0, this.zzbuo);
        if (!bl) {
            zzkd.e((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    void stop() {
        if (this.zzbuo == null) {
            return;
        }
        this.zzbui.unregisterListener((SensorEventListener)this);
        this.zzbuo.post(new Runnable(){

            @Override
            public void run() {
                Looper.myLooper().quit();
            }
        });
        this.zzbuo = null;
    }

    void zza(zza zza2) {
        this.zzbup = zza2;
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        this.zza(sensorEvent.values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zza(float[] fArray) {
        if (fArray[0] == 0.0f && fArray[1] == 0.0f && fArray[2] == 0.0f) {
            return;
        }
        Object object = this.zzbuj;
        synchronized (object) {
            if (this.zzbun == null) {
                this.zzbun = new float[9];
            }
        }
        SensorManager.getRotationMatrixFromVector((float[])this.zzbul, (float[])fArray);
        int n = this.getRotation();
        switch (n) {
            case 1: {
                SensorManager.remapCoordinateSystem((float[])this.zzbul, (int)2, (int)129, (float[])this.zzbum);
                break;
            }
            case 2: {
                SensorManager.remapCoordinateSystem((float[])this.zzbul, (int)129, (int)130, (float[])this.zzbum);
                break;
            }
            case 3: {
                SensorManager.remapCoordinateSystem((float[])this.zzbul, (int)130, (int)1, (float[])this.zzbum);
                break;
            }
            default: {
                System.arraycopy(this.zzbul, 0, this.zzbum, 0, 9);
            }
        }
        this.zzf(1, 3);
        this.zzf(2, 6);
        this.zzf(5, 7);
        Object object2 = this.zzbuj;
        synchronized (object2) {
            System.arraycopy(this.zzbum, 0, this.zzbun, 0, 9);
        }
        if (this.zzbup != null) {
            this.zzbup.zznz();
        }
    }

    public void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzb(float[] fArray) {
        Object object = this.zzbuj;
        synchronized (object) {
            if (this.zzbun == null) {
                return false;
            }
            System.arraycopy(this.zzbun, 0, fArray, 0, this.zzbun.length);
            return true;
        }
    }

    private void zzf(int n, int n2) {
        float f = this.zzbum[n];
        this.zzbum[n] = this.zzbum[n2];
        this.zzbum[n2] = f;
    }

    static interface zza {
        public void zznz();
    }
}

