/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzkg;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzlh;
import java.io.BufferedOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzin
public class zzeq
implements zzep {
    private final Context mContext;
    private final VersionInfoParcel zzalo;

    public zzeq(Context context, VersionInfoParcel versionInfoParcel) {
        this.mContext = context;
        this.zzalo = versionInfoParcel;
    }

    protected zzb zzc(JSONObject jSONObject) {
        String string2 = jSONObject.optString("http_request_id");
        String string3 = jSONObject.optString("url");
        String string4 = jSONObject.optString("post_body", null);
        URL uRL = null;
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            zzkd.zzb((String)"Error constructing http request.", (Throwable)malformedURLException);
        }
        ArrayList<zza> arrayList = new ArrayList<zza>();
        JSONArray jSONArray = jSONObject.optJSONArray("headers");
        if (jSONArray == null) {
            jSONArray = new JSONArray();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.optJSONObject(i);
            if (jSONObject2 == null) continue;
            String string5 = jSONObject2.optString("key");
            String string6 = jSONObject2.optString("value");
            arrayList.add(new zza(string5, string6));
        }
        return new zzb(string2, uRL, arrayList, string4);
    }

    protected JSONObject zza(zzd zzd2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("http_request_id", (Object)zzd2.zzle());
            if (zzd2.getBody() != null) {
                jSONObject.put("body", (Object)zzd2.getBody());
            }
            JSONArray jSONArray = new JSONArray();
            for (zza zza2 : zzd2.zzlj()) {
                jSONArray.put((Object)new JSONObject().put("key", (Object)zza2.getKey()).put("value", (Object)zza2.getValue()));
            }
            jSONObject.put("headers", (Object)jSONArray);
            jSONObject.put("response_code", zzd2.getResponseCode());
        }
        catch (JSONException jSONException) {
            zzkd.zzb((String)"Error constructing JSON for http response.", (Throwable)jSONException);
        }
        return jSONObject;
    }

    protected zzc zza(zzb zzb2) {
        try {
            Object object;
            HttpURLConnection httpURLConnection = (HttpURLConnection)zzb2.zzlf().openConnection();
            zzu.zzfq().zza(this.mContext, this.zzalo.zzcs, false, httpURLConnection);
            for (zza object22 : zzb2.zzlg()) {
                httpURLConnection.addRequestProperty(object22.getKey(), object22.getValue());
            }
            if (!TextUtils.isEmpty((CharSequence)zzb2.zzlh())) {
                httpURLConnection.setDoOutput(true);
                object = zzb2.zzlh().getBytes();
                httpURLConnection.setFixedLengthStreamingMode(((Object)object).length);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
                bufferedOutputStream.write((byte[])object);
                bufferedOutputStream.close();
            }
            object = new ArrayList();
            if (httpURLConnection.getHeaderFields() != null) {
                for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
                    for (String string2 : entry.getValue()) {
                        ((ArrayList)object).add(new zza(entry.getKey(), string2));
                    }
                }
            }
            zzd zzd2 = new zzd(zzb2.zzle(), httpURLConnection.getResponseCode(), (List<zza>)object, zzu.zzfq().zza(new InputStreamReader(httpURLConnection.getInputStream())));
            return new zzc(true, zzd2, null);
        }
        catch (Exception exception) {
            return new zzc(false, null, exception.toString());
        }
    }

    public JSONObject zzav(String string2) {
        JSONObject jSONObject;
        try {
            jSONObject = new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            zzkd.e((String)"The request is not a valid JSON.");
            try {
                return new JSONObject().put("success", false);
            }
            catch (JSONException jSONException2) {
                return new JSONObject();
            }
        }
        JSONObject jSONObject2 = new JSONObject();
        String string3 = "";
        try {
            string3 = jSONObject.optString("http_request_id");
            zzb zzb2 = this.zzc(jSONObject);
            zzc zzc2 = this.zza(zzb2);
            if (zzc2.isSuccess()) {
                JSONObject jSONObject3 = this.zza(zzc2.zzli());
                jSONObject2.put("response", (Object)jSONObject3);
                jSONObject2.put("success", true);
            } else {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)zzc2.getReason());
            }
        }
        catch (Exception exception) {
            try {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)exception.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return jSONObject2;
    }

    @Override
    public void zza(final zzlh zzlh2, final Map<String, String> map) {
        zzkg.zza(new Runnable(){

            @Override
            public void run() {
                zzkd.zzcv((String)"Received Http request.");
                String string2 = (String)map.get("http_request");
                final JSONObject jSONObject = zzeq.this.zzav(string2);
                if (jSONObject == null) {
                    zzkd.e((String)"Response should not be null.");
                    return;
                }
                zzkh.zzclc.post(new Runnable(){

                    @Override
                    public void run() {
                        zzlh2.zzb("fetchHttpRequestCompleted", jSONObject);
                        zzkd.zzcv((String)"Dispatched http response.");
                    }
                });
            }
        });
    }

    @zzin
    class zzc {
        private final zzd zzbim;
        private final boolean zzbin;
        private final String zzbio;

        public zzc(boolean bl, zzd zzd2, String string2) {
            this.zzbin = bl;
            this.zzbim = zzd2;
            this.zzbio = string2;
        }

        public String getReason() {
            return this.zzbio;
        }

        public zzd zzli() {
            return this.zzbim;
        }

        public boolean isSuccess() {
            return this.zzbin;
        }
    }

    @zzin
    static class zzd {
        private final String zzbii;
        private final int zzbip;
        private final List<zza> zzbiq;
        private final String zzbfi;

        public zzd(String string2, int n, List<zza> list, String string3) {
            this.zzbii = string2;
            this.zzbip = n;
            this.zzbiq = list == null ? new ArrayList<zza>() : list;
            this.zzbfi = string3;
        }

        public String zzle() {
            return this.zzbii;
        }

        public int getResponseCode() {
            return this.zzbip;
        }

        public Iterable<zza> zzlj() {
            return this.zzbiq;
        }

        public String getBody() {
            return this.zzbfi;
        }
    }

    @zzin
    static class zzb {
        private final String zzbii;
        private final URL zzbij;
        private final ArrayList<zza> zzbik;
        private final String zzbil;

        public zzb(String string2, URL uRL, ArrayList<zza> arrayList, String string3) {
            this.zzbii = string2;
            this.zzbij = uRL;
            this.zzbik = arrayList == null ? new ArrayList() : arrayList;
            this.zzbil = string3;
        }

        public String zzle() {
            return this.zzbii;
        }

        public URL zzlf() {
            return this.zzbij;
        }

        public ArrayList<zza> zzlg() {
            return this.zzbik;
        }

        public String zzlh() {
            return this.zzbil;
        }
    }

    @zzin
    static class zza {
        private final String zzaxp;
        private final String mValue;

        public zza(String string2, String string3) {
            this.zzaxp = string2;
            this.mValue = string3;
        }

        public String getKey() {
            return this.zzaxp;
        }

        public String getValue() {
            return this.mValue;
        }
    }
}

