/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.overlay.zzk;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzlg;
import com.google.android.gms.internal.zzlh;
import java.util.Map;
import java.util.WeakHashMap;
import org.json.JSONObject;

@zzin
public final class zzez
implements zzep {
    private final Map<zzlh, Integer> zzbiz = new WeakHashMap<zzlh, Integer>();
    private boolean zzbja;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                n2 = zzm.zziw().zza(context, Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzkd.zzcx((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    @Override
    public void zza(zzlh zzlh2, Map<String, String> map) {
        Object object;
        String string2 = map.get("action");
        if (string2 == null) {
            zzkd.zzcx((String)"Action missing from video GMSG.");
            return;
        }
        if (zzkd.zzaz((int)3)) {
            object = new JSONObject(map);
            object.remove("google.afma.Notify_dt");
            String string3 = String.valueOf(object.toString());
            zzkd.zzcv((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Video GMSG: ").append(string2).append(" ").append(string3).toString());
        }
        if ("background".equals(string2)) {
            object = map.get("color");
            if (TextUtils.isEmpty((CharSequence)object)) {
                zzkd.zzcx((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                zzk zzk2;
                int n = Color.parseColor((String)object);
                zzlg zzlg2 = zzlh2.zzuq();
                if (zzlg2 != null && (zzk2 = zzlg2.zzub()) != null) {
                    zzk2.setBackgroundColor(n);
                    return;
                }
                this.zzbiz.put(zzlh2, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzkd.zzcx((String)"Invalid color parameter in video GMSG.");
            }
            return;
        }
        object = zzlh2.zzuq();
        if (object == null) {
            zzkd.zzcx((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzlh2.getContext();
            int n2 = zzez.zza(context, map, "x", 0);
            int n3 = zzez.zza(context, map, "y", 0);
            int n4 = zzez.zza(context, map, "w", -1);
            int n5 = zzez.zza(context, map, "h", -1);
            try {
                n = Integer.parseInt(map.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean(map.get("spherical"));
            if (bl && ((zzlg)object).zzub() == null) {
                ((zzlg)object).zza(n2, n3, n4, n5, n, bl3);
                if (this.zzbiz.containsKey(zzlh2)) {
                    int n6 = this.zzbiz.get(zzlh2);
                    zzk zzk3 = ((zzlg)object).zzub();
                    zzk3.setBackgroundColor(n6);
                }
            } else {
                ((zzlg)object).zze(n2, n3, n4, n5);
            }
        } else {
            zzk zzk4 = ((zzlg)object).zzub();
            if (zzk4 == null) {
                zzk.zzh(zzlh2);
                return;
            }
            if ("click".equals(string2)) {
                Context context = zzlh2.getContext();
                int n = zzez.zza(context, map, "x", 0);
                int n7 = zzez.zza(context, map, "y", 0);
                long l = SystemClock.uptimeMillis();
                MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n7, (int)0);
                zzk4.zzd(motionEvent);
                motionEvent.recycle();
            } else if ("currentTime".equals(string2)) {
                String string4 = map.get("time");
                if (string4 == null) {
                    zzkd.zzcx((String)"Time parameter missing from currentTime video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string4);
                    int n = (int)(f * 1000.0f);
                    zzk4.seekTo(n);
                }
                catch (NumberFormatException numberFormatException) {
                    String string5 = String.valueOf(string4);
                    zzkd.zzcx((String)(string5.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string5) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                }
            } else if ("hide".equals(string2)) {
                zzk4.setVisibility(4);
            } else if ("load".equals(string2)) {
                zzk4.zzlv();
            } else if ("mimetype".equals(string2)) {
                zzk4.setMimeType(map.get("mimetype"));
            } else if ("muted".equals(string2)) {
                boolean bl4 = Boolean.parseBoolean(map.get("muted"));
                if (bl4) {
                    zzk4.zzno();
                } else {
                    zzk4.zznp();
                }
            } else if ("pause".equals(string2)) {
                zzk4.pause();
            } else if ("play".equals(string2)) {
                zzk4.play();
            } else if ("show".equals(string2)) {
                zzk4.setVisibility(0);
            } else if ("src".equals(string2)) {
                zzk4.zzbw(map.get("src"));
            } else if ("touchMove".equals(string2)) {
                Context context = zzlh2.getContext();
                int n = zzez.zza(context, map, "dx", 0);
                int n8 = zzez.zza(context, map, "dy", 0);
                zzk4.zza(n, n8);
                if (!this.zzbja) {
                    zzd zzd2 = zzlh2.zzuh();
                    zzd2.zzob();
                    this.zzbja = true;
                }
            } else if ("volume".equals(string2)) {
                String string6 = map.get("volume");
                if (string6 == null) {
                    zzkd.zzcx((String)"Level parameter missing from volume video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string6);
                    zzk4.zza(f);
                }
                catch (NumberFormatException numberFormatException) {
                    String string7 = String.valueOf(string6);
                    zzkd.zzcx((String)(string7.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string7) : new String("Could not parse volume parameter from volume video GMSG: ")));
                }
            } else if ("watermark".equals(string2)) {
                zzk4.zzon();
            } else {
                String string8 = String.valueOf(string2);
                zzkd.zzcx((String)(string8.length() != 0 ? "Unknown video action: ".concat(string8) : new String("Unknown video action: ")));
            }
        }
    }
}

