/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzfd;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzlh;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@zzin
public class zzfg
extends zzfd {
    private static final Set<String> zzbjp = Collections.synchronizedSet(new HashSet());
    private static final DecimalFormat zzbjq = new DecimalFormat("#,###");
    private File zzbjr;
    private boolean zzbjs;

    public zzfg(zzlh zzlh2) {
        super(zzlh2);
        File file = this.mContext.getCacheDir();
        if (file == null) {
            zzkd.zzcx((String)"Context.getCacheDir() returned null");
            return;
        }
        this.zzbjr = new File(file, "admobVideoStreams");
        if (!this.zzbjr.isDirectory() && !this.zzbjr.mkdirs()) {
            String string2 = String.valueOf(this.zzbjr.getAbsolutePath());
            zzkd.zzcx((String)(string2.length() != 0 ? "Could not create preload cache directory at ".concat(string2) : new String("Could not create preload cache directory at ")));
            this.zzbjr = null;
            return;
        }
        if (!this.zzbjr.setReadable(true, false) || !this.zzbjr.setExecutable(true, false)) {
            String string3 = String.valueOf(this.zzbjr.getAbsolutePath());
            zzkd.zzcx((String)(string3.length() != 0 ? "Could not set cache file permissions at ".concat(string3) : new String("Could not set cache file permissions at ")));
            this.zzbjr = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzaz(String string2) {
        if (this.zzbjr == null) {
            this.zza(string2, null, "noCacheDir", null);
            return false;
        }
        while (this.zzll() > zzdc.zzaym.get()) {
            if (this.zzlm()) continue;
            zzkd.zzcx((String)"Unable to expire stream cache");
            this.zza(string2, null, "expireFailed", null);
            return false;
        }
        String string3 = this.zzba(string2);
        File file = new File(this.zzbjr, string3);
        File file2 = this.zzb(file);
        if (file.isFile() && file2.isFile()) {
            int n = (int)file.length();
            String string4 = String.valueOf(string2);
            zzkd.zzcv((String)(string4.length() != 0 ? "Stream cache hit at ".concat(string4) : new String("Stream cache hit at ")));
            this.zza(string2, file.getAbsolutePath(), n);
            return true;
        }
        String string5 = String.valueOf(this.zzbjr.getAbsolutePath());
        String string6 = String.valueOf(string2);
        String string7 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
        Object object = zzbjp;
        synchronized (object) {
            if (zzbjp.contains(string7)) {
                String string8 = String.valueOf(string2);
                zzkd.zzcx((String)(string8.length() != 0 ? "Stream cache already in progress at ".concat(string8) : new String("Stream cache already in progress at ")));
                this.zza(string2, file.getAbsolutePath(), "inProgress", null);
                return false;
            }
            zzbjp.add(string7);
        }
        object = null;
        String string9 = "error";
        String string10 = null;
        try {
            int n;
            int n2;
            URLConnection uRLConnection = new URL(string2).openConnection();
            int n3 = zzdc.zzayr.get();
            uRLConnection.setConnectTimeout(n3);
            uRLConnection.setReadTimeout(n3);
            if (uRLConnection instanceof HttpURLConnection && (n2 = ((HttpURLConnection)uRLConnection).getResponseCode()) >= 400) {
                string9 = "badUrl";
                String string11 = String.valueOf(Integer.toString(n2));
                string10 = string11.length() != 0 ? "HTTP request failed. Code: ".concat(string11) : new String("HTTP request failed. Code: ");
                throw new IOException(new StringBuilder(32 + String.valueOf(string2).length()).append("HTTP status code ").append(n2).append(" at ").append(string2).toString());
            }
            n2 = uRLConnection.getContentLength();
            if (n2 < 0) {
                String string12 = String.valueOf(string2);
                zzkd.zzcx((String)(string12.length() != 0 ? "Stream cache aborted, missing content-length header at ".concat(string12) : new String("Stream cache aborted, missing content-length header at ")));
                this.zza(string2, file.getAbsolutePath(), "contentLengthMissing", null);
                zzbjp.remove(string7);
                return false;
            }
            String string13 = zzbjq.format(n2);
            int n4 = zzdc.zzayn.get();
            if (n2 > n4) {
                zzkd.zzcx((String)new StringBuilder(33 + String.valueOf(string13).length() + String.valueOf(string2).length()).append("Content length ").append(string13).append(" exceeds limit at ").append(string2).toString());
                String string14 = String.valueOf(string13);
                String string15 = string14.length() != 0 ? "File too big for full file cache. Size: ".concat(string14) : new String("File too big for full file cache. Size: ");
                this.zza(string2, file.getAbsolutePath(), "sizeExceeded", string15);
                zzbjp.remove(string7);
                return false;
            }
            zzkd.zzcv((String)new StringBuilder(20 + String.valueOf(string13).length() + String.valueOf(string2).length()).append("Caching ").append(string13).append(" bytes from ").append(string2).toString());
            InputStream inputStream = uRLConnection.getInputStream();
            ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
            object = new FileOutputStream(file);
            FileChannel fileChannel = ((FileOutputStream)object).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
            zze zze2 = zzu.zzfu();
            int n5 = 0;
            long l = zze2.currentTimeMillis();
            long l2 = zzdc.zzayq.get();
            zzkr zzkr2 = new zzkr(l2);
            long l3 = zzdc.zzayp.get();
            while ((n = readableByteChannel.read(byteBuffer)) >= 0) {
                if ((n5 += n) > n4) {
                    string9 = "sizeExceeded";
                    String string16 = String.valueOf(Integer.toString(n5));
                    string10 = string16.length() != 0 ? "File too big for full file cache. Size: ".concat(string16) : new String("File too big for full file cache. Size: ");
                    throw new IOException("stream cache file size limit exceeded");
                }
                byteBuffer.flip();
                while (fileChannel.write(byteBuffer) > 0) {
                }
                byteBuffer.clear();
                long l4 = zze2.currentTimeMillis();
                if (l4 - l > l3 * 1000L) {
                    string9 = "downloadTimeout";
                    String string17 = String.valueOf(Long.toString(l3));
                    string10 = new StringBuilder(29 + String.valueOf(string17).length()).append("Timeout exceeded. Limit: ").append(string17).append(" sec").toString();
                    throw new IOException("stream cache time limit exceeded");
                }
                if (this.zzbjs) {
                    string9 = "externalAbort";
                    throw new IOException("abort requested");
                }
                if (!zzkr2.tryAcquire()) continue;
                this.zza(string2, file.getAbsolutePath(), n5, n2, false);
            }
            ((FileOutputStream)object).close();
            if (zzkd.zzaz((int)3)) {
                String string18 = zzbjq.format(n5);
                zzkd.zzcv((String)new StringBuilder(22 + String.valueOf(string18).length() + String.valueOf(string2).length()).append("Preloaded ").append(string18).append(" bytes from ").append(string2).toString());
            }
            file.setReadable(true, false);
            zzfg.zzc(file2);
            this.zza(string2, file.getAbsolutePath(), n5);
            zzbjp.remove(string7);
            return true;
        }
        catch (IOException | RuntimeException exception) {
            if (exception instanceof RuntimeException) {
                zzu.zzft().zzb(exception, true);
            }
            try {
                ((FileOutputStream)object).close();
            }
            catch (IOException | NullPointerException exception2) {
                // empty catch block
            }
            if (this.zzbjs) {
                zzkd.zzcw((String)new StringBuilder(26 + String.valueOf(string2).length()).append("Preload aborted for URL \"").append(string2).append("\"").toString());
            } else {
                zzkd.zzd((String)new StringBuilder(25 + String.valueOf(string2).length()).append("Preload failed for URL \"").append(string2).append("\"").toString(), (Throwable)exception);
            }
            if (file.exists() && !file.delete()) {
                String string19 = String.valueOf(file.getAbsolutePath());
                zzkd.zzcx((String)(string19.length() != 0 ? "Could not delete partial cache file at ".concat(string19) : new String("Could not delete partial cache file at ")));
            }
            this.zza(string2, file.getAbsolutePath(), string9, string10);
            zzbjp.remove(string7);
            return false;
        }
    }

    @Override
    public void abort() {
        this.zzbjs = true;
    }

    public int zzll() {
        if (this.zzbjr == null) {
            return 0;
        }
        int n = 0;
        for (File file : this.zzbjr.listFiles()) {
            if (file.getName().endsWith(".done")) continue;
            ++n;
        }
        return n;
    }

    public boolean zzlm() {
        if (this.zzbjr == null) {
            return false;
        }
        File file = null;
        long l = Long.MAX_VALUE;
        for (File file2 : this.zzbjr.listFiles()) {
            long l2;
            if (file2.getName().endsWith(".done") || (l2 = file2.lastModified()) >= l) continue;
            file = file2;
            l = l2;
        }
        boolean bl = false;
        if (file != null) {
            bl = file.delete();
            File file3 = this.zzb(file);
            if (file3.isFile()) {
                bl &= file3.delete();
            }
        }
        return bl;
    }

    private File zzb(File file) {
        return new File(this.zzbjr, String.valueOf(file.getName()).concat(".done"));
    }

    private static void zzc(File file) {
        if (file.isFile()) {
            file.setLastModified(System.currentTimeMillis());
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

