/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzf;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzfz;
import com.google.android.gms.internal.zzga;
import com.google.android.gms.internal.zzgc;
import com.google.android.gms.internal.zzge;
import com.google.android.gms.internal.zzgj;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzgl;
import com.google.android.gms.internal.zzgm;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzgy;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzkh;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzin
public class zzgd
implements zzge.zza {
    private final String zzboc;
    private final zzgj zzajz;
    private final long zzbod;
    private final zzga zzboe;
    private final zzfz zzbof;
    private AdRequestParcel zzanc;
    private final AdSizeParcel zzani;
    private final Context mContext;
    private final Object zzail = new Object();
    private final VersionInfoParcel zzalo;
    private final boolean zzarl;
    private final NativeAdOptionsParcel zzalk;
    private final List<String> zzall;
    private final boolean zzawn;
    private zzgk zzbog;
    private int zzboh = -2;
    private zzgm zzboi;

    public zzgd(Context context, String string, zzgj zzgj2, zzga zzga2, zzfz zzfz2, AdRequestParcel adRequestParcel, AdSizeParcel adSizeParcel, VersionInfoParcel versionInfoParcel, boolean bl, boolean bl2, NativeAdOptionsParcel nativeAdOptionsParcel, List<String> list) {
        this.mContext = context;
        this.zzajz = zzgj2;
        this.zzbof = zzfz2;
        this.zzboc = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string) ? this.zzmh() : string;
        this.zzboe = zzga2;
        this.zzbod = zzga2.zzbnl != -1L ? zzga2.zzbnl : 10000L;
        this.zzanc = adRequestParcel;
        this.zzani = adSizeParcel;
        this.zzalo = versionInfoParcel;
        this.zzarl = bl;
        this.zzawn = bl2;
        this.zzalk = nativeAdOptionsParcel;
        this.zzall = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.zzail;
        synchronized (object) {
            try {
                if (this.zzbog != null) {
                    this.zzbog.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzkd.zzd((String)"Could not destroy mediation adapter.", (Throwable)remoteException);
            }
            this.zzboh = -1;
            this.zzail.notify();
        }
    }

    private String zzmh() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzbof.zzbmy)) {
                return this.zzajz.zzbn(this.zzbof.zzbmy) ? "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter" : "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzkd.zzcx((String)"Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzy(int n) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzboh = n;
            this.zzail.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(int n, zzgm zzgm2) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzboh = n;
            this.zzboi = zzgm2;
            this.zzail.notify();
        }
    }

    protected zzgk zza(MediationAdapter mediationAdapter) {
        return new zzgq(mediationAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzge zza(long l, long l2) {
        Object object = this.zzail;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            final zzgc zzgc2 = new zzgc();
            zzkh.zzclc.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = zzgd.this.zzail;
                    synchronized (object) {
                        if (zzgd.this.zzboh != -2) {
                            return;
                        }
                        zzgd.this.zzbog = zzgd.this.zzmj();
                        if (zzgd.this.zzbog == null) {
                            zzgd.this.zzy(4);
                            return;
                        }
                        if (zzgd.this.zzmk() && !zzgd.this.zzz(1)) {
                            String string = zzgd.this.zzboc;
                            zzkd.zzcx((String)new StringBuilder(56 + String.valueOf(string).length()).append("Ignoring adapter ").append(string).append(" as delayed impression is not supported").toString());
                            zzgd.this.zzy(2);
                            return;
                        }
                        zzgc2.zza(zzgd.this);
                        zzgd.this.zza(zzgc2);
                    }
                }
            });
            long l4 = this.zza(l3, this.zzbod, l, l2);
            return new zzge(this.zzbof, this.zzbog, this.zzboc, zzgc2, this.zzboh, this.zzmi(), l4);
        }
    }

    private zzgm zzmi() {
        if (this.zzboh != 0 || !this.zzmk()) {
            return null;
        }
        try {
            if (this.zzz(4) && this.zzboi != null && this.zzboi.zzmm() != 0) {
                return this.zzboi;
            }
        }
        catch (RemoteException remoteException) {
            zzkd.zzcx((String)"Could not get cpm value from MediationResponseMetadata");
        }
        return zzgd.zzaa(this.zzml());
    }

    private zzgk zzmj() {
        String string = String.valueOf(this.zzboc);
        zzkd.zzcw((String)(string.length() != 0 ? "Instantiating mediation adapter: ".concat(string) : new String("Instantiating mediation adapter: ")));
        if (!this.zzarl) {
            if (zzdc.zzbbe.get().booleanValue() && "com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzboc)) {
                return this.zza((MediationAdapter)new AdMobAdapter());
            }
            if (zzdc.zzbbf.get().booleanValue() && "com.google.ads.mediation.AdUrlAdapter".equals(this.zzboc)) {
                return this.zza((MediationAdapter)new AdUrlAdapter());
            }
            if ("com.google.ads.mediation.admob.AdMobCustomTabsAdapter".equals(this.zzboc)) {
                return new zzgq((MediationAdapter)new zzgy());
            }
        }
        try {
            return this.zzajz.zzbm(this.zzboc);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(this.zzboc);
            zzkd.zza((String)(string2.length() != 0 ? "Could not instantiate mediation adapter: ".concat(string2) : new String("Could not instantiate mediation adapter: ")), (Throwable)remoteException);
            return null;
        }
    }

    private void zza(zzgc zzgc2) {
        String string;
        if ("com.google.ads.mediation.AdUrlAdapter".equals(this.zzboc)) {
            if (this.zzanc.zzatw == null) {
                this.zzanc = new zzf(this.zzanc).zzc(new Bundle()).zzig();
            }
            if ((string = this.zzanc.zzatw.getBundle(this.zzboc)) == null) {
                string = new Bundle();
            }
            string.putString("sdk_less_network_id", this.zzbof.zzbmv);
            this.zzanc.zzatw.putBundle(this.zzboc, (Bundle)string);
        }
        string = this.zzbj(this.zzbof.zzbnc);
        try {
            if (this.zzalo.zzcnl < 4100000) {
                if (this.zzani.zzaus) {
                    this.zzbog.zza(zze.zzac((Object)this.mContext), this.zzanc, string, (zzgl)zzgc2);
                } else {
                    this.zzbog.zza(zze.zzac((Object)this.mContext), this.zzani, this.zzanc, string, (zzgl)zzgc2);
                }
            } else if (this.zzarl) {
                this.zzbog.zza(zze.zzac((Object)this.mContext), this.zzanc, string, this.zzbof.zzbmu, (zzgl)zzgc2, this.zzalk, this.zzall);
            } else if (this.zzani.zzaus) {
                this.zzbog.zza(zze.zzac((Object)this.mContext), this.zzanc, string, this.zzbof.zzbmu, (zzgl)zzgc2);
            } else if (this.zzawn) {
                if (this.zzbof.zzbnf != null) {
                    this.zzbog.zza(zze.zzac((Object)this.mContext), this.zzanc, string, this.zzbof.zzbmu, (zzgl)zzgc2, new NativeAdOptionsParcel(zzgd.zzbk(this.zzbof.zzbnj)), this.zzbof.zzbni);
                } else {
                    this.zzbog.zza(zze.zzac((Object)this.mContext), this.zzani, this.zzanc, string, this.zzbof.zzbmu, (zzgl)zzgc2);
                }
            } else {
                this.zzbog.zza(zze.zzac((Object)this.mContext), this.zzani, this.zzanc, string, this.zzbof.zzbmu, (zzgl)zzgc2);
            }
        }
        catch (RemoteException remoteException) {
            zzkd.zzd((String)"Could not request ad from mediation adapter.", (Throwable)remoteException);
            this.zzy(5);
        }
    }

    private long zza(long l, long l2, long l3, long l4) {
        while (this.zzboh == -2) {
            this.zzb(l, l2, l3, l4);
        }
        return zzu.zzfu().elapsedRealtime() - l;
    }

    private void zzb(long l, long l2, long l3, long l4) {
        long l5 = SystemClock.elapsedRealtime();
        long l6 = l2 - (l5 - l);
        long l7 = l4 - (l5 - l3);
        if (l6 <= 0L || l7 <= 0L) {
            zzkd.zzcw((String)"Timed out waiting for adapter.");
            this.zzboh = 3;
            return;
        }
        try {
            this.zzail.wait(Math.min(l6, l7));
        }
        catch (InterruptedException interruptedException) {
            this.zzboh = -1;
        }
    }

    private boolean zzz(int n) {
        Bundle bundle = null;
        try {
            bundle = this.zzarl ? this.zzbog.zzmr() : (this.zzani.zzaus ? this.zzbog.getInterstitialAdapterInfo() : this.zzbog.zzmq());
        }
        catch (RemoteException remoteException) {
            zzkd.zzcx((String)"Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private boolean zzmk() {
        return this.zzboe.zzbnv != -1;
    }

    private String zzbj(String string) {
        if (string == null || !this.zzmk() || this.zzz(2)) {
            return string;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzkd.zzcx((String)"Could not remove field. Returning the original value");
            return string;
        }
    }

    private int zzml() {
        JSONObject jSONObject;
        if (this.zzbof.zzbnc == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzbof.zzbnc);
        }
        catch (JSONException jSONException) {
            zzkd.zzcx((String)"Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzboc)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzz(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static zzgm zzaa(final int n) {
        return new zzgm.zza(){

            public int zzmm() throws RemoteException {
                return n;
            }
        };
    }

    private static NativeAdOptions zzbk(String string) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (string == null) {
            return builder.build();
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            builder.setRequestMultipleImages(jSONObject.optBoolean("multiple_images", false));
            builder.setReturnUrlsForImageAssets(jSONObject.optBoolean("only_urls", false));
            String string2 = jSONObject.optString("native_image_orientation", "any");
            builder.setImageOrientation(zzgd.zzbl(string2));
        }
        catch (JSONException jSONException) {
            zzkd.zzd((String)"Exception occurred when creating native ad options", (Throwable)jSONException);
        }
        return builder.build();
    }

    private static int zzbl(String string) {
        if ("landscape".equals(string)) {
            return 2;
        }
        if ("portrait".equals(string)) {
            return 1;
        }
        return 0;
    }
}

