/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.SearchAdRequestParcel;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.AutoClickProtectionConfigurationParcel;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzkd;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzin
public final class zziq {
    private static final SimpleDateFormat zzcel = new SimpleDateFormat("yyyyMMdd", Locale.US);

    @Nullable
    public static JSONObject zza(Context context, AdRequestInfoParcel adRequestInfoParcel, zziv zziv2, zziz.zza zza2, Location location, zzcv zzcv2, String string2, List<String> list, Bundle bundle, String string3) {
        try {
            boolean bl;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (list.size() > 0) {
                hashMap.put("eid", TextUtils.join((CharSequence)",", list));
            }
            if (adRequestInfoParcel.zzcaq != null) {
                hashMap.put("ad_pos", adRequestInfoParcel.zzcaq);
            }
            zziq.zza(hashMap, adRequestInfoParcel.zzcar);
            if (adRequestInfoParcel.zzapa.zzaut == null) {
                hashMap.put("format", adRequestInfoParcel.zzapa.zzaur);
                if (adRequestInfoParcel.zzapa.zzauv) {
                    hashMap.put("fluid", "height");
                }
            } else {
                boolean bl2 = false;
                bl = false;
                for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzapa.zzaut) {
                    if (!adSizeParcel.zzauv && !bl2) {
                        hashMap.put("format", adSizeParcel.zzaur);
                        bl2 = true;
                    }
                    if (adSizeParcel.zzauv && !bl) {
                        hashMap.put("fluid", "height");
                        bl = true;
                    }
                    if (bl2 && bl) break;
                }
            }
            if (adRequestInfoParcel.zzapa.width == -1) {
                hashMap.put("smart_w", "full");
            }
            if (adRequestInfoParcel.zzapa.height == -2) {
                hashMap.put("smart_h", "auto");
            }
            if (adRequestInfoParcel.zzapa.zzaut != null) {
                StringBuilder stringBuilder = new StringBuilder();
                bl = false;
                for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzapa.zzaut) {
                    if (adSizeParcel.zzauv) {
                        bl = true;
                        continue;
                    }
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append("|");
                    }
                    stringBuilder.append(adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / zziv2.zzcbd) : adSizeParcel.width);
                    stringBuilder.append("x");
                    stringBuilder.append(adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / zziv2.zzcbd) : adSizeParcel.height);
                }
                if (bl) {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.insert(0, "|");
                    }
                    stringBuilder.insert(0, "320x50");
                }
                hashMap.put("sz", stringBuilder);
            }
            if (adRequestInfoParcel.zzcax != 0) {
                hashMap.put("native_version", adRequestInfoParcel.zzcax);
                if (!adRequestInfoParcel.zzapa.zzauw) {
                    hashMap.put("native_templates", adRequestInfoParcel.zzaps);
                    hashMap.put("native_image_orientation", zziq.zzc(adRequestInfoParcel.zzapo));
                    if (!adRequestInfoParcel.zzcbi.isEmpty()) {
                        hashMap.put("native_custom_templates", adRequestInfoParcel.zzcbi);
                    }
                }
            }
            hashMap.put("slotname", adRequestInfoParcel.zzaou);
            hashMap.put("pn", adRequestInfoParcel.applicationInfo.packageName);
            if (adRequestInfoParcel.zzcas != null) {
                hashMap.put("vc", adRequestInfoParcel.zzcas.versionCode);
            }
            hashMap.put("ms", string2);
            hashMap.put("seq_num", adRequestInfoParcel.zzcau);
            hashMap.put("session_id", adRequestInfoParcel.zzcav);
            hashMap.put("js", adRequestInfoParcel.zzaow.zzcs);
            zziq.zza(hashMap, zziv2, zza2, adRequestInfoParcel.zzcbv);
            zziq.zza(hashMap, string3);
            hashMap.put("platform", Build.MANUFACTURER);
            hashMap.put("submodel", Build.MODEL);
            if (location != null) {
                zziq.zza(hashMap, location);
            } else if (adRequestInfoParcel.zzcar.versionCode >= 2 && adRequestInfoParcel.zzcar.zzatu != null) {
                zziq.zza(hashMap, adRequestInfoParcel.zzcar.zzatu);
            }
            if (adRequestInfoParcel.versionCode >= 2) {
                hashMap.put("quality_signals", adRequestInfoParcel.zzcaw);
            }
            if (adRequestInfoParcel.versionCode >= 4 && adRequestInfoParcel.zzcaz) {
                hashMap.put("forceHttps", adRequestInfoParcel.zzcaz);
            }
            if (bundle != null) {
                hashMap.put("content_info", bundle);
            }
            if (adRequestInfoParcel.versionCode >= 5) {
                hashMap.put("u_sd", Float.valueOf(adRequestInfoParcel.zzcbd));
                hashMap.put("sh", adRequestInfoParcel.zzcbc);
                hashMap.put("sw", adRequestInfoParcel.zzcbb);
            } else {
                hashMap.put("u_sd", Float.valueOf(zziv2.zzcbd));
                hashMap.put("sh", zziv2.zzcbc);
                hashMap.put("sw", zziv2.zzcbb);
            }
            if (adRequestInfoParcel.versionCode >= 6) {
                if (!TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzcbe)) {
                    try {
                        hashMap.put("view_hierarchy", new JSONObject(adRequestInfoParcel.zzcbe));
                    }
                    catch (JSONException jSONException) {
                        zzkd.zzd((String)"Problem serializing view hierarchy to JSON", (Throwable)jSONException);
                    }
                }
                hashMap.put("correlation_id", adRequestInfoParcel.zzcbf);
            }
            if (adRequestInfoParcel.versionCode >= 7) {
                hashMap.put("request_id", adRequestInfoParcel.zzcbg);
            }
            if (adRequestInfoParcel.versionCode >= 11 && adRequestInfoParcel.zzcbk != null) {
                hashMap.put("capability", adRequestInfoParcel.zzcbk.toBundle());
            }
            if (adRequestInfoParcel.versionCode >= 12 && !TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzcbl)) {
                hashMap.put("anchor", adRequestInfoParcel.zzcbl);
            }
            if (adRequestInfoParcel.versionCode >= 13) {
                hashMap.put("android_app_volume", Float.valueOf(adRequestInfoParcel.zzcbm));
            }
            if (adRequestInfoParcel.versionCode >= 18) {
                hashMap.put("android_app_muted", adRequestInfoParcel.zzcbs);
            }
            if (adRequestInfoParcel.versionCode >= 14 && adRequestInfoParcel.zzcbn > 0) {
                hashMap.put("target_api", adRequestInfoParcel.zzcbn);
            }
            if (adRequestInfoParcel.versionCode >= 15) {
                hashMap.put("scroll_index", adRequestInfoParcel.zzcbo == -1 ? -1 : adRequestInfoParcel.zzcbo);
            }
            if (adRequestInfoParcel.versionCode >= 16) {
                hashMap.put("_activity_context", adRequestInfoParcel.zzcbp);
            }
            if (adRequestInfoParcel.versionCode >= 18) {
                if (!TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzcbt)) {
                    try {
                        hashMap.put("app_settings", new JSONObject(adRequestInfoParcel.zzcbt));
                    }
                    catch (JSONException jSONException) {
                        zzkd.zzd((String)"Problem creating json from app settings", (Throwable)jSONException);
                    }
                }
                hashMap.put("render_in_browser", adRequestInfoParcel.zzbnq);
            }
            if (adRequestInfoParcel.versionCode >= 18) {
                hashMap.put("android_num_video_cache_tasks", adRequestInfoParcel.zzcbu);
            }
            if (zzkd.zzaz((int)2)) {
                String string4 = zzu.zzfq().zzam(hashMap).toString(2);
                String string5 = String.valueOf(string4);
                zzkd.v(string5.length() != 0 ? "Ad Request JSON: ".concat(string5) : new String("Ad Request JSON: "));
            }
            return zzu.zzfq().zzam(hashMap);
        }
        catch (JSONException jSONException) {
            String string6 = String.valueOf(jSONException.getMessage());
            zzkd.zzcx((String)(string6.length() != 0 ? "Problem serializing ad request to JSON: ".concat(string6) : new String("Problem serializing ad request to JSON: ")));
            return null;
        }
    }

    private static void zza(HashMap<String, Object> hashMap, String string2) {
        Bundle bundle = new Bundle();
        bundle.putString("doritos", string2);
        hashMap.put("pii", bundle);
    }

    private static void zza(HashMap<String, Object> hashMap, AdRequestParcel adRequestParcel) {
        String string2 = zzkb.zzsy();
        if (string2 != null) {
            hashMap.put("abf", string2);
        }
        if (adRequestParcel.zzatm != -1L) {
            hashMap.put("cust_age", zzcel.format(new Date(adRequestParcel.zzatm)));
        }
        if (adRequestParcel.extras != null) {
            hashMap.put("extras", adRequestParcel.extras);
        }
        if (adRequestParcel.zzatn != -1) {
            hashMap.put("cust_gender", adRequestParcel.zzatn);
        }
        if (adRequestParcel.zzato != null) {
            hashMap.put("kw", adRequestParcel.zzato);
        }
        if (adRequestParcel.zzatq != -1) {
            hashMap.put("tag_for_child_directed_treatment", adRequestParcel.zzatq);
        }
        if (adRequestParcel.zzatp) {
            hashMap.put("adtest", "on");
        }
        if (adRequestParcel.versionCode >= 2) {
            if (adRequestParcel.zzatr) {
                hashMap.put("d_imp_hdr", 1);
            }
            if (!TextUtils.isEmpty((CharSequence)adRequestParcel.zzats)) {
                hashMap.put("ppid", adRequestParcel.zzats);
            }
            if (adRequestParcel.zzatt != null) {
                zziq.zza(hashMap, adRequestParcel.zzatt);
            }
        }
        if (adRequestParcel.versionCode >= 3 && adRequestParcel.zzatv != null) {
            hashMap.put("url", adRequestParcel.zzatv);
        }
        if (adRequestParcel.versionCode >= 5) {
            if (adRequestParcel.zzatx != null) {
                hashMap.put("custom_targeting", adRequestParcel.zzatx);
            }
            if (adRequestParcel.zzaty != null) {
                hashMap.put("category_exclusions", adRequestParcel.zzaty);
            }
            if (adRequestParcel.zzatz != null) {
                hashMap.put("request_agent", adRequestParcel.zzatz);
            }
        }
        if (adRequestParcel.versionCode >= 6 && adRequestParcel.zzaua != null) {
            hashMap.put("request_pkg", adRequestParcel.zzaua);
        }
        if (adRequestParcel.versionCode >= 7) {
            hashMap.put("is_designed_for_families", adRequestParcel.zzaub);
        }
    }

    private static void zza(HashMap<String, Object> hashMap, zziv zziv2, zziz.zza zza2, Bundle bundle) {
        Bundle bundle2;
        hashMap.put("am", zziv2.zzcgd);
        hashMap.put("cog", zziq.zzab(zziv2.zzcge));
        hashMap.put("coh", zziq.zzab(zziv2.zzcgf));
        if (!TextUtils.isEmpty((CharSequence)zziv2.zzcgg)) {
            hashMap.put("carrier", zziv2.zzcgg);
        }
        hashMap.put("gl", zziv2.zzcgh);
        if (zziv2.zzcgi) {
            hashMap.put("simulator", 1);
        }
        if (zziv2.zzcgj) {
            hashMap.put("is_sidewinder", 1);
        }
        hashMap.put("ma", zziq.zzab(zziv2.zzcgk));
        hashMap.put("sp", zziq.zzab(zziv2.zzcgl));
        hashMap.put("hl", zziv2.zzcgm);
        if (!TextUtils.isEmpty((CharSequence)zziv2.zzcgn)) {
            hashMap.put("mv", zziv2.zzcgn);
        }
        hashMap.put("muv", zziv2.zzcgo);
        if (zziv2.zzcgp != -2) {
            hashMap.put("cnt", zziv2.zzcgp);
        }
        hashMap.put("gnt", zziv2.zzcgq);
        hashMap.put("pt", zziv2.zzcgr);
        hashMap.put("rm", zziv2.zzcgs);
        hashMap.put("riv", zziv2.zzcgt);
        Bundle bundle3 = new Bundle();
        bundle3.putString("build", zziv2.zzcgy);
        Bundle bundle4 = new Bundle();
        bundle4.putBoolean("is_charging", zziv2.zzcgv);
        bundle4.putDouble("battery_level", zziv2.zzcgu);
        bundle3.putBundle("battery", bundle4);
        Bundle bundle5 = new Bundle();
        bundle5.putInt("active_network_state", zziv2.zzcgx);
        bundle5.putBoolean("active_network_metered", zziv2.zzcgw);
        if (zza2 != null) {
            bundle2 = new Bundle();
            bundle2.putInt("predicted_latency_micros", 0);
            bundle2.putLong("predicted_down_throughput_bps", 0L);
            bundle2.putLong("predicted_up_throughput_bps", 0L);
            bundle5.putBundle("predictions", bundle2);
        }
        bundle3.putBundle("network", bundle5);
        bundle2 = new Bundle();
        bundle2.putBoolean("is_browser_custom_tabs_capable", zziv2.zzcgz);
        bundle3.putBundle("browser", bundle2);
        if (bundle != null) {
            bundle3.putBundle("android_mem_info", zziq.zzf(bundle));
        }
        hashMap.put("device", bundle3);
    }

    private static Bundle zzf(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        bundle2.putString("runtime_free", Long.toString(bundle.getLong("runtime_free_memory", -1L)));
        bundle2.putString("runtime_max", Long.toString(bundle.getLong("runtime_max_memory", -1L)));
        bundle2.putString("runtime_total", Long.toString(bundle.getLong("runtime_total_memory", -1L)));
        Debug.MemoryInfo memoryInfo = (Debug.MemoryInfo)bundle.getParcelable("debug_memory_info");
        if (memoryInfo != null) {
            bundle2.putString("debug_info_dalvik_private_dirty", Integer.toString(memoryInfo.dalvikPrivateDirty));
            bundle2.putString("debug_info_dalvik_pss", Integer.toString(memoryInfo.dalvikPss));
            bundle2.putString("debug_info_dalvik_shared_dirty", Integer.toString(memoryInfo.dalvikSharedDirty));
            bundle2.putString("debug_info_native_private_dirty", Integer.toString(memoryInfo.nativePrivateDirty));
            bundle2.putString("debug_info_native_pss", Integer.toString(memoryInfo.nativePss));
            bundle2.putString("debug_info_native_shared_dirty", Integer.toString(memoryInfo.nativeSharedDirty));
            bundle2.putString("debug_info_other_private_dirty", Integer.toString(memoryInfo.otherPrivateDirty));
            bundle2.putString("debug_info_other_pss", Integer.toString(memoryInfo.otherPss));
            bundle2.putString("debug_info_other_shared_dirty", Integer.toString(memoryInfo.otherSharedDirty));
        }
        return bundle2;
    }

    private static void zza(HashMap<String, Object> hashMap, Location location) {
        HashMap<String, Number> hashMap2 = new HashMap<String, Number>();
        Float f = Float.valueOf(location.getAccuracy() * 1000.0f);
        Long l = location.getTime() * 1000L;
        Long l2 = (long)(location.getLatitude() * 1.0E7);
        Long l3 = (long)(location.getLongitude() * 1.0E7);
        hashMap2.put("radius", f);
        hashMap2.put("lat", l2);
        hashMap2.put("long", l3);
        hashMap2.put("time", l);
        hashMap.put("uule", hashMap2);
    }

    private static void zza(HashMap<String, Object> hashMap, SearchAdRequestParcel searchAdRequestParcel) {
        String string2;
        String string3;
        if (Color.alpha((int)searchAdRequestParcel.zzawz) != 0) {
            hashMap.put("acolor", zziq.zzau(searchAdRequestParcel.zzawz));
        }
        if (Color.alpha((int)searchAdRequestParcel.backgroundColor) != 0) {
            hashMap.put("bgcolor", zziq.zzau(searchAdRequestParcel.backgroundColor));
        }
        if (Color.alpha((int)searchAdRequestParcel.zzaxa) != 0 && Color.alpha((int)searchAdRequestParcel.zzaxb) != 0) {
            hashMap.put("gradientto", zziq.zzau(searchAdRequestParcel.zzaxa));
            hashMap.put("gradientfrom", zziq.zzau(searchAdRequestParcel.zzaxb));
        }
        if (Color.alpha((int)searchAdRequestParcel.zzaxc) != 0) {
            hashMap.put("bcolor", zziq.zzau(searchAdRequestParcel.zzaxc));
        }
        hashMap.put("bthick", Integer.toString(searchAdRequestParcel.zzaxd));
        switch (searchAdRequestParcel.zzaxe) {
            case 0: {
                string3 = "none";
                break;
            }
            case 1: {
                string3 = "dashed";
                break;
            }
            case 2: {
                string3 = "dotted";
                break;
            }
            case 3: {
                string3 = "solid";
                break;
            }
            default: {
                string3 = null;
            }
        }
        if (string3 != null) {
            hashMap.put("btype", string3);
        }
        switch (searchAdRequestParcel.zzaxf) {
            case 2: {
                string2 = "dark";
                break;
            }
            case 0: {
                string2 = "light";
                break;
            }
            case 1: {
                string2 = "medium";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            hashMap.put("callbuttoncolor", string2);
        }
        if (searchAdRequestParcel.zzaxg != null) {
            hashMap.put("channel", searchAdRequestParcel.zzaxg);
        }
        if (Color.alpha((int)searchAdRequestParcel.zzaxh) != 0) {
            hashMap.put("dcolor", zziq.zzau(searchAdRequestParcel.zzaxh));
        }
        if (searchAdRequestParcel.zzaxi != null) {
            hashMap.put("font", searchAdRequestParcel.zzaxi);
        }
        if (Color.alpha((int)searchAdRequestParcel.zzaxj) != 0) {
            hashMap.put("hcolor", zziq.zzau(searchAdRequestParcel.zzaxj));
        }
        hashMap.put("headersize", Integer.toString(searchAdRequestParcel.zzaxk));
        if (searchAdRequestParcel.zzaxl != null) {
            hashMap.put("q", searchAdRequestParcel.zzaxl);
        }
    }

    private static Integer zzab(boolean bl) {
        return bl ? 1 : 0;
    }

    private static String zzau(int n) {
        return String.format(Locale.US, "#%06x", n & 0xFFFFFF);
    }

    private static String zzc(NativeAdOptionsParcel nativeAdOptionsParcel) {
        int n = nativeAdOptionsParcel != null ? nativeAdOptionsParcel.zzbgq : 0;
        switch (n) {
            case 1: {
                return "portrait";
            }
            case 2: {
                return "landscape";
            }
        }
        return "any";
    }

    public static AdResponseParcel zza(Context context, AdRequestInfoParcel adRequestInfoParcel, String string2) {
        try {
            List<String> list;
            List<String> list2;
            List<String> list3;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("ad_base_url", null);
            String string4 = jSONObject.optString("ad_url", null);
            String string5 = jSONObject.optString("ad_size", null);
            String string6 = jSONObject.optString("ad_slot_size", string5);
            boolean bl = adRequestInfoParcel != null && adRequestInfoParcel.zzcax != 0;
            String string7 = jSONObject.optString("ad_json", null);
            if (string7 == null) {
                string7 = jSONObject.optString("ad_html", null);
            }
            if (string7 == null) {
                string7 = jSONObject.optString("body", null);
            }
            long l = -1L;
            String string8 = jSONObject.optString("debug_dialog", null);
            long l2 = jSONObject.has("interstitial_timeout") ? (long)(jSONObject.getDouble("interstitial_timeout") * 1000.0) : -1L;
            String string9 = jSONObject.optString("orientation", null);
            int n = -1;
            if ("portrait".equals(string9)) {
                n = zzu.zzfs().zztk();
            } else if ("landscape".equals(string9)) {
                n = zzu.zzfs().zztj();
            }
            AdResponseParcel adResponseParcel = null;
            if (TextUtils.isEmpty((CharSequence)string7) && !TextUtils.isEmpty((CharSequence)string4)) {
                adResponseParcel = zzip.zza(adRequestInfoParcel, context, adRequestInfoParcel.zzaow.zzcs, string4, null, null, null, null);
                string3 = adResponseParcel.zzbto;
                string7 = adResponseParcel.body;
                l = adResponseParcel.zzccc;
            }
            if (string7 == null) {
                return new AdResponseParcel(0);
            }
            JSONArray jSONArray = jSONObject.optJSONArray("click_urls");
            List<String> list4 = list3 = adResponseParcel == null ? null : adResponseParcel.zzbnm;
            if (jSONArray != null) {
                list3 = zziq.zza(jSONArray, list3);
            }
            JSONArray jSONArray2 = jSONObject.optJSONArray("impression_urls");
            List<String> list5 = list2 = adResponseParcel == null ? null : adResponseParcel.zzbnn;
            if (jSONArray2 != null) {
                list2 = zziq.zza(jSONArray2, list2);
            }
            JSONArray jSONArray3 = jSONObject.optJSONArray("manual_impression_urls");
            List<String> list6 = list = adResponseParcel == null ? null : adResponseParcel.zzcca;
            if (jSONArray3 != null) {
                list = zziq.zza(jSONArray3, list);
            }
            if (adResponseParcel != null) {
                if (adResponseParcel.orientation != -1) {
                    n = adResponseParcel.orientation;
                }
                if (adResponseParcel.zzcbx > 0L) {
                    l2 = adResponseParcel.zzcbx;
                }
            }
            String string10 = jSONObject.optString("active_view");
            String string11 = null;
            boolean bl2 = jSONObject.optBoolean("ad_is_javascript", false);
            if (bl2) {
                string11 = jSONObject.optString("ad_passback_url", null);
            }
            boolean bl3 = jSONObject.optBoolean("mediation", false);
            boolean bl4 = jSONObject.optBoolean("custom_render_allowed", false);
            boolean bl5 = jSONObject.optBoolean("content_url_opted_out", true);
            boolean bl6 = jSONObject.optBoolean("prefetch", false);
            long l3 = jSONObject.optLong("refresh_interval_milliseconds", -1L);
            long l4 = jSONObject.optLong("mediation_config_cache_time_milliseconds", -1L);
            String string12 = jSONObject.optString("gws_query_id", "");
            boolean bl7 = "height".equals(jSONObject.optString("fluid", ""));
            boolean bl8 = jSONObject.optBoolean("native_express", false);
            List<String> list7 = zziq.zza(jSONObject.optJSONArray("video_start_urls"), null);
            List<String> list8 = zziq.zza(jSONObject.optJSONArray("video_complete_urls"), null);
            RewardItemParcel rewardItemParcel = RewardItemParcel.zza((JSONArray)jSONObject.optJSONArray("rewards"));
            boolean bl9 = jSONObject.optBoolean("use_displayed_impression", false);
            AutoClickProtectionConfigurationParcel autoClickProtectionConfigurationParcel = AutoClickProtectionConfigurationParcel.zzh(jSONObject.optJSONObject("auto_protection_configuration"));
            String string13 = jSONObject.optString("set_cookie", "");
            List<String> list9 = zziq.zza(jSONObject.optJSONArray("remote_ping_urls"), null);
            String string14 = jSONObject.optString("safe_browsing");
            boolean bl10 = jSONObject.optBoolean("render_in_browser", adRequestInfoParcel.zzbnq);
            return new AdResponseParcel(adRequestInfoParcel, string3, string7, list3, list2, l2, bl3, l4, list, l3, n, string5, l, string8, bl2, string11, string10, bl4, bl, adRequestInfoParcel.zzcaz, bl5, bl6, string12, bl7, bl8, rewardItemParcel, list7, list8, bl9, autoClickProtectionConfigurationParcel, adRequestInfoParcel.zzcbq, string13, list9, string14, bl10, string6);
        }
        catch (JSONException jSONException) {
            String string15 = String.valueOf(jSONException.getMessage());
            zzkd.zzcx((String)(string15.length() != 0 ? "Could not parse the inline ad response: ".concat(string15) : new String("Could not parse the inline ad response: ")));
            return new AdResponseParcel(0);
        }
    }

    @Nullable
    private static List<String> zza(@Nullable JSONArray jSONArray, @Nullable List<String> list) throws JSONException {
        if (jSONArray == null) {
            return null;
        }
        if (list == null) {
            list = new LinkedList<String>();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            list.add(jSONArray.getString(i));
        }
        return list;
    }

    public static JSONObject zzc(AdResponseParcel adResponseParcel) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (adResponseParcel.zzbto != null) {
            jSONObject.put("ad_base_url", (Object)adResponseParcel.zzbto);
        }
        if (adResponseParcel.zzccb != null) {
            jSONObject.put("ad_size", (Object)adResponseParcel.zzccb);
        }
        jSONObject.put("native", adResponseParcel.zzauu);
        if (adResponseParcel.zzauu) {
            jSONObject.put("ad_json", (Object)adResponseParcel.body);
        } else {
            jSONObject.put("ad_html", (Object)adResponseParcel.body);
        }
        if (adResponseParcel.zzccd != null) {
            jSONObject.put("debug_dialog", (Object)adResponseParcel.zzccd);
        }
        if (adResponseParcel.zzcbx != -1L) {
            jSONObject.put("interstitial_timeout", (double)adResponseParcel.zzcbx / 1000.0);
        }
        if (adResponseParcel.orientation == zzu.zzfs().zztk()) {
            jSONObject.put("orientation", (Object)"portrait");
        } else if (adResponseParcel.orientation == zzu.zzfs().zztj()) {
            jSONObject.put("orientation", (Object)"landscape");
        }
        if (adResponseParcel.zzbnm != null) {
            jSONObject.put("click_urls", (Object)zziq.zzk(adResponseParcel.zzbnm));
        }
        if (adResponseParcel.zzbnn != null) {
            jSONObject.put("impression_urls", (Object)zziq.zzk(adResponseParcel.zzbnn));
        }
        if (adResponseParcel.zzcca != null) {
            jSONObject.put("manual_impression_urls", (Object)zziq.zzk(adResponseParcel.zzcca));
        }
        if (adResponseParcel.zzccg != null) {
            jSONObject.put("active_view", (Object)adResponseParcel.zzccg);
        }
        jSONObject.put("ad_is_javascript", adResponseParcel.zzcce);
        if (adResponseParcel.zzccf != null) {
            jSONObject.put("ad_passback_url", (Object)adResponseParcel.zzccf);
        }
        jSONObject.put("mediation", adResponseParcel.zzcby);
        jSONObject.put("custom_render_allowed", adResponseParcel.zzcch);
        jSONObject.put("content_url_opted_out", adResponseParcel.zzcci);
        jSONObject.put("prefetch", adResponseParcel.zzccj);
        if (adResponseParcel.zzbns != -1L) {
            jSONObject.put("refresh_interval_milliseconds", adResponseParcel.zzbns);
        }
        if (adResponseParcel.zzcbz != -1L) {
            jSONObject.put("mediation_config_cache_time_milliseconds", adResponseParcel.zzcbz);
        }
        if (!TextUtils.isEmpty((CharSequence)adResponseParcel.zzccm)) {
            jSONObject.put("gws_query_id", (Object)adResponseParcel.zzccm);
        }
        jSONObject.put("fluid", (Object)(adResponseParcel.zzauv ? "height" : ""));
        jSONObject.put("native_express", adResponseParcel.zzauw);
        if (adResponseParcel.zzcco != null) {
            jSONObject.put("video_start_urls", (Object)zziq.zzk(adResponseParcel.zzcco));
        }
        if (adResponseParcel.zzccp != null) {
            jSONObject.put("video_complete_urls", (Object)zziq.zzk(adResponseParcel.zzccp));
        }
        if (adResponseParcel.zzccn != null) {
            jSONObject.put("rewards", (Object)adResponseParcel.zzccn.zzrw());
        }
        jSONObject.put("use_displayed_impression", adResponseParcel.zzccq);
        jSONObject.put("auto_protection_configuration", (Object)adResponseParcel.zzccr);
        jSONObject.put("render_in_browser", adResponseParcel.zzbnq);
        return jSONObject;
    }

    @Nullable
    static JSONArray zzk(List<String> list) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (String string2 : list) {
            jSONArray.put((Object)string2);
        }
        return jSONArray;
    }
}

