/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.webkit.CookieManager;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzap;
import com.google.android.gms.internal.zzau;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzgh;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzkm;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkq;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzkt;
import com.google.android.gms.internal.zzlm;
import com.google.android.gms.internal.zzln;
import org.json.JSONException;
import org.json.JSONObject;

@zziy
public class zzb
extends zzkm
implements zzc.zza {
    private final zza.zza zzcfh;
    private final AdRequestInfoParcel.zza zzcfi;
    private final Object zzccn = new Object();
    private final Context mContext;
    private final zzau zzbkp;
    private AdRequestInfoParcel zzbtk;
    private Runnable zzccm;
    zzkt zzcfj;
    AdResponseParcel zzccl;
    zzgh zzbsv;

    public zzb(Context context, AdRequestInfoParcel.zza zza2, zzau zzau2, zza.zza zza3) {
        this.zzcfh = zza3;
        this.mContext = context;
        this.zzcfi = zza2;
        this.zzbkp = zzau2;
    }

    zzkt zza(VersionInfoParcel versionInfoParcel, zzlm<AdRequestInfoParcel> zzlm2) {
        return zzc.zza(this.mContext, versionInfoParcel, zzlm2, this);
    }

    @Override
    public void zzfc() {
        zzkn.zzdd((String)"AdLoaderBackgroundTask started.");
        this.zzccm = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzb.this.zzccn;
                synchronized (object) {
                    if (zzb.this.zzcfj == null) {
                        return;
                    }
                    zzb.this.onStop();
                    zzb.this.zzd(2, "Timed out waiting for ad response.");
                }
            }
        };
        zzkr.zzcrf.postDelayed(this.zzccm, zzdi.zzbek.get().longValue());
        final zzln<AdRequestInfoParcel> zzln2 = new zzln<AdRequestInfoParcel>();
        long l = zzu.zzgf().elapsedRealtime();
        zzkq.zza(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzb.this.zzccn;
                synchronized (object) {
                    zzb.this.zzcfj = zzb.this.zza(((zzb)zzb.this).zzcfi.zzaqv, zzln2);
                    if (zzb.this.zzcfj == null) {
                        zzb.this.zzd(0, "Could not start the ad request service.");
                        zzkr.zzcrf.removeCallbacks(zzb.this.zzccm);
                    }
                }
            }
        });
        zzap zzap2 = this.zzbkp.zzaw();
        String string2 = zzap2.zzb(this.mContext);
        this.zzbtk = new AdRequestInfoParcel(this.zzcfi, string2, l);
        zzln2.zzg(this.zzbtk);
    }

    private void zzd(int n, String string2) {
        if (n == 3 || n == -1) {
            zzkn.zzde((String)string2);
        } else {
            zzkn.zzdf((String)string2);
        }
        this.zzccl = this.zzccl == null ? new AdResponseParcel(n) : new AdResponseParcel(n, this.zzccl.zzbsj);
        AdRequestInfoParcel adRequestInfoParcel = this.zzbtk != null ? this.zzbtk : new AdRequestInfoParcel(this.zzcfi, null, -1L);
        zzke.zza zza2 = new zzke.zza(adRequestInfoParcel, this.zzccl, this.zzbsv, null, n, -1L, this.zzccl.zzchg, null);
        this.zzcfh.zza(zza2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(@NonNull AdResponseParcel adResponseParcel) {
        zzkn.zzdd((String)"Received ad response.");
        this.zzccl = adResponseParcel;
        long l = zzu.zzgf().elapsedRealtime();
        Object object = this.zzccn;
        synchronized (object) {
            this.zzcfj = null;
        }
        zzu.zzgd().zzd(this.mContext, this.zzccl.zzcgt);
        object = null;
        try {
            if (this.zzccl.errorCode != -2 && this.zzccl.errorCode != -3) {
                int n = this.zzccl.errorCode;
                throw new zza(new StringBuilder(66).append("There was a problem getting an ad response. ErrorCode: ").append(n).toString(), this.zzccl.errorCode);
            }
            this.zzru();
            if (this.zzbtk.zzaqz.zzaxk != null) {
                object = this.zzb(this.zzbtk);
            }
        }
        catch (zza zza2) {
            this.zzd(zza2.getErrorCode(), zza2.getMessage());
            zzkr.zzcrf.removeCallbacks(this.zzccm);
            return;
        }
        zzu.zzgd().zzaf(this.zzccl.zzchm);
        JSONObject jSONObject = null;
        if (!TextUtils.isEmpty((CharSequence)this.zzccl.zzchk)) {
            try {
                jSONObject = new JSONObject(this.zzccl.zzchk);
            }
            catch (Exception exception) {
                zzkn.zzb((String)"Error parsing the JSON for Active View.", (Throwable)exception);
            }
        }
        zzke.zza zza3 = new zzke.zza(this.zzbtk, this.zzccl, this.zzbsv, (AdSizeParcel)object, -2, l, this.zzccl.zzchg, jSONObject);
        this.zzcfh.zza(zza3);
        zzkr.zzcrf.removeCallbacks(this.zzccm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzccn;
        synchronized (object) {
            if (this.zzcfj != null) {
                this.zzcfj.cancel();
            }
        }
    }

    protected void zzru() throws zza {
        if (this.zzccl.errorCode == -3) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzccl.body)) {
            throw new zza("No fill from ad server.", 3);
        }
        zzu.zzgd().zzc(this.mContext, this.zzccl.zzcgc);
        if (this.zzccl.zzchc) {
            try {
                this.zzbsv = new zzgh(this.zzccl.body);
                zzu.zzgd().zzag(this.zzbsv.zzbsh);
            }
            catch (JSONException jSONException) {
                zzkn.zzb((String)"Could not parse mediation config.", (Throwable)jSONException);
                String string2 = String.valueOf(this.zzccl.body);
                throw new zza(string2.length() != 0 ? "Could not parse mediation config: ".concat(string2) : new String("Could not parse mediation config: "), 0);
            }
        } else {
            zzu.zzgd().zzag(this.zzccl.zzbsh);
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzccl.zzcgu) && zzdi.zzbhh.get().booleanValue()) {
            zzkn.zzdd((String)"Received cookie from server. Setting webview cookie in CookieManager.");
            CookieManager cookieManager = zzu.zzgb().zzao(this.mContext);
            if (cookieManager != null) {
                cookieManager.setCookie("googleads.g.doubleclick.net", this.zzccl.zzcgu);
            }
        }
    }

    protected AdSizeParcel zzb(AdRequestInfoParcel adRequestInfoParcel) throws zza {
        int n;
        int n2;
        if (this.zzccl.zzaxm) {
            for (AdSizeParcel adSizeParcelArray : adRequestInfoParcel.zzaqz.zzaxk) {
                if (!adSizeParcelArray.zzaxm) continue;
                return new AdSizeParcel(adSizeParcelArray, adRequestInfoParcel.zzaqz.zzaxk);
            }
        }
        if (this.zzccl.zzchf == null) {
            throw new zza("The ad response must specify one of the supported ad sizes.", 0);
        }
        String[] stringArray = this.zzccl.zzchf.split("x");
        if (stringArray.length != 2) {
            String string2 = String.valueOf(this.zzccl.zzchf);
            throw new zza(string2.length() != 0 ? "Invalid ad size format from the ad response: ".concat(string2) : new String("Invalid ad size format from the ad response: "), 0);
        }
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = String.valueOf(this.zzccl.zzchf);
            throw new zza(string3.length() != 0 ? "Invalid ad size number from the ad response: ".concat(string3) : new String("Invalid ad size number from the ad response: "), 0);
        }
        for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzaqz.zzaxk) {
            int n3;
            float f = this.mContext.getResources().getDisplayMetrics().density;
            int n4 = adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / f) : adSizeParcel.width;
            int n5 = n3 = adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / f) : adSizeParcel.height;
            if (n2 != n4 || n != n3 || adSizeParcel.zzaxm) continue;
            return new AdSizeParcel(adSizeParcel, adRequestInfoParcel.zzaqz.zzaxk);
        }
        String string4 = String.valueOf(this.zzccl.zzchf);
        throw new zza(string4.length() != 0 ? "The ad size from the ad response was not one of the requested sizes: ".concat(string4) : new String("The ad size from the ad response was not one of the requested sizes: "), 0);
    }

    @zziy
    static final class zza
    extends Exception {
        private final int zzcdb;

        public zza(String string2, int n) {
            super(string2);
            this.zzcdb = n;
        }

        public int getErrorCode() {
            return this.zzcdb;
        }
    }
}

