/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.internal.zzhm;
import com.google.android.gms.internal.zzhn;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzlt;
import java.util.Map;
import java.util.Set;

@zziy
public class zzhh
extends zzhm {
    static final Set<String> zzbuv = zzf.zzc((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzbuw = "top-right";
    private boolean zzbux = true;
    private int zzbuy = 0;
    private int zzbuz = 0;
    private int zzajx = -1;
    private int zzbva = 0;
    private int zzbvb = 0;
    private int zzajw = -1;
    private final Object zzakd = new Object();
    private final zzlt zzbkr;
    private final Activity zzbul;
    private AdSizeParcel zzapc;
    private ImageView zzbvc;
    private LinearLayout zzbvd;
    private zzhn zzbve;
    private PopupWindow zzbvf;
    private RelativeLayout zzbvg;
    private ViewGroup zzbvh;

    public zzhh(zzlt zzlt2, zzhn zzhn2) {
        super(zzlt2, "resize");
        this.zzbkr = zzlt2;
        this.zzbul = zzlt2.zzvn();
        this.zzbve = zzhn2;
    }

    private void zzi(Map<String, String> map) {
        String string2;
        if (!TextUtils.isEmpty((CharSequence)map.get("width"))) {
            this.zzajw = zzu.zzfz().zzcw(map.get("width"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("height"))) {
            this.zzajx = zzu.zzfz().zzcw(map.get("height"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetX"))) {
            this.zzbva = zzu.zzfz().zzcw(map.get("offsetX"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetY"))) {
            this.zzbvb = zzu.zzfz().zzcw(map.get("offsetY"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("allowOffscreen"))) {
            this.zzbux = Boolean.parseBoolean(map.get("allowOffscreen"));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = map.get("customClosePosition")))) {
            this.zzbuw = string2;
        }
    }

    boolean zzns() {
        return this.zzajw > -1 && this.zzajx > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map<String, String> map) {
        Object object = this.zzakd;
        synchronized (object) {
            Bitmap bitmap;
            if (this.zzbul == null) {
                this.zzbx("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzbkr.zzdt() == null) {
                this.zzbx("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzbkr.zzdt().zzaxj) {
                this.zzbx("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzbkr.zzvv()) {
                this.zzbx("Cannot resize an expanded banner.");
                return;
            }
            this.zzi(map);
            if (!this.zzns()) {
                this.zzbx("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzbul.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzbx("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zznt();
            if (nArray == null) {
                this.zzbx("Resize location out of screen or close button is not visible.");
                return;
            }
            int n = zzm.zzjr().zzb((Context)this.zzbul, this.zzajw);
            int n2 = zzm.zzjr().zzb((Context)this.zzbul, this.zzajx);
            ViewParent viewParent = this.zzbkr.getView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.zzbkr.getView());
                if (this.zzbvf == null) {
                    this.zzbvh = (ViewGroup)viewParent;
                    bitmap = zzu.zzfz().zzk(this.zzbkr.getView());
                    this.zzbvc = new ImageView((Context)this.zzbul);
                    this.zzbvc.setImageBitmap(bitmap);
                    this.zzapc = this.zzbkr.zzdt();
                    this.zzbvh.addView((View)this.zzbvc);
                } else {
                    this.zzbvf.dismiss();
                }
            } else {
                this.zzbx("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzbvg = new RelativeLayout((Context)this.zzbul);
            this.zzbvg.setBackgroundColor(0);
            this.zzbvg.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            this.zzbvf = zzu.zzfz().zza((View)this.zzbvg, n, n2, false);
            this.zzbvf.setOutsideTouchable(true);
            this.zzbvf.setTouchable(true);
            this.zzbvf.setClippingEnabled(!this.zzbux);
            this.zzbvg.addView(this.zzbkr.getView(), -1, -1);
            this.zzbvd = new LinearLayout((Context)this.zzbul);
            bitmap = new RelativeLayout.LayoutParams(zzm.zzjr().zzb((Context)this.zzbul, 50), zzm.zzjr().zzb((Context)this.zzbul, 50));
            switch (this.zzbuw) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzbvd.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    zzhh.this.zzt(true);
                }
            });
            this.zzbvd.setContentDescription((CharSequence)"Close button");
            this.zzbvg.addView((View)this.zzbvd, (ViewGroup.LayoutParams)bitmap);
            try {
                this.zzbvf.showAtLocation(window.getDecorView(), 0, zzm.zzjr().zzb((Context)this.zzbul, nArray[0]), zzm.zzjr().zzb((Context)this.zzbul, nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(runtimeException.getMessage());
                this.zzbx(string2.length() != 0 ? "Cannot show popup window: ".concat(string2) : new String("Cannot show popup window: "));
                this.zzbvg.removeView(this.zzbkr.getView());
                if (this.zzbvh != null) {
                    this.zzbvh.removeView((View)this.zzbvc);
                    this.zzbvh.addView(this.zzbkr.getView());
                    this.zzbkr.zza(this.zzapc);
                }
                return;
            }
            this.zzb(nArray[0], nArray[1]);
            this.zzbkr.zza(new AdSizeParcel((Context)this.zzbul, new AdSize(this.zzajw, this.zzajx)));
            this.zzc(nArray[0], nArray[1]);
            this.zzbz("resized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzt(boolean bl) {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.zzbvf != null) {
                this.zzbvf.dismiss();
                this.zzbvg.removeView(this.zzbkr.getView());
                if (this.zzbvh != null) {
                    this.zzbvh.removeView((View)this.zzbvc);
                    this.zzbvh.addView(this.zzbkr.getView());
                    this.zzbkr.zza(this.zzapc);
                }
                if (bl) {
                    this.zzbz("default");
                    if (this.zzbve != null) {
                        this.zzbve.zzep();
                    }
                }
                this.zzbvf = null;
                this.zzbvg = null;
                this.zzbvh = null;
                this.zzbvd = null;
            }
        }
    }

    private int[] zznt() {
        if (!this.zznv()) {
            return null;
        }
        if (this.zzbux) {
            return new int[]{this.zzbuy + this.zzbva, this.zzbuz + this.zzbvb};
        }
        int[] nArray = zzu.zzfz().zzi(this.zzbul);
        int[] nArray2 = zzu.zzfz().zzk(this.zzbul);
        int n = nArray[0];
        int n2 = this.zzbuy + this.zzbva;
        int n3 = this.zzbuz + this.zzbvb;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 + this.zzajw > n) {
            n2 = n - this.zzajw;
        }
        if (n3 < nArray2[0]) {
            n3 = nArray2[0];
        } else if (n3 + this.zzajx > nArray2[1]) {
            n3 = nArray2[1] - this.zzajx;
        }
        return new int[]{n2, n3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(int n, int n2, boolean bl) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzbuy = n;
            this.zzbuz = n2;
            if (this.zzbvf != null && bl) {
                int[] nArray = this.zznt();
                if (nArray != null) {
                    this.zzbvf.update(zzm.zzjr().zzb((Context)this.zzbul, nArray[0]), zzm.zzjr().zzb((Context)this.zzbul, nArray[1]), this.zzbvf.getWidth(), this.zzbvf.getHeight());
                    this.zzc(nArray[0], nArray[1]);
                } else {
                    this.zzt(true);
                }
            }
        }
    }

    void zzb(int n, int n2) {
        if (this.zzbve != null) {
            this.zzbve.zza(n, n2, this.zzajw, this.zzajx);
        }
    }

    void zzc(int n, int n2) {
        int n3 = zzu.zzfz().zzk(this.zzbul)[0];
        this.zzb(n, n2 - n3, this.zzajw, this.zzajx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zznu() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.zzbvf != null;
        }
    }

    public void zzd(int n, int n2) {
        this.zzbuy = n;
        this.zzbuz = n2;
    }

    boolean zznv() {
        int[] nArray = zzu.zzfz().zzi(this.zzbul);
        int[] nArray2 = zzu.zzfz().zzk(this.zzbul);
        int n = nArray[0];
        int n2 = nArray[1];
        if (this.zzajw < 50 || this.zzajw > n) {
            zzkn.zzdf((String)"Width is too small or too large.");
            return false;
        }
        if (this.zzajx < 50 || this.zzajx > n2) {
            zzkn.zzdf((String)"Height is too small or too large.");
            return false;
        }
        if (this.zzajx == n2 && this.zzajw == n) {
            zzkn.zzdf((String)"Cannot resize to a full-screen ad.");
            return false;
        }
        if (this.zzbux) {
            int n3 = -1;
            int n4 = -2;
            switch (this.zzbuw) {
                case "top-left": {
                    n3 = this.zzbuy + this.zzbva;
                    n4 = this.zzbuz + this.zzbvb;
                    break;
                }
                case "top-center": {
                    n3 = this.zzbuy + this.zzbva + this.zzajw / 2 - 25;
                    n4 = this.zzbuz + this.zzbvb;
                    break;
                }
                case "center": {
                    n3 = this.zzbuy + this.zzbva + this.zzajw / 2 - 25;
                    n4 = this.zzbuz + this.zzbvb + this.zzajx / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n3 = this.zzbuy + this.zzbva;
                    n4 = this.zzbuz + this.zzbvb + this.zzajx - 50;
                    break;
                }
                case "bottom-center": {
                    n3 = this.zzbuy + this.zzbva + this.zzajw / 2 - 25;
                    n4 = this.zzbuz + this.zzbvb + this.zzajx - 50;
                    break;
                }
                case "bottom-right": {
                    n3 = this.zzbuy + this.zzbva + this.zzajw - 50;
                    n4 = this.zzbuz + this.zzbvb + this.zzajx - 50;
                    break;
                }
                default: {
                    n3 = this.zzbuy + this.zzbva + this.zzajw - 50;
                    n4 = this.zzbuz + this.zzbvb;
                }
            }
            if (n3 < 0 || n3 + 50 > n || n4 < nArray2[0] || n4 + 50 > nArray2[1]) {
                return false;
            }
        }
        return true;
    }
}

