/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzdq;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzlt;
import java.util.HashMap;

@zziy
public class zzk
extends FrameLayout
implements zzh {
    private final zzlt zzbkr;
    private final FrameLayout zzbyr;
    private final zzy zzbys;
    @Nullable
    private zzi zzbyt;
    private boolean zzbyu;
    private boolean zzbyv;
    private long zzbyw;
    private long zzbyx;
    private String zzbnt;

    public static void zzi(zzlt zzlt2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzlt2.zza("onVideoEvent", hashMap);
    }

    public zzk(Context context, zzlt zzlt2, int n, boolean bl, zzdq zzdq2) {
        super(context);
        this.zzbkr = zzlt2;
        this.zzbyr = new FrameLayout(context);
        this.addView((View)this.zzbyr, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzc.zzu((Object)zzlt2.zzdp());
        this.zzbyt = zzlt2.zzdp().zzamd.zza(context, zzlt2, n, bl, zzdq2);
        if (this.zzbyt != null) {
            this.zzbyr.addView((View)this.zzbyt, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            if (zzdi.zzbbo.get().booleanValue()) {
                this.zzpn();
            }
        }
        this.zzbys = new zzy(this);
        this.zzbys.zzqh();
        if (this.zzbyt != null) {
            this.zzbyt.zza(this);
        }
        if (this.zzbyt == null) {
            this.zzl("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzbyr.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public void zzca(String string2) {
        this.zzbnt = string2;
    }

    public void zza(float f, float f2) {
        if (this.zzbyt != null) {
            this.zzbyt.zza(f, f2);
        }
    }

    public void zzmt() {
        if (this.zzbyt == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzbnt)) {
            this.zzbyt.setVideoPath(this.zzbnt);
        } else {
            this.zza("no_src", new String[0]);
        }
    }

    public void pause() {
        if (this.zzbyt == null) {
            return;
        }
        this.zzbyt.pause();
    }

    public void play() {
        if (this.zzbyt == null) {
            return;
        }
        this.zzbyt.play();
    }

    public void seekTo(int n) {
        if (this.zzbyt == null) {
            return;
        }
        this.zzbyt.seekTo(n);
    }

    public void zzom() {
        if (this.zzbyt == null) {
            return;
        }
        this.zzbyt.zzom();
    }

    public void zzon() {
        if (this.zzbyt == null) {
            return;
        }
        this.zzbyt.zzon();
    }

    public void zza(float f) {
        if (this.zzbyt == null) {
            return;
        }
        this.zzbyt.zza(f);
    }

    @TargetApi(value=14)
    public void zzf(MotionEvent motionEvent) {
        if (this.zzbyt == null) {
            return;
        }
        this.zzbyt.dispatchTouchEvent(motionEvent);
    }

    @TargetApi(value=14)
    public void zzpn() {
        if (this.zzbyt == null) {
            return;
        }
        Context context = this.zzbyt.getContext();
        TextView textView = new TextView(context);
        String string2 = String.valueOf(this.zzbyt.zzog());
        textView.setText((CharSequence)(string2.length() != 0 ? "AdMob - ".concat(string2) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzbyr.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzbyr.bringChildToFront((View)textView);
    }

    @Override
    public void zzpi() {
        zzkr.zzcrf.post(new Runnable(){

            @Override
            public void run() {
                zzk.this.zza("surfaceCreated", new String[0]);
            }
        });
    }

    @Override
    public void zzpj() {
        if (this.zzbyt == null) {
            return;
        }
        if (this.zzbyx == 0L) {
            float f = (float)this.zzbyt.getDuration() / 1000.0f;
            int n = this.zzbyt.getVideoWidth();
            int n2 = this.zzbyt.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public void zzpk() {
        this.zzpp();
    }

    @Override
    public void onPaused() {
        this.zza("pause", new String[0]);
        this.zzpq();
    }

    @Override
    public void zzpl() {
        this.zza("ended", new String[0]);
        this.zzpq();
    }

    @Override
    public void zzl(String string2, @Nullable String string3) {
        this.zza("error", "what", string2, "extra", string3);
    }

    @Override
    public void zzpm() {
        this.zzbyx = this.zzbyw;
        zzkr.zzcrf.post(new Runnable(){

            @Override
            public void run() {
                zzk.this.zza("surfaceDestroyed", new String[0]);
            }
        });
    }

    public void destroy() {
        this.zzbys.cancel();
        if (this.zzbyt != null) {
            this.zzbyt.stop();
        }
        this.zzpq();
    }

    void zzpo() {
        if (this.zzbyt == null) {
            return;
        }
        long l = this.zzbyt.getCurrentPosition();
        if (this.zzbyw != l && l > 0L) {
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzbyw = l;
        }
    }

    private void zza(String string2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string2);
        String string3 = null;
        for (String string4 : stringArray) {
            if (string3 == null) {
                string3 = string4;
                continue;
            }
            hashMap.put(string3, string4);
            string3 = null;
        }
        this.zzbkr.zza("onVideoEvent", hashMap);
    }

    private void zzpp() {
        if (this.zzbkr.zzvn() == null) {
            return;
        }
        if (this.zzbyu) {
            return;
        }
        WindowManager.LayoutParams layoutParams = this.zzbkr.zzvn().getWindow().getAttributes();
        boolean bl = this.zzbyv = (layoutParams.flags & 0x80) != 0;
        if (!this.zzbyv) {
            this.zzbkr.zzvn().getWindow().addFlags(128);
            this.zzbyu = true;
        }
    }

    private void zzpq() {
        if (this.zzbkr.zzvn() == null) {
            return;
        }
        if (this.zzbyu && !this.zzbyv) {
            this.zzbkr.zzvn().getWindow().clearFlags(128);
            this.zzbyu = false;
        }
    }
}

