/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.formats.zzg;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzau;
import com.google.android.gms.internal.zzcj;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzdm;
import com.google.android.gms.internal.zzdo;
import com.google.android.gms.internal.zzdp;
import com.google.android.gms.internal.zzdq;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzfj;
import com.google.android.gms.internal.zzhm;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzlf;
import com.google.android.gms.internal.zzls;
import com.google.android.gms.internal.zzlt;
import com.google.android.gms.internal.zzlu;
import com.google.android.gms.internal.zzly;
import com.google.android.gms.internal.zzlz;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zziy
class zzlx
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzlt {
    private final zza zzcvp;
    private final Object zzakd = new Object();
    @Nullable
    private final zzau zzbkp;
    private final VersionInfoParcel zzanh;
    private final com.google.android.gms.ads.internal.zzs zzcvq;
    private final zzd zzalo;
    private zzlu zzcvr;
    private com.google.android.gms.ads.internal.overlay.zzd zzcvs;
    private AdSizeParcel zzapc;
    private boolean zzcvt;
    private boolean zzcvu;
    private boolean zzcvv;
    private boolean zzcvw;
    private Boolean zzcpv;
    private int zzcvx;
    private boolean zzcvy = true;
    boolean zzcvz = false;
    private String zzcaj = "";
    private zzly zzcwa;
    private boolean zzcwb;
    private boolean zzcwc;
    private zzg zzcwd;
    private int zzcwe;
    private int zzcwf;
    private zzdo zzcwg;
    private zzdo zzcak;
    private zzdo zzcwh;
    private zzdp zzcwi;
    private WeakReference<View.OnClickListener> zzcwj;
    private com.google.android.gms.ads.internal.overlay.zzd zzcwk;
    private zzlf zzasf;
    private int zzbvx = -1;
    private int zzbvw = -1;
    private int zzbvz = -1;
    private int zzbwa = -1;
    private Map<String, zzfj> zzcwl;
    private final WindowManager zzasl;

    static zzlx zzb(Context context, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, @Nullable zzau zzau2, VersionInfoParcel versionInfoParcel, zzdq zzdq2, com.google.android.gms.ads.internal.zzs zzs2, zzd zzd2) {
        zza zza2 = new zza(context);
        return new zzlx(zza2, adSizeParcel, bl, bl2, zzau2, versionInfoParcel, zzdq2, zzs2, zzd2);
    }

    protected zzlx(zza zza2, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, @Nullable zzau zzau2, VersionInfoParcel versionInfoParcel, zzdq zzdq2, com.google.android.gms.ads.internal.zzs zzs2, zzd zzd2) {
        super((Context)zza2);
        this.zzcvp = zza2;
        this.zzapc = adSizeParcel;
        this.zzcvv = bl;
        this.zzcvx = -1;
        this.zzbkp = zzau2;
        this.zzanh = versionInfoParcel;
        this.zzcvq = zzs2;
        this.zzalo = zzd2;
        this.zzasl = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        zzu.zzfz().zza((Context)zza2, versionInfoParcel.zzcs, webSettings);
        zzu.zzgb().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzxa();
        if (zzs.zzaxp()) {
            this.addJavascriptInterface(new zzlz(this), "googleAdsJsInterface");
        }
        if (zzs.zzaxk()) {
            this.removeJavascriptInterface("accessibility");
            this.removeJavascriptInterface("accessibilityTraversal");
        }
        this.zzasf = new zzlf(this.zzcvp.zzvn(), (View)this, this, null);
        this.zzd(zzdq2);
    }

    @Override
    public void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzlu) {
            this.zzcvr = (zzlu)webViewClient;
        }
    }

    @Override
    public WebView getWebView() {
        return this;
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public zzd zzdp() {
        return this.zzalo;
    }

    public boolean zzwv() {
        int n;
        int n2;
        if (!this.zzvr().zzib() && !this.zzvr().zzwj()) {
            return false;
        }
        DisplayMetrics displayMetrics = zzu.zzfz().zza(this.zzasl);
        int n3 = zzm.zzjr().zzb(displayMetrics, displayMetrics.widthPixels);
        int n4 = zzm.zzjr().zzb(displayMetrics, displayMetrics.heightPixels);
        Activity activity = this.zzvn();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            int[] nArray = zzu.zzfz().zzh(activity);
            n2 = zzm.zzjr().zzb(displayMetrics, nArray[0]);
            n = zzm.zzjr().zzb(displayMetrics, nArray[1]);
        }
        if (this.zzbvw == n3 && this.zzbvx == n4 && this.zzbvz == n2 && this.zzbwa == n) {
            return false;
        }
        boolean bl = this.zzbvw != n3 || this.zzbvx != n4;
        this.zzbvw = n3;
        this.zzbvx = n4;
        this.zzbvz = n2;
        this.zzbwa = n;
        new zzhm(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzasl.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzu.zzfz().zzan(map);
        }
        catch (JSONException jSONException) {
            zzkn.zzdf((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zzb(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    public void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzkn.zzdf((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(string2, valueCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzdj(String string2) {
        Object object = this.zzakd;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzkn.zzdf((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadUrl(String string2) {
        Object object = this.zzakd;
        synchronized (object) {
            if (!this.isDestroyed()) {
                try {
                    super.loadUrl(string2);
                }
                catch (Throwable throwable) {
                    String string3 = String.valueOf(throwable);
                    zzkn.zzdf((String)new StringBuilder(24 + String.valueOf(string3).length()).append("Could not call loadUrl. ").append(string3).toString());
                }
            } else {
                zzkn.zzdf((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzdg(String string2) {
        Object object = this.zzakd;
        synchronized (object) {
            try {
                super.loadUrl(string2);
            }
            catch (Throwable throwable) {
                String string3 = String.valueOf(throwable);
                zzkn.zzdf((String)new StringBuilder(24 + String.valueOf(string3).length()).append("Could not call loadUrl. ").append(string3).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(String string2, String string3, String string4) {
        Object object = this.zzakd;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(string2, string3, string4);
            } else {
                zzkn.zzdf((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        Object object = this.zzakd;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            } else {
                zzkn.zzdf((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    protected void zza(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzakd;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.evaluateJavascript(string2, valueCallback);
            } else {
                zzkn.zzdf((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
            }
        }
    }

    protected void zzdk(String string2) {
        if (zzs.zzaxr()) {
            if (this.zztr() == null) {
                this.zzww();
            }
            if (this.zztr().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
            } else {
                String string3 = String.valueOf(string2);
                this.zzdj(string3.length() != 0 ? "javascript:".concat(string3) : new String("javascript:"));
            }
        } else {
            String string4 = String.valueOf(string2);
            this.zzdj(string4.length() != 0 ? "javascript:".concat(string4) : new String("javascript:"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzww() {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzcpv = zzu.zzgd().zztr();
            if (this.zzcpv == null) {
                try {
                    String string2 = "(function(){})()";
                    this.evaluateJavascript(string2, null);
                    this.zzb(true);
                }
                catch (IllegalStateException illegalStateException) {
                    this.zzb(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzb(Boolean bl) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzcpv = bl;
        }
        zzu.zzgd().zzb(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean zztr() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.zzcpv;
        }
    }

    @Override
    public void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        this.zzj(string2, string3);
    }

    @Override
    public void zzj(String string2, String string3) {
        String string4 = new StringBuilder(3 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("(").append(string3).append(");").toString();
        this.zzdk(string4);
    }

    @Override
    public void zzb(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(window.AFMA_ReceiveMessage || function() {})('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzkn.zzdd((String)(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: ")));
        this.zzdk(stringBuilder.toString());
    }

    @Override
    public void zzvl() {
        this.zzwx();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzanh.zzcs);
        this.zza("onhide", hashMap);
    }

    @Override
    public void zzah(int n) {
        if (n == 0) {
            this.zzwy();
        }
        this.zzwx();
        if (this.zzcwi.zzkz() != null) {
            this.zzcwi.zzkz().zzh("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzanh.zzcs);
        this.zza("onhide", hashMap);
    }

    private void zzwx() {
        zzdm.zza(this.zzcwi.zzkz(), this.zzcak, "aeh2");
    }

    private void zzwy() {
        zzdm.zza(this.zzcwi.zzkz(), this.zzcak, "aebb2");
    }

    @Override
    public void zzoz() {
        if (this.zzcwg == null) {
            zzdm.zza(this.zzcwi.zzkz(), this.zzcak, "aes2");
            this.zzcwg = zzdm.zzb(this.zzcwi.zzkz());
            this.zzcwi.zza("native:view_show", this.zzcwg);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzanh.zzcs);
        this.zza("onshow", hashMap);
    }

    @Override
    public void zzvm() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzu.zzfz().zzfg()));
        hashMap.put("app_volume", String.valueOf(zzu.zzfz().zzfe()));
        hashMap.put("device_volume", String.valueOf(zzu.zzfz().zzal(this.getContext())));
        this.zza("volume", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zzd zzvp() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.zzcvs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zzd zzvq() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.zzcwk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdSizeParcel zzdt() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.zzapc;
        }
    }

    @Override
    public zzlu zzvr() {
        return this.zzcvr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzvs() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.zzcvt;
        }
    }

    @Override
    public zzau zzvt() {
        return this.zzbkp;
    }

    @Override
    public VersionInfoParcel zzvu() {
        return this.zzanh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzvv() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.zzcvv;
        }
    }

    public void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzu.zzfz().zzb(this.getContext(), intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzkn.zzdd((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzvr().zzwj()) {
            Object object = this.zzakd;
            synchronized (object) {
                if (this.zzcwd != null) {
                    this.zzcwd.zzc(motionEvent);
                }
            }
        } else if (this.zzbkp != null) {
            this.zzbkp.zza(motionEvent);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if (zzdi.zzbcx.get().booleanValue()) {
            boolean bl;
            float f = motionEvent.getAxisValue(9);
            float f2 = motionEvent.getAxisValue(10);
            boolean bl2 = bl = motionEvent.getActionMasked() == 8;
            if (bl && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
                return false;
            }
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DrawAllocation"})
    protected void onMeasure(int n, int n2) {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.zzcvv || this.zzapc.zzaxl) {
                super.onMeasure(n, n2);
                return;
            }
            if (this.zzapc.zzaxm) {
                if (zzdi.zzbgf.get().booleanValue() || !zzs.zzaxp()) {
                    super.onMeasure(n, n2);
                    return;
                }
                this.zza("/contentHeight", this.zzwz());
                String string2 = "(function() {  var height = -1;  if (document.body) { height = document.body.offsetHeight;}  else if (document.documentElement) {      height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  window.googleAdsJsInterface.notify(url);  })();";
                this.zzdk(string2);
                float f = this.zzcvp.getResources().getDisplayMetrics().density;
                int n3 = View.MeasureSpec.getSize((int)n);
                int n4 = 0;
                switch (this.zzcwf) {
                    case -1: {
                        n4 = View.MeasureSpec.getSize((int)n2);
                        break;
                    }
                    default: {
                        n4 = (int)((float)this.zzcwf * f);
                    }
                }
                this.setMeasuredDimension(n3, n4);
                return;
            }
            if (this.zzapc.zzaxj) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zzasl.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            int n9 = Integer.MAX_VALUE;
            if (n5 == Integer.MIN_VALUE || n5 == 0x40000000) {
                n9 = n6;
            }
            int n10 = Integer.MAX_VALUE;
            if (n7 == Integer.MIN_VALUE || n7 == 0x40000000) {
                n10 = n8;
            }
            if (this.zzapc.widthPixels > n9 || this.zzapc.heightPixels > n10) {
                float f = this.zzcvp.getResources().getDisplayMetrics().density;
                int n11 = (int)((float)this.zzapc.widthPixels / f);
                int n12 = (int)((float)this.zzapc.heightPixels / f);
                int n13 = (int)((float)n6 / f);
                int n14 = (int)((float)n8 / f);
                zzkn.zzdf((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n11).append("x").append(n12).append(" dp, but only has ").append(n13).append("x").append(n14).append(" dp.").toString());
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzapc.widthPixels, this.zzapc.heightPixels);
            }
        }
    }

    zzev zzwz() {
        return new zzev(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zza(zzlt zzlt2, Map<String, String> map) {
                String string2;
                if (map != null && !TextUtils.isEmpty((CharSequence)(string2 = map.get("height")))) {
                    try {
                        int n = Integer.parseInt(string2);
                        Object object = zzlx.this.zzakd;
                        synchronized (object) {
                            if (zzlx.this.zzcwf != n) {
                                zzlx.this.zzcwf = n;
                                zzlx.this.requestLayout();
                            }
                        }
                    }
                    catch (Exception exception) {
                        zzkn.zzd((String)"Exception occurred while getting webview content height", (Throwable)exception);
                    }
                }
            }
        };
    }

    public void onGlobalLayout() {
        boolean bl = this.zzwv();
        com.google.android.gms.ads.internal.overlay.zzd zzd2 = this.zzvp();
        if (zzd2 != null && bl) {
            zzd2.zzoy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(Context context, AdSizeParcel adSizeParcel, zzdq zzdq2) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzasf.zzvb();
            this.setContext(context);
            this.zzcvs = null;
            this.zzapc = adSizeParcel;
            this.zzcvv = false;
            this.zzcvt = false;
            this.zzcaj = "";
            this.zzcvx = -1;
            zzu.zzgb().zzm(this);
            this.loadUrl("about:blank");
            this.zzcvr.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
            this.zzcvy = true;
            this.zzcvz = false;
            this.zzcwa = null;
            this.zzd(zzdq2);
            this.zzcwb = false;
            this.zzcwe = 0;
            zzu.zzgw().zze(this);
            this.zzxd();
        }
    }

    private void zzd(zzdq zzdq2) {
        this.zzxe();
        this.zzcwi = new zzdp(new zzdq(true, "make_wv", this.zzapc.zzaxi));
        this.zzcwi.zzkz().zzc(zzdq2);
        this.zzcak = zzdm.zzb(this.zzcwi.zzkz());
        this.zzcwi.zza("native:view_create", this.zzcak);
        this.zzcwh = null;
        this.zzcwg = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(com.google.android.gms.ads.internal.overlay.zzd zzd2) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzcvs = zzd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzc(com.google.android.gms.ads.internal.overlay.zzd zzd2) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzcwk = zzd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(AdSizeParcel adSizeParcel) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzapc = adSizeParcel;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzaj(boolean bl) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzcvv = bl;
            this.zzxa();
        }
    }

    @Override
    public void zzwd() {
        this.zzasf.zzva();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttachedToWindow() {
        Object object = this.zzakd;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzasf.onAttachedToWindow();
            }
            boolean bl = this.zzcwb;
            if (this.zzvr() != null && this.zzvr().zzwj()) {
                bl = true;
                if (!this.zzcwc) {
                    ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                    ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzvr().zzwk();
                    if (onGlobalLayoutListener != null) {
                        zzu.zzgx().zza(this.getView(), onGlobalLayoutListener);
                    }
                    if ((onScrollChangedListener = this.zzvr().zzwl()) != null) {
                        zzu.zzgx().zza(this.getView(), onScrollChangedListener);
                    }
                    this.zzcwc = true;
                }
            }
            this.zzao(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        Object object = this.zzakd;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzasf.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzcwc && this.zzvr() != null && this.zzvr().zzwj() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzvr().zzwk();
                if (onGlobalLayoutListener != null) {
                    zzu.zzgb().zza(this.getViewTreeObserver(), onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzvr().zzwl()) != null) {
                    this.getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
                }
                this.zzcwc = false;
            }
        }
        this.zzao(false);
    }

    @Override
    public void setContext(Context context) {
        this.zzcvp.setBaseContext(context);
        this.zzasf.zzl(this.zzcvp.zzvn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzak(boolean bl) {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.zzcvs != null) {
                this.zzcvs.zza(this.zzcvr.zzib(), bl);
            } else {
                this.zzcvt = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestedOrientation() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.zzcvx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestedOrientation(int n) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzcvx = n;
            if (this.zzcvs != null) {
                this.zzcvs.setRequestedOrientation(this.zzcvx);
            }
        }
    }

    @Override
    public Activity zzvn() {
        return this.zzcvp.zzvn();
    }

    @Override
    public Context zzvo() {
        return this.zzcvp.zzvo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzxa() {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.zzcvv || this.zzapc.zzaxj) {
                if (Build.VERSION.SDK_INT < 14) {
                    zzkn.zzdd((String)"Disabling hardware acceleration on an overlay.");
                    this.zzxb();
                } else {
                    zzkn.zzdd((String)"Enabling hardware acceleration on an overlay.");
                    this.zzxc();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                zzkn.zzdd((String)"Disabling hardware acceleration on an AdView.");
                this.zzxb();
            } else {
                zzkn.zzdd((String)"Enabling hardware acceleration on an AdView.");
                this.zzxc();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzxb() {
        Object object = this.zzakd;
        synchronized (object) {
            if (!this.zzcvw) {
                zzu.zzgb().zzp((View)this);
            }
            this.zzcvw = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzxc() {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.zzcvw) {
                zzu.zzgb().zzo((View)this);
            }
            this.zzcvw = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzxe();
            this.zzasf.zzvb();
            if (this.zzcvs != null) {
                this.zzcvs.close();
                this.zzcvs.onDestroy();
                this.zzcvs = null;
            }
            this.zzcvr.reset();
            if (this.zzcvu) {
                return;
            }
            zzu.zzgw().zze(this);
            this.zzxd();
            this.zzcvu = true;
            zzkn.v("Initiating WebView self destruct sequence in 3...");
            this.zzcvr.zzwn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Object object = this.zzakd;
        synchronized (object) {
            if (!this.zzcvu) {
                this.zzcvr.reset();
                zzu.zzgw().zze(this);
                this.zzxd();
            }
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzvw() {
        Object object = this.zzakd;
        synchronized (object) {
            zzkn.v("Destroying WebView!");
            zzkr.zzcrf.post(new Runnable(){

                @Override
                public void run() {
                    zzlx.super.destroy();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.zzcvu;
        }
    }

    @TargetApi(value=21)
    protected void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzvr() != null && this.zzvr().zzwu() != null) {
            this.zzvr().zzwu().zzes();
        }
    }

    @Override
    public void zzwe() {
        if (this.zzcwh == null) {
            this.zzcwh = zzdm.zzb(this.zzcwi.zzkz());
            this.zzcwi.zza("native:view_load", this.zzcwh);
        }
    }

    @Override
    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (zzs.zzaxk()) {
                super.onPause();
            }
        }
        catch (Exception exception) {
            zzkn.zzb((String)"Could not pause webview.", (Throwable)exception);
        }
    }

    @Override
    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (zzs.zzaxk()) {
                super.onResume();
            }
        }
        catch (Exception exception) {
            zzkn.zzb((String)"Could not resume webview.", (Throwable)exception);
        }
    }

    @Override
    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
        }
        catch (Exception exception) {
            zzkn.zzb((String)"Could not stop loading webview.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzal(boolean bl) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzcvy = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzpr() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.zzcvy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzvx() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.zzcvz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzel() {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzcvz = true;
            if (this.zzcvq != null) {
                this.zzcvq.zzel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzem() {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzcvz = false;
            if (this.zzcvq != null) {
                this.zzcvq.zzem();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzxd() {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzcwl = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzdh(String string2) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzcaj = string2 == null ? "" : string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRequestId() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.zzcaj;
        }
    }

    @Override
    public zzls zzvy() {
        return null;
    }

    @Override
    public zzdo zzvz() {
        return this.zzcak;
    }

    @Override
    public zzdp zzwa() {
        return this.zzcwi;
    }

    @Override
    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzcwj = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public View.OnClickListener zzwf() {
        return (View.OnClickListener)this.zzcwj.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(zzg zzg2) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzcwd = zzg2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzg zzwg() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.zzcwd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzly zzwb() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.zzcwa;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzly zzly2) {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.zzcwa != null) {
                zzkn.e((String)"Attempt to create multiple AdWebViewVideoControllers.");
                return;
            }
            this.zzcwa = zzly2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzwc() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.zzcwe > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzam(boolean bl) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzcwe += bl ? 1 : -1;
            if (this.zzcwe <= 0 && this.zzcvs != null) {
                this.zzcvs.zzpb();
            }
        }
    }

    private void zzxe() {
        if (this.zzcwi == null) {
            return;
        }
        zzdq zzdq2 = this.zzcwi.zzkz();
        if (zzdq2 != null && zzu.zzgd().zztm() != null) {
            zzu.zzgd().zztm().zza(zzdq2);
        }
    }

    @Override
    public void zzwh() {
        this.setBackgroundColor(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzcj zzcj2, boolean bl) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzcwb = bl;
        }
        this.zzao(bl);
    }

    private void zzao(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public void zza(String string2, zzev zzev2) {
        if (this.zzcvr != null) {
            this.zzcvr.zza(string2, zzev2);
        }
    }

    @Override
    public void zzb(String string2, zzev zzev2) {
        if (this.zzcvr != null) {
            this.zzcvr.zzb(string2, zzev2);
        }
    }

    @zziy
    public static class zza
    extends MutableContextWrapper {
        private Activity zzctd;
        private Context zzask;
        private Context zzcwn;

        public zza(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context context) {
            this.zzask = context.getApplicationContext();
            this.zzctd = context instanceof Activity ? (Activity)context : null;
            this.zzcwn = context;
            super.setBaseContext(this.zzask);
        }

        public void startActivity(Intent intent) {
            if (this.zzctd != null) {
                this.zzctd.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.zzask.startActivity(intent);
            }
        }

        public Activity zzvn() {
            return this.zzctd;
        }

        public Object getSystemService(String string2) {
            return this.zzcwn.getSystemService(string2);
        }

        public Context zzvo() {
            return this.zzcwn;
        }
    }
}

