/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.cache;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.ads.internal.cache.CacheEntryParcel;
import com.google.android.gms.ads.internal.cache.CacheOffering;
import com.google.android.gms.ads.internal.cache.zzc;
import com.google.android.gms.ads.internal.cache.zzf;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.internal.zzcz;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzlb;

@zzji
public class zza {
    private final Runnable zzaxy = new Runnable(){

        @Override
        public void run() {
            zza.this.disconnect();
        }
    };
    private final Object zzako = new Object();
    @Nullable
    private zzc zzaxz;
    @Nullable
    private Context mContext;
    @Nullable
    private zzf zzaya;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Context context) {
        if (context == null) {
            return;
        }
        Object object = this.zzako;
        synchronized (object) {
            if (this.mContext != null) {
                return;
            }
            this.mContext = context.getApplicationContext();
            if (zzdr.zzbkr.get().booleanValue()) {
                this.connect();
            } else if (zzdr.zzbkq.get().booleanValue()) {
                this.zza(new zzcz.zzb(){

                    @Override
                    public void zzk(boolean bl) {
                        if (bl) {
                            zza.this.connect();
                        } else {
                            zza.this.disconnect();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzjt() {
        if (zzdr.zzbks.get().booleanValue()) {
            Object object = this.zzako;
            synchronized (object) {
                this.connect();
                zzu.zzgm();
                zzlb.zzcvl.removeCallbacks(this.zzaxy);
                zzu.zzgm();
                zzlb.zzcvl.postDelayed(this.zzaxy, zzdr.zzbkt.get().longValue());
            }
        }
    }

    protected void zza(zzcz.zzb zzb2) {
        zzu.zzgp().zza(zzb2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntryParcel zza(CacheOffering cacheOffering) {
        Object object = this.zzako;
        synchronized (object) {
            if (this.zzaya == null) {
                return new CacheEntryParcel();
            }
            try {
                return this.zzaya.zza(cacheOffering);
            }
            catch (RemoteException remoteException) {
                zzkx.zzb((String)"Unable to call into cache service.", (Throwable)remoteException);
                return new CacheEntryParcel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        Object object = this.zzako;
        synchronized (object) {
            if (this.mContext == null || this.zzaxz != null) {
                return;
            }
            zze.zzb zzb2 = new zze.zzb(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onConnected(@Nullable Bundle bundle) {
                    Object object = zza.this.zzako;
                    synchronized (object) {
                        try {
                            zza.this.zzaya = zza.this.zzaxz.zzjz();
                        }
                        catch (DeadObjectException deadObjectException) {
                            zzkx.zzb((String)"Unable to obtain a cache service instance.", (Throwable)deadObjectException);
                            zza.this.disconnect();
                        }
                        zza.this.zzako.notifyAll();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onConnectionSuspended(int n) {
                    Object object = zza.this.zzako;
                    synchronized (object) {
                        zza.this.zzaxz = null;
                        zza.this.zzaya = null;
                        zza.this.zzako.notifyAll();
                        zzu.zzhc().zzwk();
                    }
                }
            };
            zze.zzc zzc2 = new zze.zzc(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
                    Object object = zza.this.zzako;
                    synchronized (object) {
                        zza.this.zzaxz = null;
                        zza.this.zzaya = null;
                        zza.this.zzako.notifyAll();
                        zzu.zzhc().zzwk();
                    }
                }
            };
            this.zzaxz = this.zza(zzb2, zzc2);
            this.zzaxz.zzavd();
        }
    }

    protected zzc zza(zze.zzb zzb2, zze.zzc zzc2) {
        return new zzc(this.mContext, zzu.zzhc().zzwj(), zzb2, zzc2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        Object object = this.zzako;
        synchronized (object) {
            if (this.zzaxz == null) {
                return;
            }
            if (this.zzaxz.isConnected() || this.zzaxz.isConnecting()) {
                this.zzaxz.disconnect();
            }
            this.zzaxz = null;
            this.zzaya = null;
            Binder.flushPendingCommands();
            zzu.zzhc().zzwk();
        }
    }
}

