/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.formats;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.formats.zza;
import com.google.android.gms.ads.internal.formats.zzb;
import com.google.android.gms.ads.internal.formats.zzd;
import com.google.android.gms.ads.internal.formats.zzg;
import com.google.android.gms.ads.internal.formats.zzi;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzav;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzfe;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzja;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzme;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzji
public class zzj
implements zzi {
    private final Object zzako = new Object();
    private final zzq zzbnr;
    private final Context mContext;
    @Nullable
    private final JSONObject zzbnu;
    @Nullable
    private final zzja zzbnv;
    @Nullable
    private final zzi.zza zzbnw;
    private final zzav zzbnx;
    @Nullable
    private final VersionInfoParcel zzanu;
    boolean zzbny;
    private zzmd zzbnz;
    private String zzboa;
    @Nullable
    private String zzbob;
    private WeakReference<View> zzboc = null;

    public zzj(Context context, zzq zzq2, @Nullable zzja zzja2, zzav zzav2, @Nullable JSONObject jSONObject, @Nullable zzi.zza zza2, @Nullable VersionInfoParcel versionInfoParcel, @Nullable String string) {
        this.mContext = context;
        this.zzbnr = zzq2;
        this.zzbnv = zzja2;
        this.zzbnx = zzav2;
        this.zzbnu = jSONObject;
        this.zzbnw = zza2;
        this.zzanu = versionInfoParcel;
        this.zzbob = string;
    }

    public zzb zza(View.OnClickListener onClickListener) {
        zza zza2 = this.zzbnw.zzmr();
        if (zza2 == null) {
            return null;
        }
        zzb zzb2 = new zzb(this.mContext, zza2);
        zzb2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzb2.zzmm().setOnClickListener(onClickListener);
        zzb2.zzmm().setContentDescription((CharSequence)zzdr.zzbjg.get());
        return zzb2;
    }

    public void zza(View view, String string, @Nullable JSONObject jSONObject, Map<String, WeakReference<View>> map, View view2) {
        zzaa.zzhs((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("asset", (Object)string);
            jSONObject2.put("template", (Object)this.zzbnw.zzmq());
            final JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("ad", (Object)this.zzbnu);
            jSONObject3.put("click", (Object)jSONObject2);
            jSONObject3.put("has_custom_click_handler", this.zzbnr.zzaa(this.zzbnw.getCustomTemplateId()) != null);
            if (zzdr.zzbji.get().booleanValue()) {
                if (zzdr.zzbjj.get().booleanValue()) {
                    jSONObject3.put("asset_view_signal", (Object)this.zzb(map, view2));
                    jSONObject3.put("ad_view_signal", (Object)this.zzo(view2));
                } else {
                    jSONObject3.put("view_rectangles", (Object)this.zza(map, view2));
                    jSONObject3.put("native_view_rectangle", (Object)this.zzn(view2));
                }
            }
            if (jSONObject != null) {
                jSONObject3.put("click_point", (Object)jSONObject);
            }
            try {
                JSONObject jSONObject4 = this.zzbnu.optJSONObject("tracking_urls_and_actions");
                if (jSONObject4 == null) {
                    jSONObject4 = new JSONObject();
                }
                String string2 = jSONObject4.optString("click_string");
                jSONObject2.put("click_signals", (Object)this.zzbnx.zzaz().zza(this.mContext, string2, view));
            }
            catch (Exception exception) {
                zzkx.zzb((String)"Exception obtaining click signals", (Throwable)exception);
            }
            jSONObject3.put("ads_id", (Object)this.zzbob);
            this.zzbnv.zza(new zzja.zza(){

                @Override
                public void zze(zzgi zzgi2) {
                    zzgi2.zza("google.afma.nativeAds.handleClickGmsg", jSONObject3);
                }
            });
        }
        catch (JSONException jSONException) {
            zzkx.zzb((String)"Unable to create click JSON.", (Throwable)jSONException);
        }
    }

    public void zza(View view, Map<String, WeakReference<View>> map, JSONObject jSONObject, View view2) {
        zzaa.zzhs((String)"performClick must be called on the main UI thread.");
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view3 = (View)entry.getValue().get();
            if (!view.equals(view3)) continue;
            this.zza(view, entry.getKey(), jSONObject, map, view2);
            return;
        }
        if ("2".equals(this.zzbnw.zzmq())) {
            this.zza(view, "2099", jSONObject, map, view2);
        } else if ("1".equals(this.zzbnw.zzmq())) {
            this.zza(view, "1099", jSONObject, map, view2);
        }
    }

    public void zzd(MotionEvent motionEvent) {
        this.zzbnx.zza(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzd(View view, Map<String, WeakReference<View>> map) {
        Object object = this.zzako;
        synchronized (object) {
            if (this.zzbny) {
                return;
            }
            if (!view.isShown()) {
                return;
            }
            if (!view.getGlobalVisibleRect(new Rect(), null)) {
                return;
            }
            this.zzb(view, map);
        }
    }

    public void zzb(View view, Map<String, WeakReference<View>> map) {
        zzaa.zzhs((String)"recordImpression must be called on the main UI thread.");
        this.zzr(true);
        try {
            final JSONObject jSONObject = new JSONObject();
            jSONObject.put("ad", (Object)this.zzbnu);
            jSONObject.put("ads_id", (Object)this.zzbob);
            if (zzdr.zzbji.get().booleanValue()) {
                if (zzdr.zzbjj.get().booleanValue()) {
                    jSONObject.put("asset_view_signal", (Object)this.zzb(map, view));
                    jSONObject.put("ad_view_signal", (Object)this.zzo(view));
                } else {
                    jSONObject.put("view_rectangles", (Object)this.zza(map, view));
                    jSONObject.put("native_view_rectangle", (Object)this.zzn(view));
                }
            }
            this.zzbnv.zza(new zzja.zza(){

                @Override
                public void zze(zzgi zzgi2) {
                    zzgi2.zza("google.afma.nativeAds.handleImpressionPing", jSONObject);
                }
            });
        }
        catch (JSONException jSONException) {
            zzkx.zzb((String)"Unable to create impression JSON.", (Throwable)jSONException);
        }
        this.zzbnr.zza(this);
    }

    public View zzmy() {
        return this.zzboc != null ? (View)this.zzboc.get() : null;
    }

    public void zzj(View view) {
        this.zzboc = new WeakReference<View>(view);
    }

    public void zza(View view, Map<String, WeakReference<View>> map, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        if (!zzdr.zzbjd.get().booleanValue()) {
            return;
        }
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(onTouchListener);
            view2.setClickable(true);
            view2.setOnClickListener(onClickListener);
        }
    }

    public void zzc(View view, Map<String, WeakReference<View>> map) {
        if (zzdr.zzbjc.get().booleanValue()) {
            return;
        }
        view.setOnTouchListener(null);
        view.setClickable(false);
        view.setOnClickListener(null);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(null);
            view2.setClickable(false);
            view2.setOnClickListener(null);
        }
    }

    public zzmd zzmx() {
        this.zzbnz = this.zzna();
        this.zzbnz.getView().setVisibility(8);
        zzja.zza zza2 = new zzja.zza(){

            @Override
            public void zze(final zzgi zzgi2) {
                zzgi2.zza("/loadHtml", new zzfe(){

                    @Override
                    public void zza(zzmd zzmd2, final Map<String, String> map) {
                        zzj.this.zzbnz.zzxc().zza(new zzme.zza(){

                            @Override
                            public void zza(zzmd zzmd2, boolean bl) {
                                zzj.this.zzboa = (String)map.get("id");
                                JSONObject jSONObject = new JSONObject();
                                try {
                                    jSONObject.put("messageType", (Object)"htmlLoaded");
                                    jSONObject.put("id", (Object)zzj.this.zzboa);
                                    zzgi2.zzb("sendMessageToNativeJs", jSONObject);
                                }
                                catch (JSONException jSONException) {
                                    zzkx.zzb((String)"Unable to dispatch sendMessageToNativeJs event", (Throwable)jSONException);
                                }
                            }
                        });
                        String string = map.get("overlayHtml");
                        String string2 = map.get("baseUrl");
                        if (TextUtils.isEmpty((CharSequence)string2)) {
                            zzj.this.zzbnz.loadData(string, "text/html", "UTF-8");
                        } else {
                            zzj.this.zzbnz.loadDataWithBaseURL(string2, string, "text/html", "UTF-8", null);
                        }
                    }
                });
                zzgi2.zza("/showOverlay", new zzfe(){

                    @Override
                    public void zza(zzmd zzmd2, Map<String, String> map) {
                        zzj.this.zzbnz.getView().setVisibility(0);
                    }
                });
                zzgi2.zza("/hideOverlay", new zzfe(){

                    @Override
                    public void zza(zzmd zzmd2, Map<String, String> map) {
                        zzj.this.zzbnz.getView().setVisibility(8);
                    }
                });
                zzj.this.zzbnz.zzxc().zza("/hideOverlay", new zzfe(){

                    @Override
                    public void zza(zzmd zzmd2, Map<String, String> map) {
                        zzj.this.zzbnz.getView().setVisibility(8);
                    }
                });
                zzj.this.zzbnz.zzxc().zza("/sendMessageToSdk", new zzfe(){

                    @Override
                    public void zza(zzmd zzmd2, Map<String, String> map) {
                        JSONObject jSONObject = new JSONObject();
                        try {
                            for (String string : map.keySet()) {
                                jSONObject.put(string, (Object)map.get(string));
                            }
                            jSONObject.put("id", (Object)zzj.this.zzboa);
                            zzgi2.zzb("sendMessageToNativeJs", jSONObject);
                        }
                        catch (JSONException jSONException) {
                            zzkx.zzb((String)"Unable to dispatch sendMessageToNativeJs event", (Throwable)jSONException);
                        }
                    }
                });
            }
        };
        this.zzbnv.zza(zza2);
        return this.zzbnz;
    }

    public void zza(View view, zzg zzg2) {
        zzeg zzeg2;
        if (!(this.zzbnw instanceof zzd)) {
            return;
        }
        zzd zzd2 = (zzd)this.zzbnw;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        if (zzd2.zzms() != null) {
            ((FrameLayout)view).addView(zzd2.zzms(), (ViewGroup.LayoutParams)layoutParams);
            this.zzbnr.zza(zzg2);
            return;
        }
        if (zzd2.getImages() != null && zzd2.getImages().size() > 0 && (zzeg2 = this.zze(zzd2.getImages().get(0))) != null) {
            try {
                com.google.android.gms.dynamic.zzd zzd3 = zzeg2.zzmn();
                if (zzd3 != null) {
                    Drawable drawable = (Drawable)zze.zzae((com.google.android.gms.dynamic.zzd)zzd3);
                    ImageView imageView = this.zznb();
                    imageView.setImageDrawable(drawable);
                    imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    ((FrameLayout)view).addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
                }
            }
            catch (RemoteException remoteException) {
                zzkx.zzdi((String)"Could not get drawable from image");
            }
        }
    }

    public void zzmz() {
        if (!(this.zzbnw instanceof zzd)) {
            return;
        }
        this.zzbnr.zzfw();
    }

    protected void zzr(boolean bl) {
        this.zzbny = bl;
    }

    zzmd zzna() {
        return zzu.zzgn().zza(this.mContext, AdSizeParcel.zzj((Context)this.mContext), false, false, this.zzbnx, this.zzanu);
    }

    public Context getContext() {
        return this.mContext;
    }

    @Nullable
    zzeg zze(Object object) {
        if (object instanceof IBinder) {
            return zzeg.zza.zzab((IBinder)((IBinder)object));
        }
        return null;
    }

    ImageView zznb() {
        return new ImageView(this.mContext);
    }

    int[] zzk(View view) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        return nArray;
    }

    int zzab(int n) {
        return zzm.zzkr().zzc(this.mContext, n);
    }

    int zzl(View view) {
        return view.getMeasuredWidth();
    }

    int zzm(View view) {
        return view.getMeasuredHeight();
    }

    private JSONObject zzn(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            jSONObject.put("width", this.zzab(this.zzl(view)));
            jSONObject.put("height", this.zzab(this.zzm(view)));
        }
        catch (Exception exception) {
            zzkx.zzdi((String)"Unable to get native ad view bounding box");
        }
        return jSONObject;
    }

    private JSONObject zza(Map<String, WeakReference<View>> map, View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        try {
            int[] nArray = this.zzk(view);
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view2 = (View)entry.getValue().get();
                if (view2 == null) continue;
                int[] nArray2 = this.zzk(view2);
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("width", this.zzab(this.zzl(view2)));
                jSONObject2.put("height", this.zzab(this.zzm(view2)));
                jSONObject2.put("x", this.zzab(nArray2[0] - nArray[0]));
                jSONObject2.put("y", this.zzab(nArray2[1] - nArray[1]));
                jSONObject.put(entry.getKey(), (Object)jSONObject2);
            }
        }
        catch (JSONException jSONException) {
            zzkx.zzdi((String)"Unable to get all view rectangles");
        }
        return jSONObject;
    }

    private JSONObject zzb(Rect rect) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("x", this.zzab(rect.left));
        jSONObject.put("y", this.zzab(rect.top));
        jSONObject.put("width", this.zzab(rect.right - rect.left));
        jSONObject.put("height", this.zzab(rect.bottom - rect.top));
        jSONObject.put("relative_to", (Object)"self");
        return jSONObject;
    }

    private JSONObject zzo(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            JSONObject jSONObject2;
            int[] nArray = this.zzk(view);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("width", this.zzab(this.zzl(view)));
            jSONObject3.put("height", this.zzab(this.zzm(view)));
            jSONObject3.put("x", this.zzab(nArray[0]));
            jSONObject3.put("y", this.zzab(nArray[1]));
            jSONObject3.put("relative_to", (Object)"window");
            jSONObject.put("frame", (Object)jSONObject3);
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                jSONObject2 = this.zzb(rect);
            } else {
                jSONObject2 = new JSONObject();
                jSONObject2.put("x", this.zzab(nArray[0]));
                jSONObject2.put("y", this.zzab(nArray[1]));
                jSONObject2.put("width", 0);
                jSONObject2.put("height", 0);
                jSONObject2.put("relative_to", (Object)"window");
            }
            jSONObject.put("visible_bounds", (Object)jSONObject2);
        }
        catch (Exception exception) {
            zzkx.zzdi((String)"Unable to get native ad view bounding box");
        }
        return jSONObject;
    }

    private JSONObject zzb(Map<String, WeakReference<View>> map, View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        int[] nArray = this.zzk(view);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            int[] nArray2 = this.zzk(view2);
            JSONObject jSONObject2 = new JSONObject();
            JSONObject jSONObject3 = new JSONObject();
            try {
                JSONObject jSONObject4;
                jSONObject3.put("width", this.zzab(this.zzl(view2)));
                jSONObject3.put("height", this.zzab(this.zzm(view2)));
                jSONObject3.put("x", this.zzab(nArray2[0] - nArray[0]));
                jSONObject3.put("y", this.zzab(nArray2[1] - nArray[1]));
                jSONObject3.put("relative_to", (Object)"ad_view");
                jSONObject2.put("frame", (Object)jSONObject3);
                Rect rect = new Rect();
                if (view2.getLocalVisibleRect(rect)) {
                    jSONObject4 = this.zzb(rect);
                } else {
                    jSONObject4 = new JSONObject();
                    jSONObject4.put("x", this.zzab(nArray2[0] - nArray[0]));
                    jSONObject4.put("y", this.zzab(nArray2[1] - nArray[1]));
                    jSONObject4.put("width", 0);
                    jSONObject4.put("height", 0);
                    jSONObject4.put("relative_to", (Object)"ad_view");
                }
                jSONObject2.put("visible_bounds", (Object)jSONObject4);
                if (view2 instanceof TextView) {
                    TextView textView = (TextView)view2;
                    jSONObject2.put("text_color", textView.getCurrentTextColor());
                    jSONObject2.put("font_size", (double)textView.getTextSize());
                    jSONObject2.put("text", (Object)textView.getText());
                }
                jSONObject.put(entry.getKey(), (Object)jSONObject2);
            }
            catch (JSONException jSONException) {
                zzkx.zzdi((String)"Unable to get asset views information");
            }
        }
        return jSONObject;
    }
}

