/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzlb;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzji
@TargetApi(value=14)
public class zzc
extends zzi
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzbzp = new HashMap<Integer, String>();
    private final zzy zzbzq;
    private final boolean zzbzr;
    private int zzbzs = 0;
    private int zzbzt = 0;
    private MediaPlayer zzbzu;
    private Uri zzbzv;
    private int zzbzw;
    private int zzbzx;
    private int zzbzy;
    private int zzbzz;
    private int zzcaa;
    private zzx zzcab;
    private boolean zzcac;
    private int zzcad;
    private zzh zzcae;

    public zzc(Context context, boolean bl, boolean bl2, zzy zzy2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzbzq = zzy2;
        this.zzcac = bl;
        this.zzbzr = bl2;
        this.zzbzq.zza(this);
    }

    @Override
    public String zzpg() {
        String string = String.valueOf(this.zzcac ? " spherical" : "");
        return string.length() != 0 ? "MediaPlayer".concat(string) : new String("MediaPlayer");
    }

    @Override
    public void zza(zzh zzh2) {
        this.zzcae = zzh2;
    }

    @Override
    public void setVideoPath(String string) {
        this.setVideoURI(Uri.parse((String)string));
    }

    public void setVideoURI(Uri uri) {
        this.zzbzv = uri;
        this.zzcad = 0;
        this.zzph();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void stop() {
        zzkx.v("AdMediaPlayerView stop");
        if (this.zzbzu != null) {
            this.zzbzu.stop();
            this.zzbzu.release();
            this.zzbzu = null;
            this.zzai(0);
            this.zzaj(0);
        }
        this.zzbzq.onStop();
    }

    public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzkx.v(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzbzw = mediaPlayer.getVideoWidth();
        this.zzbzx = mediaPlayer.getVideoHeight();
        if (this.zzbzw != 0 && this.zzbzx != 0) {
            this.requestLayout();
        }
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        zzkx.v("AdMediaPlayerView prepared");
        this.zzai(2);
        this.zzbzq.zzqc();
        zzlb.zzcvl.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzcae != null) {
                    zzc.this.zzcae.zzqc();
                }
            }
        });
        this.zzbzw = mediaPlayer.getVideoWidth();
        this.zzbzx = mediaPlayer.getVideoHeight();
        if (this.zzcad != 0) {
            this.seekTo(this.zzcad);
        }
        this.zzpi();
        int n = this.zzbzw;
        int n2 = this.zzbzx;
        zzkx.zzdh((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzbzt == 3) {
            this.play();
        }
        this.zzpk();
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        zzkx.v("AdMediaPlayerView completion");
        this.zzai(5);
        this.zzaj(5);
        zzlb.zzcvl.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzcae != null) {
                    zzc.this.zzcae.zzqe();
                }
            }
        });
    }

    public boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string = zzbzp.get(n);
        String string2 = zzbzp.get(n2);
        zzkx.v(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string).append(":").append(string2).toString());
        return true;
    }

    public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        final String string = zzbzp.get(n);
        final String string2 = zzbzp.get(n2);
        zzkx.zzdi((String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string).append(":").append(string2).toString());
        this.zzai(-1);
        this.zzaj(-1);
        zzlb.zzcvl.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzcae != null) {
                    zzc.this.zzcae.zzk(string, string2);
                }
            }
        });
        return true;
    }

    public void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzbzy = n;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzkx.v("AdMediaPlayerView surface created");
        this.zzph();
        zzlb.zzcvl.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzcae != null) {
                    zzc.this.zzcae.zzqb();
                }
            }
        });
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, final int n, final int n2) {
        boolean bl;
        zzkx.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzbzt == 3;
        boolean bl3 = bl = this.zzbzw == n && this.zzbzx == n2;
        if (this.zzbzu != null && bl2 && bl) {
            if (this.zzcad != 0) {
                this.seekTo(this.zzcad);
            }
            this.play();
        }
        if (this.zzcab != null) {
            this.zzcab.zzi(n, n2);
        }
        zzlb.zzcvl.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzcae != null) {
                    zzc.this.zzcae.zzf(n, n2);
                }
            }
        });
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzkx.v("AdMediaPlayerView surface destroyed");
        if (this.zzbzu != null && this.zzcad == 0) {
            this.zzcad = this.zzbzu.getCurrentPosition();
        }
        if (this.zzcab != null) {
            this.zzcab.zzqs();
        }
        zzlb.zzcvl.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzcae != null) {
                    zzc.this.zzcae.onPaused();
                    zzc.this.zzcae.zzqf();
                }
            }
        });
        this.zzz(true);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzbzq.zzb(this);
        this.zzcbw.zza(surfaceTexture, this.zzcae);
    }

    protected void onMeasure(int n, int n2) {
        int n3 = zzc.getDefaultSize((int)this.zzbzw, (int)n);
        int n4 = zzc.getDefaultSize((int)this.zzbzx, (int)n2);
        if (this.zzbzw > 0 && this.zzbzx > 0 && this.zzcab == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzbzw * n4 < n3 * this.zzbzx) {
                    n3 = n4 * this.zzbzw / this.zzbzx;
                } else if (this.zzbzw * n4 > n3 * this.zzbzx) {
                    n4 = n3 * this.zzbzx / this.zzbzw;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzbzx / this.zzbzw;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzbzw / this.zzbzx;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzbzw;
                n4 = this.zzbzx;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzbzw / this.zzbzx;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzbzx / this.zzbzw;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzcab != null) {
            this.zzcab.zzi(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzbzz > 0 && this.zzbzz != n3 || this.zzcaa > 0 && this.zzcaa != n4) {
                this.zzpi();
            }
            this.zzbzz = n3;
            this.zzcaa = n4;
        }
    }

    public String toString() {
        String string = String.valueOf(this.getClass().getName());
        String string2 = String.valueOf(Integer.toHexString(this.hashCode()));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("@").append(string2).toString();
    }

    private void zzph() {
        zzkx.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzbzv == null || surfaceTexture == null) {
            return;
        }
        this.zzz(false);
        try {
            Surface surface;
            this.zzbzu = zzu.zzhd().zzqr();
            this.zzbzu.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzbzu.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzbzu.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzbzu.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzbzu.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzbzu.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzbzy = 0;
            if (this.zzcac) {
                this.zzcab = new zzx(this.getContext());
                this.zzcab.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzcab.start();
                surface = this.zzcab.zzqt();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzcab.zzqs();
                    this.zzcab = null;
                }
            }
            this.zzbzu.setDataSource(this.getContext(), this.zzbzv);
            surface = zzu.zzhe().zza(surfaceTexture);
            this.zzbzu.setSurface(surface);
            this.zzbzu.setAudioStreamType(3);
            this.zzbzu.setScreenOnWhilePlaying(true);
            this.zzbzu.prepareAsync();
            this.zzai(1);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string = String.valueOf(this.zzbzv);
            zzkx.zzc((String)new StringBuilder(36 + String.valueOf(string).length()).append("Failed to initialize MediaPlayer at ").append(string).toString(), (Throwable)exception);
            this.onError(this.zzbzu, 1, 0);
        }
    }

    private void zzpi() {
        if (!this.zzbzr) {
            return;
        }
        if (this.zzpj() && this.zzbzu.getCurrentPosition() > 0 && this.zzbzt != 3) {
            long l;
            zzkx.v("AdMediaPlayerView nudging MediaPlayer");
            this.zza(0.0f);
            this.zzbzu.start();
            int n = this.zzbzu.getCurrentPosition();
            long l2 = zzu.zzgs().currentTimeMillis();
            while (this.zzpj() && this.zzbzu.getCurrentPosition() == n && (l = zzu.zzgs().currentTimeMillis()) - l2 <= 250L) {
            }
            this.zzbzu.pause();
            this.zzpk();
        }
    }

    private void zzz(boolean bl) {
        zzkx.v("AdMediaPlayerView release");
        if (this.zzcab != null) {
            this.zzcab.zzqs();
            this.zzcab = null;
        }
        if (this.zzbzu != null) {
            this.zzbzu.reset();
            this.zzbzu.release();
            this.zzbzu = null;
            this.zzai(0);
            if (bl) {
                this.zzbzt = 0;
                this.zzaj(0);
            }
        }
    }

    @Override
    public void play() {
        zzkx.v("AdMediaPlayerView play");
        if (this.zzpj()) {
            this.zzbzu.start();
            this.zzai(3);
            this.zzcbw.zzqd();
            zzlb.zzcvl.post(new Runnable(){

                @Override
                public void run() {
                    if (zzc.this.zzcae != null) {
                        zzc.this.zzcae.zzqd();
                    }
                }
            });
        }
        this.zzaj(3);
    }

    @Override
    public void pause() {
        zzkx.v("AdMediaPlayerView pause");
        if (this.zzpj() && this.zzbzu.isPlaying()) {
            this.zzbzu.pause();
            this.zzai(4);
            zzlb.zzcvl.post(new Runnable(){

                @Override
                public void run() {
                    if (zzc.this.zzcae != null) {
                        zzc.this.zzcae.onPaused();
                    }
                }
            });
        }
        this.zzaj(4);
    }

    @Override
    public int getDuration() {
        if (this.zzpj()) {
            return this.zzbzu.getDuration();
        }
        return -1;
    }

    @Override
    public int getCurrentPosition() {
        if (this.zzpj()) {
            return this.zzbzu.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public void seekTo(int n) {
        zzkx.v(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzpj()) {
            this.zzbzu.seekTo(n);
            this.zzcad = 0;
        } else {
            this.zzcad = n;
        }
    }

    private boolean zzpj() {
        return this.zzbzu != null && this.zzbzs != -1 && this.zzbzs != 0 && this.zzbzs != 1;
    }

    @Override
    public void zza(float f, float f2) {
        if (this.zzcab != null) {
            this.zzcab.zzb(f, f2);
        }
    }

    @Override
    public int getVideoWidth() {
        if (this.zzbzu != null) {
            return this.zzbzu.getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (this.zzbzu != null) {
            return this.zzbzu.getVideoHeight();
        }
        return 0;
    }

    @Override
    public void zzpk() {
        this.zza(this.zzcbx.zzrh());
    }

    private void zza(float f) {
        if (this.zzbzu != null) {
            try {
                this.zzbzu.setVolume(f, f);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            zzkx.zzdi((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
        }
    }

    private void zzai(int n) {
        if (n == 3) {
            this.zzbzq.zzre();
            this.zzcbx.zzre();
        } else if (this.zzbzs == 3) {
            this.zzbzq.zzrf();
            this.zzcbx.zzrf();
        }
        this.zzbzs = n;
    }

    private void zzaj(int n) {
        this.zzbzt = n;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzbzp.put(-1004, "MEDIA_ERROR_IO");
            zzbzp.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzbzp.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzbzp.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzbzp.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzbzp.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzbzp.put(1, "MEDIA_ERROR_UNKNOWN");
        zzbzp.put(1, "MEDIA_INFO_UNKNOWN");
        zzbzp.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzbzp.put(701, "MEDIA_INFO_BUFFERING_START");
        zzbzp.put(702, "MEDIA_INFO_BUFFERING_END");
        zzbzp.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzbzp.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzbzp.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzbzp.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzbzp.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

