/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkx;

@zzji
class zzw
implements SensorEventListener {
    private final SensorManager zzccu;
    private final Object zzccv;
    private final Display zzccw;
    private final float[] zzccx;
    private final float[] zzccy;
    private float[] zzccz;
    private Handler zzcda;
    private zza zzcdb;

    zzw(Context context) {
        this.zzccu = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzccw = windowManager.getDefaultDisplay();
        this.zzccx = new float[9];
        this.zzccy = new float[9];
        this.zzccv = new Object();
    }

    int getRotation() {
        return this.zzccw.getRotation();
    }

    void start() {
        if (this.zzcda != null) {
            return;
        }
        Sensor sensor = this.zzccu.getDefaultSensor(11);
        if (sensor == null) {
            zzkx.e((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzcda = new Handler(handlerThread.getLooper());
        boolean bl = this.zzccu.registerListener((SensorEventListener)this, sensor, 0, this.zzcda);
        if (!bl) {
            zzkx.e((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    void stop() {
        if (this.zzcda == null) {
            return;
        }
        this.zzccu.unregisterListener((SensorEventListener)this);
        this.zzcda.post(new Runnable(){

            @Override
            public void run() {
                Looper.myLooper().quit();
            }
        });
        this.zzcda = null;
    }

    void zza(zza zza2) {
        this.zzcdb = zza2;
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        this.zza(sensorEvent.values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zza(float[] fArray) {
        if (fArray[0] == 0.0f && fArray[1] == 0.0f && fArray[2] == 0.0f) {
            return;
        }
        Object object = this.zzccv;
        synchronized (object) {
            if (this.zzccz == null) {
                this.zzccz = new float[9];
            }
        }
        SensorManager.getRotationMatrixFromVector((float[])this.zzccx, (float[])fArray);
        int n = this.getRotation();
        switch (n) {
            case 1: {
                SensorManager.remapCoordinateSystem((float[])this.zzccx, (int)2, (int)129, (float[])this.zzccy);
                break;
            }
            case 2: {
                SensorManager.remapCoordinateSystem((float[])this.zzccx, (int)129, (int)130, (float[])this.zzccy);
                break;
            }
            case 3: {
                SensorManager.remapCoordinateSystem((float[])this.zzccx, (int)130, (int)1, (float[])this.zzccy);
                break;
            }
            default: {
                System.arraycopy(this.zzccx, 0, this.zzccy, 0, 9);
            }
        }
        this.zzh(1, 3);
        this.zzh(2, 6);
        this.zzh(5, 7);
        Object object2 = this.zzccv;
        synchronized (object2) {
            System.arraycopy(this.zzccy, 0, this.zzccz, 0, 9);
        }
        if (this.zzcdb != null) {
            this.zzcdb.zzpr();
        }
    }

    public void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzb(float[] fArray) {
        Object object = this.zzccv;
        synchronized (object) {
            if (this.zzccz == null) {
                return false;
            }
            System.arraycopy(this.zzccz, 0, fArray, 0, this.zzccz.length);
            return true;
        }
    }

    private void zzh(int n, int n2) {
        float f = this.zzccy[n];
        this.zzccy[n] = this.zzccy[n2];
        this.zzccy[n2] = f;
    }

    static interface zza {
        public void zzpr();
    }
}

