/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.webkit.CookieManager;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzaq;
import com.google.android.gms.internal.zzav;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzkw;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzld;
import com.google.android.gms.internal.zzlw;
import com.google.android.gms.internal.zzlx;
import org.json.JSONException;
import org.json.JSONObject;

@zzji
public class zzb
extends zzkw
implements zzc.zza {
    private final zza.zza zzcjh;
    private final AdRequestInfoParcel.zza zzcji;
    private final Object zzcgi = new Object();
    private final Context mContext;
    private final zzav zzbnx;
    private AdRequestInfoParcel zzbws;
    private Runnable zzcgh;
    zzld zzcjj;
    AdResponseParcel zzcgg;
    zzgq zzbwc;

    public zzb(Context context, AdRequestInfoParcel.zza zza2, zzav zzav2, zza.zza zza3) {
        this.zzcjh = zza3;
        this.mContext = context;
        this.zzcji = zza2;
        this.zzbnx = zzav2;
    }

    zzld zza(VersionInfoParcel versionInfoParcel, zzlw<AdRequestInfoParcel> zzlw2) {
        return zzc.zza(this.mContext, versionInfoParcel, zzlw2, this);
    }

    @Override
    public void zzfp() {
        zzkx.zzdg((String)"AdLoaderBackgroundTask started.");
        this.zzcgh = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzb.this.zzcgi;
                synchronized (object) {
                    if (zzb.this.zzcjj == null) {
                        return;
                    }
                    zzb.this.onStop();
                    zzb.this.zzd(2, "Timed out waiting for ad response.");
                }
            }
        };
        zzlb.zzcvl.postDelayed(this.zzcgh, zzdr.zzbhj.get().longValue());
        final zzlx<AdRequestInfoParcel> zzlx2 = new zzlx<AdRequestInfoParcel>();
        long l = zzu.zzgs().elapsedRealtime();
        zzla.zza(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzb.this.zzcgi;
                synchronized (object) {
                    zzb.this.zzcjj = zzb.this.zza(((zzb)zzb.this).zzcji.zzari, zzlx2);
                    if (zzb.this.zzcjj == null) {
                        zzb.this.zzd(0, "Could not start the ad request service.");
                        zzlb.zzcvl.removeCallbacks(zzb.this.zzcgh);
                    }
                }
            }
        });
        zzaq zzaq2 = this.zzbnx.zzaz();
        String string2 = zzaq2.zzb(this.mContext);
        this.zzbws = new AdRequestInfoParcel(this.zzcji, string2, l);
        zzlx2.zzg(this.zzbws);
    }

    private void zzd(int n, String string2) {
        if (n == 3 || n == -1) {
            zzkx.zzdh((String)string2);
        } else {
            zzkx.zzdi((String)string2);
        }
        this.zzcgg = this.zzcgg == null ? new AdResponseParcel(n) : new AdResponseParcel(n, this.zzcgg.zzbvq);
        AdRequestInfoParcel adRequestInfoParcel = this.zzbws != null ? this.zzbws : new AdRequestInfoParcel(this.zzcji, null, -1L);
        zzko.zza zza2 = new zzko.zza(adRequestInfoParcel, this.zzcgg, this.zzbwc, null, n, -1L, this.zzcgg.zzclf, null);
        this.zzcjh.zza(zza2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(@NonNull AdResponseParcel adResponseParcel) {
        zzkx.zzdg((String)"Received ad response.");
        this.zzcgg = adResponseParcel;
        long l = zzu.zzgs().elapsedRealtime();
        Object object = this.zzcgi;
        synchronized (object) {
            this.zzcjj = null;
        }
        zzu.zzgq().zzd(this.mContext, this.zzcgg.zzcks);
        object = null;
        try {
            if (this.zzcgg.errorCode != -2 && this.zzcgg.errorCode != -3) {
                int n = this.zzcgg.errorCode;
                throw new zza(new StringBuilder(66).append("There was a problem getting an ad response. ErrorCode: ").append(n).toString(), this.zzcgg.errorCode);
            }
            this.zzta();
            if (this.zzbws.zzarm.zzazs != null) {
                object = this.zzb(this.zzbws);
            }
        }
        catch (zza zza2) {
            this.zzd(zza2.getErrorCode(), zza2.getMessage());
            zzlb.zzcvl.removeCallbacks(this.zzcgh);
            return;
        }
        zzu.zzgq().zzaf(this.zzcgg.zzcll);
        zzu.zzgq().zzag(this.zzcgg.zzcly);
        JSONObject jSONObject = null;
        if (!TextUtils.isEmpty((CharSequence)this.zzcgg.zzclj)) {
            try {
                jSONObject = new JSONObject(this.zzcgg.zzclj);
            }
            catch (Exception exception) {
                zzkx.zzb((String)"Error parsing the JSON for Active View.", (Throwable)exception);
            }
        }
        zzko.zza zza3 = new zzko.zza(this.zzbws, this.zzcgg, this.zzbwc, (AdSizeParcel)object, -2, l, this.zzcgg.zzclf, jSONObject);
        this.zzcjh.zza(zza3);
        zzlb.zzcvl.removeCallbacks(this.zzcgh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzcgi;
        synchronized (object) {
            if (this.zzcjj != null) {
                this.zzcjj.cancel();
            }
        }
    }

    protected void zzta() throws zza {
        if (this.zzcgg.errorCode == -3) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzcgg.body)) {
            throw new zza("No fill from ad server.", 3);
        }
        zzu.zzgq().zzc(this.mContext, this.zzcgg.zzckc);
        if (this.zzcgg.zzclb) {
            try {
                this.zzbwc = new zzgq(this.zzcgg.body);
                zzu.zzgq().zzah(this.zzbwc.zzbvo);
            }
            catch (JSONException jSONException) {
                zzkx.zzb((String)"Could not parse mediation config.", (Throwable)jSONException);
                String string2 = String.valueOf(this.zzcgg.body);
                throw new zza(string2.length() != 0 ? "Could not parse mediation config: ".concat(string2) : new String("Could not parse mediation config: "), 0);
            }
        } else {
            zzu.zzgq().zzah(this.zzcgg.zzbvo);
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzcgg.zzckt) && zzdr.zzbkn.get().booleanValue()) {
            zzkx.zzdg((String)"Received cookie from server. Setting webview cookie in CookieManager.");
            CookieManager cookieManager = zzu.zzgo().zzal(this.mContext);
            if (cookieManager != null) {
                cookieManager.setCookie("googleads.g.doubleclick.net", this.zzcgg.zzckt);
            }
        }
    }

    protected AdSizeParcel zzb(AdRequestInfoParcel adRequestInfoParcel) throws zza {
        int n;
        int n2;
        if (this.zzcgg.zzazu) {
            for (AdSizeParcel adSizeParcelArray : adRequestInfoParcel.zzarm.zzazs) {
                if (!adSizeParcelArray.zzazu) continue;
                return new AdSizeParcel(adSizeParcelArray, adRequestInfoParcel.zzarm.zzazs);
            }
        }
        if (this.zzcgg.zzcle == null) {
            throw new zza("The ad response must specify one of the supported ad sizes.", 0);
        }
        String[] stringArray = this.zzcgg.zzcle.split("x");
        if (stringArray.length != 2) {
            String string2 = String.valueOf(this.zzcgg.zzcle);
            throw new zza(string2.length() != 0 ? "Invalid ad size format from the ad response: ".concat(string2) : new String("Invalid ad size format from the ad response: "), 0);
        }
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = String.valueOf(this.zzcgg.zzcle);
            throw new zza(string3.length() != 0 ? "Invalid ad size number from the ad response: ".concat(string3) : new String("Invalid ad size number from the ad response: "), 0);
        }
        for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzarm.zzazs) {
            int n3;
            float f = this.mContext.getResources().getDisplayMetrics().density;
            int n4 = adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / f) : adSizeParcel.width;
            int n5 = n3 = adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / f) : adSizeParcel.height;
            if (n2 != n4 || n != n3 || adSizeParcel.zzazu) continue;
            return new AdSizeParcel(adSizeParcel, adRequestInfoParcel.zzarm.zzazs);
        }
        String string4 = String.valueOf(this.zzcgg.zzcle);
        throw new zza(string4.length() != 0 ? "The ad size from the ad response was not one of the requested sizes: ".concat(string4) : new String("The ad size from the ad response was not one of the requested sizes: "), 0);
    }

    @zzji
    static final class zza
    extends Exception {
        private final int zzcgw;

        public zza(String string2, int n) {
            super(string2);
            this.zzcgw = n;
        }

        public int getErrorCode() {
            return this.zzcgw;
        }
    }
}

