/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import com.google.android.gms.ads.internal.formats.zzd;
import com.google.android.gms.ads.internal.formats.zze;
import com.google.android.gms.ads.internal.zzf;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzfe;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zzhd;
import com.google.android.gms.internal.zzhe;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzme;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzji
public class zzn {
    @Nullable
    public static View zzg(@Nullable zzko zzko2) {
        if (zzko2 == null) {
            zzkx.e((String)"AdState is null");
            return null;
        }
        if (zzn.zzh(zzko2) && zzko2.zzcbm != null) {
            return zzko2.zzcbm.getView();
        }
        try {
            com.google.android.gms.dynamic.zzd zzd2;
            com.google.android.gms.dynamic.zzd zzd3 = zzd2 = zzko2.zzbwn != null ? zzko2.zzbwn.getView() : null;
            if (zzd2 == null) {
                zzkx.zzdi((String)"View in mediation adapter is null.");
                return null;
            }
            return (View)com.google.android.gms.dynamic.zze.zzae((com.google.android.gms.dynamic.zzd)zzd2);
        }
        catch (RemoteException remoteException) {
            zzkx.zzc((String)"Could not get View from mediation adapter.", (Throwable)remoteException);
            return null;
        }
    }

    public static void zza(@Nullable zzko zzko2, zzf.zza zza2) {
        if (zzko2 != null && zzn.zzh(zzko2)) {
            View view;
            zzmd zzmd2 = zzko2.zzcbm;
            View view2 = view = zzmd2 != null ? zzmd2.getView() : null;
            if (view == null) {
                zzkx.zzdi((String)"AdWebView is null");
                return;
            }
            try {
                zzhe zzhe2;
                List<String> list;
                List<String> list2 = list = zzko2.zzbwm != null ? zzko2.zzbwm.zzbvg : null;
                if (list == null || list.isEmpty()) {
                    zzkx.zzdi((String)"No template ids present in mediation response");
                    return;
                }
                zzhd zzhd2 = zzko2.zzbwn != null ? zzko2.zzbwn.zzom() : null;
                zzhe zzhe3 = zzhe2 = zzko2.zzbwn != null ? zzko2.zzbwn.zzon() : null;
                if (list.contains("2") && zzhd2 != null) {
                    zzhd2.zzl(com.google.android.gms.dynamic.zze.zzac((Object)view));
                    if (!zzhd2.getOverrideImpressionRecording()) {
                        zzhd2.recordImpression();
                    }
                    zzmd2.zzxc().zza("/nativeExpressViewClicked", zzn.zza(zzhd2, null, zza2));
                } else if (list.contains("1") && zzhe2 != null) {
                    zzhe2.zzl(com.google.android.gms.dynamic.zze.zzac((Object)view));
                    if (!zzhe2.getOverrideImpressionRecording()) {
                        zzhe2.recordImpression();
                    }
                    zzmd2.zzxc().zza("/nativeExpressViewClicked", zzn.zza(null, zzhe2, zza2));
                } else {
                    zzkx.zzdi((String)"No matching template id and mapper");
                }
            }
            catch (RemoteException remoteException) {
                zzkx.zzc((String)"Error occurred while recording impression and registering for clicks", (Throwable)remoteException);
                return;
            }
        }
    }

    public static boolean zza(zzmd zzmd2, zzgu zzgu2, CountDownLatch countDownLatch) {
        boolean bl = false;
        try {
            bl = zzn.zzb(zzmd2, zzgu2, countDownLatch);
        }
        catch (RemoteException remoteException) {
            zzkx.zzc((String)"Unable to invoke load assets", (Throwable)remoteException);
        }
        catch (RuntimeException runtimeException) {
            countDownLatch.countDown();
            throw runtimeException;
        }
        if (!bl) {
            countDownLatch.countDown();
        }
        return bl;
    }

    private static boolean zzb(zzmd zzmd2, zzgu zzgu2, CountDownLatch countDownLatch) throws RemoteException {
        Object object;
        View view = zzmd2.getView();
        if (view == null) {
            zzkx.zzdi((String)"AdWebView is null");
            return false;
        }
        view.setVisibility(4);
        List<String> list = zzgu2.zzbwm.zzbvg;
        if (list == null || list.isEmpty()) {
            zzkx.zzdi((String)"No template ids present in mediation response");
            return false;
        }
        zzn.zza(zzmd2, countDownLatch);
        zzhd zzhd2 = zzgu2.zzbwn.zzom();
        zzhe zzhe2 = zzgu2.zzbwn.zzon();
        if (list.contains("2") && zzhd2 != null) {
            object = zzn.zza(zzhd2);
            zzn.zza(zzmd2, object, zzgu2.zzbwm.zzbvf);
        } else if (list.contains("1") && zzhe2 != null) {
            object = zzn.zza(zzhe2);
            zzn.zza(zzmd2, (zze)object, zzgu2.zzbwm.zzbvf);
        } else {
            zzkx.zzdi((String)"No matching template id and mapper");
            return false;
        }
        object = zzgu2.zzbwm.zzbvd;
        String string2 = zzgu2.zzbwm.zzbve;
        if (string2 != null) {
            zzmd2.loadDataWithBaseURL(string2, (String)object, "text/html", "UTF-8", null);
        } else {
            zzmd2.loadData((String)object, "text/html", "UTF-8");
        }
        return true;
    }

    public static boolean zzh(@Nullable zzko zzko2) {
        return zzko2 != null && zzko2.zzclb && zzko2.zzbwm != null && zzko2.zzbwm.zzbvd != null;
    }

    private static zzd zza(zzhd zzhd2) throws RemoteException {
        return new zzd(zzhd2.getHeadline(), zzhd2.getImages(), zzhd2.getBody(), zzhd2.zzmo(), zzhd2.getCallToAction(), zzhd2.getStarRating(), zzhd2.getStore(), zzhd2.getPrice(), null, zzhd2.getExtras(), null, null);
    }

    private static zze zza(zzhe zzhe2) throws RemoteException {
        return new zze(zzhe2.getHeadline(), zzhe2.getImages(), zzhe2.getBody(), zzhe2.zzmt(), zzhe2.getCallToAction(), zzhe2.getAdvertiser(), null, zzhe2.getExtras());
    }

    private static void zza(final zzmd zzmd2, final zzd zzd2, final String string2) {
        zzmd2.zzxc().zza(new zzme.zza(){

            @Override
            public void zza(zzmd zzmd22, boolean bl) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("headline", (Object)zzd2.getHeadline());
                    jSONObject.put("body", (Object)zzd2.getBody());
                    jSONObject.put("call_to_action", (Object)zzd2.getCallToAction());
                    jSONObject.put("price", (Object)zzd2.getPrice());
                    jSONObject.put("star_rating", (Object)String.valueOf(zzd2.getStarRating()));
                    jSONObject.put("store", (Object)zzd2.getStore());
                    jSONObject.put("icon", (Object)zzn.zza(zzd2.zzmo()));
                    JSONArray jSONArray = new JSONArray();
                    List list = zzd2.getImages();
                    if (list != null) {
                        for (Object e : list) {
                            zzeg zzeg2 = zzn.zze(e);
                            jSONArray.put((Object)zzn.zza(zzeg2));
                        }
                    }
                    jSONObject.put("images", (Object)jSONArray);
                    jSONObject.put("extras", (Object)zzn.zza(zzd2.getExtras(), string2));
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("assets", (Object)jSONObject);
                    jSONObject2.put("template_id", (Object)"2");
                    zzmd2.zza("google.afma.nativeExpressAds.loadAssets", jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzkx.zzc((String)"Exception occurred when loading assets", (Throwable)jSONException);
                }
            }
        });
    }

    private static void zza(final zzmd zzmd2, final zze zze2, final String string2) {
        zzmd2.zzxc().zza(new zzme.zza(){

            @Override
            public void zza(zzmd zzmd22, boolean bl) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("headline", (Object)zze2.getHeadline());
                    jSONObject.put("body", (Object)zze2.getBody());
                    jSONObject.put("call_to_action", (Object)zze2.getCallToAction());
                    jSONObject.put("advertiser", (Object)zze2.getAdvertiser());
                    jSONObject.put("logo", (Object)zzn.zza(zze2.zzmt()));
                    JSONArray jSONArray = new JSONArray();
                    List list = zze2.getImages();
                    if (list != null) {
                        for (Object e : list) {
                            zzeg zzeg2 = zzn.zze(e);
                            jSONArray.put((Object)zzn.zza(zzeg2));
                        }
                    }
                    jSONObject.put("images", (Object)jSONArray);
                    jSONObject.put("extras", (Object)zzn.zza(zze2.getExtras(), string2));
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("assets", (Object)jSONObject);
                    jSONObject2.put("template_id", (Object)"1");
                    zzmd2.zza("google.afma.nativeExpressAds.loadAssets", jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzkx.zzc((String)"Exception occurred when loading assets", (Throwable)jSONException);
                }
            }
        });
    }

    private static void zza(zzmd zzmd2, CountDownLatch countDownLatch) {
        zzmd2.zzxc().zza("/nativeExpressAssetsLoaded", zzn.zza(countDownLatch));
        zzmd2.zzxc().zza("/nativeExpressAssetsLoadingFailed", zzn.zzb(countDownLatch));
    }

    static zzfe zza(final CountDownLatch countDownLatch) {
        return new zzfe(){

            @Override
            public void zza(zzmd zzmd2, Map<String, String> map) {
                countDownLatch.countDown();
                zzmd2.getView().setVisibility(0);
            }
        };
    }

    static zzfe zzb(final CountDownLatch countDownLatch) {
        return new zzfe(){

            @Override
            public void zza(zzmd zzmd2, Map<String, String> map) {
                zzkx.zzdi((String)"Adapter returned an ad, but assets substitution failed");
                countDownLatch.countDown();
                zzmd2.destroy();
            }
        };
    }

    static zzfe zza(final @Nullable zzhd zzhd2, final @Nullable zzhe zzhe2, final zzf.zza zza2) {
        return new zzfe(){

            @Override
            public void zza(zzmd zzmd2, Map<String, String> map) {
                View view = zzmd2.getView();
                if (view == null) {
                    return;
                }
                try {
                    if (zzhd2 != null) {
                        if (!zzhd2.getOverrideClickHandling()) {
                            zzhd2.zzk(com.google.android.gms.dynamic.zze.zzac((Object)view));
                            zza2.onClick();
                        } else {
                            zzn.zza(zzmd2);
                        }
                    } else if (zzhe2 != null) {
                        if (!zzhe2.getOverrideClickHandling()) {
                            zzhe2.zzk(com.google.android.gms.dynamic.zze.zzac((Object)view));
                            zza2.onClick();
                        } else {
                            zzn.zza(zzmd2);
                        }
                    }
                }
                catch (RemoteException remoteException) {
                    zzkx.zzc((String)"Unable to call handleClick on mapper", (Throwable)remoteException);
                }
            }
        };
    }

    private static void zza(zzmd zzmd2) {
        View.OnClickListener onClickListener = zzmd2.zzxr();
        if (onClickListener != null) {
            onClickListener.onClick(zzmd2.getView());
        }
    }

    private static JSONObject zza(@Nullable Bundle bundle, String string2) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (bundle == null || TextUtils.isEmpty((CharSequence)string2)) {
            return jSONObject;
        }
        JSONObject jSONObject2 = new JSONObject(string2);
        Iterator iterator = jSONObject2.keys();
        while (iterator.hasNext()) {
            Object object;
            String string3 = (String)iterator.next();
            if (!bundle.containsKey(string3)) continue;
            String string4 = jSONObject2.getString(string3);
            if ("image".equals(string4)) {
                object = bundle.get(string3);
                if (object instanceof Bitmap) {
                    String string5 = zzn.zza((Bitmap)object);
                    jSONObject.put(string3, (Object)string5);
                    continue;
                }
                zzkx.zzdi((String)"Invalid type. An image type extra should return a bitmap");
                continue;
            }
            object = bundle.get(string3);
            if (object instanceof Bitmap) {
                zzkx.zzdi((String)"Invalid asset type. Bitmap should be returned only for image type");
                continue;
            }
            jSONObject.put(string3, (Object)String.valueOf(bundle.get(string3)));
        }
        return jSONObject;
    }

    static String zza(@Nullable zzeg zzeg2) {
        if (zzeg2 == null) {
            zzkx.zzdi((String)"Image is null. Returning empty string");
            return "";
        }
        Uri uri = null;
        try {
            uri = zzeg2.getUri();
            if (uri != null) {
                return uri.toString();
            }
        }
        catch (RemoteException remoteException) {
            zzkx.zzdi((String)"Unable to get image uri. Trying data uri next");
        }
        return zzn.zzb(zzeg2);
    }

    private static String zzb(zzeg zzeg2) {
        com.google.android.gms.dynamic.zzd zzd2;
        Drawable drawable2 = null;
        try {
            zzd2 = zzeg2.zzmn();
            if (zzd2 == null) {
                zzkx.zzdi((String)"Drawable is null. Returning empty string");
                return "";
            }
            drawable2 = (Drawable)com.google.android.gms.dynamic.zze.zzae((com.google.android.gms.dynamic.zzd)zzd2);
        }
        catch (RemoteException remoteException) {
            zzkx.zzdi((String)"Unable to get drawable. Returning empty string");
            return "";
        }
        if (!(drawable2 instanceof BitmapDrawable)) {
            zzkx.zzdi((String)"Drawable is not an instance of BitmapDrawable. Returning empty string");
            return "";
        }
        zzd2 = (BitmapDrawable)drawable2;
        Bitmap bitmap = zzd2.getBitmap();
        return zzn.zza(bitmap);
    }

    private static String zza(@Nullable Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bitmap == null) {
            zzkx.zzdi((String)"Bitmap is null. Returning empty string");
            return "";
        }
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        String string2 = Base64.encodeToString((byte[])byArray, (int)0);
        String string3 = String.valueOf("data:image/png;base64,");
        String string4 = String.valueOf(string2);
        return string4.length() != 0 ? string3.concat(string4) : new String(string3);
    }

    @Nullable
    private static zzeg zze(Object object) {
        if (object instanceof IBinder) {
            return zzeg.zza.zzab((IBinder)((IBinder)object));
        }
        return null;
    }
}

