/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.formats.zzg;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzaq;
import com.google.android.gms.internal.zzav;
import com.google.android.gms.internal.zzaw;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzfc;
import com.google.android.gms.internal.zzfe;
import com.google.android.gms.internal.zzfm;
import com.google.android.gms.internal.zzfo;
import com.google.android.gms.internal.zzfp;
import com.google.android.gms.internal.zzft;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkw;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzll;
import com.google.android.gms.internal.zzmd;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzji
public final class zzfd {
    public static final zzfe zzbpj = new zzfe(){

        @Override
        public void zza(zzmd zzmd2, Map<String, String> map) {
        }
    };
    public static final zzfe zzbpk = new zzfe(){

        @Override
        public void zza(zzmd zzmd2, Map<String, String> map) {
            String string2 = map.get("urls");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                zzkx.zzdi((String)"URLs missing in canOpenURLs GMSG.");
                return;
            }
            String[] stringArray = string2.split(",");
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            PackageManager packageManager = zzmd2.getContext().getPackageManager();
            for (String string3 : stringArray) {
                String[] stringArray2 = string3.split(";", 2);
                String string4 = stringArray2[0].trim();
                String string5 = stringArray2.length > 1 ? stringArray2[1].trim() : "android.intent.action.VIEW";
                Uri uri = Uri.parse((String)string4);
                Intent intent = new Intent(string5, uri);
                ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
                hashMap.put(string3, resolveInfo != null);
            }
            zzmd2.zza("openableURLs", hashMap);
        }
    };
    public static final zzfe zzbpl = new zzfe(){

        @Override
        public void zza(zzmd zzmd2, Map<String, String> map) {
            JSONArray jSONArray;
            JSONObject jSONObject;
            PackageManager packageManager = zzmd2.getContext().getPackageManager();
            String string2 = map.get("data");
            try {
                jSONObject = new JSONObject(string2);
            }
            catch (JSONException jSONException) {
                zzmd2.zzb("openableIntents", new JSONObject());
                return;
            }
            try {
                jSONArray = jSONObject.getJSONArray("intents");
            }
            catch (JSONException jSONException) {
                zzmd2.zzb("openableIntents", new JSONObject());
                return;
            }
            JSONObject jSONObject2 = new JSONObject();
            for (int i = 0; i < jSONArray.length(); ++i) {
                ResolveInfo resolveInfo;
                JSONObject jSONObject3;
                try {
                    jSONObject3 = jSONArray.getJSONObject(i);
                }
                catch (JSONException jSONException) {
                    zzkx.zzb((String)"Error parsing the intent data.", (Throwable)jSONException);
                    continue;
                }
                String string3 = jSONObject3.optString("id");
                String string4 = jSONObject3.optString("u");
                String string5 = jSONObject3.optString("i");
                String string6 = jSONObject3.optString("m");
                String string7 = jSONObject3.optString("p");
                String string8 = jSONObject3.optString("c");
                String string9 = jSONObject3.optString("f");
                String string10 = jSONObject3.optString("e");
                Intent intent = new Intent();
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    intent.setData(Uri.parse((String)string4));
                }
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    intent.setAction(string5);
                }
                if (!TextUtils.isEmpty((CharSequence)string6)) {
                    intent.setType(string6);
                }
                if (!TextUtils.isEmpty((CharSequence)string7)) {
                    intent.setPackage(string7);
                }
                if (!TextUtils.isEmpty((CharSequence)string8) && ((ResolveInfo)(resolveInfo = string8.split("/", 2))).length == 2) {
                    intent.setComponent(new ComponentName((String)resolveInfo[0], (String)resolveInfo[1]));
                }
                boolean bl = (resolveInfo = packageManager.resolveActivity(intent, 65536)) != null;
                try {
                    jSONObject2.put(string3, bl);
                    continue;
                }
                catch (JSONException jSONException) {
                    zzkx.zzb((String)"Error constructing openable urls response.", (Throwable)jSONException);
                }
            }
            zzmd2.zzb("openableIntents", jSONObject2);
        }
    };
    public static final zzfe zzbpm = new zzfe(){

        @Override
        public void zza(zzmd zzmd2, Map<String, String> map) {
            Object object;
            String string2 = map.get("u");
            if (string2 == null) {
                zzkx.zzdi((String)"URL missing from click GMSG.");
                return;
            }
            Uri uri = Uri.parse((String)string2);
            try {
                object = zzmd2.zzxe();
                if (object != null && ((zzav)object).zzc(uri)) {
                    uri = ((zzav)object).zza(uri, zzmd2.getContext(), zzmd2.getView());
                }
            }
            catch (zzaw zzaw2) {
                String string3 = String.valueOf(string2);
                zzkx.zzdi((String)(string3.length() != 0 ? "Unable to append parameter to URL: ".concat(string3) : new String("Unable to append parameter to URL: ")));
            }
            string2 = uri.toString();
            object = new zzll(zzmd2.getContext(), zzmd2.zzxf().zzda, string2);
            Future cfr_ignored_0 = (Future)((zzkw)object).zzrz();
        }
    };
    public static final zzfe zzbpn = new zzfe(){

        @Override
        public void zza(zzmd zzmd2, Map<String, String> map) {
            com.google.android.gms.ads.internal.overlay.zzd zzd2 = zzmd2.zzxa();
            if (zzd2 != null) {
                zzd2.close();
            } else {
                com.google.android.gms.ads.internal.overlay.zzd zzd3 = zzmd2.zzxb();
                if (zzd3 != null) {
                    zzd3.close();
                } else {
                    zzkx.zzdi((String)"A GMSG tried to close something that wasn't an overlay.");
                }
            }
        }
    };
    public static final zzfe zzbpo = new zzfe(){

        private void zzd(zzmd zzmd2) {
            zzm zzm2;
            zzkx.zzdh((String)"Received support message, responding.");
            boolean bl = false;
            zzd zzd2 = zzmd2.zzec();
            if (zzd2 != null && (zzm2 = zzd2.zzamr) != null) {
                zzmd2.getContext();
                bl = false;
            }
            zzm2 = new JSONObject();
            try {
                zzm2.put("event", "checkSupport");
                zzm2.put("supports", false);
                zzmd2.zzb("appStreaming", (JSONObject)zzm2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void zza(zzmd zzmd2, Map<String, String> map) {
            if ("checkSupport".equals(map.get("action"))) {
                this.zzd(zzmd2);
                return;
            }
            com.google.android.gms.ads.internal.overlay.zzd zzd2 = zzmd2.zzxa();
            if (zzd2 != null) {
                zzd2.zzg(zzmd2, map);
            }
        }
    };
    public static final zzfe zzbpp = new zzfe(){

        @Override
        public void zza(zzmd zzmd2, Map<String, String> map) {
            zzmd2.zzal("1".equals(map.get("custom_close")));
        }
    };
    public static final zzfe zzbpq = new zzfe(){

        @Override
        public void zza(zzmd zzmd2, Map<String, String> map) {
            String string2 = map.get("u");
            if (string2 == null) {
                zzkx.zzdi((String)"URL missing from httpTrack GMSG.");
                return;
            }
            zzll zzll2 = new zzll(zzmd2.getContext(), zzmd2.zzxf().zzda, string2);
            Future cfr_ignored_0 = (Future)zzll2.zzrz();
        }
    };
    public static final zzfe zzbpr = new zzfe(){

        @Override
        public void zza(zzmd zzmd2, Map<String, String> map) {
            String string2 = String.valueOf(map.get("string"));
            zzkx.zzdh((String)(string2.length() != 0 ? "Received log message: ".concat(string2) : new String("Received log message: ")));
        }
    };
    public static final zzfe zzbps = new zzfe(){

        @Override
        public void zza(zzmd zzmd2, Map<String, String> map) {
            zzg zzg2 = zzmd2.zzxs();
            if (zzg2 != null) {
                zzg2.zzmu();
            }
        }
    };
    public static final zzfe zzbpt = new zzfe(){

        @Override
        public void zza(zzmd zzmd2, Map<String, String> map) {
            String string2 = map.get("tx");
            String string3 = map.get("ty");
            String string4 = map.get("td");
            try {
                int n = Integer.parseInt(string2);
                int n2 = Integer.parseInt(string3);
                int n3 = Integer.parseInt(string4);
                zzav zzav2 = zzmd2.zzxe();
                if (zzav2 != null) {
                    zzaq zzaq2 = zzav2.zzaz();
                    zzaq2.zza(n, n2, n3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                zzkx.zzdi((String)"Could not parse touch parameters from gmsg.");
            }
        }
    };
    public static final zzfe zzbpu = new zzfe(){

        @Override
        public void zza(zzmd zzmd2, Map<String, String> map) {
            if (!zzdr.zzbhd.get().booleanValue()) {
                return;
            }
            String string2 = map.get("disabled");
            boolean bl = Boolean.parseBoolean(string2);
            zzmd2.zzam(!bl);
        }
    };
    public static final zzfe zzbpv = new zzfe(){

        @Override
        public void zza(zzmd zzmd2, Map<String, String> map) {
            String string2 = map.get("action");
            if ("pause".equals(string2)) {
                zzmd2.zzey();
            } else if ("resume".equals(string2)) {
                zzmd2.zzez();
            }
        }
    };
    public static final zzfe zzbpw = new zzfo();
    public static final zzfe zzbpx = new zzfp();
    public static final zzfe zzbpy = new zzft();
    public static final zzfe zzbpz = new zzfc();
    public static final zzfm zzbqa = new zzfm();
    public static final zzfe zzbqb = new zzfe(){

        @Override
        public void zza(zzmd zzmd2, Map<String, String> map) {
            if (map.keySet().contains("start")) {
                zzmd2.zzxc().zzyb();
                return;
            }
            if (map.keySet().contains("stop")) {
                zzmd2.zzxc().zzyc();
                return;
            }
            if (map.keySet().contains("cancel")) {
                zzmd2.zzxc().zzyd();
                return;
            }
        }
    };
    public static final zzfe zzbqc = new zzfe(){

        @Override
        public void zza(zzmd zzmd2, Map<String, String> map) {
            if (map.keySet().contains("start")) {
                zzmd2.zzan(true);
            }
            if (map.keySet().contains("stop")) {
                zzmd2.zzan(false);
            }
        }
    };
    public static final zzfe zzbqd = new zzfe(){

        @Override
        public void zza(zzmd zzmd2, Map<String, String> map) {
            WindowManager windowManager = (WindowManager)zzmd2.getContext().getSystemService("window");
            Map<String, Integer> map2 = zzu.zzgm().zza((View)zzmd2, windowManager);
            zzmd2.zza("locationReady", map2);
            zzkx.zzdi((String)"GET LOCATION COMPILED");
        }
    };
}

