/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzfw;
import com.google.android.gms.internal.zzga;
import com.google.android.gms.internal.zzgb;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjr;
import com.google.android.gms.internal.zzkx;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;

@zzji
public class zzfz {
    private final Map<zzga, zzgb> zzbsl = new HashMap<zzga, zzgb>();
    private final LinkedList<zzga> zzbsm = new LinkedList();
    @Nullable
    private zzfw zzbsn;

    void zza(zzfw zzfw2) {
        if (this.zzbsn == null) {
            this.zzbsn = zzfw2.zznl();
            this.restore();
        }
    }

    @Nullable
    zzgb.zza zza(AdRequestParcel adRequestParcel, String string2) {
        Object object;
        if (this.zzbm(string2)) {
            return null;
        }
        Context context = this.zzbsn.getApplicationContext();
        zzjr zzjr2 = new zzjr.zza(context).zztr();
        int n = zzjr2.zzcqe;
        AdRequestParcel adRequestParcel2 = zzfz.zzn(adRequestParcel);
        zzga zzga2 = new zzga(adRequestParcel2, string2, n);
        zzgb zzgb2 = this.zzbsl.get(zzga2);
        if (zzgb2 == null) {
            zzfz.zza("Interstitial pool created at %s.", zzga2);
            zzgb2 = new zzgb(adRequestParcel2, string2, n);
            this.zzbsl.put(zzga2, zzgb2);
        }
        this.zzbsm.remove(zzga2);
        this.zzbsm.add(zzga2);
        zzgb2.zznr();
        while (this.zzbsm.size() > zzdr.zzbgk.get()) {
            object = this.zzbsm.remove();
            zzgb zzgb3 = this.zzbsl.get(object);
            zzfz.zza("Evicting interstitial queue for %s.", (zzga)object);
            while (zzgb3.size() > 0) {
                zzgb.zza zza2 = zzgb3.zzp(null);
                zza2.zzbss.zzfn();
            }
            this.zzbsl.remove(object);
        }
        while (zzgb2.size() > 0) {
            long l;
            object = zzgb2.zzp(adRequestParcel2);
            if (((zzgb.zza)object).zzbsw && (l = zzu.zzgs().currentTimeMillis() - ((zzgb.zza)object).zzbsv) > 1000L * (long)zzdr.zzbgm.get().intValue()) {
                zzfz.zza("Expired interstitial at %s.", zzga2);
                continue;
            }
            String string3 = ((zzgb.zza)object).zzbst != null ? " (inline) " : " ";
            zzfz.zza(new StringBuilder(34 + String.valueOf(string3).length()).append("Pooled interstitial").append(string3).append("returned at %s.").toString(), zzga2);
            return object;
        }
        return null;
    }

    void zzb(AdRequestParcel adRequestParcel, String string2) {
        if (this.zzbsn == null) {
            return;
        }
        Context context = this.zzbsn.getApplicationContext();
        zzjr zzjr2 = new zzjr.zza(context).zztr();
        int n = zzjr2.zzcqe;
        AdRequestParcel adRequestParcel2 = zzfz.zzn(adRequestParcel);
        zzga zzga2 = new zzga(adRequestParcel2, string2, n);
        zzgb zzgb2 = this.zzbsl.get(zzga2);
        if (zzgb2 == null) {
            zzfz.zza("Interstitial pool created at %s.", zzga2);
            zzgb2 = new zzgb(adRequestParcel2, string2, n);
            this.zzbsl.put(zzga2, zzgb2);
        }
        zzgb2.zza(this.zzbsn, adRequestParcel);
        zzgb2.zznr();
        zzfz.zza("Inline entry added to the queue at %s.", zzga2);
    }

    void zznm() {
        if (this.zzbsn == null) {
            return;
        }
        for (Map.Entry<zzga, zzgb> entry : this.zzbsl.entrySet()) {
            zzga zzga2 = entry.getKey();
            zzgb zzgb2 = entry.getValue();
            if (zzkx.zzbi((int)2)) {
                int n = zzgb2.size();
                int n2 = zzgb2.zznp();
                if (n2 < n) {
                    zzkx.v(String.format("Loading %s/%s pooled interstitials for %s.", n - n2, n, zzga2));
                }
            }
            zzgb2.zznq();
            while (zzgb2.size() < zzdr.zzbgl.get()) {
                zzfz.zza("Pooling and loading one new interstitial for %s.", zzga2);
                zzgb2.zzb(this.zzbsn);
            }
        }
        this.save();
    }

    void save() {
        if (this.zzbsn == null) {
            return;
        }
        Context context = this.zzbsn.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        for (Map.Entry<zzga, zzgb> entry : this.zzbsl.entrySet()) {
            zzga zzga2 = entry.getKey();
            zzgb zzgb2 = entry.getValue();
            if (!zzgb2.zzns()) continue;
            zzgd zzgd2 = new zzgd(zzgb2);
            String string2 = zzgd2.zznv();
            String string3 = zzga2.toString();
            editor.putString(string3, string2);
            zzfz.zza("Saved interstitial queue for %s.", zzga2);
        }
        editor.putString("PoolKeys", this.zznn());
        editor.apply();
    }

    void restore() {
        if (this.zzbsn == null) {
            return;
        }
        Context context = this.zzbsn.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
        this.flush();
        try {
            zzga zzga2;
            HashMap<String, zzga> hashMap = new HashMap<String, zzga>();
            String[] stringArray = sharedPreferences.getAll().entrySet().iterator();
            while (stringArray.hasNext()) {
                String[] stringArray2 = stringArray.next();
                String string2 = (String)stringArray2.getKey();
                if (string2.equals("PoolKeys")) continue;
                String string3 = (String)stringArray2.getValue();
                zzgd object = zzgd.zzbn(string3);
                zzga2 = new zzga(object.zzapj, object.zzant, object.zzbsq);
                if (this.zzbsl.containsKey(zzga2)) continue;
                zzgb zzgb2 = new zzgb(object.zzapj, object.zzant, object.zzbsq);
                this.zzbsl.put(zzga2, zzgb2);
                hashMap.put(zzga2.toString(), zzga2);
                zzfz.zza("Restored interstitial queue for %s.", zzga2);
            }
            for (String string2 : stringArray = this.zzbl(sharedPreferences.getString("PoolKeys", ""))) {
                zzga2 = (zzga)hashMap.get(string2);
                if (!this.zzbsl.containsKey(zzga2)) continue;
                this.zzbsm.add(zzga2);
            }
        }
        catch (Throwable throwable) {
            zzu.zzgq().zza(throwable, "InterstitialAdPool.restore");
            zzkx.zzc((String)"Malformed preferences value for InterstitialAdPool.", (Throwable)throwable);
            this.zzbsl.clear();
            this.zzbsm.clear();
        }
    }

    void flush() {
        while (this.zzbsm.size() > 0) {
            zzga zzga2 = this.zzbsm.remove();
            zzgb zzgb2 = this.zzbsl.get(zzga2);
            zzfz.zza("Flushing interstitial queue for %s.", zzga2);
            while (zzgb2.size() > 0) {
                zzgb.zza zza2 = zzgb2.zzp(null);
                zza2.zzbss.zzfn();
            }
            this.zzbsl.remove(zzga2);
        }
    }

    private String zznn() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.zzbsm.iterator();
            while (iterator.hasNext()) {
                String string2 = ((zzga)iterator.next()).toString();
                stringBuilder.append(Base64.encodeToString((byte[])string2.getBytes("UTF-8"), (int)0));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\u0000");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private String[] zzbl(String string2) {
        try {
            String[] stringArray = string2.split("\u0000");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(Base64.decode((String)stringArray[i], (int)0), "UTF-8");
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String[0];
        }
    }

    private boolean zzbm(String string2) {
        try {
            return Pattern.matches(zzdr.zzbgn.get(), string2);
        }
        catch (RuntimeException runtimeException) {
            zzu.zzgq().zza(runtimeException, "InterstitialAdPool.isExcludedAdUnit");
            return false;
        }
    }

    @Nullable
    static Bundle zzk(AdRequestParcel adRequestParcel) {
        Bundle bundle = adRequestParcel.zzayv;
        if (bundle == null) {
            return null;
        }
        return bundle.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
    }

    static AdRequestParcel zzl(AdRequestParcel adRequestParcel) {
        AdRequestParcel adRequestParcel2 = zzfz.zzo(adRequestParcel);
        Bundle bundle = zzfz.zzk(adRequestParcel2);
        if (bundle == null) {
            bundle = new Bundle();
            adRequestParcel2.zzayv.putBundle("com.google.ads.mediation.admob.AdMobAdapter", bundle);
        }
        bundle.putBoolean("_skipMediation", true);
        return adRequestParcel2;
    }

    static boolean zzm(AdRequestParcel adRequestParcel) {
        Bundle bundle = adRequestParcel.zzayv;
        if (bundle == null) {
            return false;
        }
        Bundle bundle2 = bundle.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        return bundle2 != null && bundle2.containsKey("_skipMediation");
    }

    private static AdRequestParcel zzn(AdRequestParcel adRequestParcel) {
        String[] stringArray;
        AdRequestParcel adRequestParcel2 = zzfz.zzo(adRequestParcel);
        String string2 = zzdr.zzbgj.get();
        for (String string3 : stringArray = string2.split(",")) {
            zzfz.zzc(adRequestParcel2.zzayv, string3);
        }
        return adRequestParcel2;
    }

    static AdRequestParcel zzo(AdRequestParcel adRequestParcel) {
        Parcel parcel = Parcel.obtain();
        adRequestParcel.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        AdRequestParcel adRequestParcel2 = (AdRequestParcel)AdRequestParcel.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        AdRequestParcel.zzj((AdRequestParcel)adRequestParcel2);
        return adRequestParcel2;
    }

    private static void zzc(Bundle bundle, String string2) {
        String[] stringArray = string2.split("/", 2);
        if (stringArray.length == 0) {
            return;
        }
        String string3 = stringArray[0];
        if (stringArray.length == 1) {
            bundle.remove(string3);
            return;
        }
        Bundle bundle2 = bundle.getBundle(string3);
        if (bundle2 == null) {
            return;
        }
        zzfz.zzc(bundle2, stringArray[1]);
    }

    private static void zza(String string2, zzga zzga2) {
        if (zzkx.zzbi((int)2)) {
            zzkx.v(String.format(string2, zzga2));
        }
    }
}

