/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzdj;
import com.google.android.gms.internal.zzhv;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzmd;
import java.util.Map;

@zzji
public class zzhp
extends zzhv {
    private final Map<String, String> zzbly;
    private final Context mContext;
    private String zzbxx;
    private long zzbxy;
    private long zzbxz;
    private String zzbya;
    private String zzbyb;

    public zzhp(zzmd zzmd2, Map<String, String> map) {
        super(zzmd2, "createCalendarEvent");
        this.zzbly = map;
        this.mContext = zzmd2.zzwy();
        this.zzor();
    }

    private void zzor() {
        this.zzbxx = this.zzby("description");
        this.zzbya = this.zzby("summary");
        this.zzbxy = this.zzbz("start_ticks");
        this.zzbxz = this.zzbz("end_ticks");
        this.zzbyb = this.zzby("location");
    }

    private String zzby(String string2) {
        return TextUtils.isEmpty((CharSequence)this.zzbly.get(string2)) ? "" : this.zzbly.get(string2);
    }

    private long zzbz(String string2) {
        String string3 = this.zzbly.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzcb("Activity context is not available.");
            return;
        }
        zzdj zzdj2 = zzu.zzgm().zzac(this.mContext);
        if (!zzdj2.zzln()) {
            this.zzcb("This feature is not available on the device.");
            return;
        }
        AlertDialog.Builder builder = zzu.zzgm().zzab(this.mContext);
        Resources resources = zzu.zzgq().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.create_calendar_title) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.create_calendar_message) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.accept) : "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                Intent intent = zzhp.this.createIntent();
                zzu.zzgm().zzb(zzhp.this.mContext, intent);
            }
        });
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.decline) : "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                zzhp.this.zzcb("Operation denied by user.");
            }
        });
        builder.create().show();
    }

    @TargetApi(value=14)
    Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzbxx);
        intent.putExtra("eventLocation", this.zzbyb);
        intent.putExtra("description", this.zzbya);
        if (this.zzbxy > -1L) {
            intent.putExtra("beginTime", this.zzbxy);
        }
        if (this.zzbxz > -1L) {
            intent.putExtra("endTime", this.zzbxz);
        }
        intent.setFlags(0x10000000);
        return intent;
    }
}

