/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.formats.zzc;
import com.google.android.gms.ads.internal.formats.zzf;
import com.google.android.gms.ads.internal.formats.zzi;
import com.google.android.gms.ads.internal.formats.zzj;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzav;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzes;
import com.google.android.gms.internal.zzet;
import com.google.android.gms.internal.zzfe;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzja;
import com.google.android.gms.internal.zzjc;
import com.google.android.gms.internal.zzjd;
import com.google.android.gms.internal.zzje;
import com.google.android.gms.internal.zzjf;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzli;
import com.google.android.gms.internal.zzlq;
import com.google.android.gms.internal.zzlr;
import com.google.android.gms.internal.zzls;
import com.google.android.gms.internal.zzlt;
import com.google.android.gms.internal.zzmd;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzji
public class zzjb
implements Callable<zzko> {
    static long zzchj = TimeUnit.SECONDS.toMillis(60L);
    private final Context mContext;
    private final zzli zzchs;
    private final zzq zzcht;
    private final zzav zzbnx;
    private final zzja zzbnv;
    private final Object zzako = new Object();
    private final zzko.zza zzcgf;
    private final zzdz zzalt;
    private boolean zzchu;
    private int zzcgw;
    private List<String> zzchv;
    private JSONObject zzchw;

    public zzjb(Context context, zzq zzq2, zzli zzli2, zzav zzav2, zzko.zza zza2, zzdz zzdz2) {
        this.mContext = context;
        this.zzcht = zzq2;
        this.zzchs = zzli2;
        this.zzcgf = zza2;
        this.zzbnx = zzav2;
        this.zzalt = zzdz2;
        this.zzbnv = this.zza(context, zza2, zzq2, zzav2);
        this.zzbnv.zzsh();
        this.zzchu = false;
        this.zzcgw = -2;
        this.zzchv = null;
    }

    public zzko zzss() {
        try {
            this.zzbnv.zzsi();
            String string2 = this.zzsu();
            JSONObject jSONObject = this.zzcj(string2);
            zza zza2 = this.zze(jSONObject);
            zzi.zza zza3 = this.zza(zza2, jSONObject, string2);
            this.zza(zza3);
            zzko zzko2 = this.zzb(zza3);
            return zzko2;
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (JSONException jSONException) {
            zzkx.zzc((String)"Malformed native JSON response.", (Throwable)jSONException);
        }
        catch (TimeoutException timeoutException) {
            zzkx.zzc((String)"Timeout when loading native ad.", (Throwable)timeoutException);
        }
        if (!this.zzchu) {
            this.zzas(0);
        }
        return this.zzb(null);
    }

    private JSONObject zzcj(final String string2) throws ExecutionException, InterruptedException, TimeoutException, JSONException {
        if (this.zzst()) {
            return null;
        }
        final zzlq zzlq2 = new zzlq();
        final zzb zzb2 = new zzb();
        zzja.zza zza2 = new zzja.zza(){

            @Override
            public void zze(final zzgi zzgi2) {
                zzfe zzfe2;
                zzb2.zzciq = zzfe2 = new zzfe(){

                    @Override
                    public void zza(zzmd zzmd2, Map<String, String> map) {
                        try {
                            String string2 = map.get("success");
                            if (TextUtils.isEmpty((CharSequence)string2)) {
                                return;
                            }
                            JSONObject jSONObject = new JSONObject(string2);
                            if (!string2.equals(jSONObject.optString("ads_id", ""))) {
                                return;
                            }
                            zzgi2.zzb("/nativeAdPreProcess", zzb2.zzciq);
                            zzlq2.zzh(new JSONObject(string2).getJSONArray("ads").getJSONObject(0));
                            return;
                        }
                        catch (JSONException jSONException) {
                            zzkx.zzb((String)"Malformed native JSON response.", (Throwable)jSONException);
                            zzjb.this.zzas(0);
                            zzaa.zza((boolean)zzjb.this.zzst(), (Object)"Unable to set the ad state error!");
                            zzlq2.zzh(null);
                            return;
                        }
                    }
                };
                zzgi2.zza("/nativeAdPreProcess", zzfe2);
                try {
                    JSONObject jSONObject = new JSONObject(((zzjb)zzjb.this).zzcgf.zzcsu.body);
                    jSONObject.put("ads_id", (Object)string2);
                    zzgi2.zza("google.afma.nativeAds.preProcessJsonGmsg", jSONObject);
                }
                catch (JSONException jSONException) {
                    zzkx.zzc((String)"Exception occurred while invoking javascript", (Throwable)jSONException);
                    zzlq2.zzh(null);
                }
            }

            @Override
            public void zzsr() {
                zzlq2.zzh(null);
            }
        };
        this.zzbnv.zza(zza2);
        return (JSONObject)zzlq2.get(zzchj, TimeUnit.MILLISECONDS);
    }

    protected zza zze(JSONObject jSONObject) throws ExecutionException, InterruptedException, JSONException, TimeoutException {
        boolean bl;
        if (this.zzst() || jSONObject == null) {
            return null;
        }
        String string2 = jSONObject.getString("template_id");
        boolean bl2 = this.zzcgf.zzcmx.zzasa != null ? this.zzcgf.zzcmx.zzasa.zzboj : false;
        boolean bl3 = bl = this.zzcgf.zzcmx.zzasa != null ? this.zzcgf.zzcmx.zzasa.zzbol : false;
        if ("2".equals(string2)) {
            return new zzjd(bl2, bl);
        }
        if ("1".equals(string2)) {
            return new zzje(bl2, bl);
        }
        if ("3".equals(string2)) {
            final String string3 = jSONObject.getString("custom_template_id");
            final zzlq zzlq2 = new zzlq();
            zzlb.zzcvl.post(new Runnable(){

                @Override
                public void run() {
                    zzlq2.zzh((zzet)zzjb.this.zzcht.zzfv().get((Object)string3));
                }
            });
            if (zzlq2.get(zzchj, TimeUnit.MILLISECONDS) != null) {
                return new zzjf(bl2);
            }
            String string4 = String.valueOf(jSONObject.getString("custom_template_id"));
            zzkx.e((String)(string4.length() != 0 ? "No handler for custom template: ".concat(string4) : new String("No handler for custom template: ")));
        } else {
            this.zzas(0);
        }
        return null;
    }

    private void zza(zzi.zza zza2) {
        zzfe zzfe2;
        if (!(zza2 instanceof zzf)) {
            return;
        }
        final zzf zzf2 = (zzf)zza2;
        zzb zzb2 = new zzb();
        zzb2.zzciq = zzfe2 = new zzfe(){

            @Override
            public void zza(zzmd zzmd2, Map<String, String> map) {
                String string2 = map.get("asset");
                zzjb.this.zzb((zzeo)zzf2, string2);
            }
        };
        this.zzbnv.zza(new zzja.zza(){

            @Override
            public void zze(zzgi zzgi2) {
                zzgi2.zza("/nativeAdCustomClick", zzfe2);
            }
        });
    }

    private void zzb(zzeo zzeo2, String string2) {
        try {
            zzes zzes2 = this.zzcht.zzaa(zzeo2.getCustomTemplateId());
            if (zzes2 != null) {
                zzes2.zza(zzeo2, string2);
            }
        }
        catch (RemoteException remoteException) {
            zzkx.zzc((String)new StringBuilder(40 + String.valueOf(string2).length()).append("Failed to call onCustomClick for asset ").append(string2).append(".").toString(), (Throwable)remoteException);
        }
    }

    private zzi.zza zza(zza zza2, JSONObject jSONObject, String string2) throws ExecutionException, InterruptedException, JSONException {
        if (this.zzst() || zza2 == null || jSONObject == null) {
            return null;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("tracking_urls_and_actions");
        String[] stringArray = this.zzd(jSONObject2, "impression_tracking_urls");
        this.zzchv = stringArray == null ? null : Arrays.asList(stringArray);
        this.zzchw = jSONObject2.optJSONObject("active_view");
        Object t = zza2.zza(this, jSONObject);
        if (t == null) {
            zzkx.e((String)"Failed to retrieve ad assets.");
            return null;
        }
        t.zzb((zzi)new zzj(this.mContext, this.zzcht, this.zzbnv, this.zzbnx, jSONObject, (zzi.zza)t, this.zzcgf.zzcmx.zzari, string2));
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzko zzb(zzi.zza zza2) {
        int n;
        Object object = this.zzako;
        synchronized (object) {
            n = this.zzcgw;
            if (zza2 == null && this.zzcgw == -2) {
                n = 0;
            }
        }
        if (n != -2) {
            zza2 = null;
        }
        return new zzko(this.zzcgf.zzcmx.zzcju, null, this.zzcgf.zzcsu.zzbvk, n, this.zzcgf.zzcsu.zzbvl, this.zzchv, this.zzcgf.zzcsu.orientation, this.zzcgf.zzcsu.zzbvq, this.zzcgf.zzcmx.zzcjx, false, null, null, null, null, null, 0L, this.zzcgf.zzarm, this.zzcgf.zzcsu.zzcla, this.zzcgf.zzcso, this.zzcgf.zzcsp, this.zzcgf.zzcsu.zzclg, this.zzchw, zza2, null, null, null, this.zzcgf.zzcsu.zzclt, this.zzcgf.zzcsu.zzclu, null, this.zzcgf.zzcsu.zzbvn, this.zzcgf.zzcsu.zzclx);
    }

    public zzlt<com.google.android.gms.ads.internal.formats.zza> zzf(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject.optJSONObject("attribution");
        if (jSONObject2 == null) {
            return new zzlr<Object>(null);
        }
        final String string2 = jSONObject2.optString("text");
        final int n = jSONObject2.optInt("text_size", -1);
        final Integer n2 = this.zzb(jSONObject2, "text_color");
        final Integer n3 = this.zzb(jSONObject2, "bg_color");
        final int n4 = jSONObject2.optInt("animation_ms", 1000);
        final int n5 = jSONObject2.optInt("presentation_ms", 4000);
        final int n6 = this.zzcgf.zzcmx.zzasa != null && this.zzcgf.zzcmx.zzasa.versionCode >= 2 ? this.zzcgf.zzcmx.zzasa.zzbom : 1;
        ArrayList arrayList = new ArrayList<zzlt<zzc>>();
        if (jSONObject2.optJSONArray("images") != null) {
            arrayList = this.zza(jSONObject2, "images", false, false, true);
        } else {
            arrayList.add(this.zza(jSONObject2, "image", false, false));
        }
        zzlt zzlt2 = zzls.zzo(arrayList);
        return zzls.zza(zzlt2, new zzls.zza<List<zzc>, com.google.android.gms.ads.internal.formats.zza>(){

            public com.google.android.gms.ads.internal.formats.zza zzj(List<zzc> list) {
                try {
                    return list == null || list.isEmpty() ? null : new com.google.android.gms.ads.internal.formats.zza(string2, zzjb.zzh(list), n3, n2, n > 0 ? Integer.valueOf(n) : null, n5 + n4, n6);
                }
                catch (RemoteException remoteException) {
                    zzkx.zzb((String)"Could not get attribution icon", (Throwable)remoteException);
                    return null;
                }
            }

            @Override
            public /* synthetic */ Object apply(Object object) {
                return this.zzj((List)object);
            }
        });
    }

    private Integer zzb(JSONObject jSONObject, String string2) {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
            int n = jSONObject2.getInt("r");
            int n2 = jSONObject2.getInt("g");
            int n3 = jSONObject2.getInt("b");
            return Color.rgb((int)n, (int)n2, (int)n3);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public Future<zzc> zza(JSONObject jSONObject, String string2, boolean bl) throws JSONException {
        JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
        boolean bl2 = jSONObject2.optBoolean("require", true);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl2, bl);
    }

    public zzlt<zzc> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2) throws JSONException {
        JSONObject jSONObject2 = bl ? jSONObject.getJSONObject(string2) : jSONObject.optJSONObject(string2);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl, bl2);
    }

    public List<zzlt<zzc>> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2, boolean bl3) throws JSONException {
        JSONArray jSONArray = bl ? jSONObject.getJSONArray(string2) : jSONObject.optJSONArray(string2);
        ArrayList<zzlt<zzc>> arrayList = new ArrayList<zzlt<zzc>>();
        if (jSONArray == null || jSONArray.length() == 0) {
            this.zza(0, bl);
            return arrayList;
        }
        int n = bl3 ? jSONArray.length() : 1;
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
            arrayList.add(this.zza(jSONObject2, bl, bl2));
        }
        return arrayList;
    }

    private zzlt<zzc> zza(JSONObject jSONObject, final boolean bl, boolean bl2) throws JSONException {
        final String string2 = bl ? jSONObject.getString("url") : jSONObject.optString("url");
        final double d = jSONObject.optDouble("scale", 1.0);
        final boolean bl3 = jSONObject.optBoolean("is_transparent", true);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zza(0, bl);
            return new zzlr<Object>(null);
        }
        if (bl2) {
            return new zzlr<zzc>(new zzc(null, Uri.parse((String)string2), d));
        }
        return this.zzchs.zza(string2, new zzli.zza<zzc>(){

            public zzc zzsv() {
                zzjb.this.zza(2, bl);
                return null;
            }

            @TargetApi(value=19)
            public zzc zzg(InputStream inputStream) {
                Bitmap bitmap = null;
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inDensity = (int)(160.0 * d);
                if (!bl3) {
                    options.inPreferredConfig = Bitmap.Config.RGB_565;
                }
                try {
                    bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
                }
                catch (Exception exception) {
                    zzkx.zzb((String)"Error grabbing image.", (Throwable)exception);
                }
                if (bitmap == null) {
                    zzjb.this.zza(2, bl);
                    return null;
                }
                if (zzs.zzayu()) {
                    int n = bitmap.getWidth();
                    int n2 = bitmap.getHeight();
                    int n3 = bitmap.getAllocationByteCount();
                    zzkx.v(new StringBuilder(61).append("Decoded image w: ").append(n).append(" h:").append(n2).append(" bytes: ").append(n3).toString());
                }
                return new zzc((Drawable)new BitmapDrawable(Resources.getSystem(), bitmap), Uri.parse((String)string2), d);
            }

            @Override
            public /* synthetic */ Object zzsw() {
                return this.zzsv();
            }

            @Override
            @TargetApi(value=19)
            public /* synthetic */ Object zzh(InputStream inputStream) {
                return this.zzg(inputStream);
            }
        });
    }

    public zzlt<zzmd> zzc(JSONObject jSONObject, String string2) throws JSONException {
        JSONObject jSONObject2 = jSONObject.optJSONObject(string2);
        if (jSONObject2 == null) {
            return new zzlr<Object>(null);
        }
        String string3 = jSONObject2.optString("vast_xml");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            zzkx.zzdi((String)"Required field 'vast_xml' is missing");
            return new zzlr<Object>(null);
        }
        return this.zza(this.mContext, this.zzbnx, this.zzcgf, this.zzalt, this.zzcht).zzg(jSONObject2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzst() {
        Object object = this.zzako;
        synchronized (object) {
            return this.zzchu;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzas(int n) {
        Object object = this.zzako;
        synchronized (object) {
            this.zzchu = true;
            this.zzcgw = n;
        }
    }

    public void zza(int n, boolean bl) {
        if (bl) {
            this.zzas(n);
        }
    }

    private String[] zzd(JSONObject jSONObject, String string2) throws JSONException {
        JSONArray jSONArray = jSONObject.optJSONArray(string2);
        if (jSONArray == null) {
            return null;
        }
        String[] stringArray = new String[jSONArray.length()];
        for (int i = 0; i < jSONArray.length(); ++i) {
            stringArray[i] = jSONArray.getString(i);
        }
        return stringArray;
    }

    private static List<Drawable> zzh(List<zzc> list) throws RemoteException {
        ArrayList<Drawable> arrayList = new ArrayList<Drawable>();
        for (zzc zzc2 : list) {
            arrayList.add((Drawable)zze.zzae((zzd)zzc2.zzmn()));
        }
        return arrayList;
    }

    zzja zza(Context context, zzko.zza zza2, zzq zzq2, zzav zzav2) {
        return new zzja(context, zza2, zzq2, zzav2);
    }

    zzjc zza(Context context, zzav zzav2, zzko.zza zza2, zzdz zzdz2, zzq zzq2) {
        return new zzjc(context, zzav2, zza2, zzdz2, zzq2);
    }

    String zzsu() {
        return UUID.randomUUID().toString();
    }

    @Override
    public /* synthetic */ Object call() throws Exception {
        return this.zzss();
    }

    class zzb {
        public zzfe zzciq;

        zzb() {
        }
    }

    public static interface zza<T extends zzi.zza> {
        public T zza(zzjb var1, JSONObject var2) throws JSONException, InterruptedException, ExecutionException;
    }
}

