/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.reward.client.RewardedVideoAdRequestParcel;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzb;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zzgp;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzgy;
import com.google.android.gms.internal.zzgz;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjm;
import com.google.android.gms.internal.zzkf;
import com.google.android.gms.internal.zzkj;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzlb;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzji
public class zzkb
extends zzb
implements zzkf {
    private static final zzgy zzcqy = new zzgy();
    private final Map<String, zzkj> zzcqz = new HashMap<String, zzkj>();
    private boolean zzcra;

    public zzkb(Context context, zzd zzd2, AdSizeParcel adSizeParcel, zzgz zzgz2, VersionInfoParcel versionInfoParcel) {
        super(context, adSizeParcel, null, zzgz2, versionInfoParcel, zzd2);
    }

    public void zza(RewardedVideoAdRequestParcel rewardedVideoAdRequestParcel) {
        zzaa.zzhs((String)"loadAd must be called on the main UI thread.");
        if (TextUtils.isEmpty((CharSequence)rewardedVideoAdRequestParcel.zzarg)) {
            zzkx.zzdi((String)"Invalid ad unit id. Aborting.");
            zzlb.zzcvl.post(new Runnable(){

                @Override
                public void run() {
                    zzkb.this.zzh(1);
                }
            });
            return;
        }
        this.zzcra = false;
        this.zzaly.zzarg = rewardedVideoAdRequestParcel.zzarg;
        super.zzb(rewardedVideoAdRequestParcel.zzcju);
    }

    @Override
    public void zza(final zzko.zza zza2, zzdz zzdz2) {
        if (zza2.errorCode != -2) {
            zzlb.zzcvl.post(new Runnable(){

                @Override
                public void run() {
                    zzkb.this.zzb(new zzko(zza2, null, null, null, null, null, null, null));
                }
            });
            return;
        }
        this.zzaly.zzaro = zza2;
        if (zza2.zzcsk == null) {
            this.zzaly.zzaro = this.zzd(zza2);
        }
        this.zzaly.zzasi = 0;
        this.zzaly.zzarl = zzu.zzgl().zza(this.zzaly.zzahs, this.zzaly.zzaro, this);
    }

    @Nullable
    public zzkj zzcp(String string2) {
        zzkj zzkj2 = this.zzcqz.get(string2);
        if (zzkj2 == null) {
            try {
                zzgz zzgz2 = this.zzamf;
                if ("com.google.ads.mediation.admob.AdMobAdapter".equals(string2)) {
                    zzgz2 = zzcqy;
                }
                zzkj2 = new zzkj(zzgz2.zzbu(string2), this);
                this.zzcqz.put(string2, zzkj2);
            }
            catch (Exception exception) {
                String string3 = String.valueOf(string2);
                zzkx.zzc((String)(string3.length() != 0 ? "Fail to instantiate adapter ".concat(string3) : new String("Fail to instantiate adapter ")), (Throwable)exception);
            }
        }
        return zzkj2;
    }

    @Override
    public boolean zza(zzko zzko2, zzko zzko3) {
        return true;
    }

    @Override
    protected boolean zza(AdRequestParcel adRequestParcel, zzko zzko2, boolean bl) {
        return false;
    }

    @Override
    public void pause() {
        zzaa.zzhs((String)"pause must be called on the main UI thread.");
        for (String string2 : this.zzcqz.keySet()) {
            try {
                zzkj zzkj2 = this.zzcqz.get(string2);
                if (zzkj2 == null || zzkj2.zzuc() == null) continue;
                zzkj2.zzuc().pause();
            }
            catch (RemoteException remoteException) {
                String string3 = String.valueOf(string2);
                zzkx.zzdi((String)(string3.length() != 0 ? "Fail to pause adapter: ".concat(string3) : new String("Fail to pause adapter: ")));
            }
        }
    }

    @Override
    public void resume() {
        zzaa.zzhs((String)"resume must be called on the main UI thread.");
        for (String string2 : this.zzcqz.keySet()) {
            try {
                zzkj zzkj2 = this.zzcqz.get(string2);
                if (zzkj2 == null || zzkj2.zzuc() == null) continue;
                zzkj2.zzuc().resume();
            }
            catch (RemoteException remoteException) {
                String string3 = String.valueOf(string2);
                zzkx.zzdi((String)(string3.length() != 0 ? "Fail to resume adapter: ".concat(string3) : new String("Fail to resume adapter: ")));
            }
        }
    }

    @Override
    public void destroy() {
        zzaa.zzhs((String)"destroy must be called on the main UI thread.");
        for (String string2 : this.zzcqz.keySet()) {
            try {
                zzkj zzkj2 = this.zzcqz.get(string2);
                if (zzkj2 == null || zzkj2.zzuc() == null) continue;
                zzkj2.zzuc().destroy();
            }
            catch (RemoteException remoteException) {
                String string3 = String.valueOf(string2);
                zzkx.zzdi((String)(string3.length() != 0 ? "Fail to destroy adapter: ".concat(string3) : new String("Fail to destroy adapter: ")));
            }
        }
    }

    public void zztu() {
        zzaa.zzhs((String)"showAd must be called on the main UI thread.");
        if (!this.isLoaded()) {
            zzkx.zzdi((String)"The reward video has not loaded.");
            return;
        }
        this.zzcra = true;
        zzkj zzkj2 = this.zzcp(this.zzaly.zzarn.zzbwo);
        if (zzkj2 != null && zzkj2.zzuc() != null) {
            try {
                zzkj2.zzuc().showVideo();
            }
            catch (RemoteException remoteException) {
                zzkx.zzc((String)"Could not call showVideo.", (Throwable)remoteException);
            }
        }
    }

    public boolean isLoaded() {
        zzaa.zzhs((String)"isLoaded must be called on the main UI thread.");
        return this.zzaly.zzark == null && this.zzaly.zzarl == null && this.zzaly.zzarn != null && !this.zzcra;
    }

    @Override
    public void onRewardedVideoAdOpened() {
        this.zza(this.zzaly.zzarn, false);
        this.zzem();
    }

    @Override
    public void onRewardedVideoStarted() {
        if (this.zzaly.zzarn != null && this.zzaly.zzarn.zzbwm != null) {
            zzu.zzhf().zza(this.zzaly.zzahs, this.zzaly.zzari.zzda, this.zzaly.zzarn, this.zzaly.zzarg, false, this.zzaly.zzarn.zzbwm.zzbvb);
        }
        this.zzeo();
    }

    @Override
    public void onRewardedVideoAdClosed() {
        this.zzek();
    }

    @Override
    public void zzc(@Nullable RewardItemParcel rewardItemParcel) {
        if (this.zzaly.zzarn != null && this.zzaly.zzarn.zzbwm != null) {
            zzu.zzhf().zza(this.zzaly.zzahs, this.zzaly.zzari.zzda, this.zzaly.zzarn, this.zzaly.zzarg, false, this.zzaly.zzarn.zzbwm.zzbvc);
        }
        if (this.zzaly.zzarn != null && this.zzaly.zzarn.zzcsk != null && !TextUtils.isEmpty((CharSequence)this.zzaly.zzarn.zzcsk.zzbvr)) {
            rewardItemParcel = new RewardItemParcel(this.zzaly.zzarn.zzcsk.zzbvr, this.zzaly.zzarn.zzcsk.zzbvs);
        }
        this.zza(rewardItemParcel);
    }

    @Override
    public void zztv() {
        this.onAdClicked();
    }

    @Override
    public void onRewardedVideoAdLeftApplication() {
        this.zzel();
    }

    public void onContextChanged(@NonNull Context context) {
        for (zzkj zzkj2 : this.zzcqz.values()) {
            try {
                zzkj2.zzuc().zzj(zze.zzac((Object)context));
            }
            catch (RemoteException remoteException) {
                zzkx.zzb((String)"Unable to call Adapter.onContextChanged.", (Throwable)remoteException);
            }
        }
    }

    private zzko.zza zzd(zzko.zza zza2) {
        Object object;
        zzkx.v("Creating mediation ad response for non-mediated rewarded ad.");
        String string2 = null;
        String string3 = null;
        try {
            string2 = zzjm.zzc(zza2.zzcsu).toString();
            object = new JSONObject();
            object.put("pubid", (Object)zza2.zzcmx.zzarg);
            string3 = object.toString();
        }
        catch (JSONException jSONException) {
            zzkx.zzb((String)"Unable to generate ad state for non-mediated rewarded video.", (Throwable)jSONException);
            return this.zze(zza2);
        }
        object = new zzgp(string2, null, Arrays.asList("com.google.ads.mediation.admob.AdMobAdapter"), null, null, Collections.emptyList(), Collections.emptyList(), string3, null, Collections.emptyList(), Collections.emptyList(), null, null, null, null, null, Collections.emptyList());
        zzgq zzgq2 = new zzgq(Arrays.asList(object), -1L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, "", -1L, 0, 1, null, 0, -1, -1L, false);
        return new zzko.zza(zza2.zzcmx, zza2.zzcsu, zzgq2, zza2.zzarm, zza2.errorCode, zza2.zzcso, zza2.zzcsp, zza2.zzcsi);
    }

    private zzko.zza zze(zzko.zza zza2) {
        return new zzko.zza(zza2.zzcmx, zza2.zzcsu, null, zza2.zzarm, 0, zza2.zzcso, zza2.zzcsp, zza2.zzcsi);
    }
}

