/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.formats.zzg;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzav;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzdv;
import com.google.android.gms.internal.zzdx;
import com.google.android.gms.internal.zzdy;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zzfe;
import com.google.android.gms.internal.zzfs;
import com.google.android.gms.internal.zzhv;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzlp;
import com.google.android.gms.internal.zzmc;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmi;
import com.google.android.gms.internal.zzmj;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzji
class zzmh
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzmd {
    private final zza zzczx;
    private final Object zzako = new Object();
    @Nullable
    private final zzav zzbnx;
    private final VersionInfoParcel zzanu;
    private final com.google.android.gms.ads.internal.zzs zzczy;
    private final zzd zzamb;
    private zzme zzczz;
    private com.google.android.gms.ads.internal.overlay.zzd a;
    private AdSizeParcel zzapp;
    private boolean b;
    private boolean c;
    private boolean d;
    private boolean e;
    private Boolean zzcub;
    private int f;
    private boolean g = true;
    boolean h = false;
    private String zzcec = "";
    private zzmi i;
    private boolean j;
    private boolean k;
    private zzg l;
    private int m;
    private int n;
    private zzdx o;
    private zzdx zzced;
    private zzdx p;
    private zzdy q;
    private WeakReference<View.OnClickListener> r;
    private com.google.android.gms.ads.internal.overlay.zzd s;
    private zzlp zzass;
    private int zzbze = -1;
    private int zzbzd = -1;
    private int zzbzg = -1;
    private int zzbzh = -1;
    private Map<String, zzfs> t;
    private final WindowManager zzati;

    static zzmh zzb(Context context, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, @Nullable zzav zzav2, VersionInfoParcel versionInfoParcel, zzdz zzdz2, com.google.android.gms.ads.internal.zzs zzs2, zzd zzd2) {
        zza zza2 = new zza(context);
        return new zzmh(zza2, adSizeParcel, bl, bl2, zzav2, versionInfoParcel, zzdz2, zzs2, zzd2);
    }

    protected zzmh(zza zza2, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, @Nullable zzav zzav2, VersionInfoParcel versionInfoParcel, zzdz zzdz2, com.google.android.gms.ads.internal.zzs zzs2, zzd zzd2) {
        super((Context)zza2);
        this.zzczx = zza2;
        this.zzapp = adSizeParcel;
        this.d = bl;
        this.f = -1;
        this.zzbnx = zzav2;
        this.zzanu = versionInfoParcel;
        this.zzczy = zzs2;
        this.zzamb = zzd2;
        this.zzati = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        zzu.zzgm().zza((Context)zza2, versionInfoParcel.zzda, webSettings);
        zzu.zzgo().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzym();
        if (zzs.zzays()) {
            this.addJavascriptInterface(new zzmj(this), "googleAdsJsInterface");
        }
        if (zzs.zzayn()) {
            this.removeJavascriptInterface("accessibility");
            this.removeJavascriptInterface("accessibilityTraversal");
        }
        this.zzass = new zzlp(this.zzczx.zzwy(), (View)this, this, null);
        this.zzd(zzdz2);
    }

    @Override
    public void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzme) {
            this.zzczz = (zzme)webViewClient;
        }
    }

    @Override
    public WebView getWebView() {
        return this;
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public zzd zzec() {
        return this.zzamb;
    }

    public boolean zzyh() {
        int n;
        int n2;
        if (!this.zzxc().zzic() && !this.zzxc().zzxv()) {
            return false;
        }
        DisplayMetrics displayMetrics = zzu.zzgm().zza(this.zzati);
        int n3 = zzm.zzkr().zzb(displayMetrics, displayMetrics.widthPixels);
        int n4 = zzm.zzkr().zzb(displayMetrics, displayMetrics.heightPixels);
        Activity activity = this.zzwy();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            int[] nArray = zzu.zzgm().zzh(activity);
            n2 = zzm.zzkr().zzb(displayMetrics, nArray[0]);
            n = zzm.zzkr().zzb(displayMetrics, nArray[1]);
        }
        if (this.zzbzd == n3 && this.zzbze == n4 && this.zzbzg == n2 && this.zzbzh == n) {
            return false;
        }
        boolean bl = this.zzbzd != n3 || this.zzbze != n4;
        this.zzbzd = n3;
        this.zzbze = n4;
        this.zzbzg = n2;
        this.zzbzh = n;
        new zzhv(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzati.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzu.zzgm().zzap(map);
        }
        catch (JSONException jSONException) {
            zzkx.zzdi((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zzb(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    public void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzako;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzkx.zzdi((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(string2, valueCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzdm(String string2) {
        Object object = this.zzako;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzkx.zzdi((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadUrl(String string2) {
        Object object = this.zzako;
        synchronized (object) {
            if (!this.isDestroyed()) {
                try {
                    super.loadUrl(string2);
                }
                catch (Throwable throwable) {
                    String string3 = String.valueOf(throwable);
                    zzkx.zzdi((String)new StringBuilder(24 + String.valueOf(string3).length()).append("Could not call loadUrl. ").append(string3).toString());
                }
            } else {
                zzkx.zzdi((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzdj(String string2) {
        Object object = this.zzako;
        synchronized (object) {
            try {
                super.loadUrl(string2);
            }
            catch (Throwable throwable) {
                String string3 = String.valueOf(throwable);
                zzkx.zzdi((String)new StringBuilder(24 + String.valueOf(string3).length()).append("Could not call loadUrl. ").append(string3).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(String string2, String string3, String string4) {
        Object object = this.zzako;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(string2, string3, string4);
            } else {
                zzkx.zzdi((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        Object object = this.zzako;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            } else {
                zzkx.zzdi((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    protected void zza(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzako;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.evaluateJavascript(string2, valueCallback);
            } else {
                zzkx.zzdi((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
            }
        }
    }

    protected void zzdn(String string2) {
        if (zzs.zzayu()) {
            if (this.zzva() == null) {
                this.zzyi();
            }
            if (this.zzva().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
            } else {
                String string3 = String.valueOf(string2);
                this.zzdm(string3.length() != 0 ? "javascript:".concat(string3) : new String("javascript:"));
            }
        } else {
            String string4 = String.valueOf(string2);
            this.zzdm(string4.length() != 0 ? "javascript:".concat(string4) : new String("javascript:"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzyi() {
        Object object = this.zzako;
        synchronized (object) {
            this.zzcub = zzu.zzgq().zzva();
            if (this.zzcub == null) {
                try {
                    String string2 = "(function(){})()";
                    this.evaluateJavascript(string2, null);
                    this.zzb(true);
                }
                catch (IllegalStateException illegalStateException) {
                    this.zzb(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzb(Boolean bl) {
        Object object = this.zzako;
        synchronized (object) {
            this.zzcub = bl;
        }
        zzu.zzgq().zzb(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean zzva() {
        Object object = this.zzako;
        synchronized (object) {
            return this.zzcub;
        }
    }

    @Override
    public void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        this.zzi(string2, string3);
    }

    @Override
    public void zzi(String string2, String string3) {
        String string4 = new StringBuilder(3 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("(").append(string3).append(");").toString();
        this.zzdn(string4);
    }

    @Override
    public void zzb(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(window.AFMA_ReceiveMessage || function() {})('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzkx.zzdg((String)(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: ")));
        this.zzdn(stringBuilder.toString());
    }

    @Override
    public void zzww() {
        this.zzyj();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzanu.zzda);
        this.zza("onhide", hashMap);
    }

    @Override
    public void zzak(int n) {
        if (n == 0) {
            this.zzyk();
        }
        this.zzyj();
        if (this.q.zzly() != null) {
            this.q.zzly().zzg("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzanu.zzda);
        this.zza("onhide", hashMap);
    }

    private void zzyj() {
        zzdv.zza(this.q.zzly(), this.zzced, "aeh2");
    }

    private void zzyk() {
        zzdv.zza(this.q.zzly(), this.zzced, "aebb2");
    }

    @Override
    public void zzps() {
        if (this.o == null) {
            zzdv.zza(this.q.zzly(), this.zzced, "aes2");
            this.o = zzdv.zzb(this.q.zzly());
            this.q.zza("native:view_show", this.o);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzanu.zzda);
        this.zza("onshow", hashMap);
    }

    @Override
    public void zzwx() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzu.zzgm().zzft()));
        hashMap.put("app_volume", String.valueOf(zzu.zzgm().zzfr()));
        hashMap.put("device_volume", String.valueOf(zzu.zzgm().zzah(this.getContext())));
        this.zza("volume", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zzd zzxa() {
        Object object = this.zzako;
        synchronized (object) {
            return this.a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zzd zzxb() {
        Object object = this.zzako;
        synchronized (object) {
            return this.s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdSizeParcel zzeg() {
        Object object = this.zzako;
        synchronized (object) {
            return this.zzapp;
        }
    }

    @Override
    public zzme zzxc() {
        return this.zzczz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzxd() {
        Object object = this.zzako;
        synchronized (object) {
            return this.b;
        }
    }

    @Override
    public zzav zzxe() {
        return this.zzbnx;
    }

    @Override
    public VersionInfoParcel zzxf() {
        return this.zzanu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzxg() {
        Object object = this.zzako;
        synchronized (object) {
            return this.d;
        }
    }

    public void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzu.zzgm().zzb(this.getContext(), intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzkx.zzdg((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzxc().zzxv()) {
            Object object = this.zzako;
            synchronized (object) {
                if (this.l != null) {
                    this.l.zzc(motionEvent);
                }
            }
        } else if (this.zzbnx != null) {
            this.zzbnx.zza(motionEvent);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if (zzdr.zzbfv.get().booleanValue()) {
            boolean bl;
            float f = motionEvent.getAxisValue(9);
            float f2 = motionEvent.getAxisValue(10);
            boolean bl2 = bl = motionEvent.getActionMasked() == 8;
            if (bl && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
                return false;
            }
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DrawAllocation"})
    protected void onMeasure(int n, int n2) {
        Object object = this.zzako;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.d || this.zzapp.zzazt) {
                super.onMeasure(n, n2);
                return;
            }
            if (this.zzapp.zzazu) {
                if (zzdr.zzbjk.get().booleanValue() || !zzs.zzays()) {
                    super.onMeasure(n, n2);
                    return;
                }
                this.zza("/contentHeight", this.zzyl());
                String string2 = "(function() {  var height = -1;  if (document.body) { height = document.body.offsetHeight;}  else if (document.documentElement) {      height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  window.googleAdsJsInterface.notify(url);  })();";
                this.zzdn(string2);
                float f = this.zzczx.getResources().getDisplayMetrics().density;
                int n3 = View.MeasureSpec.getSize((int)n);
                int n4 = 0;
                switch (this.n) {
                    case -1: {
                        n4 = View.MeasureSpec.getSize((int)n2);
                        break;
                    }
                    default: {
                        n4 = (int)((float)this.n * f);
                    }
                }
                this.setMeasuredDimension(n3, n4);
                return;
            }
            if (this.zzapp.zzazr) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zzati.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            int n9 = Integer.MAX_VALUE;
            if (n5 == Integer.MIN_VALUE || n5 == 0x40000000) {
                n9 = n6;
            }
            int n10 = Integer.MAX_VALUE;
            if (n7 == Integer.MIN_VALUE || n7 == 0x40000000) {
                n10 = n8;
            }
            if (this.zzapp.widthPixels > n9 || this.zzapp.heightPixels > n10) {
                float f = this.zzczx.getResources().getDisplayMetrics().density;
                int n11 = (int)((float)this.zzapp.widthPixels / f);
                int n12 = (int)((float)this.zzapp.heightPixels / f);
                int n13 = (int)((float)n6 / f);
                int n14 = (int)((float)n8 / f);
                zzkx.zzdi((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n11).append("x").append(n12).append(" dp, but only has ").append(n13).append("x").append(n14).append(" dp.").toString());
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzapp.widthPixels, this.zzapp.heightPixels);
            }
        }
    }

    zzfe zzyl() {
        return new zzfe(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zza(zzmd zzmd2, Map<String, String> map) {
                String string2;
                if (map != null && !TextUtils.isEmpty((CharSequence)(string2 = map.get("height")))) {
                    try {
                        int n = Integer.parseInt(string2);
                        Object object = zzmh.this.zzako;
                        synchronized (object) {
                            if (zzmh.this.n != n) {
                                zzmh.this.n = n;
                                zzmh.this.requestLayout();
                            }
                        }
                    }
                    catch (Exception exception) {
                        zzkx.zzc((String)"Exception occurred while getting webview content height", (Throwable)exception);
                    }
                }
            }
        };
    }

    public void onGlobalLayout() {
        boolean bl = this.zzyh();
        com.google.android.gms.ads.internal.overlay.zzd zzd2 = this.zzxa();
        if (zzd2 != null && bl) {
            zzd2.zzpr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(Context context, AdSizeParcel adSizeParcel, zzdz zzdz2) {
        Object object = this.zzako;
        synchronized (object) {
            this.zzass.zzwm();
            this.setContext(context);
            this.a = null;
            this.zzapp = adSizeParcel;
            this.d = false;
            this.b = false;
            this.zzcec = "";
            this.f = -1;
            zzu.zzgo().zzm(this);
            this.loadUrl("about:blank");
            this.zzczz.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
            this.g = true;
            this.h = false;
            this.i = null;
            this.zzd(zzdz2);
            this.j = false;
            this.m = 0;
            zzu.zzhj().zze(this);
            this.zzyp();
        }
    }

    private void zzd(zzdz zzdz2) {
        this.zzyq();
        this.q = new zzdy(new zzdz(true, "make_wv", this.zzapp.zzazq));
        this.q.zzly().zzc(zzdz2);
        this.zzced = zzdv.zzb(this.q.zzly());
        this.q.zza("native:view_create", this.zzced);
        this.p = null;
        this.o = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(com.google.android.gms.ads.internal.overlay.zzd zzd2) {
        Object object = this.zzako;
        synchronized (object) {
            this.a = zzd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzc(com.google.android.gms.ads.internal.overlay.zzd zzd2) {
        Object object = this.zzako;
        synchronized (object) {
            this.s = zzd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(AdSizeParcel adSizeParcel) {
        Object object = this.zzako;
        synchronized (object) {
            this.zzapp = adSizeParcel;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzak(boolean bl) {
        Object object = this.zzako;
        synchronized (object) {
            this.d = bl;
            this.zzym();
        }
    }

    @Override
    public void zzxp() {
        this.zzass.zzwl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttachedToWindow() {
        Object object = this.zzako;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzass.onAttachedToWindow();
            }
            boolean bl = this.j;
            if (this.zzxc() != null && this.zzxc().zzxv()) {
                bl = true;
                if (!this.k) {
                    ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                    ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzxc().zzxw();
                    if (onGlobalLayoutListener != null) {
                        zzu.zzhk().zza(this.getView(), onGlobalLayoutListener);
                    }
                    if ((onScrollChangedListener = this.zzxc().zzxx()) != null) {
                        zzu.zzhk().zza(this.getView(), onScrollChangedListener);
                    }
                    this.k = true;
                }
            }
            this.zzap(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        Object object = this.zzako;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzass.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.k && this.zzxc() != null && this.zzxc().zzxv() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzxc().zzxw();
                if (onGlobalLayoutListener != null) {
                    zzu.zzgo().zza(this.getViewTreeObserver(), onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzxc().zzxx()) != null) {
                    this.getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
                }
                this.k = false;
            }
        }
        this.zzap(false);
    }

    @Override
    public void setContext(Context context) {
        this.zzczx.setBaseContext(context);
        this.zzass.zzl(this.zzczx.zzwy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzal(boolean bl) {
        Object object = this.zzako;
        synchronized (object) {
            if (this.a != null) {
                this.a.zza(this.zzczz.zzic(), bl);
            } else {
                this.b = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestedOrientation() {
        Object object = this.zzako;
        synchronized (object) {
            return this.f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestedOrientation(int n) {
        Object object = this.zzako;
        synchronized (object) {
            this.f = n;
            if (this.a != null) {
                this.a.setRequestedOrientation(this.f);
            }
        }
    }

    @Override
    public Activity zzwy() {
        return this.zzczx.zzwy();
    }

    @Override
    public Context zzwz() {
        return this.zzczx.zzwz();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzym() {
        Object object = this.zzako;
        synchronized (object) {
            if (this.d || this.zzapp.zzazr) {
                if (Build.VERSION.SDK_INT < 14) {
                    zzkx.zzdg((String)"Disabling hardware acceleration on an overlay.");
                    this.zzyn();
                } else {
                    zzkx.zzdg((String)"Enabling hardware acceleration on an overlay.");
                    this.zzyo();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                zzkx.zzdg((String)"Disabling hardware acceleration on an AdView.");
                this.zzyn();
            } else {
                zzkx.zzdg((String)"Enabling hardware acceleration on an AdView.");
                this.zzyo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzyn() {
        Object object = this.zzako;
        synchronized (object) {
            if (!this.e) {
                zzu.zzgo().zzv((View)this);
            }
            this.e = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzyo() {
        Object object = this.zzako;
        synchronized (object) {
            if (this.e) {
                zzu.zzgo().zzu((View)this);
            }
            this.e = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.zzako;
        synchronized (object) {
            this.zzyq();
            this.zzass.zzwm();
            if (this.a != null) {
                this.a.close();
                this.a.onDestroy();
                this.a = null;
            }
            this.zzczz.reset();
            if (this.c) {
                return;
            }
            zzu.zzhj().zze(this);
            this.zzyp();
            this.c = true;
            zzkx.v("Initiating WebView self destruct sequence in 3...");
            this.zzczz.zzxz();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Object object = this.zzako;
        synchronized (object) {
            if (!this.c) {
                this.zzczz.reset();
                zzu.zzhj().zze(this);
                this.zzyp();
            }
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzxh() {
        Object object = this.zzako;
        synchronized (object) {
            zzkx.v("Destroying WebView!");
            zzlb.zzcvl.post(new Runnable(){

                @Override
                public void run() {
                    zzmh.super.destroy();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        Object object = this.zzako;
        synchronized (object) {
            return this.c;
        }
    }

    @TargetApi(value=21)
    protected void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzxc() != null && this.zzxc().zzyg() != null) {
            this.zzxc().zzyg().zzff();
        }
    }

    @Override
    public void zzxq() {
        if (this.p == null) {
            this.p = zzdv.zzb(this.q.zzly());
            this.q.zza("native:view_load", this.p);
        }
    }

    @Override
    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (zzs.zzayn()) {
                super.onPause();
            }
        }
        catch (Exception exception) {
            zzkx.zzb((String)"Could not pause webview.", (Throwable)exception);
        }
    }

    @Override
    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (zzs.zzayn()) {
                super.onResume();
            }
        }
        catch (Exception exception) {
            zzkx.zzb((String)"Could not resume webview.", (Throwable)exception);
        }
    }

    @Override
    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
        }
        catch (Exception exception) {
            zzkx.zzb((String)"Could not stop loading webview.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzam(boolean bl) {
        Object object = this.zzako;
        synchronized (object) {
            this.g = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzxi() {
        Object object = this.zzako;
        synchronized (object) {
            return this.g;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzxj() {
        Object object = this.zzako;
        synchronized (object) {
            return this.h;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzey() {
        Object object = this.zzako;
        synchronized (object) {
            this.h = true;
            if (this.zzczy != null) {
                this.zzczy.zzey();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzez() {
        Object object = this.zzako;
        synchronized (object) {
            this.h = false;
            if (this.zzczy != null) {
                this.zzczy.zzez();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzyp() {
        Object object = this.zzako;
        synchronized (object) {
            this.t = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzdk(String string2) {
        Object object = this.zzako;
        synchronized (object) {
            this.zzcec = string2 == null ? "" : string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRequestId() {
        Object object = this.zzako;
        synchronized (object) {
            return this.zzcec;
        }
    }

    @Override
    public zzmc zzxk() {
        return null;
    }

    @Override
    public zzdx zzxl() {
        return this.zzced;
    }

    @Override
    public zzdy zzxm() {
        return this.q;
    }

    @Override
    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.r = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public View.OnClickListener zzxr() {
        return (View.OnClickListener)this.r.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(zzg zzg2) {
        Object object = this.zzako;
        synchronized (object) {
            this.l = zzg2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzg zzxs() {
        Object object = this.zzako;
        synchronized (object) {
            return this.l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzmi zzxn() {
        Object object = this.zzako;
        synchronized (object) {
            return this.i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzmi zzmi2) {
        Object object = this.zzako;
        synchronized (object) {
            if (this.i != null) {
                zzkx.e((String)"Attempt to create multiple AdWebViewVideoControllers.");
                return;
            }
            this.i = zzmi2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzxo() {
        Object object = this.zzako;
        synchronized (object) {
            return this.m > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzan(boolean bl) {
        Object object = this.zzako;
        synchronized (object) {
            this.m += bl ? 1 : -1;
            if (this.m <= 0 && this.a != null) {
                this.a.zzpu();
            }
        }
    }

    private void zzyq() {
        if (this.q == null) {
            return;
        }
        zzdz zzdz2 = this.q.zzly();
        if (zzdz2 != null && zzu.zzgq().zzuu() != null) {
            zzu.zzgq().zzuu().zza(zzdz2);
        }
    }

    @Override
    public void zzxt() {
        this.setBackgroundColor(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzcu.zza zza2) {
        Object object = this.zzako;
        synchronized (object) {
            this.j = zza2.zzave;
        }
        this.zzap(zza2.zzave);
    }

    private void zzap(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public void zza(String string2, zzfe zzfe2) {
        if (this.zzczz != null) {
            this.zzczz.zza(string2, zzfe2);
        }
    }

    @Override
    public void zzb(String string2, zzfe zzfe2) {
        if (this.zzczz != null) {
            this.zzczz.zzb(string2, zzfe2);
        }
    }

    @zzji
    public static class zza
    extends MutableContextWrapper {
        private Activity zzcxl;
        private Context zzatc;
        private Context v;

        public zza(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context context) {
            this.zzatc = context.getApplicationContext();
            this.zzcxl = context instanceof Activity ? (Activity)context : null;
            this.v = context;
            super.setBaseContext(this.zzatc);
        }

        public void startActivity(Intent intent) {
            if (this.zzcxl != null) {
                this.zzcxl.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.zzatc.startActivity(intent);
            }
        }

        public Activity zzwy() {
            return this.zzcxl;
        }

        public Object getSystemService(String string2) {
            return this.v.getSystemService(string2);
        }

        public Context zzwz() {
            return this.v;
        }
    }
}

