/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzayd;
import com.google.android.gms.internal.zzrw;
import com.google.android.gms.internal.zzsx;
import com.google.android.gms.internal.zztg;

public class CampaignTrackingService
extends Service {
    private Handler mHandler;
    private static Boolean zzaax;

    public static boolean zzU(Context context) {
        zzac.zzw((Object)context);
        if (zzaax != null) {
            return zzaax;
        }
        boolean bl = zztg.zzr(context, "com.google.android.gms.analytics.CampaignTrackingService");
        zzaax = bl;
        return bl;
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onCreate() {
        super.onCreate();
        zzrw zzrw2 = zzrw.zzW((Context)this);
        zzsx zzsx2 = zzrw2.zznr();
        zzsx2.zzbO("CampaignTrackingService is starting up");
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onDestroy() {
        zzrw zzrw2 = zzrw.zzW((Context)this);
        zzsx zzsx2 = zzrw2.zznr();
        zzsx2.zzbO("CampaignTrackingService is shutting down");
        super.onDestroy();
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public int onStartCommand(Intent intent, int n, final int n2) {
        String string;
        this.zzlS();
        zzrw zzrw2 = zzrw.zzW((Context)this);
        final zzsx zzsx2 = zzrw2.zznr();
        String string2 = intent.getStringExtra("referrer");
        final Handler handler = this.getHandler();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzsx2.zzbR("No campaign found on com.android.vending.INSTALL_REFERRER \"referrer\" extra");
            zzrw2.zznt().zzg(new Runnable(){

                @Override
                public void run() {
                    CampaignTrackingService.this.zza(zzsx2, handler, n2);
                }
            });
            return 2;
        }
        int n3 = zzrw2.zzns().zzoz();
        if (string2.length() <= n3) {
            string = string2;
        } else {
            zzsx2.zzc("Campaign data exceed the maximum supported size and will be clipped. size, limit", string2.length(), n3);
            string = string2.substring(0, n3);
        }
        zzsx2.zza("CampaignTrackingService called. startId, campaign", n2, string);
        zzrw2.zzlZ().zza(string, new Runnable(){

            @Override
            public void run() {
                CampaignTrackingService.this.zza(zzsx2, handler, n2);
            }
        });
        return 2;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzlS() {
        try {
            Object object = CampaignTrackingReceiver.zztU;
            synchronized (object) {
                zzayd zzayd2 = CampaignTrackingReceiver.zzaav;
                if (zzayd2 != null && zzayd2.isHeld()) {
                    zzayd2.release();
                }
            }
        }
        catch (SecurityException securityException) {}
    }

    protected void zza(final zzsx zzsx2, Handler handler, final int n) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                boolean bl = CampaignTrackingService.this.stopSelfResult(n);
                if (bl) {
                    zzsx2.zza("Install campaign broadcast processed", bl);
                }
            }
        });
    }

    private Handler getHandler() {
        Handler handler = this.mHandler;
        if (handler == null) {
            this.mHandler = handler = new Handler(this.getMainLooper());
        }
        return handler;
    }
}

