/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.internal.zzsw;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler zzaaB;
    private final Tracker zzaaC;
    private final Context mContext;
    private ExceptionParser zzaaD;
    private GoogleAnalytics zzaaE;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.zzaaB = uncaughtExceptionHandler;
        this.zzaaC = tracker;
        this.zzaaD = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        String string = String.valueOf(uncaughtExceptionHandler == null ? "null" : uncaughtExceptionHandler.getClass().getName());
        zzsw.v(string.length() != 0 ? "ExceptionReporter created, original handler is ".concat(string) : new String("ExceptionReporter created, original handler is "));
    }

    public ExceptionParser getExceptionParser() {
        return this.zzaaD;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.zzaaD = exceptionParser;
    }

    GoogleAnalytics zzlT() {
        if (this.zzaaE == null) {
            this.zzaaE = GoogleAnalytics.getInstance(this.mContext);
        }
        return this.zzaaE;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        Object object;
        String string = "UncaughtException";
        if (this.zzaaD != null) {
            object = thread != null ? thread.getName() : null;
            string = this.zzaaD.getDescription((String)object, throwable);
        }
        String string2 = String.valueOf(string);
        zzsw.v(string2.length() != 0 ? "Reporting uncaught exception: ".concat(string2) : new String("Reporting uncaught exception: "));
        this.zzaaC.send(new HitBuilders.ExceptionBuilder().setDescription(string).setFatal(true).build());
        object = this.zzlT();
        ((GoogleAnalytics)object).dispatchLocalHits();
        ((GoogleAnalytics)object).zzlY();
        if (this.zzaaB != null) {
            zzsw.v("Passing exception to the original handler");
            this.zzaaB.uncaughtException(thread, throwable);
        }
    }

    Thread.UncaughtExceptionHandler zzlU() {
        return this.zzaaB;
    }
}

